// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.
// Code generated by informer-gen. DO NOT EDIT.

package v1

import (
	"context"
	time "time"

	dorisv1 "github.com/apache/doris-operator/api/doris/v1"
	versioned "github.com/apache/doris-operator/client/clientset/versioned"
	internalinterfaces "github.com/apache/doris-operator/client/informers/externalversions/internalinterfaces"
	v1 "github.com/apache/doris-operator/client/listers/doris/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
)

// DorisClusterInformer provides access to a shared informer and lister for
// DorisClusters.
type DorisClusterInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() v1.DorisClusterLister
}

type dorisClusterInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
	namespace        string
}

// NewDorisClusterInformer constructs a new informer for DorisCluster type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewDorisClusterInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredDorisClusterInformer(client, namespace, resyncPeriod, indexers, nil)
}

// NewFilteredDorisClusterInformer constructs a new informer for DorisCluster type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredDorisClusterInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options metav1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.DorisV1().DorisClusters(namespace).List(context.TODO(), options)
			},
			WatchFunc: func(options metav1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.DorisV1().DorisClusters(namespace).Watch(context.TODO(), options)
			},
		},
		&dorisv1.DorisCluster{},
		resyncPeriod,
		indexers,
	)
}

func (f *dorisClusterInformer) defaultInformer(client versioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredDorisClusterInformer(client, f.namespace, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *dorisClusterInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&dorisv1.DorisCluster{}, f.defaultInformer)
}

func (f *dorisClusterInformer) Lister() v1.DorisClusterLister {
	return v1.NewDorisClusterLister(f.Informer().GetIndexer())
}
