/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.valueeditors.image;

import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.valueeditors.AbstractDialogBinaryValueEditor;
import org.apache.directory.studio.valueeditors.image.ImageDialog;
import org.apache.directory.studio.valueeditors.image.Messages;
import org.eclipse.swt.widgets.Shell;

public class ImageValueEditor
extends AbstractDialogBinaryValueEditor {
    protected boolean openDialog(Shell shell) {
        byte[] currentImageData;
        ImageDialog dialog;
        Object value = this.getValue();
        if (value instanceof byte[] && (dialog = new ImageDialog(shell, currentImageData = (byte[])value, 4)).open() == 0 && dialog.getNewImageRawData() != null) {
            this.setValue(dialog.getNewImageRawData());
            return true;
        }
        return false;
    }

    public String getDisplayValue(IValue value) {
        if (this.showRawValues()) {
            return ImageValueEditor.getPrintableString((IValue)value);
        }
        if (value == null) {
            return ">>> Error, the configured value editor can not handle this value! <<<";
        }
        if (value.isBinary()) {
            byte[] data = value.getBinaryValue();
            String text = ImageDialog.getImageInfo(data);
            return text;
        }
        return Messages.getString("ImageValueEditor.InvalidImageData");
    }
}

