/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.editor;

import java.util.List;
import org.apache.directory.server.config.beans.ChangePasswordServerBean;
import org.apache.directory.server.config.beans.DirectoryServiceBean;
import org.apache.directory.server.config.beans.KdcServerBean;
import org.apache.directory.server.config.beans.TransportBean;
import org.apache.directory.studio.apacheds.configuration.editor.KerberosServerPage;
import org.apache.directory.studio.apacheds.configuration.editor.LdapLdapsServersPage;
import org.apache.directory.studio.apacheds.configuration.editor.Messages;
import org.apache.directory.studio.apacheds.configuration.editor.PartitionsPage;
import org.apache.directory.studio.apacheds.configuration.editor.ServerConfigurationEditor;
import org.apache.directory.studio.apacheds.configuration.editor.ServerConfigurationEditorPage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class OverviewPage
extends ServerConfigurationEditorPage {
    public static final String ID = OverviewPage.class.getName();
    private static final String TITLE = Messages.getString("OverviewPage.Overview");
    private Button enableLdapCheckbox;
    private Text ldapPortText;
    private Button enableLdapsCheckbox;
    private Text ldapsPortText;
    private Hyperlink openLdapConfigurationLink;
    private Button enableKerberosCheckbox;
    private Text kerberosPortText;
    private Button enableChangePasswordCheckbox;
    private Text changePasswordPortText;
    private Hyperlink openKerberosConfigurationLink;
    private Label partitionsLabel;
    private TableViewer partitionsTableViewer;
    private Hyperlink openPartitionsConfigurationLink;
    private Button allowAnonymousAccessCheckbox;
    private Button enableAccessControlCheckbox;
    private Button enableHiddenPasswordCheckbox;
    private SelectionAdapter enableLdapCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            boolean enableLdap = OverviewPage.this.enableLdapCheckbox.getSelection();
            LdapLdapsServersPage.getLdapServerTransportBean(OverviewPage.this.getDirectoryServiceBean()).setEnabled(enableLdap);
            OverviewPage.this.setEnabled((Control)OverviewPage.this.ldapPortText, enableLdap);
        }
    };
    private ModifyListener ldapPortTextListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            try {
                int port = Integer.parseInt(OverviewPage.this.ldapPortText.getText());
                LdapLdapsServersPage.getLdapServerTransportBean(OverviewPage.this.getDirectoryServiceBean()).setSystemPort(port);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Wrong LDAP TCP Port : it must be an integer");
            }
        }
    };
    private SelectionAdapter enableLdapsCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            boolean enableLdaps = OverviewPage.this.enableLdapsCheckbox.getSelection();
            LdapLdapsServersPage.getLdapTransportBean(OverviewPage.this.getDirectoryServiceBean(), "ldaps").setEnabled(enableLdaps);
            OverviewPage.this.setEnabled((Control)OverviewPage.this.ldapsPortText, enableLdaps);
        }
    };
    private ModifyListener ldapsPortTextListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            try {
                int port = Integer.parseInt(OverviewPage.this.ldapsPortText.getText());
                LdapLdapsServersPage.getLdapsServerTransportBean(OverviewPage.this.getDirectoryServiceBean()).setSystemPort(port);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Wrong LDAPS TCP Port : it must be an integer");
            }
        }
    };
    private HyperlinkAdapter openLdapConfigurationLinkListener = new HyperlinkAdapter(){

        public void linkActivated(HyperlinkEvent e) {
            OverviewPage.this.getServerConfigurationEditor().showPage(LdapLdapsServersPage.class);
        }
    };
    private SelectionAdapter enableKerberosCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            boolean enableKerberos = OverviewPage.this.enableKerberosCheckbox.getSelection();
            KerberosServerPage.enableKerberosServer(OverviewPage.this.getDirectoryServiceBean(), enableKerberos);
            OverviewPage.this.setEnabled((Control)OverviewPage.this.kerberosPortText, enableKerberos);
        }
    };
    private ModifyListener kerberosPortTextListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            KerberosServerPage.setKerberosPort(OverviewPage.this.getDirectoryServiceBean(), OverviewPage.this.kerberosPortText.getText());
        }
    };
    private SelectionAdapter enableChangePasswordCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            ChangePasswordServerBean changePasswordServerBean = OverviewPage.this.getDirectoryServiceBean().getChangePasswordServerBean();
            boolean enableChangePassword = OverviewPage.this.enableChangePasswordCheckbox.getSelection();
            changePasswordServerBean.setEnabled(enableChangePassword);
            OverviewPage.this.setEnabled((Control)OverviewPage.this.changePasswordPortText, enableChangePassword);
        }
    };
    private ModifyListener changePasswordPortTextListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            KerberosServerPage.setChangePasswordPort(OverviewPage.this.getDirectoryServiceBean(), OverviewPage.this.changePasswordPortText.getText());
        }
    };
    private HyperlinkAdapter openKerberosConfigurationLinkListener = new HyperlinkAdapter(){

        public void linkActivated(HyperlinkEvent e) {
            OverviewPage.this.getServerConfigurationEditor().showPage(KerberosServerPage.class);
        }
    };
    private HyperlinkAdapter openPartitionsConfigurationLinkListener = new HyperlinkAdapter(){

        public void linkActivated(HyperlinkEvent e) {
            OverviewPage.this.getServerConfigurationEditor().showPage(PartitionsPage.class);
        }
    };
    private SelectionAdapter allowAnonymousAccessCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            OverviewPage.this.getDirectoryServiceBean().setDsAllowAnonymousAccess(OverviewPage.this.allowAnonymousAccessCheckbox.getSelection());
        }
    };
    private SelectionAdapter enableAccessControlCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            OverviewPage.this.getDirectoryServiceBean().setDsAccessControlEnabled(OverviewPage.this.enableAccessControlCheckbox.getSelection());
        }
    };
    private SelectionAdapter enableHiddenPasswordCheckboxListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            OverviewPage.this.getDirectoryServiceBean().setDsPasswordHidden(OverviewPage.this.enableHiddenPasswordCheckbox.getSelection());
        }
    };

    public OverviewPage(ServerConfigurationEditor editor) {
        super(editor, ID, TITLE);
    }

    @Override
    protected void createFormContent(Composite parent, FormToolkit toolkit) {
        TableWrapLayout twl = new TableWrapLayout();
        twl.numColumns = 2;
        parent.setLayout((Layout)twl);
        Composite leftComposite = toolkit.createComposite(parent);
        leftComposite.setLayout((Layout)new GridLayout());
        TableWrapData leftCompositeTableWrapData = new TableWrapData(128, 16);
        leftCompositeTableWrapData.grabHorizontal = true;
        leftComposite.setLayoutData((Object)leftCompositeTableWrapData);
        Composite rightComposite = toolkit.createComposite(parent);
        rightComposite.setLayout((Layout)new GridLayout());
        TableWrapData rightCompositeTableWrapData = new TableWrapData(128, 16);
        rightCompositeTableWrapData.grabHorizontal = true;
        rightComposite.setLayoutData((Object)rightCompositeTableWrapData);
        this.createLdapLdapsServersSection(toolkit, leftComposite);
        this.createPartitionsSection(toolkit, leftComposite);
        this.createKerberosChangePasswordServersSection(toolkit, rightComposite);
        this.createOptionsSection(toolkit, rightComposite);
        this.refreshUI();
    }

    private void createLdapLdapsServersSection(FormToolkit toolkit, Composite parent) {
        int nbColumns = 4;
        Composite composite = this.createSection(toolkit, parent, "OverviewPage.LdapLdapsServers", nbColumns, 256);
        this.enableLdapCheckbox = toolkit.createButton(composite, Messages.getString("OverviewPage.EnableLdapServer"), 32);
        this.enableLdapCheckbox.setLayoutData((Object)new GridData(4, 0, true, false, nbColumns, 1));
        toolkit.createLabel(composite, "      ");
        toolkit.createLabel(composite, Messages.getString("OverviewPage.Port"));
        this.ldapPortText = this.createPortText(toolkit, composite);
        this.createDefaultValueLabel(toolkit, composite, Integer.toString(10389));
        this.enableLdapsCheckbox = toolkit.createButton(composite, Messages.getString("OverviewPage.EnableLdapsServer"), 32);
        this.enableLdapsCheckbox.setLayoutData((Object)new GridData(4, 0, true, false, nbColumns, 1));
        toolkit.createLabel(composite, "      ");
        toolkit.createLabel(composite, Messages.getString("OverviewPage.Port"));
        this.ldapsPortText = this.createPortText(toolkit, composite);
        this.createDefaultValueLabel(toolkit, composite, Integer.toString(10636));
        this.openLdapConfigurationLink = toolkit.createHyperlink(composite, Messages.getString("OverviewPage.AdvancedLdapLdapsConfiguration"), 0);
        this.openLdapConfigurationLink.setLayoutData((Object)new GridData(4, 0, true, false, nbColumns, 1));
        this.openLdapConfigurationLink.addHyperlinkListener((IHyperlinkListener)this.openLdapConfigurationLinkListener);
    }

    private void createKerberosChangePasswordServersSection(FormToolkit toolkit, Composite parent) {
        int nbColumns = 4;
        Composite composite = this.createSection(toolkit, parent, "OverviewPage.KerberosServer", nbColumns, 256);
        this.enableKerberosCheckbox = toolkit.createButton(composite, Messages.getString("OverviewPage.EnableKerberosServer"), 32);
        this.enableKerberosCheckbox.setLayoutData((Object)new GridData(4, 0, true, false, nbColumns, 1));
        toolkit.createLabel(composite, "      ");
        toolkit.createLabel(composite, Messages.getString("OverviewPage.Port"));
        this.kerberosPortText = this.createPortText(toolkit, composite);
        this.createDefaultValueLabel(toolkit, composite, Integer.toString(60088));
        this.enableChangePasswordCheckbox = toolkit.createButton(composite, Messages.getString("OverviewPage.EnableKerberosChangePasswordServer"), 32);
        this.enableChangePasswordCheckbox.setLayoutData((Object)new GridData(4, 0, true, false, nbColumns, 1));
        toolkit.createLabel(composite, "      ");
        toolkit.createLabel(composite, Messages.getString("OverviewPage.Port"));
        this.changePasswordPortText = this.createPortText(toolkit, composite);
        this.createDefaultValueLabel(toolkit, composite, Integer.toString(60464));
        this.openKerberosConfigurationLink = toolkit.createHyperlink(composite, Messages.getString("OverviewPage.AdvancedKerberosConfiguration"), 0);
        this.openKerberosConfigurationLink.setLayoutData((Object)new GridData(4, 0, true, false, nbColumns, 1));
        this.openKerberosConfigurationLink.addHyperlinkListener((IHyperlinkListener)this.openKerberosConfigurationLinkListener);
    }

    private void createPartitionsSection(FormToolkit toolkit, Composite parent) {
        int nbColumns = 1;
        Composite composite = this.createSection(toolkit, parent, "OverviewPage.Partitions", nbColumns, 256);
        this.partitionsLabel = toolkit.createLabel(composite, "");
        this.partitionsLabel.setLayoutData((Object)new GridData(4, 0, true, false));
        Table partitionsTable = toolkit.createTable(composite, 0);
        GridData gd = new GridData(4, 0, true, false);
        gd.heightHint = 45;
        partitionsTable.setLayoutData((Object)gd);
        this.partitionsTableViewer = new TableViewer(partitionsTable);
        this.partitionsTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.partitionsTableViewer.setLabelProvider((IBaseLabelProvider)PartitionsPage.PARTITIONS_LABEL_PROVIDER);
        this.partitionsTableViewer.setComparator(PartitionsPage.PARTITIONS_COMPARATOR);
        this.openPartitionsConfigurationLink = toolkit.createHyperlink(composite, Messages.getString("OverviewPage.AdvancedPartitionsConfiguration"), 0);
        this.openPartitionsConfigurationLink.setLayoutData((Object)new GridData(4, 0, true, false, nbColumns, 1));
        this.openPartitionsConfigurationLink.addHyperlinkListener((IHyperlinkListener)this.openPartitionsConfigurationLinkListener);
    }

    private void createOptionsSection(FormToolkit toolkit, Composite parent) {
        int nbColumns = 1;
        Composite composite = this.createSection(toolkit, parent, "OverviewPage.Options", nbColumns, 256);
        this.allowAnonymousAccessCheckbox = toolkit.createButton(composite, Messages.getString("OverviewPage.AllowAnonymousAccess"), 32);
        this.allowAnonymousAccessCheckbox.setLayoutData((Object)new GridData(0, 0, true, false));
        this.enableAccessControlCheckbox = toolkit.createButton(composite, Messages.getString("OverviewPage.EnableAccessControl"), 32);
        this.enableAccessControlCheckbox.setLayoutData((Object)new GridData(0, 0, true, false));
        this.enableHiddenPasswordCheckbox = toolkit.createButton(composite, Messages.getString("OverviewPage.EnableHiddenPassword"), 32);
        this.enableHiddenPasswordCheckbox.setLayoutData((Object)new GridData(0, 0, true, false));
    }

    private void addListeners() {
        this.addDirtyListener(this.enableLdapCheckbox);
        this.addSelectionListener(this.enableLdapCheckbox, (SelectionListener)this.enableLdapCheckboxListener);
        this.addDirtyListener(this.ldapPortText);
        this.addModifyListener(this.ldapPortText, this.ldapPortTextListener);
        this.addDirtyListener(this.enableLdapsCheckbox);
        this.addSelectionListener(this.enableLdapsCheckbox, (SelectionListener)this.enableLdapsCheckboxListener);
        this.addDirtyListener(this.ldapsPortText);
        this.addModifyListener(this.ldapsPortText, this.ldapsPortTextListener);
        this.addDirtyListener(this.enableKerberosCheckbox);
        this.addSelectionListener(this.enableKerberosCheckbox, (SelectionListener)this.enableKerberosCheckboxListener);
        this.addDirtyListener(this.kerberosPortText);
        this.addModifyListener(this.kerberosPortText, this.kerberosPortTextListener);
        this.addDirtyListener(this.enableChangePasswordCheckbox);
        this.addSelectionListener(this.enableChangePasswordCheckbox, (SelectionListener)this.enableChangePasswordCheckboxListener);
        this.addDirtyListener(this.changePasswordPortText);
        this.addModifyListener(this.changePasswordPortText, this.changePasswordPortTextListener);
        this.addDirtyListener(this.allowAnonymousAccessCheckbox);
        this.addSelectionListener(this.allowAnonymousAccessCheckbox, (SelectionListener)this.allowAnonymousAccessCheckboxListener);
        this.addDirtyListener(this.enableAccessControlCheckbox);
        this.addSelectionListener(this.enableAccessControlCheckbox, (SelectionListener)this.enableAccessControlCheckboxListener);
        this.addDirtyListener(this.enableHiddenPasswordCheckbox);
        this.addSelectionListener(this.enableHiddenPasswordCheckbox, (SelectionListener)this.enableHiddenPasswordCheckboxListener);
    }

    private void removeListeners() {
        this.removeDirtyListener(this.enableLdapCheckbox);
        this.removeSelectionListener(this.enableLdapCheckbox, (SelectionListener)this.enableLdapCheckboxListener);
        this.removeDirtyListener(this.ldapPortText);
        this.removeModifyListener(this.ldapPortText, this.ldapPortTextListener);
        this.removeDirtyListener(this.enableLdapsCheckbox);
        this.removeSelectionListener(this.enableLdapsCheckbox, (SelectionListener)this.enableLdapsCheckboxListener);
        this.removeDirtyListener(this.ldapsPortText);
        this.removeModifyListener(this.ldapsPortText, this.ldapsPortTextListener);
        this.removeDirtyListener(this.enableKerberosCheckbox);
        this.removeSelectionListener(this.enableKerberosCheckbox, (SelectionListener)this.enableKerberosCheckboxListener);
        this.removeDirtyListener(this.kerberosPortText);
        this.removeModifyListener(this.kerberosPortText, this.kerberosPortTextListener);
        this.removeDirtyListener(this.enableChangePasswordCheckbox);
        this.removeSelectionListener(this.enableChangePasswordCheckbox, (SelectionListener)this.enableChangePasswordCheckboxListener);
        this.removeDirtyListener(this.changePasswordPortText);
        this.removeModifyListener(this.changePasswordPortText, this.changePasswordPortTextListener);
        this.removeDirtyListener(this.allowAnonymousAccessCheckbox);
        this.removeSelectionListener(this.allowAnonymousAccessCheckbox, (SelectionListener)this.allowAnonymousAccessCheckboxListener);
        this.removeDirtyListener(this.enableAccessControlCheckbox);
        this.removeSelectionListener(this.enableAccessControlCheckbox, (SelectionListener)this.enableAccessControlCheckboxListener);
        this.removeDirtyListener(this.enableHiddenPasswordCheckbox);
        this.removeSelectionListener(this.enableHiddenPasswordCheckbox, (SelectionListener)this.enableHiddenPasswordCheckboxListener);
    }

    @Override
    protected void refreshUI() {
        if (this.isInitialized()) {
            this.removeListeners();
            DirectoryServiceBean directoryServiceBean = this.getDirectoryServiceBean();
            TransportBean ldapServerTransportBean = LdapLdapsServersPage.getLdapServerTransportBean(directoryServiceBean);
            this.setSelection(this.enableLdapCheckbox, ldapServerTransportBean.isEnabled());
            this.setEnabled((Control)this.ldapPortText, this.enableLdapCheckbox.getSelection());
            this.setText(this.ldapPortText, Integer.toString(ldapServerTransportBean.getSystemPort()));
            TransportBean ldapsServerTransportBean = LdapLdapsServersPage.getLdapsServerTransportBean(directoryServiceBean);
            this.setSelection(this.enableLdapsCheckbox, ldapsServerTransportBean.isEnabled());
            this.setEnabled((Control)this.ldapsPortText, this.enableLdapsCheckbox.getSelection());
            this.setText(this.ldapsPortText, Integer.toString(ldapsServerTransportBean.getSystemPort()));
            KdcServerBean kdcServerBean = KerberosServerPage.getKdcServerBean(directoryServiceBean);
            this.setSelection(this.enableKerberosCheckbox, kdcServerBean.isEnabled());
            this.setEnabled((Control)this.kerberosPortText, this.enableKerberosCheckbox.getSelection());
            this.setText(this.kerberosPortText, Integer.toString(kdcServerBean.getTransports()[0].getSystemPort()));
            ChangePasswordServerBean changePasswordServerBean = KerberosServerPage.getChangePasswordServerBean(directoryServiceBean);
            this.setSelection(this.enableChangePasswordCheckbox, changePasswordServerBean.isEnabled());
            this.setEnabled((Control)this.changePasswordPortText, this.enableChangePasswordCheckbox.getSelection());
            this.setText(this.changePasswordPortText, Integer.toString(changePasswordServerBean.getTransports()[0].getSystemPort()));
            List partitions = directoryServiceBean.getPartitions();
            if (partitions.size() == 1) {
                this.partitionsLabel.setText(Messages.getString("OverviewPage.ThereIsOnePartitionDefined"));
            } else {
                this.partitionsLabel.setText(NLS.bind((String)Messages.getString("OverviewPage.ThereAreXPartitionsDefined"), (Object)partitions.size()));
            }
            this.partitionsTableViewer.setInput((Object)partitions.toArray());
            this.allowAnonymousAccessCheckbox.setSelection(directoryServiceBean.isDsAllowAnonymousAccess());
            this.enableAccessControlCheckbox.setSelection(directoryServiceBean.isDsAccessControlEnabled());
            this.enableHiddenPasswordCheckbox.setSelection(directoryServiceBean.isDsPasswordHidden());
            this.addListeners();
        }
    }
}

