/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.searchresult;

import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditorCellModifier;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditorContentProvider;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditorCursor;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditorFilter;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditorLabelProvider;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditorSorter;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditorWidget;
import org.apache.directory.studio.valueeditors.ValueEditorManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPart;

public class SearchResultEditorConfiguration {
    private boolean disposed = false;
    protected SearchResultEditorCursor cursor;
    protected SearchResultEditorSorter sorter;
    protected SearchResultEditorFilter filter;
    protected SearchResultEditorContentProvider contentProvider;
    protected SearchResultEditorLabelProvider labelProvider;
    protected SearchResultEditorCellModifier cellModifier;
    protected ValueEditorManager valueEditorManager;
    protected MenuManager contextMenuManager;

    public SearchResultEditorConfiguration(IWorkbenchPart part) {
    }

    public void dispose() {
        if (!this.disposed) {
            if (this.contentProvider != null) {
                this.contentProvider.dispose();
                this.contentProvider = null;
            }
            if (this.labelProvider != null) {
                this.labelProvider.dispose();
                this.labelProvider = null;
            }
            if (this.cellModifier != null) {
                this.cellModifier.dispose();
                this.cellModifier = null;
            }
            if (this.valueEditorManager != null) {
                this.valueEditorManager.dispose();
                this.valueEditorManager = null;
            }
            if (this.contextMenuManager != null) {
                this.contextMenuManager.dispose();
                this.contextMenuManager = null;
            }
            if (this.cursor != null) {
                this.cursor.dispose();
                this.cursor = null;
            }
            this.disposed = true;
        }
    }

    public SearchResultEditorSorter getSorter() {
        if (this.sorter == null) {
            this.sorter = new SearchResultEditorSorter();
        }
        return this.sorter;
    }

    public SearchResultEditorFilter getFilter() {
        if (this.filter == null) {
            this.filter = new SearchResultEditorFilter();
        }
        return this.filter;
    }

    public IMenuManager getContextMenuManager(TableViewer viewer) {
        if (this.contextMenuManager == null) {
            this.contextMenuManager = new MenuManager();
            Menu menu = this.contextMenuManager.createContextMenu(viewer.getControl());
            this.getCursor(viewer).setMenu(menu);
        }
        return this.contextMenuManager;
    }

    public SearchResultEditorContentProvider getContentProvider(SearchResultEditorWidget mainWidget) {
        if (this.contentProvider == null) {
            this.contentProvider = new SearchResultEditorContentProvider(mainWidget, this);
        }
        return this.contentProvider;
    }

    public SearchResultEditorLabelProvider getLabelProvider(TableViewer viewer) {
        if (this.labelProvider == null) {
            this.labelProvider = new SearchResultEditorLabelProvider(this.getValueEditorManager(viewer));
        }
        return this.labelProvider;
    }

    public SearchResultEditorCellModifier getCellModifier(TableViewer viewer) {
        if (this.cellModifier == null) {
            this.cellModifier = new SearchResultEditorCellModifier(this.getValueEditorManager(viewer), this.getCursor(viewer));
        }
        return this.cellModifier;
    }

    public SearchResultEditorCursor getCursor(TableViewer viewer) {
        if (this.cursor == null) {
            this.cursor = new SearchResultEditorCursor(viewer);
        }
        return this.cursor;
    }

    public ValueEditorManager getValueEditorManager(TableViewer viewer) {
        if (this.valueEditorManager == null) {
            this.valueEditorManager = new ValueEditorManager((Composite)viewer.getTable(), true, true);
        }
        return this.valueEditorManager;
    }
}

