/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.views;

import java.util.List;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.SchemaObject;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.controller.HierarchyViewController;
import org.apache.directory.studio.schemaeditor.view.ViewUtils;
import org.apache.directory.studio.schemaeditor.view.views.HierarchyViewContentProvider;
import org.apache.directory.studio.schemaeditor.view.views.HierarchyViewLabelProvider;
import org.apache.directory.studio.schemaeditor.view.views.Messages;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class HierarchyView
extends ViewPart {
    public static final String ID = PluginConstants.VIEW_HIERARCHY_VIEW_ID;
    private TreeViewer viewer;
    private HierarchyViewController controller;
    private Label overviewLabel;

    public void createPartControl(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        parent.setLayout((Layout)gridLayout);
        this.overviewLabel = new Label(parent, 64);
        this.overviewLabel.setText("");
        this.overviewLabel.setLayoutData((Object)new GridData(4, 0, true, false));
        Label separatorLabel = new Label(parent, 258);
        separatorLabel.setLayoutData((Object)new GridData(4, 0, true, false));
        this.initViewer(parent);
        this.controller = new HierarchyViewController(this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(PluginConstants.PLUGIN_ID) + "." + "hierarchy_view");
    }

    private void initViewer(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)new HierarchyViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new HierarchyViewLabelProvider(this.viewer), Activator.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.viewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.getTree().setEnabled(false);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void refresh() {
        this.viewer.refresh();
        this.viewer.expandAll();
    }

    public void setInput(Object input) {
        this.viewer.setInput(input);
        this.viewer.expandAll();
        if (input == null) {
            this.overviewLabel.setText("");
        } else if (input instanceof AttributeType) {
            this.setOverviewLabel((SchemaObject)((AttributeType)input));
        } else if (input instanceof ObjectClass) {
            this.setOverviewLabel((SchemaObject)((ObjectClass)input));
        } else {
            this.overviewLabel.setText("");
        }
    }

    private void setOverviewLabel(SchemaObject object) {
        StringBuffer sb = new StringBuffer();
        List names = object.getNames();
        if (names != null && names.size() > 0) {
            sb.append(ViewUtils.concateAliases(names));
        } else {
            sb.append(Messages.getString("HierarchyView.None"));
        }
        sb.append(NLS.bind((String)Messages.getString("HierarchyView.Schema"), (Object[])new String[]{object.getOid(), object.getSchemaName()}));
        this.overviewLabel.setText(sb.toString());
    }

    public void dispose() {
        this.controller.dispose();
        super.dispose();
    }
}

