/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.synchronize.AbstractSynchronizeScope;
import org.eclipse.ui.IMemento;

public class ResourceScope
extends AbstractSynchronizeScope {
    private static final String CTX_ROOT = "resource_scope_roots";
    private static final String CTX_ROOT_PATH = "resource_scope_root_resource";
    private IResource[] resources;

    public ResourceScope(IResource[] resources) {
        this.resources = resources;
    }

    protected ResourceScope(IMemento memento) {
        super(memento);
    }

    public void setResources(IResource[] resources) {
        this.resources = resources;
        this.fireRootsChanges();
    }

    @Override
    public String getName() {
        return Utils.convertSelection(this.resources);
    }

    @Override
    public IResource[] getRoots() {
        return this.resources;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void saveState(IMemento memento) {
        if (this.resources != null) {
            IResource[] iResourceArray = this.resources;
            int n = this.resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                IMemento rootNode = memento.createChild(CTX_ROOT);
                rootNode.putString(CTX_ROOT_PATH, resource.getFullPath().toString());
                ++n2;
            }
        }
    }

    @Override
    protected void init(IMemento memento) {
        IMemento[] rootNodes = memento.getChildren(CTX_ROOT);
        if (rootNodes != null) {
            ArrayList<IResource> resources = new ArrayList<IResource>();
            IMemento[] iMementoArray = rootNodes;
            int n = rootNodes.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento rootNode = iMementoArray[n2];
                Path path = new Path(rootNode.getString(CTX_ROOT_PATH));
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path, true);
                if (resource != null) {
                    resources.add(resource);
                }
                ++n2;
            }
            this.resources = resources.toArray(new IResource[resources.size()]);
        }
    }
}

