/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapservers.actions;

import org.apache.directory.studio.ldapservers.LdapServersManager;
import org.apache.directory.studio.ldapservers.LdapServersPluginConstants;
import org.apache.directory.studio.ldapservers.actions.Messages;
import org.apache.directory.studio.ldapservers.model.LdapServer;
import org.apache.directory.studio.ldapservers.views.ServersView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class RenameAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private ServersView view;

    public RenameAction(ServersView view) {
        this.view = view;
        this.setText(Messages.getString("RenameAction.Rename"));
        this.setToolTipText(Messages.getString("RenameAction.RenameToolTip"));
        this.setId(LdapServersPluginConstants.CMD_RENAME);
        this.setActionDefinitionId(LdapServersPluginConstants.CMD_RENAME);
    }

    public void run() {
        StructuredSelection selection;
        LdapServer server;
        if (this.view != null && (server = (LdapServer)(selection = (StructuredSelection)this.view.getViewer().getSelection()).getFirstElement()) != null) {
            IInputValidator validator = new IInputValidator(){

                public String isValid(String newName) {
                    if (server.getName().equals(newName)) {
                        return null;
                    }
                    if (!LdapServersManager.getDefault().isNameAvailable(newName)) {
                        return Messages.getString("RenameAction.ErrorNameInUse");
                    }
                    return null;
                }
            };
            InputDialog dialog = new InputDialog(this.view.getSite().getShell(), Messages.getString("RenameAction.RenameServer"), Messages.getString("RenameAction.NewName"), server.getName(), validator);
            dialog.open();
            String newName = dialog.getValue();
            if (newName != null) {
                server.setName(newName);
            }
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

