/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.searchRequest;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.SearchRequestDecorator;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreSearchRequestScope
extends GrammarAction<LdapMessageContainer<SearchRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreSearchRequestScope.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreSearchRequestScope() {
        super("Store SearchRequest scope");
    }

    @Override
    public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
        SearchRequest searchRequest = (SearchRequest)container.getMessage().getDecorated();
        TLV tlv = container.getCurrentTLV();
        BerValue value = tlv.getValue();
        int scope = 0;
        try {
            scope = IntegerDecoder.parse(value, 0, 2);
        }
        catch (IntegerDecoderException ide) {
            String msg = I18n.err(I18n.ERR_04101, value.toString());
            LOG.error(msg);
            throw new DecoderException(msg, ide);
        }
        searchRequest.setScope(SearchScope.getSearchScope(scope));
        if (IS_DEBUG) {
            switch (scope) {
                case 0: {
                    LOG.debug("Searching within BASE_OBJECT scope ");
                    break;
                }
                case 1: {
                    LOG.debug("Searching within SINGLE_LEVEL scope ");
                    break;
                }
                case 2: {
                    LOG.debug("Searching within WHOLE_SUBTREE scope ");
                    break;
                }
                default: {
                    LOG.debug("Searching within UNKNOWN scope ");
                }
            }
        }
    }
}

