/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.templates.transformer.om;

import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.option.OptionName;
import org.apache.torque.generator.source.SourceAttributeName;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.SourceElementName;
import org.apache.torque.generator.source.transform.SourceTransformerException;
import org.apache.torque.templates.TemplateOptionName;
import org.apache.torque.templates.TorqueSchemaElementName;
import org.apache.torque.templates.transformer.om.FieldHelper;
import org.apache.torque.templates.transformer.om.JavaFieldAttributeName;
import org.apache.torque.templates.transformer.om.OMForeignKeyTransformer;
import org.apache.torque.templates.transformer.om.TableAttributeName;
import org.apache.torque.templates.transformer.om.TableChildElementName;

public class OMJoinGetterTransformer {
    public void transform(SourceElement tableElement, ControllerState controllerState) throws SourceTransformerException {
        if (!controllerState.getBooleanOption((OptionName)TemplateOptionName.OM_GENERATE_JOIN_GETTERS)) {
            return;
        }
        this.checkElementName(tableElement);
        SourceElement referencingForeignKeys = tableElement.getChild((SourceElementName)TableChildElementName.REFERENCING_FOREIGN_KEYS);
        for (SourceElement foreignKey : referencingForeignKeys.getChildren((SourceElementName)TorqueSchemaElementName.FOREIGN_KEY)) {
            SourceElement foreignTable = foreignKey.getParent();
            for (SourceElement remoteForeignKey : foreignTable.getChildren((SourceElementName)TorqueSchemaElementName.FOREIGN_KEY)) {
                if (remoteForeignKey == foreignKey) continue;
                SourceElement remoteForeignTable = remoteForeignKey.getChild((SourceElementName)TorqueSchemaElementName.TABLE);
                String localReferencedBySuffix = OMForeignKeyTransformer.getForeignReferencedBySuffix(foreignKey, controllerState);
                String localGetterSetterFieldName = (String)foreignTable.getAttribute((SourceAttributeName)TableAttributeName.DB_OBJECT_CLASS_NAME) + localReferencedBySuffix;
                String foreignReferencedBySuffix = OMForeignKeyTransformer.getForeignReferencedBySuffix(remoteForeignKey, controllerState);
                String foreignGetterSetterFieldName = (String)remoteForeignTable.getAttribute((SourceAttributeName)TableAttributeName.DB_OBJECT_CLASS_NAME) + foreignReferencedBySuffix;
                String joinGetterFieldName = localGetterSetterFieldName + controllerState.getStringOption((OptionName)TemplateOptionName.OM_JOIN_GETTER_SEPARATOR) + foreignGetterSetterFieldName;
                String joinGetterName = FieldHelper.getGetterName(joinGetterFieldName, null, controllerState);
                SourceElement joinGetterElement = new SourceElement((SourceElementName)TableChildElementName.JOIN_GETTER);
                tableElement.getChildren().add(joinGetterElement);
                joinGetterElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.GETTER_NAME, (Object)joinGetterName);
                joinGetterElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.GETTER_ACCESS_MODIFIER, (Object)controllerState.getStringOption((OptionName)TemplateOptionName.OM_JOIN_GETTER_VISIBILITY));
                SourceElement localElement = new SourceElement((SourceElementName)TableChildElementName.LOCAL);
                joinGetterElement.getChildren().add(localElement);
                localElement.getChildren().add(foreignKey);
                SourceElement foreignElement = new SourceElement((SourceElementName)TableChildElementName.FOREIGN);
                joinGetterElement.getChildren().add(foreignElement);
                foreignElement.getChildren().add(remoteForeignKey);
            }
        }
    }

    protected void checkElementName(SourceElement tableElement) {
        if (!TorqueSchemaElementName.TABLE.getName().equals(tableElement.getName()) && !TorqueSchemaElementName.VIEW.getName().equals(tableElement.getName())) {
            throw new IllegalArgumentException("Illegal element Name " + tableElement.getName());
        }
    }
}

