/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration.controller;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.torque.generator.configuration.controller.LoggingAdapter;
import org.apache.torque.generator.configuration.controller.Loglevel;

public class Log4j2LoggingAdapter
implements LoggingAdapter {
    private static Logger log = LogManager.getLogger(Log4j2LoggingAdapter.class);
    private final Map<Loglevel, Level> log4jLevels;

    public Log4j2LoggingAdapter() {
        HashMap<Loglevel, Level> levels = new HashMap<Loglevel, Level>();
        levels.put(Loglevel.TRACE, Level.TRACE);
        levels.put(Loglevel.DEBUG, Level.DEBUG);
        levels.put(Loglevel.INFO, Level.INFO);
        levels.put(Loglevel.WARN, Level.WARN);
        levels.put(Loglevel.ERROR, Level.ERROR);
        this.log4jLevels = Collections.unmodifiableMap(levels);
    }

    @Override
    public Loglevel getCurrentLoglevel() {
        Level level = LogManager.getRootLogger().getLevel();
        for (Map.Entry<Loglevel, Level> loglevel : this.log4jLevels.entrySet()) {
            if (!loglevel.getValue().equals((Object)level)) continue;
            return loglevel.getKey();
        }
        return Loglevel.INFO;
    }

    @Override
    public void setLoglevel(Loglevel loglevel) {
        if (loglevel == null) {
            return;
        }
        Level log4jLevel = this.log4jLevels.get((Object)loglevel);
        if (LogManager.getRootLogger().getLevel() != this.log4jLevels.get((Object)loglevel)) {
            log.info("apply() : Setting loglevel to " + String.valueOf((Object)loglevel));
            Configurator.setRootLevel((Level)log4jLevel);
        }
    }
}

