/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.transport.DaemonClient;
import org.eclipse.jgit.transport.DaemonService;
import org.eclipse.jgit.transport.ReceivePack;
import org.eclipse.jgit.transport.ServiceMayNotContinueException;
import org.eclipse.jgit.transport.UploadPack;
import org.eclipse.jgit.transport.resolver.ReceivePackFactory;
import org.eclipse.jgit.transport.resolver.RepositoryResolver;
import org.eclipse.jgit.transport.resolver.ServiceNotAuthorizedException;
import org.eclipse.jgit.transport.resolver.ServiceNotEnabledException;
import org.eclipse.jgit.transport.resolver.UploadPackFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Daemon {
    public static final int DEFAULT_PORT = 9418;
    private static final int BACKLOG = 5;
    private InetSocketAddress myAddress;
    private final DaemonService[] services;
    private final ThreadGroup processors;
    private boolean run;
    private Thread acceptThread;
    private int timeout;
    private PackConfig packConfig;
    private volatile RepositoryResolver<DaemonClient> repositoryResolver;
    private volatile UploadPackFactory<DaemonClient> uploadPackFactory;
    private volatile ReceivePackFactory<DaemonClient> receivePackFactory;

    public Daemon() {
        this(null);
    }

    public Daemon(InetSocketAddress addr) {
        this.myAddress = addr;
        this.processors = new ThreadGroup("Git-Daemon");
        this.repositoryResolver = RepositoryResolver.NONE;
        this.uploadPackFactory = new UploadPackFactory<DaemonClient>(){

            @Override
            public UploadPack create(DaemonClient req, Repository db) throws ServiceNotEnabledException, ServiceNotAuthorizedException {
                UploadPack up = new UploadPack(db);
                up.setTimeout(Daemon.this.getTimeout());
                up.setPackConfig(Daemon.this.getPackConfig());
                return up;
            }
        };
        this.receivePackFactory = new ReceivePackFactory<DaemonClient>(){

            @Override
            public ReceivePack create(DaemonClient req, Repository db) throws ServiceNotEnabledException, ServiceNotAuthorizedException {
                ReceivePack rp = new ReceivePack(db);
                InetAddress peer = req.getRemoteAddress();
                String host = peer.getCanonicalHostName();
                if (host == null) {
                    host = peer.getHostAddress();
                }
                String name = "anonymous";
                String email = name + "@" + host;
                rp.setRefLogIdent(new PersonIdent(name, email));
                rp.setTimeout(Daemon.this.getTimeout());
                return rp;
            }
        };
        this.services = new DaemonService[]{new DaemonService("upload-pack", "uploadpack"){
            {
                this.setEnabled(true);
            }

            protected void execute(DaemonClient dc, Repository db) throws IOException, ServiceNotEnabledException, ServiceNotAuthorizedException {
                UploadPack up = Daemon.this.uploadPackFactory.create(dc, db);
                InputStream in = dc.getInputStream();
                OutputStream out = dc.getOutputStream();
                up.upload(in, out, null);
            }
        }, new DaemonService("receive-pack", "receivepack"){
            {
                this.setEnabled(false);
            }

            protected void execute(DaemonClient dc, Repository db) throws IOException, ServiceNotEnabledException, ServiceNotAuthorizedException {
                ReceivePack rp = Daemon.this.receivePackFactory.create(dc, db);
                InputStream in = dc.getInputStream();
                OutputStream out = dc.getOutputStream();
                rp.receive(in, out, null);
            }
        }};
    }

    public synchronized InetSocketAddress getAddress() {
        return this.myAddress;
    }

    public synchronized DaemonService getService(String name) {
        if (!name.startsWith("git-")) {
            name = "git-" + name;
        }
        for (DaemonService s : this.services) {
            if (!s.getCommandName().equals(name)) continue;
            return s;
        }
        return null;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int seconds) {
        this.timeout = seconds;
    }

    public PackConfig getPackConfig() {
        return this.packConfig;
    }

    public void setPackConfig(PackConfig pc) {
        this.packConfig = pc;
    }

    public void setRepositoryResolver(RepositoryResolver<DaemonClient> resolver) {
        this.repositoryResolver = resolver;
    }

    public void setUploadPackFactory(UploadPackFactory<DaemonClient> factory) {
        this.uploadPackFactory = factory != null ? factory : UploadPackFactory.DISABLED;
    }

    public void setReceivePackFactory(ReceivePackFactory<DaemonClient> factory) {
        this.receivePackFactory = factory != null ? factory : ReceivePackFactory.DISABLED;
    }

    public synchronized void start() throws IOException {
        if (this.acceptThread != null) {
            throw new IllegalStateException(JGitText.get().daemonAlreadyRunning);
        }
        final ServerSocket listenSock = new ServerSocket(this.myAddress != null ? this.myAddress.getPort() : 0, 5, this.myAddress != null ? this.myAddress.getAddress() : null);
        this.myAddress = (InetSocketAddress)listenSock.getLocalSocketAddress();
        this.run = true;
        this.acceptThread = new Thread(this.processors, "Git-Daemon-Accept"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                Daemon daemon;
                while (Daemon.this.isRunning()) {
                    try {
                        Daemon.this.startClient(listenSock.accept());
                    }
                    catch (InterruptedIOException e) {
                    }
                    catch (IOException e) {
                        // empty catch block
                        break;
                    }
                }
                try {
                    try {
                        listenSock.close();
                    }
                    catch (IOException iOException) {
                        Object var3_5 = null;
                        Daemon daemon3 = Daemon.this;
                        synchronized (daemon3) {
                            Daemon.this.acceptThread = null;
                            return;
                        }
                    }
                    Object var3_4 = null;
                    daemon = Daemon.this;
                }
                catch (Throwable throwable) {
                    Object var3_6 = null;
                    Daemon daemon2 = Daemon.this;
                    synchronized (daemon2) {
                        Daemon.this.acceptThread = null;
                        throw throwable;
                    }
                }
                synchronized (daemon) {
                    Daemon.this.acceptThread = null;
                    return;
                }
            }
        };
        this.acceptThread.start();
    }

    public synchronized boolean isRunning() {
        return this.run;
    }

    public synchronized void stop() {
        if (this.acceptThread != null) {
            this.run = false;
            this.acceptThread.interrupt();
        }
    }

    private void startClient(final Socket s) {
        final DaemonClient dc = new DaemonClient(this);
        SocketAddress peer = s.getRemoteSocketAddress();
        if (peer instanceof InetSocketAddress) {
            dc.setRemoteAddress(((InetSocketAddress)peer).getAddress());
        }
        new Thread(this.processors, "Git-Daemon-Client " + peer.toString()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void run() {
                block20: {
                    dc.execute(s);
                    Object var3_1 = null;
                    try {
                        s.getInputStream().close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    try {
                        s.getOutputStream().close();
                    }
                    catch (IOException e2) {}
                    break block20;
                    {
                        catch (ServiceNotEnabledException e) {
                            Object var3_2 = null;
                            try {
                                s.getInputStream().close();
                            }
                            catch (IOException e2) {
                                // empty catch block
                            }
                            try {
                                s.getOutputStream().close();
                            }
                            catch (IOException e2) {}
                            break block20;
                        }
                        catch (ServiceNotAuthorizedException e) {
                            Object var3_3 = null;
                            try {
                                s.getInputStream().close();
                            }
                            catch (IOException e2) {
                                // empty catch block
                            }
                            try {
                                s.getOutputStream().close();
                            }
                            catch (IOException e2) {}
                            break block20;
                        }
                        catch (IOException iOException) {
                            Object var3_4 = null;
                            try {
                                s.getInputStream().close();
                            }
                            catch (IOException e2) {
                                // empty catch block
                            }
                            try {
                                s.getOutputStream().close();
                            }
                            catch (IOException e2) {}
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_5 = null;
                        try {
                            s.getInputStream().close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                        try {
                            s.getOutputStream().close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
        }.start();
    }

    synchronized DaemonService matchService(String cmd) {
        for (DaemonService d : this.services) {
            if (!d.handles(cmd)) continue;
            return d;
        }
        return null;
    }

    Repository openRepository(DaemonClient client, String name) throws ServiceMayNotContinueException {
        if (!(name = name.replace('\\', '/')).startsWith("/")) {
            return null;
        }
        try {
            return this.repositoryResolver.open(client, name.substring(1));
        }
        catch (RepositoryNotFoundException e) {
            return null;
        }
        catch (ServiceNotAuthorizedException e) {
            return null;
        }
        catch (ServiceNotEnabledException e) {
            return null;
        }
    }
}

