/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.sttest.utils;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.tools.JDBCDisplayUtil;

public class Setup {
    public static boolean doit(String string) throws Throwable {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        boolean bl = false;
        System.out.println("dbsetup start");
        try {
            connection = DriverManager.getConnection(string + ";create=true");
            connection.setAutoCommit(false);
            connection.setHoldability(2);
        }
        catch (SQLException sQLException) {
            System.out.println("connect failed for " + string);
            JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)sQLException);
            return false;
        }
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery("select tablename from sys.systables  where tablename = 'DATATYPES'");
            if (resultSet.next()) {
                resultSet.close();
                System.out.println("table 'DATATYPES' already exists");
                bl = true;
            }
        }
        catch (SQLException sQLException) {
            System.out.println("create table: FAIL -- unexpected exception:");
            JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)sQLException);
            return false;
        }
        if (!bl) {
            try {
                System.out.println("creating table 'DATATYPES'");
                statement.execute("create table Datatypes (id int not null,t_char char(100),t_blob blob(100K),t_clob clob(100K),t_date date,t_decimal decimal,t_decimal_nn decimal(10,10),t_double double precision,t_float float,t_int int,t_longint bigint,t_numeric_large numeric(31,0),t_real real,t_smallint smallint,t_time time,t_timestamp timestamp,t_varchar varchar(100),serialkey bigint generated always as identity (start with 1,increment by 1),unique (serialkey), unique (id))");
                statement.execute("create index t_char_ind on Datatypes ( t_char)");
                statement.execute("create index t_date_ind on Datatypes ( t_date)");
                statement.execute("create index t_decimal_ind on Datatypes ( t_decimal)");
                statement.execute("create index t_decimal_nn_ind on Datatypes ( t_decimal_nn)");
                statement.execute("create index t_double_ind on Datatypes ( t_double)");
                statement.execute("create index t_float_ind on Datatypes ( t_float)");
                statement.execute("create index t_int_ind on Datatypes ( t_int)");
                statement.execute("create index t_longint_ind on Datatypes ( t_longint)");
                statement.execute("create index t_numeric_larg_ind on Datatypes ( t_numeric_large)");
                statement.execute("create index t_real_ind on Datatypes ( t_real)");
                statement.execute("create index t_smallint_ind on Datatypes ( t_smallint)");
                statement.execute("create index t_time_ind on Datatypes ( t_time)");
                statement.execute("create index t_timestamp_ind on Datatypes ( t_timestamp)");
                statement.execute("create index t_varchar_ind on Datatypes ( t_varchar)");
                connection.commit();
                connection.close();
            }
            catch (SQLException sQLException) {
                System.out.println("create table: FAIL -- unexpected exception:");
                JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)sQLException);
                return false;
            }
        }
        return true;
    }
}

