/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.RuntimeStatisticsParser;
import org.apache.derbyTesting.junit.SQLUtilities;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;

public class DistinctTest
extends BaseJDBCTestCase {
    public DistinctTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite(DistinctTest.class);
        Properties properties = new Properties();
        properties.put("derby.optimizer.noTimeout", "true");
        SystemPropertyTestSetup systemPropertyTestSetup = new SystemPropertyTestSetup((Test)baseTestSuite, properties);
        return new CleanDatabaseTestSetup((Test)systemPropertyTestSetup){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.execute("create table t (i int, s smallint, r real, f float, d date, t time, ts timestamp, c char(10), v varchar(20))");
                statement.execute("create table one(c1 int, c2 int, c3 int, c4 int, c5 int)");
                statement.execute("create unique index one_c1 on one(c1)");
                statement.execute("create table two(c1 int, c2 int, c3 int, c4 int, c5 int)");
                statement.execute("create unique index two_c1c3 on two(c1, c3)");
                statement.execute("create table three(c1 int, c2 int, c3 int, c4 int, c5 int)");
                statement.execute("create unique index three_c1 on three(c1)");
                statement.execute("create table four(c1 int, c2 int, c3 int, c4 int, c5 int)");
                statement.execute("create unique index four_c1c3 on four(c1, c3)");
                statement.execute("CREATE TABLE \"APP\".\"IDEPT\" (\"DISCRIM_DEPT\" VARCHAR(32), \"NO1\" INTEGER NOT NULL, \"NAME\" VARCHAR(50), \"AUDITOR_NO\" INTEGER, \"REPORTTO_NO\" INTEGER, \"HARDWAREASSET\" VARCHAR(15), \"SOFTWAREASSET\" VARCHAR(15))");
                statement.execute("ALTER TABLE \"APP\".\"IDEPT\" ADD CONSTRAINT \"PK_IDEPT\" PRIMARY KEY (\"NO1\")");
                statement.execute("insert into one values (1, 1, 1, 1, 1)");
                statement.execute("insert into one values (2, 1, 1, 1, 1)");
                statement.execute("insert into one values (3, 1, 1, 1, 1)");
                statement.execute("insert into one values (4, 1, 1, 1, 1)");
                statement.execute("insert into one values (5, 1, 1, 1, 1)");
                statement.execute("insert into one values (6, 1, 1, 1, 1)");
                statement.execute("insert into one values (7, 1, 1, 1, 1)");
                statement.execute("insert into one values (8, 1, 1, 1, 1)");
                statement.execute("insert into two values (1, 1, 1, 1, 1)");
                statement.execute("insert into two values (1, 1, 2, 1, 1)");
                statement.execute("insert into two values (1, 1, 3, 1, 1)");
                statement.execute("insert into two values (2, 1, 1, 1, 1)");
                statement.execute("insert into two values (2, 1, 2, 1, 1)");
                statement.execute("insert into two values (2, 1, 3, 1, 1)");
                statement.execute("insert into two values (3, 1, 1, 1, 1)");
                statement.execute("insert into two values (3, 1, 2, 1, 1)");
                statement.execute("insert into two values (3, 1, 3, 1, 1)");
                statement.execute("insert into three values (1, 1, 1, 1, 1)");
                statement.execute("insert into three values (2, 1, 1, 1, 1)");
                statement.execute("insert into three values (3, 1, 1, 1, 1)");
                statement.execute("insert into three values (4, 1, 1, 1, 1)");
                statement.execute("insert into three values (5, 1, 1, 1, 1)");
                statement.execute("insert into three values (6, 1, 1, 1, 1)");
                statement.execute("insert into three values (7, 1, 1, 1, 1)");
                statement.execute("insert into three values (8, 1, 1, 1, 1)");
                statement.execute("insert into four values (1, 1, 1, 1, 1)");
                statement.execute("insert into four values (1, 1, 2, 1, 1)");
                statement.execute("insert into four values (1, 1, 3, 1, 1)");
                statement.execute("insert into four values (2, 1, 1, 1, 1)");
                statement.execute("insert into four values (2, 1, 2, 1, 1)");
                statement.execute("insert into four values (2, 1, 3, 1, 1)");
                statement.execute("insert into four values (3, 1, 1, 1, 1)");
                statement.execute("insert into four values (3, 1, 2, 1, 1)");
                statement.execute("insert into four values (3, 1, 3, 1, 1)");
                statement.execute("insert into idept values ('Dept', 1, 'Department1', null, null, null, null)");
                statement.execute("insert into idept values ('HardwareDept', 2, 'Department2', 25, 1, 'hardwareaset2', null)");
                statement.execute("insert into idept values ('HardwareDept', 3, 'Department3', 25, 2, 'hardwareaset3', null)");
                statement.execute("insert into idept values ('SoftwareDept', 4, 'Department4', 25, 1, null, 'softwareasset4')");
                statement.execute("insert into idept values ('SoftwareDept', 5, 'Department5', 30, 4, null, 'softwareasset5')");
            }
        };
    }

    public void testNoData() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("delete from t");
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        this.checkDistinctRows(nArray);
        statement.close();
    }

    public void testOneRow() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("delete from t");
        statement.execute("insert into t values (1, 2, 3, 4, '1992-01-01', '19:01:01', '1992-01-01 19:01:01.000', 'hello', 'planet')");
        int[] nArray = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 0, -1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1};
        this.checkDistinctRows(nArray);
        statement.close();
    }

    public void testIdenticalRows() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("delete from t");
        statement.execute("insert into t values (1, 2, 3, 4, '1992-01-01', '19:01:01', '1992-01-01 19:01:01.000', 'hello', 'planet')");
        statement.execute("insert into t values (1, 2, 3, 4, '1992-01-01', '19:01:01', '1992-01-01 19:01:01.000', 'hello', 'planet')");
        int[] nArray = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 0, 0, 2, 0, 2, 2, 2, 0, -1, 1, 1, 1, 2, 2, 1, 2, 2, 1, 2, 1, 1, 1, 1};
        this.checkDistinctRows(nArray);
        statement.close();
    }

    public void testDistinctIdenticalAndDifferingRows() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("delete from t");
        statement.execute("insert into t values (1, 2, 3, 4, '1992-01-01', '19:01:01', '1992-01-01 19:01:01.000', 'hello', 'planet')");
        statement.execute("insert into t values (1, 2, 3, 4, '1992-01-01', '19:01:01', '1992-01-01 19:01:01.000', 'hello', 'planet')");
        statement.execute("insert into t values (2, 1, 4, 3, '1992-01-01', '19:01:01', '1992-01-01 19:01:01.000', 'hello', 'planet')");
        int[] nArray = new int[]{2, 2, 2, 2, 1, 1, 1, 1, 1, 2, 2, 2, 3, 3, 0, 3, 3, 3, 3, 3, 3, 0, -1, 2, 2, 2, 3, 3, 2, 3, 3, 2, 4, 2, 2, 2, 2};
        this.checkDistinctRows(nArray);
        statement.close();
    }

    public void testDistinctTwoVaryingRows() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("delete from t");
        statement.execute("insert into t values (1, 2, 3, 4, '1992-01-01', '19:01:01', '1992-01-01 19:01:01.000', 'hello', 'planet')");
        statement.execute("insert into t values (1, 1, 3, 4, '1992-01-02', '19:01:01', '1992-01-01 19:01:01.000', 'goodbye', 'planet')");
        int[] nArray = new int[]{1, 2, 1, 1, 2, 1, 1, 2, 1, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 0, -2, 2, 2, 2, 4, 4, 2, 2, 2, 2, 2, 1, 2, 2, 4};
        this.checkDistinctRows(nArray);
        statement.close();
    }

    public void testDistinctIdenticalNullRows() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("delete from t");
        statement.execute("insert into t (i) values (null)");
        statement.execute("insert into t (i) values (null)");
        int[] nArray = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 2, 1, 1, 1, 0};
        this.checkDistinctRows(nArray);
    }

    public void testDistinctSomeNullRows() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("delete from t");
        statement.execute("insert into t values (1, 2, 3, 4, '1992-01-01', '19:01:01', '1992-01-01 19:01:01.000', 'hello', 'planet')");
        statement.execute("insert into t values (1, 1, 3, 4, '1992-01-02', '19:01:01', '1992-01-01 19:01:01.000', 'goodbye', 'planet')");
        statement.execute("insert into t (i) values (null)");
        int[] nArray = new int[]{2, 3, 2, 2, 3, 2, 2, 3, 2, 3, 3, 3, 3, 3, 0, 2, 0, 2, 2, 2, 0, -2, -2, 3, 3, 3, 4, 4, 3, 2, 2, 2, 4, 2, 3, 3, 4};
        this.checkDistinctRows(nArray);
    }

    public void testDistinctManyNullRows() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("delete from t");
        statement.execute("insert into t values (1, 2, 3, 4, '1992-01-01', '19:01:01', '1992-01-01 19:01:01.000', 'hello', 'planet')");
        statement.execute("insert into t values (1, 1, 3, 4, '1992-01-02', '19:01:01', '1992-01-01 19:01:01.000', 'goodbye', 'planet')");
        statement.execute("insert into t (i) values (null)");
        statement.execute("insert into t (i) values (null)");
        statement.execute("insert into t (i) values (null)");
        int[] nArray = new int[]{2, 3, 2, 2, 3, 2, 2, 3, 2, 3, 3, 3, 5, 5, 0, 2, 0, 2, 2, 2, 0, -2, -2, 3, 3, 3, 4, 4, 3, 2, 2, 2, 4, 2, 3, 3, 4};
        this.checkDistinctRows(nArray);
    }

    public void testDistinctMixedNullRows() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("delete from t");
        statement.execute("insert into t values (1, 2, 3, 4, '1992-01-01', '19:01:01', '1992-01-01 19:01:01.000', 'hello', 'planet')");
        statement.execute("insert into t values (1, 1, 3, 4, '1992-01-02', '19:01:01', '1992-01-01 19:01:01.000', 'goodbye', 'planet')");
        statement.execute("insert into t values (null, 1, null, 4, null, '19:01:01', null, 'goodbye', null)");
        statement.execute("insert into t values (1, null, 3, null, '1992-01-02', null, '1992-01-01 19:01:01.000', null, 'planet')");
        int[] nArray = new int[]{2, 3, 2, 2, 3, 2, 2, 3, 2, 4, 4, 4, 4, 4, 0, 3, 0, 3, 3, 3, 0, -2, -2, 4, 4, 4, 9, 9, 4, 2, 2, 2, 4, 2, 4, 4, 9};
        this.checkDistinctRows(nArray);
    }

    public void testDistinctInValuesClause() throws SQLException {
        Statement statement = this.createStatement();
        this.assertRowCount(3, statement.executeQuery("select distinct * from (values (1,2),(1,3),(1,2),(2,3)) as t(a,b)"));
        this.assertRowCount(2, statement.executeQuery("select distinct a from (values (1,2),(1,3),(1,2),(2,3)) as t(a,b)"));
        statement.close();
    }

    public void testDistinctSyntaxErrors() throws SQLException {
        Statement statement = this.createStatement();
        try {
            statement.executeQuery("select distinct from t");
        }
        catch (SQLException sQLException) {
            DistinctTest.assertSQLState("42X01", sQLException);
        }
        try {
            statement.executeQuery("select i as distinct from t");
        }
        catch (SQLException sQLException) {
            DistinctTest.assertSQLState("42X01", sQLException);
        }
        try {
            statement.executeQuery("select i, v from t distinct");
        }
        catch (SQLException sQLException) {
            DistinctTest.assertSQLState("42X01", sQLException);
        }
        statement.close();
    }

    public void testBasicDistinct() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create table userInt (u integer)");
        statement.execute("insert into userInt values (123)");
        statement.execute("insert into userInt values (123)");
        statement.execute("insert into userInt values (456)");
        statement.execute("insert into userInt values (null)");
        statement.execute("create table sqlInt (i int not null)");
        statement.execute("insert into sqlInt values(123)");
        this.assertRowCount(2, statement.executeQuery("select distinct u from userInt where u is not null"));
        this.assertRowCount(3, statement.executeQuery("select u from userInt where u is not null"));
        try {
            statement.executeQuery("select distinct i from sqlInt where i = (select distinct u from userInt)");
        }
        catch (SQLException sQLException) {
            DistinctTest.assertSQLState("21000", sQLException);
        }
        statement.execute("drop table userInt");
        statement.execute("drop table sqlInt");
        statement.close();
    }

    public void testDistinctPaddingInVarcharIgnored() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create table v (v varchar(40))");
        statement.execute("insert into v values ('hello')");
        statement.execute("insert into v values ('hello   ')");
        statement.execute("insert into v values ('hello      ')");
        this.assertRowCount(1, statement.executeQuery("select distinct v from v"));
        JDBC.assertSingleValueResultSet(statement.executeQuery("select {fn length(c)} from (select distinct v from v) as t(c)"), "5");
        statement.execute("drop table v");
        statement.close();
    }

    public void testDistinctWithBigInt() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create table li (l bigint, i int)");
        statement.execute("insert into li values(1, 1)");
        statement.execute("insert into li values(1, 1)");
        statement.execute("insert into li values(9223372036854775807, 2147483647)");
        this.assertRowCount(2, statement.executeQuery("select distinct l from li"));
        this.assertRowCount(4, statement.executeQuery("(select distinct l from li) union all (select distinct i from li) order by 1"));
        this.assertRowCount(3, statement.executeQuery("select distinct l from li union select distinct i from li"));
        this.assertRowCount(3, statement.executeQuery("select distinct l from (select l from li union all select i from li) a(l)"));
        statement.execute("drop table li");
        statement.close();
    }

    public void testDistinctWithUpdatedRows() throws SQLException {
        Connection connection = this.getConnection();
        connection.setAutoCommit(false);
        Statement statement = connection.createStatement(1004, 1008);
        statement.execute("create table u (d date)");
        statement.execute("insert into u values ('1997-09-09'),('1997-09-09')");
        statement.execute("insert into u values (null)");
        ResultSet resultSet = statement.executeQuery("select distinct d from u");
        DistinctTest.assertTrue((boolean)resultSet.next());
        DistinctTest.assertTrue((boolean)resultSet.next());
        DistinctTest.assertFalse((boolean)resultSet.next());
        resultSet.close();
        try {
            resultSet = statement.executeQuery("select distinct d from u for update");
            DistinctTest.fail((String)"Distinct: for update test should have thrown exception");
        }
        catch (SQLException sQLException) {
            DistinctTest.assertSQLState("42Y90", sQLException);
        }
        try {
            resultSet = statement.executeQuery("select distinct d from u for update of d");
            DistinctTest.fail((String)"Distinct: for update test should have thrown exception");
        }
        catch (SQLException sQLException) {
            DistinctTest.assertSQLState("42Y90", sQLException);
        }
        statement.setCursorName("C1");
        resultSet = statement.executeQuery("select distinct d from u");
        DistinctTest.assertTrue((boolean)resultSet.next());
        Statement statement2 = this.createStatement();
        try {
            statement2.executeUpdate("update u set d='1992-01-01' where current of C1");
            DistinctTest.fail((String)"Distinct: update test should have thrown exception");
        }
        catch (SQLException sQLException) {
            DistinctTest.assertSQLState("42X23", sQLException);
        }
        try {
            statement2.executeUpdate("delete from u where current of C1");
            DistinctTest.fail((String)"Distinct: update test should have thrown exception");
        }
        catch (SQLException sQLException) {
            DistinctTest.assertSQLState("42X23", sQLException);
        }
        DistinctTest.assertTrue((boolean)resultSet.next());
        DistinctTest.assertFalse((boolean)resultSet.next());
        resultSet.close();
        try {
            statement2.executeUpdate("update u set d='1992-01-01' where current of C1");
            DistinctTest.fail((String)"Distinct: update test should have thrown exception");
        }
        catch (SQLException sQLException) {
            DistinctTest.assertSQLState("42X30", sQLException);
        }
        try {
            statement2.executeUpdate("delete from u where current of c1");
            DistinctTest.fail((String)"Distinct: update test should have thrown exception");
        }
        catch (SQLException sQLException) {
            DistinctTest.assertSQLState("42X30", sQLException);
        }
        statement2.close();
        statement.close();
        connection.rollback();
        connection.setAutoCommit(true);
    }

    public void testDistinctInInsert() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("delete from t");
        statement.execute("create table insert_test (i int, s smallint, r real, f float, d date, t time, ts timestamp, c char(10), v varchar(20))");
        statement.execute("insert into t values (1, 2, 3, 4, '1992-01-01', '19:01:01', '1992-01-01 19:01:01.000', 'hello', 'planet')");
        statement.execute("insert into t values (1, 2, 3, 4, '1992-01-01', '19:01:01', '1992-01-01 19:01:01.000', 'hello', 'planet')");
        statement.execute("insert into t values (2, 1, 4, 3, '1992-01-01', '19:01:01', '1992-01-01 19:01:01.000', 'hello', 'planet')");
        statement.execute("insert into insert_test select distinct * from t");
        this.assertRowCount(2, statement.executeQuery("select * from insert_test"));
        statement.execute("delete from insert_test");
        statement.execute("insert into insert_test select distinct * from t union select * from t");
        this.assertRowCount(2, statement.executeQuery("select * from insert_test"));
        statement.execute("delete from insert_test");
        statement.execute("drop table insert_test");
        statement.execute("delete from t");
        statement.close();
    }

    public void testDistinctInsertWithGeneratedColumn() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create table destWithAI(c11 int generated always as identity, c12 int)");
        statement.execute("alter table destWithAI alter c11 set increment by 1");
        statement.execute("create table destWithNoAI(c21 int, c22 int)");
        statement.execute("create table source(c31 int, c32 int, c33 int)");
        statement.execute("insert into source values(1,1,1)");
        statement.execute("insert into source values(1,2,1)");
        statement.execute("insert into source values(2,1,1)");
        statement.execute("insert into source values(2,2,1)");
        this.assertRowCount(2, statement.executeQuery("select distinct(c31) from source"));
        DistinctTest.assertEquals((int)2, (int)statement.executeUpdate("insert into destWithAI(c12) select distinct(c31) from source"));
        String[][] stringArray = new String[][]{{"1"}, {"2"}};
        JDBC.assertFullResultSet(statement.executeQuery("select c11 from destWithAI order by c11"), stringArray);
        JDBC.assertFullResultSet(statement.executeQuery("select c12 from destWithAI order by c12"), stringArray);
        DistinctTest.assertEquals((int)2, (int)statement.executeUpdate("insert into destWithNoAI(c22) select distinct(c31) from source"));
        stringArray = new String[][]{{null, "1"}, {null, "2"}};
        JDBC.assertFullResultSet(statement.executeQuery("select * from destWithNoAI order by c22"), stringArray);
        statement.execute("drop table source");
        statement.execute("drop table destWithNoAI");
        statement.execute("drop table destWithAI");
        statement.close();
    }

    public void testResultSetInOrderWhenUsingIndex() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("CREATE TABLE netbutton1 (lname varchar(128) not null, name varchar(128), summary varchar(256), lsummary varchar(256), description varchar(2000), ldescription varchar(2000), publisher_username varchar(256), publisher_lusername varchar(256), version varchar(16), source long varchar for bit data, updated timestamp, created timestamp DEFAULT current_timestamp, primary key (lname))");
        statement.execute("insert into netbutton1 values('lname1','name1','sum2','lsum1', 'des1','ldes1','pubu1', 'publu1', 'ver1', null, current_timestamp, default)");
        statement.execute("insert into netbutton1 values('lname2','name2','sum2','lsum2', 'des2','ldes2','pubu2', 'publu2', 'ver2', null, current_timestamp, default)");
        statement.execute("CREATE TABLE library_netbutton (netbuttonlibrary_id int not null, lname varchar(128) not null, primary key (netbuttonlibrary_id, lname))");
        statement.execute("insert into library_netbutton values(1, 'lname1')");
        statement.execute("insert into library_netbutton values(2, 'lname2')");
        statement.execute("create unique index ln_library_id on library_netbutton(netbuttonlibrary_id)");
        statement.execute("ALTER TABLE library_netbutton ADD CONSTRAINT ln_lname_fk FOREIGN KEY (lname) REFERENCES netbutton1(lname)");
        statement.execute("CREATE TABLE netbuttonlibraryrole1 (lusername varchar(512) not null, netbuttonlibrary_id int not null, username varchar(512), role varchar(24), created timestamp DEFAULT current_timestamp, primary key (lusername, netbuttonlibrary_id))");
        statement.execute("insert into netbuttonlibraryrole1 values('lusername1', 1,'user1', 'role1', default)");
        statement.execute("insert into netbuttonlibraryrole1 values('lusername2', 2,'user2', 'role2', default)");
        PreparedStatement preparedStatement = this.prepareStatement("SELECT DISTINCT nb.name AS name, nb.summary AS summary FROM netbutton1 nb, netbuttonlibraryrole1 nlr, library_netbutton ln WHERE nlr.netbuttonlibrary_id = ln.netbuttonlibrary_id AND nb.lname = ln.lname AND (nlr.lusername = ? OR nlr.lusername = ?) AND nb.lname = ? ORDER BY summary");
        preparedStatement.setString(1, "lusername1");
        preparedStatement.setString(2, "lusername2");
        preparedStatement.setString(3, "lname1");
        DistinctTest.assertTrue((boolean)preparedStatement.execute());
        String[][] stringArray = new String[][]{{"name1", "sum2"}};
        ResultSet resultSet = preparedStatement.getResultSet();
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet.close();
        preparedStatement.close();
        preparedStatement = this.prepareStatement("SELECT DISTINCT nb.name AS name, nb.summary AS summary FROM netbutton1 nb, netbuttonlibraryrole1 nlr, library_netbutton ln WHERE nlr.netbuttonlibrary_id = ln.netbuttonlibrary_id AND nb.lname = ln.lname AND (nlr.lusername = ? OR nlr.lusername =?) ORDER BY summary");
        preparedStatement.setString(1, "lusername1");
        preparedStatement.setString(2, "lusername2");
        DistinctTest.assertTrue((boolean)preparedStatement.execute());
        stringArray = new String[][]{{"name1", "sum2"}, {"name2", "sum2"}};
        resultSet = preparedStatement.getResultSet();
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet.close();
        statement.execute("drop table library_netbutton");
        statement.execute("drop table netbutton1");
        statement.close();
    }

    public void testDistinctStoreSort() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create table td (x int)");
        statement.execute("insert into td values (1)");
        statement.execute("insert into td values (1)");
        statement.execute("insert into td values (2)");
        String[][] stringArray = new String[][]{{"1", "1"}, {"1", "1"}, {"2", "1"}};
        JDBC.assertFullResultSet(statement.executeQuery("select * from td, (select distinct 1 from td) as sub(x)"), stringArray);
        stringArray = new String[][]{{"1", "2"}, {"1", "1"}, {"1", "2"}, {"1", "1"}, {"2", "2"}, {"2", "1"}};
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from td, (select distinct x from td) as sub(x)"), stringArray);
        statement.execute("drop table td");
        statement.close();
    }

    public void testDistinctScanForSubquery() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create table names (id int, name varchar(10), age int)");
        statement.execute("insert into names (id, name, age) values (1, 'Anna', 23), (2, 'Ben', 24), (3, 'Carl', 25), (4, 'Anna', 23), (5, 'Ben', 24), (6, 'Carl', 25)");
        statement.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        this.assertRowCount(3, statement.executeQuery("select distinct name from (select name, id from names) as n"));
        RuntimeStatisticsParser runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        DistinctTest.assertTrue((boolean)runtimeStatisticsParser.usedTableScan());
        DistinctTest.assertFalse((boolean)runtimeStatisticsParser.usedDistinctScan());
        this.assertRowCount(3, statement.executeQuery("select distinct name from (select name from names) as n"));
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        DistinctTest.assertFalse((boolean)runtimeStatisticsParser.usedTableScan());
        DistinctTest.assertTrue((boolean)runtimeStatisticsParser.usedDistinctScan());
        this.assertRowCount(6, statement.executeQuery("select distinct a, b, b, a from (select y as a, x as b from (select id as x, name as y from names) as n) as m"));
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        DistinctTest.assertFalse((boolean)runtimeStatisticsParser.usedTableScan());
        DistinctTest.assertTrue((boolean)runtimeStatisticsParser.usedDistinctScan());
        this.assertRowCount(3, statement.executeQuery("select distinct a, a from (select y as a from (select id as x, name as y from names) as n) as m"));
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        DistinctTest.assertTrue((boolean)runtimeStatisticsParser.usedTableScan());
        DistinctTest.assertFalse((boolean)runtimeStatisticsParser.usedDistinctScan());
        statement.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(0)");
        statement.execute("drop table names");
        statement.close();
    }

    public void testDistinctElimination() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        this.assertRowCount(1, statement.executeQuery("select distinct c2 from one"));
        RuntimeStatisticsParser runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        DistinctTest.assertTrue((boolean)runtimeStatisticsParser.usedDistinctScan());
        this.assertRowCount(2, statement.executeQuery("select distinct q1.\"NO1\",  q1.\"NAME\",  q1.\"AUDITOR_NO\",  q1.\"REPORTTO_NO\",  q1.\"DISCRIM_DEPT\",  q1.\"SOFTWAREASSET\" from IDEPT q1, IDEPT q2 where ( q2.\"DISCRIM_DEPT\" = 'HardwareDept') and ( q1.\"DISCRIM_DEPT\" = 'SoftwareDept') and ( q1.\"NO1\" <> ALL ( select q3.\"NO1\" from IDEPT q3 where ( ( q3.\"DISCRIM_DEPT\" = 'Dept') or ( q3.\"DISCRIM_DEPT\" = 'HardwareDept')  or  ( q3.\"DISCRIM_DEPT\" = 'SoftwareDept') ) and ( q3.\"REPORTTO_NO\" =  q2.\"NO1\") ) ) "));
        this.assertRowCount(2, statement.executeQuery("select  distinct  q1.\"NO1\" from IDEPT q1, IDEPT q2 where ( q2.\"DISCRIM_DEPT\" = 'HardwareDept')\tand ( q1.\"DISCRIM_DEPT\" = 'SoftwareDept') and ( q1.\"NO1\" <> ALL (select  q3.\"NO1\" from IDEPT q3 where  ( ABS(q3.\"REPORTTO_NO\") =  q2.\"NO1\")))"));
        statement.execute("create table temp_result (c2 int, c3 int)");
        statement.execute("insert into temp_result select distinct c2, c3 from two");
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        DistinctTest.assertTrue((boolean)runtimeStatisticsParser.usedDistinctScan());
        this.assertRowCount(3, statement.executeQuery("select distinct c2, c3 from two order by c2, c3"));
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        DistinctTest.assertFalse((boolean)runtimeStatisticsParser.usedDistinctScan());
        this.assertRowCount(3, statement.executeQuery("select distinct a.c1, b.c1 from one a, two b where a.c1 = b.c1 and b.c2 =1"));
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        DistinctTest.assertTrue((boolean)runtimeStatisticsParser.eliminatedDuplicates());
        this.assertRowCount(8, statement.executeQuery("select distinct a.c1 from one a, two b"));
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        DistinctTest.assertTrue((boolean)runtimeStatisticsParser.eliminatedDuplicates());
        this.assertRowCount(9, statement.executeQuery("select distinct a.c1, a.c3, a.c2 from two a, two b where a.c1 = b.c1"));
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        DistinctTest.assertTrue((boolean)runtimeStatisticsParser.eliminatedDuplicates());
        this.assertRowCount(9, statement.executeQuery("select distinct a.c1, a.c3, a.c2 from two a, two b where a.c1 = b.c1 and a.c2 = 1"));
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        DistinctTest.assertTrue((boolean)runtimeStatisticsParser.eliminatedDuplicates());
        this.assertRowCount(1, statement.executeQuery("select distinct a.c1 from one a, two b, three c where a.c1 = b.c1 and c.c1 = b.c3 and a.c1 = 1"));
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        DistinctTest.assertTrue((boolean)runtimeStatisticsParser.eliminatedDuplicates());
        this.assertRowCount(3, statement.executeQuery("select distinct a.c1 from two a, four b where a.c1 = b.c1 and b.c3 = 1"));
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        DistinctTest.assertTrue((boolean)runtimeStatisticsParser.eliminatedDuplicates());
        this.assertRowCount(9, statement.executeQuery("select distinct a.c1, a.c3 from two a, one b"));
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        DistinctTest.assertTrue((boolean)runtimeStatisticsParser.eliminatedDuplicates());
        this.assertRowCount(1, statement.executeQuery("select distinct a.c1 from one a, two b, three c where a.c1 = c.c1 and a.c1 = 1"));
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        DistinctTest.assertTrue((boolean)runtimeStatisticsParser.eliminatedDuplicates());
        this.assertRowCount(8, statement.executeQuery("select distinct c1 from one"));
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        DistinctTest.assertFalse((boolean)runtimeStatisticsParser.usedDistinctScan());
        DistinctTest.assertFalse((boolean)runtimeStatisticsParser.eliminatedDuplicates());
        this.assertRowCount(8, statement.executeQuery("select distinct c1, c2 + c3 from one"));
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        DistinctTest.assertFalse((boolean)runtimeStatisticsParser.usedDistinctScan());
        DistinctTest.assertFalse((boolean)runtimeStatisticsParser.eliminatedDuplicates());
        this.assertRowCount(9, statement.executeQuery("select distinct c3, c1 from two"));
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        DistinctTest.assertFalse((boolean)runtimeStatisticsParser.usedDistinctScan());
        DistinctTest.assertFalse((boolean)runtimeStatisticsParser.eliminatedDuplicates());
        this.assertRowCount(1, statement.executeQuery("select distinct c2 from one where c1 = 3"));
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        DistinctTest.assertFalse((boolean)runtimeStatisticsParser.usedDistinctScan());
        DistinctTest.assertFalse((boolean)runtimeStatisticsParser.eliminatedDuplicates());
        this.assertRowCount(1, statement.executeQuery("select distinct c3 from one where c1 = 3"));
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        DistinctTest.assertFalse((boolean)runtimeStatisticsParser.usedDistinctScan());
        DistinctTest.assertFalse((boolean)runtimeStatisticsParser.eliminatedDuplicates());
        this.assertRowCount(8, statement.executeQuery("select distinct c2, c5, c1 from one"));
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        DistinctTest.assertFalse((boolean)runtimeStatisticsParser.usedDistinctScan());
        DistinctTest.assertFalse((boolean)runtimeStatisticsParser.eliminatedDuplicates());
        this.assertRowCount(9, statement.executeQuery("select distinct c2, c3, c1 from two"));
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        DistinctTest.assertFalse((boolean)runtimeStatisticsParser.usedDistinctScan());
        DistinctTest.assertFalse((boolean)runtimeStatisticsParser.eliminatedDuplicates());
        this.assertRowCount(8, statement.executeQuery("select distinct a.c1 from one a, one b where a.c1 = b.c1"));
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        DistinctTest.assertFalse((boolean)runtimeStatisticsParser.usedDistinctScan());
        DistinctTest.assertFalse((boolean)runtimeStatisticsParser.eliminatedDuplicates());
        this.assertRowCount(8, statement.executeQuery("select distinct a.c1, 3 from one a, one b where a.c1 = b.c1"));
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        DistinctTest.assertFalse((boolean)runtimeStatisticsParser.usedDistinctScan());
        DistinctTest.assertFalse((boolean)runtimeStatisticsParser.eliminatedDuplicates());
        this.assertRowCount(9, statement.executeQuery("select distinct a.c1, a.c3, a.c2 from two a, one b where a.c1 = b.c1"));
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        DistinctTest.assertFalse((boolean)runtimeStatisticsParser.usedDistinctScan());
        DistinctTest.assertFalse((boolean)runtimeStatisticsParser.eliminatedDuplicates());
        this.assertRowCount(9, statement.executeQuery("select distinct a.c1, a.c3, a.c2 from two a, two b where a.c1 = b.c1 and b.c3 = 1"));
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        DistinctTest.assertFalse((boolean)runtimeStatisticsParser.usedDistinctScan());
        DistinctTest.assertFalse((boolean)runtimeStatisticsParser.eliminatedDuplicates());
        this.assertRowCount(3, statement.executeQuery("select distinct a.c1 from two a, four b where a.c1 = b.c1 and a.c3 = b.c3 and b.c3 = 1"));
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        DistinctTest.assertFalse((boolean)runtimeStatisticsParser.usedDistinctScan());
        DistinctTest.assertFalse((boolean)runtimeStatisticsParser.eliminatedDuplicates());
        statement.execute("drop table temp_result");
        statement.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(0)");
        statement.close();
    }

    public void testDistinctFiltering() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create table t1(c1 int, c2 char(50), c3 char(50))");
        statement.execute("create table t2(c1 int, c2 char(50), c3 char(50))");
        statement.execute("create index t11 on t1(c1)");
        statement.execute("create index t12 on t1(c1, c2)");
        statement.execute("create index t13 on t1(c1, c3, c2)");
        statement.execute("create unique index t21 on t2(c1, c2)");
        statement.execute("create unique index t22 on t2(c1, c3)");
        statement.execute("insert into t1 values (1, '1', '1'), (1, '1', '1'), (1, '11', '11'), (1, '11', '11'), (2, '2', '2'), (2, '2', '3'), (2, '3', '2'), (3, '3', '3'), (null, null, null)");
        statement.execute("insert into t2 values (1, '1', '1'), (1, '2', '2'), (2, '1', '1'), (2, '2', '2'), (null, 'null', 'null')");
        statement.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        this.assertRowCount(4, statement.executeQuery("select distinct c1 from t1 where 1=1"));
        RuntimeStatisticsParser runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        DistinctTest.assertFalse((boolean)runtimeStatisticsParser.usedDistinctScan());
        DistinctTest.assertTrue((boolean)runtimeStatisticsParser.eliminatedDuplicates());
        this.assertRowCount(1, statement.executeQuery("select distinct c2 from t1 where c1 = 1 and c3 = '1'"));
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        DistinctTest.assertFalse((boolean)runtimeStatisticsParser.usedDistinctScan());
        DistinctTest.assertTrue((boolean)runtimeStatisticsParser.eliminatedDuplicates());
        this.assertRowCount(1, statement.executeQuery("select distinct c3 from t1 where c1 = 1 and c2 = '1'"));
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        DistinctTest.assertFalse((boolean)runtimeStatisticsParser.usedDistinctScan());
        DistinctTest.assertTrue((boolean)runtimeStatisticsParser.eliminatedDuplicates());
        this.assertRowCount(1, statement.executeQuery("select distinct c3 from t2 where c1 = 1 and c2 = '1'"));
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        DistinctTest.assertFalse((boolean)runtimeStatisticsParser.usedDistinctScan());
        DistinctTest.assertFalse((boolean)runtimeStatisticsParser.eliminatedDuplicates());
        this.assertRowCount(6, statement.executeQuery("select distinct c2, c1 from t1 where 1=1"));
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        DistinctTest.assertFalse((boolean)runtimeStatisticsParser.usedDistinctScan());
        DistinctTest.assertTrue((boolean)runtimeStatisticsParser.eliminatedDuplicates());
        this.assertRowCount(2, statement.executeQuery("select distinct c2 from t1 where c1 = 1"));
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        DistinctTest.assertFalse((boolean)runtimeStatisticsParser.usedDistinctScan());
        DistinctTest.assertTrue((boolean)runtimeStatisticsParser.eliminatedDuplicates());
        this.assertRowCount(1, statement.executeQuery("select distinct c2, c1 from t1 where c3 = '1'"));
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        DistinctTest.assertFalse((boolean)runtimeStatisticsParser.usedDistinctScan());
        DistinctTest.assertTrue((boolean)runtimeStatisticsParser.eliminatedDuplicates());
        this.assertRowCount(1, statement.executeQuery("select distinct c2 from t1 where c3 = '1' and c1 = 1"));
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        DistinctTest.assertFalse((boolean)runtimeStatisticsParser.usedDistinctScan());
        DistinctTest.assertTrue((boolean)runtimeStatisticsParser.eliminatedDuplicates());
        statement.execute("create table temp_result (result_column int)");
        statement.execute("insert into temp_result (select distinct c1 from t1)");
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        DistinctTest.assertTrue((boolean)runtimeStatisticsParser.usedDistinctScan());
        this.assertRowCount(4, statement.executeQuery("select * from temp_result order by result_column"));
        this.assertRowCount(4, statement.executeQuery("select distinct c1 from t1 order by c1"));
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        DistinctTest.assertFalse((boolean)runtimeStatisticsParser.usedDistinctScan());
        DistinctTest.assertTrue((boolean)runtimeStatisticsParser.eliminatedDuplicates());
        statement.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(0)");
        statement.execute("drop table temp_result");
        statement.execute("drop table t1");
        statement.execute("drop table t2");
        statement.close();
    }

    private void checkDistinctRows(int[] nArray) throws SQLException {
        DistinctTest.assertEquals((String)"DistinctTest: rowcounts array is not the right length", (int)37, (int)nArray.length);
        Statement statement = this.createStatement();
        this.assertRowCount(nArray[0], statement.executeQuery("select distinct i from t"));
        this.assertRowCount(nArray[1], statement.executeQuery("select distinct s from t"));
        this.assertRowCount(nArray[2], statement.executeQuery("select distinct r from t"));
        this.assertRowCount(nArray[3], statement.executeQuery("select distinct f from t"));
        this.assertRowCount(nArray[4], statement.executeQuery("select distinct d from t"));
        this.assertRowCount(nArray[5], statement.executeQuery("select distinct t from t"));
        this.assertRowCount(nArray[6], statement.executeQuery("select distinct ts from t"));
        this.assertRowCount(nArray[7], statement.executeQuery("select distinct c from t"));
        this.assertRowCount(nArray[8], statement.executeQuery("select distinct v from t"));
        this.assertRowCount(nArray[9], statement.executeQuery("select distinct t,i,s,f,d from t"));
        this.assertRowCount(nArray[10], statement.executeQuery("select distinct * from t"));
        this.assertRowCount(nArray[11], statement.executeQuery("select distinct t.*,ts from t"));
        this.assertRowCount(nArray[12], statement.executeQuery("select * from t where exists (select distinct i from t)"));
        this.assertRowCount(nArray[13], statement.executeQuery("select * from t where exists (select distinct * from t)"));
        this.assertRowCount(nArray[14], statement.executeQuery("select * from t where not exists (select distinct t from t)"));
        this.assertRowCount(nArray[15], statement.executeQuery("select * from t where i in (select distinct s from t)"));
        this.assertRowCount(nArray[16], statement.executeQuery("select * from t where s not in (select distinct r from t)"));
        this.assertRowCount(nArray[17], statement.executeQuery("select * from t where i =any (select distinct s from t)"));
        this.assertRowCount(nArray[18], statement.executeQuery("select * from t where s <>any (select distinct r from t)"));
        this.assertRowCount(nArray[19], statement.executeQuery("select * from t where d >=any (select distinct d from t)"));
        this.assertRowCount(nArray[20], statement.executeQuery("select * from t where t <=all (select distinct t from t)"));
        try {
            this.assertRowCount(nArray[21], statement.executeQuery("select * from t where c = (select distinct v from t)"));
        }
        catch (SQLException sQLException) {
            if (nArray[21] == -2) {
                DistinctTest.assertSQLState("21000", sQLException);
            }
            DistinctTest.fail((String)"Distinct: expected SQLException was not thrown.");
        }
        try {
            this.assertRowCount(nArray[22], statement.executeQuery("select * from t where v < (select distinct d from t)"));
        }
        catch (SQLException sQLException) {
            if (nArray[22] == -1) {
                DistinctTest.assertSQLState("22007", sQLException);
            }
            if (nArray[22] == -2) {
                DistinctTest.assertSQLState("21000", sQLException);
            }
            DistinctTest.fail((String)"Distinct: expected SQLException was not thrown.");
        }
        this.assertRowCount(nArray[23], statement.executeQuery("select * from (select distinct t,i,s,f,d from t) as s(a,b,c,d,e)"));
        this.assertRowCount(nArray[24], statement.executeQuery("select * from (select distinct * from t) as s"));
        this.assertRowCount(nArray[25], statement.executeQuery("select * from (select distinct t.*,ts as tts from t) as s"));
        this.assertRowCount(nArray[26], statement.executeQuery("select * from t, (select distinct t.*,ts as tts from t) as s where t.i=s.i"));
        this.assertRowCount(nArray[27], statement.executeQuery("select * from (select distinct t.*,ts as tts from t) as s, t where t.i=s.i"));
        this.assertRowCount(nArray[28], statement.executeQuery("select distinct * from (select distinct t,i,s,f,d from t) as s(a,b,c,d,e)"));
        this.assertRowCount(nArray[29], statement.executeQuery("select i, s from t as touter where touter.i in (select distinct i from t)\tand exists (select distinct s from t as ti where touter.s=ti.s)"));
        this.assertRowCount(nArray[30], statement.executeQuery("select i, s from t as touter where touter.i in (select distinct i from t)\tand touter.s =any (select distinct s from t)"));
        this.assertRowCount(nArray[31], statement.executeQuery("select distinct i, s from t where t.i in (select distinct i from t) and t.s in (select distinct s from t)"));
        this.assertRowCount(nArray[32], statement.executeQuery("select distinct i from t union all select distinct i from t"));
        this.assertRowCount(nArray[33], statement.executeQuery("select distinct * from (select i from t union all select i from t) as s"));
        this.assertRowCount(nArray[34], statement.executeQuery("select distinct * from (select t,i,s,f,d from t) as s(a,b,c,d,e)"));
        this.assertRowCount(nArray[35], statement.executeQuery("select distinct * from (select distinct t,i,s,f,d from t) as s(a,b,c,d,e)"));
        this.assertRowCount(nArray[36], statement.executeQuery("select distinct * from t t1, t t2 where t1.i = t2.i"));
        statement.close();
    }

    public void assertRowCount(int n, ResultSet resultSet) throws SQLException {
        JDBC.assertDrainResults(resultSet, n);
    }
}

