/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;

public class CryptoCrashRecoveryTest
extends BaseJDBCTestCase {
    private static boolean USE_ENC_PWD = true;
    private static boolean USE_ENC_KEY = false;
    private static final int OP_ENCRYPT = 0;
    private static final int OP_DECRYPT = 1;
    private static final int OP_REENCRYPT = 2;
    private static final String TEST_TABLE_NAME = "emp";
    private static final String OLD_PASSWORD = "xyz1234abc";
    private static final String NEW_PASSWORD = "new1234xyz";
    private static final String OLD_KEY = "6162636465666768";
    private static final String NEW_KEY = "5666768616263646";
    private static final String TEST_REENCRYPT_CRASH_BEFORE_COMMT = "TEST_REENCRYPT_CRASH_BEFORE_COMMT";
    private static final String TEST_REENCRYPT_CRASH_AFTER_COMMT = "TEST_REENCRYPT_CRASH_AFTER_COMMT";
    private static final String TEST_REENCRYPT_CRASH_AFTER_SWITCH_TO_NEWKEY = "TEST_REENCRYPT_CRASH_AFTER_SWITCH_TO_NEWKEY";
    private static final String TEST_REENCRYPT_CRASH_AFTER_CHECKPOINT = "TEST_REENCRYPT_CRASH_AFTER_CHECKPOINT";
    private static final String TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_LOGFILE_DELETE = "TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_LOGFILE_DELETE";
    private static final String TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_REVERTING_KEY = "TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_REVERTING_KEY";
    private static final String TEST_REENCRYPT_CRASH_BEFORE_RECOVERY_FINAL_CLEANUP = "TEST_REENCRYPT_CRASH_BEFORE_RECOVERY_FINAL_CLEANUP";

    public CryptoCrashRecoveryTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("CryptoCrashRecovery disabled due to non-debug build");
        CryptoCrashRecoveryTest.println("CryptoCrashRecoveryTest disabled due to non-debug build");
        return baseTestSuite;
    }

    public void testDecryptionWithBootPassword() throws Exception {
        String string = "wombat_pwd_de";
        DataSource dataSource = JDBCDataSource.getDataSource(string);
        this.runCrashRecoveryTestCases(dataSource, 1, USE_ENC_PWD);
        CryptoCrashRecoveryTest.assertDirectoryDeleted(new File("system", string));
    }

    public void testDecryptionWithEncryptionKey() throws Exception {
        String string = "wombat_key_de";
        DataSource dataSource = JDBCDataSource.getDataSource(string);
        this.runCrashRecoveryTestCases(dataSource, 1, USE_ENC_KEY);
        CryptoCrashRecoveryTest.assertDirectoryDeleted(new File("system", string));
    }

    public void testEncryptionWithBootPassword() throws Exception {
        String string = "wombat_pwd_en";
        DataSource dataSource = JDBCDataSource.getDataSource(string);
        this.runCrashRecoveryTestCases(dataSource, 0, USE_ENC_PWD);
        CryptoCrashRecoveryTest.assertDirectoryDeleted(new File("system", string));
    }

    public void testEncryptionWithEncryptionKey() throws Exception {
        String string = "wombat_key_en";
        DataSource dataSource = JDBCDataSource.getDataSource(string);
        this.runCrashRecoveryTestCases(dataSource, 0, USE_ENC_KEY);
        CryptoCrashRecoveryTest.assertDirectoryDeleted(new File("system", string));
    }

    public void testReEncryptionWithBootPassword() throws Exception {
        String string = "wombat_pwd_ren";
        DataSource dataSource = JDBCDataSource.getDataSource(string);
        this.runCrashRecoveryTestCases(dataSource, 2, USE_ENC_PWD);
        CryptoCrashRecoveryTest.assertDirectoryDeleted(new File("system", string));
    }

    public void testReEncryptionWithEncryptionKey() throws Exception {
        String string = "wombat_key_ren";
        DataSource dataSource = JDBCDataSource.getDataSource(string);
        this.runCrashRecoveryTestCases(dataSource, 2, USE_ENC_KEY);
        CryptoCrashRecoveryTest.assertDirectoryDeleted(new File("system", string));
    }

    private void runCrashRecoveryTestCases(DataSource dataSource, int n, boolean bl) throws SQLException {
        Connection connection = null;
        switch (n) {
            case 1: 
            case 2: {
                connection = this.createEncryptedDatabase(dataSource, bl);
                break;
            }
            case 0: {
                connection = this.createDatabase(dataSource);
                break;
            }
            default: {
                CryptoCrashRecoveryTest.fail((String)("unsupported operation: " + n));
            }
        }
        this.createTable(connection, TEST_TABLE_NAME);
        this.insert(connection, TEST_TABLE_NAME, 100);
        connection.commit();
        connection.close();
        JDBCDataSource.shutdownDatabase(dataSource);
        Boolean bl2 = n == 2 ? Boolean.FALSE : null;
        this.crash(dataSource, n, bl, TEST_REENCRYPT_CRASH_BEFORE_COMMT);
        this.crash(dataSource, n, bl, TEST_REENCRYPT_CRASH_AFTER_COMMT);
        this.crashInRecovery(dataSource, bl, bl2, TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_LOGFILE_DELETE);
        this.crashInRecovery(dataSource, bl, bl2, TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_REVERTING_KEY);
        this.crashInRecovery(dataSource, bl, bl2, TEST_REENCRYPT_CRASH_BEFORE_RECOVERY_FINAL_CLEANUP);
        this.crash(dataSource, n, bl, TEST_REENCRYPT_CRASH_AFTER_COMMT);
        this.crashInRecovery(dataSource, bl, bl2, TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_LOGFILE_DELETE);
        this.crash(dataSource, n, bl, TEST_REENCRYPT_CRASH_AFTER_COMMT);
        this.crash(dataSource, n, bl, TEST_REENCRYPT_CRASH_AFTER_SWITCH_TO_NEWKEY);
        this.crashInRecovery(dataSource, bl, bl2, TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_LOGFILE_DELETE);
        this.crashInRecovery(dataSource, bl, bl2, TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_REVERTING_KEY);
        this.crashInRecovery(dataSource, bl, bl2, TEST_REENCRYPT_CRASH_BEFORE_RECOVERY_FINAL_CLEANUP);
        this.crash(dataSource, n, bl, TEST_REENCRYPT_CRASH_AFTER_SWITCH_TO_NEWKEY);
        this.crashInRecovery(dataSource, bl, bl2, TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_REVERTING_KEY);
        this.crash(dataSource, n, bl, TEST_REENCRYPT_CRASH_AFTER_SWITCH_TO_NEWKEY);
        this.crashInRecovery(dataSource, bl, bl2, TEST_REENCRYPT_CRASH_BEFORE_RECOVERY_FINAL_CLEANUP);
        bl2 = n == 2 ? Boolean.TRUE : Boolean.FALSE;
        this.crash(dataSource, n, bl, TEST_REENCRYPT_CRASH_AFTER_CHECKPOINT);
        this.crashInRecovery(dataSource, bl, bl2, TEST_REENCRYPT_CRASH_BEFORE_RECOVERY_FINAL_CLEANUP);
        if (n == 1) {
            bl2 = null;
        }
        this.recover(dataSource, bl, bl2);
        JDBCDataSource.shutdownDatabase(dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void crash(DataSource dataSource, int n, boolean bl, String string) {
        CryptoCrashRecoveryTest.println("Testing crash at " + string);
        this.setDebugFlag(string);
        try {
            switch (n) {
                case 2: {
                    this.reEncryptDatabase(dataSource, bl);
                    break;
                }
                case 0: {
                    this.encryptDatabase(dataSource, bl);
                    break;
                }
                case 1: {
                    this.decryptDatabase(dataSource, bl);
                    break;
                }
                default: {
                    CryptoCrashRecoveryTest.fail((String)"unsupported operation");
                }
            }
            CryptoCrashRecoveryTest.fail((String)"crypto operation didn't crash as expected");
        }
        catch (SQLException sQLException) {
            this.verifyBootException(sQLException, string);
        }
        finally {
            this.clearDebugFlag(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void crashInRecovery(DataSource dataSource, boolean bl, Boolean bl2, String string) throws SQLException {
        CryptoCrashRecoveryTest.println("Recovery crash at " + string);
        this.setDebugFlag(string);
        try {
            this.bootDatabase(dataSource, bl, bl2);
            CryptoCrashRecoveryTest.fail((String)"database booted unexpectedly");
        }
        catch (SQLException sQLException) {
            this.verifyBootException(sQLException, string);
        }
        finally {
            this.clearDebugFlag(string);
        }
    }

    private void recover(DataSource dataSource, boolean bl, Boolean bl2) throws SQLException {
        Connection connection = this.bootDatabase(dataSource, bl, bl2);
        this.runConsistencyChecker(connection, TEST_TABLE_NAME);
        this.insert(connection, TEST_TABLE_NAME, 100);
        connection.commit();
        connection.close();
    }

    private void setDebugFlag(String string) {
    }

    private void clearDebugFlag(String string) {
    }

    private void verifyBootException(SQLException sQLException, String string) {
        CryptoCrashRecoveryTest.assertSQLState("XJ040", sQLException);
        for (SQLException sQLException2 = sQLException.getNextException(); sQLException2 != null; sQLException2 = sQLException2.getNextException()) {
            String string2 = sQLException2.getMessage();
            if (string2.indexOf(string) == -1) continue;
            return;
        }
        CryptoCrashRecoveryTest.fail("real error or wrong debug flag triggered crash", sQLException);
    }

    private void createTable(Connection connection, String string) throws SQLException {
        Statement statement = connection.createStatement();
        statement.executeUpdate("CREATE TABLE " + string + "(id INT,name VARCHAR(200))");
        statement.executeUpdate("create index " + string + "_id_idx on " + string + "(id)");
        statement.close();
    }

    private void runConsistencyChecker(Connection connection, String string) throws SQLException {
        Statement statement = connection.createStatement();
        statement.execute("values SYSCS_UTIL.SYSCS_CHECK_TABLE('APP',  'EMP')");
        this.verifyContents(connection, string);
    }

    private void insert(Connection connection, String string, int n) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO " + string + " VALUES(?,?)");
        int n2 = this.findMaxId(connection, string);
        int n3 = n + n2;
        for (int i = n2; i < n3; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setString(2, "skywalker" + i);
            preparedStatement.executeUpdate();
        }
        preparedStatement.close();
        connection.commit();
    }

    private int findMaxId(Connection connection, String string) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT max(ID) from " + string);
        CryptoCrashRecoveryTest.assertTrue((boolean)resultSet.next());
        int n = resultSet.getInt(1);
        resultSet.close();
        statement.close();
        return n;
    }

    private void verifyContents(Connection connection, String string) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT ID, name from " + string + " order by id");
        int n = 0;
        int n2 = 0;
        while (resultSet.next()) {
            int n3 = resultSet.getInt(1);
            String string2 = resultSet.getString(2);
            CryptoCrashRecoveryTest.assertEquals((String)("skywalker" + n2), (String)string2);
            CryptoCrashRecoveryTest.assertEquals((int)n2, (int)n3);
            ++n2;
            ++n;
        }
        resultSet.close();
        statement.close();
        connection.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection createEncryptedDatabase(DataSource dataSource, boolean bl) throws SQLException {
        Object object = "dataEncryption=true;";
        object = bl ? (String)object + "bootPassword=xyz1234abc" : (String)object + "encryptionKey=6162636465666768";
        JDBCDataSource.setBeanProperty(dataSource, "createDatabase", "create");
        JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", object);
        try {
            Connection connection = dataSource.getConnection();
            return connection;
        }
        finally {
            JDBCDataSource.clearStringBeanProperty(dataSource, "createDatabase");
            JDBCDataSource.clearStringBeanProperty(dataSource, "connectionAttributes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection createDatabase(DataSource dataSource) throws SQLException {
        JDBCDataSource.setBeanProperty(dataSource, "createDatabase", "create");
        try {
            Connection connection = dataSource.getConnection();
            JDBC.assertNoWarnings(connection.getWarnings());
            Connection connection2 = connection;
            return connection2;
        }
        finally {
            JDBCDataSource.clearStringBeanProperty(dataSource, "createDatabase");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection reEncryptDatabase(DataSource dataSource, boolean bl) throws SQLException {
        String string = bl ? "bootPassword=xyz1234abc;newBootPassword=new1234xyz" : "encryptionKey=6162636465666768;newEncryptionKey=5666768616263646";
        JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", string);
        CryptoCrashRecoveryTest.println("re-encrypting " + CryptoCrashRecoveryTest.db(dataSource) + " with " + string);
        try {
            Connection connection = dataSource.getConnection();
            return connection;
        }
        finally {
            JDBCDataSource.clearStringBeanProperty(dataSource, "connectionAttributes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection encryptDatabase(DataSource dataSource, boolean bl) throws SQLException {
        Object object = "dataEncryption=true;";
        object = bl ? (String)object + "bootPassword=xyz1234abc" : (String)object + "encryptionKey=6162636465666768";
        JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", object);
        CryptoCrashRecoveryTest.println("encrypting " + CryptoCrashRecoveryTest.db(dataSource) + " with " + (String)object);
        try {
            Connection connection = dataSource.getConnection();
            return connection;
        }
        finally {
            JDBCDataSource.clearStringBeanProperty(dataSource, "connectionAttributes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection decryptDatabase(DataSource dataSource, boolean bl) throws SQLException {
        Object object = "decryptDatabase=true;";
        object = bl ? (String)object + "bootPassword=xyz1234abc" : (String)object + "encryptionKey=6162636465666768";
        JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", object);
        CryptoCrashRecoveryTest.println("decrypting " + CryptoCrashRecoveryTest.db(dataSource) + " with " + (String)object);
        try {
            Connection connection = dataSource.getConnection();
            return connection;
        }
        finally {
            JDBCDataSource.clearStringBeanProperty(dataSource, "connectionAttributes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection bootDatabase(DataSource dataSource, boolean bl, Boolean bl2) throws SQLException {
        String string = "";
        if (bl) {
            if (Boolean.TRUE.equals(bl2)) {
                string = "bootPassword=new1234xyz";
            } else if (Boolean.FALSE.equals(bl2)) {
                string = "bootPassword=xyz1234abc";
            }
        } else if (Boolean.TRUE.equals(bl2)) {
            string = "encryptionKey=5666768616263646";
        } else if (Boolean.FALSE.equals(bl2)) {
            string = "encryptionKey=6162636465666768";
        }
        JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", string);
        CryptoCrashRecoveryTest.println("booting " + CryptoCrashRecoveryTest.db(dataSource) + (String)(string.length() > 0 ? " with " + string : ""));
        try {
            Connection connection = dataSource.getConnection();
            return connection;
        }
        finally {
            JDBCDataSource.clearStringBeanProperty(dataSource, "connectionAttributes");
        }
    }

    private static String db(DataSource dataSource) {
        try {
            return (String)JDBCDataSource.getBeanProperty(dataSource, "databaseName");
        }
        catch (Exception exception) {
            return "<unknown/error>";
        }
    }
}

