/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ParameterMetaDataJdbc30Test
extends BaseJDBCTestCase {
    public ParameterMetaDataJdbc30Test(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("ParameterMetaDataJdbc30Test");
        if (JDBC.vmSupportsJSR169()) {
            return new BaseTestSuite("Empty ParameterMetaDataJDBC30. JSR169 does not support ParameterMetaData");
        }
        baseTestSuite.addTest(ParameterMetaDataJdbc30Test.baseSuite("ParameterMetaDataJdbc30Test:embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(ParameterMetaDataJdbc30Test.baseSuite("ParameterMetaDataJdbc30Test:client")));
        return baseTestSuite;
    }

    private static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        baseTestSuite.addTestSuite(ParameterMetaDataJdbc30Test.class);
        return new CleanDatabaseTestSetup((Test)baseTestSuite){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                Connection connection = this.getConnection();
                statement.execute("CREATE PROCEDURE PMDD(IN pmdI_1 DECIMAL(5,3), IN pmdI_2 DECIMAL(4,2), INOUT pmdI_3 DECIMAL(9,0), OUT pmdI_4 DECIMAL(10,2)) language java parameter style java external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.ParameterMetaDataJdbc30Test.dummyDecimal'");
                statement.execute("create table t ( c char(5), iNoNull int not null, i int, de decimal, d date)");
                statement.executeUpdate("create function RDB(P1 INT) RETURNS DECIMAL(10,2) language java external name 'org.apache.derbyTesting.functionTests.tests.lang.outparams30.returnsBigDecimal' parameter style java");
            }
        };
    }

    public void testCallableStatement() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create procedure dummyint( in a integer, in b integer, out c integer, inout d integer) language java external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.ParameterMetaDataJdbc30Test.dummyint' parameter style java");
        CallableStatement callableStatement = this.prepareCall("CALL dummyint(?,?,?,?)");
        callableStatement.setInt(1, 1);
        callableStatement.setInt(2, 1);
        callableStatement.registerOutParameter(3, 4);
        Integer n = 1;
        callableStatement.setObject(4, (Object)n, 4);
        callableStatement.registerOutParameter(4, 4);
        ParameterMetaData parameterMetaData = callableStatement.getParameterMetaData();
        ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter count", (int)4, (int)parameterMetaData.getParameterCount());
        String[][] stringArray = new String[][]{{"PARAMETER_NULLABLE", "true", "10", "0", "4", "INTEGER", "java.lang.Integer", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "true", "10", "0", "4", "INTEGER", "java.lang.Integer", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "true", "10", "0", "4", "INTEGER", "java.lang.Integer", "PARAMETER_MODE_OUT"}, {"PARAMETER_NULLABLE", "true", "10", "0", "4", "INTEGER", "java.lang.Integer", "PARAMETER_MODE_IN_OUT"}};
        ParameterMetaDataJdbc30Test.testParameterMetaData(parameterMetaData, stringArray);
        callableStatement.execute();
        callableStatement = this.prepareCall("? = call RDB(?)");
        parameterMetaData = callableStatement.getParameterMetaData();
        ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter count", (int)2, (int)parameterMetaData.getParameterCount());
        String[][] stringArray2 = new String[][]{{"PARAMETER_NULLABLE", "true", "31", "0", "3", "DECIMAL", "java.math.BigDecimal", "PARAMETER_MODE_OUT"}, {"PARAMETER_NULLABLE", "true", "10", "0", "4", "INTEGER", "java.lang.Integer", "PARAMETER_MODE_IN"}};
        ParameterMetaDataJdbc30Test.testParameterMetaData(parameterMetaData, stringArray2);
        statement.execute("drop procedure dummyint");
        statement.close();
        callableStatement.close();
    }

    public void testPreparedStatement() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("insert into t values(?, ?, ?, ?, ?)");
        preparedStatement.setNull(1, 1);
        preparedStatement.setInt(2, 1);
        preparedStatement.setNull(3, 4);
        preparedStatement.setBigDecimal(4, new BigDecimal("1"));
        preparedStatement.setNull(5, 91);
        ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
        ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter count", (int)5, (int)parameterMetaData.getParameterCount());
        String[][] stringArray = new String[][]{{"PARAMETER_NULLABLE", "false", "5", "0", "1", "CHAR", "java.lang.String", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "true", "10", "0", "4", "INTEGER", "java.lang.Integer", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "true", "10", "0", "4", "INTEGER", "java.lang.Integer", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "true", "5", "0", "3", "DECIMAL", "java.math.BigDecimal", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "false", "10", "0", "91", "DATE", "java.sql.Date", "PARAMETER_MODE_IN"}};
        ParameterMetaDataJdbc30Test.testParameterMetaData(parameterMetaData, stringArray);
        preparedStatement.execute();
        preparedStatement = this.prepareStatement("select * from sys.systables where  CAST(tablename AS VARCHAR(128)) like ? and CAST(tableID AS CHAR(36)) like ?");
        preparedStatement.setString(1, "SYS%");
        preparedStatement.setString(2, "8000001%");
        parameterMetaData = preparedStatement.getParameterMetaData();
        ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter count", (int)2, (int)parameterMetaData.getParameterCount());
        String[][] stringArray2 = new String[][]{{"PARAMETER_NULLABLE", "false", "128", "0", "12", "VARCHAR", "java.lang.String", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "false", "36", "0", "1", "CHAR", "java.lang.String", "PARAMETER_MODE_IN"}};
        ParameterMetaDataJdbc30Test.testParameterMetaData(parameterMetaData, stringArray2);
        preparedStatement.execute();
        preparedStatement.close();
    }

    public void testBooleanParameters() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create function booleanValue( b boolean )\nreturns varchar( 100 ) language java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.BooleanValuesTest.booleanValue'\n");
        statement.executeUpdate("create table t_boolean( b boolean )");
        statement.close();
        PreparedStatement preparedStatement = this.prepareStatement("values( booleanValue( ? ) )");
        ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
        ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter count", (int)1, (int)parameterMetaData.getParameterCount());
        String[][] stringArray = new String[][]{{"PARAMETER_NULLABLE", "false", "1", "0", "16", "BOOLEAN", "java.lang.Boolean", "PARAMETER_MODE_IN"}};
        ParameterMetaDataJdbc30Test.testParameterMetaData(parameterMetaData, stringArray);
        preparedStatement.close();
        preparedStatement = this.prepareStatement("insert into t_boolean values(?)");
        preparedStatement.setBoolean(1, true);
        parameterMetaData = preparedStatement.getParameterMetaData();
        ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter count", (int)1, (int)parameterMetaData.getParameterCount());
        stringArray = new String[][]{{"PARAMETER_NULLABLE", "false", "1", "0", "16", "BOOLEAN", "java.lang.Boolean", "PARAMETER_MODE_IN"}};
        ParameterMetaDataJdbc30Test.testParameterMetaData(parameterMetaData, stringArray);
        preparedStatement.close();
    }

    public void testBooleanProcedureArgs() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("create procedure booleanProc( in inarg boolean, out outarg boolean, inout inoutarg boolean )language java external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.ParameterMetaDataJdbc30Test.booleanProc' parameter style java");
        CallableStatement callableStatement = this.prepareCall("CALL booleanProc(?,?,?)");
        callableStatement.registerOutParameter(2, 16);
        callableStatement.registerOutParameter(3, 16);
        ParameterMetaData parameterMetaData = callableStatement.getParameterMetaData();
        ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter count", (int)3, (int)parameterMetaData.getParameterCount());
        String[][] stringArray = new String[][]{{"PARAMETER_NULLABLE", "false", "1", "0", "16", "BOOLEAN", "java.lang.Boolean", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "false", "1", "0", "16", "BOOLEAN", "java.lang.Boolean", "PARAMETER_MODE_OUT"}, {"PARAMETER_NULLABLE", "false", "1", "0", "16", "BOOLEAN", "java.lang.Boolean", "PARAMETER_MODE_IN_OUT"}};
        ParameterMetaDataJdbc30Test.testParameterMetaData(parameterMetaData, stringArray);
        callableStatement.setBoolean(1, true);
        callableStatement.setBoolean(3, true);
        callableStatement.execute();
        ParameterMetaDataJdbc30Test.assertEquals((boolean)true, (boolean)callableStatement.getBoolean(2));
        ParameterMetaDataJdbc30Test.assertEquals((boolean)false, (boolean)callableStatement.getBoolean(3));
        callableStatement.setObject(1, (Object)Boolean.FALSE);
        callableStatement.setObject(3, (Object)Boolean.FALSE);
        callableStatement.execute();
        ParameterMetaDataJdbc30Test.assertEquals((boolean)false, (boolean)callableStatement.getBoolean(2));
        ParameterMetaDataJdbc30Test.assertEquals((boolean)true, (boolean)callableStatement.getBoolean(3));
        statement.close();
        callableStatement.close();
    }

    public void testLikeEscaleStatement() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select * from sys.systables where CAST(tablename AS VARCHAR(128)) like ? escape CAST(? AS VARCHAR(128))");
        preparedStatement.setString(1, "SYS%");
        preparedStatement.setString(2, "");
        ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
        ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter count", (int)2, (int)parameterMetaData.getParameterCount());
        String[][] stringArray = new String[][]{{"PARAMETER_NULLABLE", "false", "128", "0", "12", "VARCHAR", "java.lang.String", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "false", "128", "0", "12", "VARCHAR", "java.lang.String", "PARAMETER_MODE_IN"}};
        ParameterMetaDataJdbc30Test.testParameterMetaData(parameterMetaData, stringArray);
        try {
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            ParameterMetaDataJdbc30Test.fail((String)"DERBY-44 failed (didn't get SQLSTATE 22019)");
            resultSet.close();
        }
        catch (SQLException sQLException) {
            ParameterMetaDataJdbc30Test.assertSQLState("22019", sQLException);
        }
        preparedStatement.close();
    }

    public void testExecuteStatementUsing() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select * from sys.systables where CAST(tablename AS VARCHAR(128)) like 'SYS%' and CAST(tableID AS VARCHAR(128)) like '8000001%'");
        ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
        ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter count", (int)0, (int)parameterMetaData.getParameterCount());
        String[][] stringArray = null;
        ParameterMetaDataJdbc30Test.testParameterMetaData(parameterMetaData, stringArray);
        preparedStatement.execute();
        preparedStatement.close();
    }

    public void testSelectStatementUsingBoolean() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select * from t where 1=? for update");
        ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
        ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter count", (int)1, (int)parameterMetaData.getParameterCount());
        String[][] stringArray = new String[][]{{"PARAMETER_NULLABLE", "true", "10", "0", "4", "INTEGER", "java.lang.Integer", "PARAMETER_MODE_IN"}};
        ParameterMetaDataJdbc30Test.testParameterMetaData(parameterMetaData, stringArray);
        ParameterMetaDataJdbc30Test.dumpParameterMetaDataNegative(parameterMetaData);
        preparedStatement.setInt(1, 1);
        preparedStatement.execute();
        preparedStatement.close();
    }

    public void testSelectStatementUsingNoParameter() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select * from t");
        ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
        ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter count", (int)0, (int)parameterMetaData.getParameterCount());
        String[][] stringArray = null;
        ParameterMetaDataJdbc30Test.testParameterMetaData(parameterMetaData, stringArray);
        preparedStatement.execute();
        preparedStatement.close();
    }

    public void testCallableStatementReturnedScale() throws SQLException {
        if (!ParameterMetaDataJdbc30Test.usingDerbyNetClient()) {
            Statement statement = this.createStatement();
            statement.executeUpdate("create procedure dummy_numeric_Proc(out a NUMERIC(30,15), out b NUMERIC(30,15)) language java parameter style java external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.ParameterMetaDataJdbc30Test.dummy_numeric_Proc'");
            CallableStatement callableStatement = this.prepareCall("CALL dummy_numeric_Proc(?,?)");
            callableStatement.registerOutParameter(1, 2);
            callableStatement.registerOutParameter(2, 2, 15);
            callableStatement.execute();
            ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter count", (int)2, (int)callableStatement.getParameterMetaData().getParameterCount());
            String[][] stringArray = new String[][]{{"PARAMETER_NULLABLE", "true", "30", "15", "2", "NUMERIC", "java.math.BigDecimal", "PARAMETER_MODE_OUT"}, {"PARAMETER_NULLABLE", "true", "30", "15", "2", "NUMERIC", "java.math.BigDecimal", "PARAMETER_MODE_OUT"}};
            ParameterMetaDataJdbc30Test.testParameterMetaData(callableStatement.getParameterMetaData(), stringArray);
            callableStatement.close();
        }
    }

    public void testMetatdataAfterProcRecompile() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create procedure dummyint( in a integer, in b integer, out c integer, inout d integer) language java external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.ParameterMetaDataJdbc30Test.dummyint' parameter style java");
        CallableStatement callableStatement = this.prepareCall("CALL dummyint(?,?,?,?)");
        callableStatement.registerOutParameter(3, 4);
        callableStatement.registerOutParameter(4, 4);
        callableStatement.setInt(1, 1);
        callableStatement.setInt(2, 1);
        callableStatement.setInt(4, 4);
        String[][] stringArray = new String[][]{{"PARAMETER_NULLABLE", "true", "10", "0", "4", "INTEGER", "java.lang.Integer", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "true", "10", "0", "4", "INTEGER", "java.lang.Integer", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "true", "10", "0", "4", "INTEGER", "java.lang.Integer", "PARAMETER_MODE_OUT"}, {"PARAMETER_NULLABLE", "true", "10", "0", "4", "INTEGER", "java.lang.Integer", "PARAMETER_MODE_IN_OUT"}};
        ParameterMetaDataJdbc30Test.testParameterMetaData(callableStatement.getParameterMetaData(), stringArray);
        callableStatement.execute();
        ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected DUMMYINT alias returned", (int)11111, (int)callableStatement.getInt(4));
        if (!ParameterMetaDataJdbc30Test.usingDerbyNetClient()) {
            statement.executeUpdate("drop procedure dummyint");
            statement.executeUpdate("create procedure dummyint(in a integer, in b integer, out c integer, inout d integer) language java external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.ParameterMetaDataJdbc30Test.dummyint2' parameter style java");
            callableStatement.execute();
            String[][] stringArray2 = new String[][]{{"PARAMETER_NULLABLE", "true", "10", "0", "4", "INTEGER", "java.lang.Integer", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "true", "10", "0", "4", "INTEGER", "java.lang.Integer", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "true", "10", "0", "4", "INTEGER", "java.lang.Integer", "PARAMETER_MODE_OUT"}, {"PARAMETER_NULLABLE", "true", "10", "0", "4", "INTEGER", "java.lang.Integer", "PARAMETER_MODE_IN_OUT"}};
            ParameterMetaDataJdbc30Test.testParameterMetaData(callableStatement.getParameterMetaData(), stringArray2);
            callableStatement.setInt(4, 6);
            ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected DUMMYINT alias returned", (int)6, (int)callableStatement.getInt(4));
            callableStatement.execute();
            ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected DUMMYINT alias returned", (int)22222, (int)callableStatement.getInt(4));
        }
        callableStatement.close();
        statement.execute("drop procedure dummyint");
    }

    public void testParameterMetadataWithINTParameters() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("CREATE PROCEDURE PMDI(IN pmdI_1 INTEGER, IN pmdI_2 INTEGER, INOUT pmdI_3 INTEGER, OUT pmdI_4 INTEGER) language java parameter style java external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.ParameterMetaDataJdbc30Test.dummyint'");
        CallableStatement callableStatement = this.prepareCall("CALL PMDI(?, ?, ?, ?)");
        callableStatement.setInt(1, 1);
        callableStatement.setInt(2, 1);
        Integer n = 1;
        callableStatement.setObject(3, (Object)n, 4);
        callableStatement.registerOutParameter(3, 4);
        callableStatement.registerOutParameter(4, 4);
        ParameterMetaData parameterMetaData = callableStatement.getParameterMetaData();
        ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter count", (int)4, (int)parameterMetaData.getParameterCount());
        String[][] stringArray = new String[][]{{"PARAMETER_NULLABLE", "true", "10", "0", "4", "INTEGER", "java.lang.Integer", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "true", "10", "0", "4", "INTEGER", "java.lang.Integer", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "true", "10", "0", "4", "INTEGER", "java.lang.Integer", "PARAMETER_MODE_IN_OUT"}, {"PARAMETER_NULLABLE", "true", "10", "0", "4", "INTEGER", "java.lang.Integer", "PARAMETER_MODE_OUT"}};
        ParameterMetaDataJdbc30Test.testParameterMetaData(callableStatement.getParameterMetaData(), stringArray);
        callableStatement.close();
        statement.execute("DROP PROCEDURE PMDI");
        statement.close();
    }

    public void testParameterMetadataWithCHARParameters() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("CREATE PROCEDURE PMDC(IN pmdI_1 CHAR(10), IN pmdI_2 VARCHAR(25), INOUT pmdI_3 CHAR(19), OUT pmdI_4 VARCHAR(32)) language java parameter style java external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.ParameterMetaDataJdbc30Test.dummyString'");
        CallableStatement callableStatement = this.prepareCall("CALL PMDC(?, ?, ?, ?)");
        callableStatement.setString(1, "TEST0");
        callableStatement.setString(2, "TEST1");
        String string = new String("TEST");
        callableStatement.setObject(3, (Object)string, 1);
        callableStatement.registerOutParameter(3, 1);
        callableStatement.registerOutParameter(4, 1);
        ParameterMetaData parameterMetaData = callableStatement.getParameterMetaData();
        ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter count", (int)4, (int)parameterMetaData.getParameterCount());
        String[][] stringArray = new String[][]{{"PARAMETER_NULLABLE", "false", "10", "0", "1", "CHAR", "java.lang.String", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "false", "25", "0", "12", "VARCHAR", "java.lang.String", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "false", "19", "0", "1", "CHAR", "java.lang.String", "PARAMETER_MODE_IN_OUT"}, {"PARAMETER_NULLABLE", "false", "32", "0", "12", "VARCHAR", "java.lang.String", "PARAMETER_MODE_OUT"}};
        ParameterMetaDataJdbc30Test.testParameterMetaData(callableStatement.getParameterMetaData(), stringArray);
        callableStatement.close();
        statement.execute("DROP PROCEDURE PMDC");
        statement.close();
    }

    public void testParameterMetadataWithTimestampParameters() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("CREATE PROCEDURE PMDT(IN pmdI_1 TIMESTAMP, INOUT pmdI_2 TIMESTAMP, OUT pmdI_3 TIMESTAMP) language java parameter style java external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.ParameterMetaDataJdbc30Test.dummyString'");
        CallableStatement callableStatement = this.prepareCall("CALL PMDT(?, ?, ?)");
        callableStatement.setTimestamp(1, new Timestamp(0L));
        Timestamp timestamp = new Timestamp(2L);
        callableStatement.setObject(2, (Object)timestamp, 1);
        callableStatement.registerOutParameter(2, 93);
        callableStatement.registerOutParameter(3, 93);
        ParameterMetaData parameterMetaData = callableStatement.getParameterMetaData();
        ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter count", (int)3, (int)parameterMetaData.getParameterCount());
        String[][] stringArray = new String[][]{{"PARAMETER_NULLABLE", "false", "29", "9", "93", "TIMESTAMP", "java.sql.Timestamp", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "false", "29", "9", "93", "TIMESTAMP", "java.sql.Timestamp", "PARAMETER_MODE_IN_OUT"}, {"PARAMETER_NULLABLE", "false", "29", "9", "93", "TIMESTAMP", "java.sql.Timestamp", "PARAMETER_MODE_OUT"}};
        ParameterMetaDataJdbc30Test.testParameterMetaData(callableStatement.getParameterMetaData(), stringArray);
        callableStatement.close();
        statement.execute("DROP PROCEDURE PMDT");
        statement.close();
    }

    public void testParameterMetadataWithDECIMALParameters() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("CALL PMDD(?, ?, ?, ?)");
        callableStatement.setBigDecimal(1, new BigDecimal("1"));
        callableStatement.setBigDecimal(2, new BigDecimal("1"));
        BigDecimal bigDecimal = new BigDecimal(1.1);
        callableStatement.setObject(3, (Object)bigDecimal, 3);
        callableStatement.registerOutParameter(3, 3);
        callableStatement.registerOutParameter(4, 3);
        ParameterMetaData parameterMetaData = callableStatement.getParameterMetaData();
        ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter count", (int)4, (int)parameterMetaData.getParameterCount());
        String[][] stringArray = new String[][]{{"PARAMETER_NULLABLE", "true", "5", "3", "3", "DECIMAL", "java.math.BigDecimal", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "true", "4", "2", "3", "DECIMAL", "java.math.BigDecimal", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "true", "9", "0", "3", "DECIMAL", "java.math.BigDecimal", "PARAMETER_MODE_IN_OUT"}, {"PARAMETER_NULLABLE", "true", "10", "2", "3", "DECIMAL", "java.math.BigDecimal", "PARAMETER_MODE_OUT"}};
        ParameterMetaDataJdbc30Test.testParameterMetaData(callableStatement.getParameterMetaData(), stringArray);
        callableStatement.close();
    }

    public void testParameterMetadataWithLITERALParameters() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("CALL PMDD(32.4, ?, ?, ?)");
        callableStatement.setBigDecimal(1, new BigDecimal("1"));
        BigDecimal bigDecimal = new BigDecimal(1.1);
        callableStatement.setObject(2, (Object)bigDecimal, 3);
        callableStatement.registerOutParameter(2, 3);
        callableStatement.registerOutParameter(3, 3);
        ParameterMetaData parameterMetaData = callableStatement.getParameterMetaData();
        ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter count", (int)3, (int)parameterMetaData.getParameterCount());
        String[][] stringArray = new String[][]{{"PARAMETER_NULLABLE", "true", "4", "2", "3", "DECIMAL", "java.math.BigDecimal", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "true", "9", "0", "3", "DECIMAL", "java.math.BigDecimal", "PARAMETER_MODE_IN_OUT"}, {"PARAMETER_NULLABLE", "true", "10", "2", "3", "DECIMAL", "java.math.BigDecimal", "PARAMETER_MODE_OUT"}};
        ParameterMetaDataJdbc30Test.testParameterMetaData(callableStatement.getParameterMetaData(), stringArray);
        callableStatement.close();
        callableStatement = this.prepareCall("CALL PMDD(32.4, 47.9, ?, ?)");
        BigDecimal bigDecimal2 = new BigDecimal(1.1);
        callableStatement.setObject(1, (Object)bigDecimal2, 3);
        callableStatement.registerOutParameter(1, 3);
        callableStatement.registerOutParameter(2, 3);
        parameterMetaData = callableStatement.getParameterMetaData();
        ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter count", (int)2, (int)parameterMetaData.getParameterCount());
        String[][] stringArray2 = new String[][]{{"PARAMETER_NULLABLE", "true", "9", "0", "3", "DECIMAL", "java.math.BigDecimal", "PARAMETER_MODE_IN_OUT"}, {"PARAMETER_NULLABLE", "true", "10", "2", "3", "DECIMAL", "java.math.BigDecimal", "PARAMETER_MODE_OUT"}};
        ParameterMetaDataJdbc30Test.testParameterMetaData(callableStatement.getParameterMetaData(), stringArray2);
        callableStatement.close();
        callableStatement = this.prepareCall("CALL PMDD(?, 38.2, ?, ?)");
        callableStatement.setBigDecimal(1, new BigDecimal("1"));
        BigDecimal bigDecimal3 = new BigDecimal(1.1);
        callableStatement.setObject(2, (Object)bigDecimal3, 3);
        callableStatement.registerOutParameter(2, 3);
        callableStatement.registerOutParameter(3, 3);
        parameterMetaData = callableStatement.getParameterMetaData();
        ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter count", (int)3, (int)parameterMetaData.getParameterCount());
        String[][] stringArray3 = new String[][]{{"PARAMETER_NULLABLE", "true", "5", "3", "3", "DECIMAL", "java.math.BigDecimal", "PARAMETER_MODE_IN"}, {"PARAMETER_NULLABLE", "true", "9", "0", "3", "DECIMAL", "java.math.BigDecimal", "PARAMETER_MODE_IN_OUT"}, {"PARAMETER_NULLABLE", "true", "10", "2", "3", "DECIMAL", "java.math.BigDecimal", "PARAMETER_MODE_OUT"}};
        ParameterMetaDataJdbc30Test.testParameterMetaData(callableStatement.getParameterMetaData(), stringArray3);
        callableStatement.close();
    }

    static String parameterIsNullableInStringForm(int n) {
        if (n == 0) {
            return "PARAMETER_NO_NULLS";
        }
        if (n == 1) {
            return "PARAMETER_NULLABLE";
        }
        if (n == 2) {
            return "PARAMETER_NULLABLE_UNKNOWN";
        }
        return "ERROR: donot recognize this parameter isNullable() value";
    }

    static String parameterModeInStringForm(int n) {
        if (n == 1) {
            return "PARAMETER_MODE_IN";
        }
        if (n == 2) {
            return "PARAMETER_MODE_IN_OUT";
        }
        if (n == 4) {
            return "PARAMETER_MODE_OUT";
        }
        if (n == 0) {
            return "PARAMETER_MODE_UNKNOWN";
        }
        return "ERROR: donot recognize this parameter mode";
    }

    static void testParameterMetaData(ParameterMetaData parameterMetaData, String[][] stringArray) throws SQLException {
        int n = parameterMetaData.getParameterCount();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter isNullable", (String)stringArray[i][n2++], (String)ParameterMetaDataJdbc30Test.parameterIsNullableInStringForm(parameterMetaData.isNullable(i + 1)));
            ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter isSigned", (boolean)Boolean.valueOf(stringArray[i][n2++]), (boolean)parameterMetaData.isSigned(i + 1));
            ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter getPrecision", (int)Integer.parseInt(stringArray[i][n2++]), (int)parameterMetaData.getPrecision(i + 1));
            ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter getScale", (int)Integer.parseInt(stringArray[i][n2++]), (int)parameterMetaData.getScale(i + 1));
            ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter getParameterType", (int)Integer.parseInt(stringArray[i][n2++]), (int)parameterMetaData.getParameterType(i + 1));
            ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter getParameterTypeName", (String)stringArray[i][n2++], (String)parameterMetaData.getParameterTypeName(i + 1));
            ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter getParameterClassName", (String)stringArray[i][n2++], (String)parameterMetaData.getParameterClassName(i + 1));
            ParameterMetaDataJdbc30Test.assertEquals((String)"Unexpected parameter getParameterMode", (String)stringArray[i][n2++], (String)ParameterMetaDataJdbc30Test.parameterModeInStringForm(parameterMetaData.getParameterMode(i + 1)));
            n2 = 0;
        }
    }

    static void dumpParameterMetaDataNegative(ParameterMetaData parameterMetaData) throws SQLException {
        int n = parameterMetaData.getParameterCount();
        String string = ParameterMetaDataJdbc30Test.usingEmbedded() ? "XCL13" : "XCL14";
        try {
            parameterMetaData.isNullable(-1);
            ParameterMetaDataJdbc30Test.fail((String)"parameterMetaData.isNullable(-1) should have failed");
        }
        catch (SQLException sQLException) {
            ParameterMetaDataJdbc30Test.assertSQLState(string, sQLException);
        }
        try {
            parameterMetaData.isNullable(0);
            ParameterMetaDataJdbc30Test.fail((String)"parameterMetaData.isNullable(0) should have failed");
        }
        catch (SQLException sQLException) {
            ParameterMetaDataJdbc30Test.assertSQLState(string, sQLException);
        }
        try {
            parameterMetaData.isNullable(n + 1);
            ParameterMetaDataJdbc30Test.fail((String)("parameterMetaData.isNullable(" + (n + 1) + ") should have failed"));
        }
        catch (SQLException sQLException) {
            ParameterMetaDataJdbc30Test.assertSQLState(string, sQLException);
        }
    }

    public static void dummyint(int n, int n2, int[] nArray, int[] nArray2) throws SQLException {
        nArray2[0] = 11111;
    }

    public static void dummyint2(int n, int n2, int[] nArray, int[] nArray2) throws SQLException {
        nArray2[0] = 22222;
    }

    public static void dummy_numeric_Proc(BigDecimal[] bigDecimalArray, BigDecimal[] bigDecimalArray2) throws SQLException {
    }

    public static void dummyString(String string, String string2, String[] stringArray, String[] stringArray2) {
    }

    public static void dummyString(Timestamp timestamp, Timestamp[] timestampArray, Timestamp[] timestampArray2) {
    }

    public static void dummyDecimal(BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal[] bigDecimalArray, BigDecimal[] bigDecimalArray2) {
    }

    public static void booleanProc(boolean bl, boolean[] blArray, boolean[] blArray2) {
        blArray[0] = bl;
        blArray2[0] = !blArray2[0];
    }
}

