/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.engine;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ErrorStreamTest
extends BaseJDBCTestCase {
    private static final String FILE_PROP = "derby.stream.error.file";
    private static final String METHOD_PROP = "derby.stream.error.method";
    private static final String FIELD_PROP = "derby.stream.error.field";
    private static final String STYLE_PROP = "derby.stream.error.style";
    private static final String ROLLING_FILE_STYLE = "rollingFile";
    private static final String ROLLING_FILE_COUNT_PROP = "derby.stream.error.rollingFile.count";
    private static final String ROLLING_FILE_LIMIT_PROP = "derby.stream.error.rollingFile.limit";
    private static final String ROLLING_FILE_PATTERN_PROP = "derby.stream.error.rollingFile.pattern";
    private static final String DERBY_0_LOG = "derby-0.log";
    private static final String DERBYLANGUAGELOG_QUERY_PLAN = "derby.language.logQueryPlan";
    private static final String LOGFILESDIR = "logfilesdir";
    private static int runNo = 0;
    private File fileStreamFile;
    private static OutputStream methodStream;
    private File methodStreamFile;
    public static OutputStream fieldStream;
    private File fieldStreamFile;
    private OutputStream errStream;
    private File errStreamFile;

    public ErrorStreamTest(String string) {
        super(string);
    }

    public static Test suite() {
        return TestConfiguration.embeddedSuite(ErrorStreamTest.class);
    }

    public void setUp() throws Exception {
        this.bootDerby();
        this.getTestConfiguration().shutdownEngine();
        this.openStreams();
    }

    @Override
    public void tearDown() throws Exception {
        ErrorStreamTest.resetProps();
        this.closeStreams();
        this.nullFields();
        super.tearDown();
    }

    public void testDefault() throws IOException, SQLException {
        File file = new File(ErrorStreamTest.getSystemProperty("derby.system.home"), "derby.log");
        this.bootDerby();
        ErrorStreamTest.assertIsExisting(file);
        ErrorStreamTest.assertNotDirectory(file);
        ErrorStreamTest.assertNotEmpty(file);
        ErrorStreamTest.println("Shutdown database");
        this.getTestConfiguration().shutdownDatabase();
        ErrorStreamTest.assertIsExisting(file);
        ErrorStreamTest.assertNotDirectory(file);
        ErrorStreamTest.assertNotEmpty(file);
        ErrorStreamTest.println("Shutdown engine");
        this.getTestConfiguration().shutdownEngine();
        boolean bl = ErrorStreamTest.deleteFile(file);
        ErrorStreamTest.assertTrue((String)("File " + String.valueOf(file) + " could not be deleted"), (boolean)bl);
    }

    public void testFile() throws IOException, SQLException {
        ErrorStreamTest.setSystemProperty(FILE_PROP, ErrorStreamTest.getCanonicalPath(this.fileStreamFile));
        this.bootDerby();
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        ErrorStreamTest.assertNotEmpty(this.fileStreamFile);
        ErrorStreamTest.assertIsEmpty(this.methodStreamFile);
        ErrorStreamTest.assertIsEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertIsEmpty(this.errStreamFile);
    }

    public void testWrongFile() throws IOException, SQLException {
        ErrorStreamTest.setSystemProperty(FILE_PROP, ErrorStreamTest.getCanonicalPath(new File(new File(ErrorStreamTest.getSystemProperty("derby.system.home"), "foo"), ErrorStreamTest.makeStreamFilename("file"))));
        this.bootDerby();
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        ErrorStreamTest.assertNotExisting(this.fileStreamFile);
        ErrorStreamTest.assertIsEmpty(this.methodStreamFile);
        ErrorStreamTest.assertIsEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertNotEmpty(this.errStreamFile);
    }

    public void testMethod() throws IOException, SQLException {
        ErrorStreamTest.setSystemProperty(METHOD_PROP, "org.apache.derbyTesting.functionTests.tests.engine.ErrorStreamTest.getStream");
        this.bootDerby();
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        ErrorStreamTest.assertNotExisting(this.fileStreamFile);
        ErrorStreamTest.assertNotEmpty(this.methodStreamFile);
        ErrorStreamTest.assertIsEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertIsEmpty(this.errStreamFile);
    }

    public void testWrongMethod() throws IOException, SQLException {
        ErrorStreamTest.setSystemProperty(METHOD_PROP, "org.apache.derbyTesting.functionTests.tests.engine.ErrorStreamTest.nonExistingGetStream");
        this.bootDerby();
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        ErrorStreamTest.assertNotExisting(this.fileStreamFile);
        ErrorStreamTest.assertIsEmpty(this.methodStreamFile);
        ErrorStreamTest.assertIsEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertNotEmpty(this.errStreamFile);
    }

    public void testField() throws IOException, SQLException {
        ErrorStreamTest.setSystemProperty(FIELD_PROP, "org.apache.derbyTesting.functionTests.tests.engine.ErrorStreamTest.fieldStream");
        this.bootDerby();
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        ErrorStreamTest.assertNotExisting(this.fileStreamFile);
        ErrorStreamTest.assertIsEmpty(this.methodStreamFile);
        ErrorStreamTest.assertNotEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertIsEmpty(this.errStreamFile);
    }

    public void testWrongField() throws IOException, SQLException {
        ErrorStreamTest.setSystemProperty(FIELD_PROP, "org.apache.derbyTesting.functionTests.tests.engine.ErrorStreamTest.nonExistingFieldStream");
        this.bootDerby();
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        ErrorStreamTest.assertNotExisting(this.fileStreamFile);
        ErrorStreamTest.assertIsEmpty(this.methodStreamFile);
        ErrorStreamTest.assertIsEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertNotEmpty(this.errStreamFile);
    }

    public void testFileOverMethod() throws IOException, SQLException {
        ErrorStreamTest.setSystemProperty(FILE_PROP, ErrorStreamTest.getCanonicalPath(this.fileStreamFile));
        ErrorStreamTest.setSystemProperty(METHOD_PROP, "org.apache.derbyTesting.functionTests.tests.engine.ErrorStreamTest.getStream");
        this.bootDerby();
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        ErrorStreamTest.assertNotEmpty(this.fileStreamFile);
        ErrorStreamTest.assertIsEmpty(this.methodStreamFile);
        ErrorStreamTest.assertIsEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertIsEmpty(this.errStreamFile);
    }

    public void testFileOverField() throws IOException, SQLException {
        ErrorStreamTest.setSystemProperty(FILE_PROP, ErrorStreamTest.getCanonicalPath(this.fileStreamFile));
        ErrorStreamTest.setSystemProperty(FIELD_PROP, "org.apache.derbyTesting.functionTests.tests.engine.ErrorStreamTest.fieldStream");
        this.bootDerby();
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        ErrorStreamTest.assertNotEmpty(this.fileStreamFile);
        ErrorStreamTest.assertIsEmpty(this.methodStreamFile);
        ErrorStreamTest.assertIsEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertIsEmpty(this.errStreamFile);
    }

    public void testFileOverMethodAndField() throws IOException, SQLException {
        ErrorStreamTest.setSystemProperty(FILE_PROP, ErrorStreamTest.getCanonicalPath(this.fileStreamFile));
        ErrorStreamTest.setSystemProperty(METHOD_PROP, "org.apache.derbyTesting.functionTests.tests.engine.ErrorStreamTest.getStream");
        ErrorStreamTest.setSystemProperty(FIELD_PROP, "org.apache.derbyTesting.functionTests.tests.engine.ErrorStreamTest.fieldStream");
        this.bootDerby();
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        ErrorStreamTest.assertNotEmpty(this.fileStreamFile);
        ErrorStreamTest.assertIsEmpty(this.methodStreamFile);
        ErrorStreamTest.assertIsEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertIsEmpty(this.errStreamFile);
    }

    public void testMethodOverField() throws IOException, SQLException {
        ErrorStreamTest.setSystemProperty(METHOD_PROP, "org.apache.derbyTesting.functionTests.tests.engine.ErrorStreamTest.getStream");
        ErrorStreamTest.setSystemProperty(FIELD_PROP, "org.apache.derbyTesting.functionTests.tests.engine.ErrorStreamTest.fieldStream");
        this.bootDerby();
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        ErrorStreamTest.assertNotExisting(this.fileStreamFile);
        ErrorStreamTest.assertNotEmpty(this.methodStreamFile);
        ErrorStreamTest.assertIsEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertIsEmpty(this.errStreamFile);
    }

    public void testStyleRollingFile() throws IOException, SQLException {
        ErrorStreamTest.setSystemProperty(STYLE_PROP, ROLLING_FILE_STYLE);
        File file = new File(ErrorStreamTest.getSystemProperty("derby.system.home"), DERBY_0_LOG);
        File file2 = new File(ErrorStreamTest.getSystemProperty("derby.system.home"), "derby-0.log.lck");
        this.bootDerby();
        ErrorStreamTest.assertIsExisting(file);
        ErrorStreamTest.assertNotDirectory(file);
        ErrorStreamTest.assertNotEmpty(file);
        ErrorStreamTest.assertIsExisting(file2);
        ErrorStreamTest.assertNotDirectory(file2);
        ErrorStreamTest.assertIsEmpty(file2);
        ErrorStreamTest.println("Shutdown database");
        this.getTestConfiguration().shutdownDatabase();
        ErrorStreamTest.assertIsExisting(file);
        ErrorStreamTest.assertNotDirectory(file);
        ErrorStreamTest.assertNotEmpty(file);
        ErrorStreamTest.assertIsExisting(file2);
        ErrorStreamTest.assertNotDirectory(file2);
        ErrorStreamTest.assertIsEmpty(file2);
        ErrorStreamTest.println("Shutdown engine");
        this.getTestConfiguration().shutdownEngine();
        ErrorStreamTest.assertNotExisting(file2);
        boolean bl = ErrorStreamTest.deleteFile(file);
        ErrorStreamTest.assertTrue((String)("File " + String.valueOf(file) + " could not be deleted"), (boolean)bl);
    }

    public void testWrongStyle() throws IOException, SQLException {
        ErrorStreamTest.setSystemProperty(STYLE_PROP, "unknownStyle");
        File file = new File(ErrorStreamTest.getSystemProperty("derby.system.home"), DERBY_0_LOG);
        this.bootDerby();
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        ErrorStreamTest.assertNotExisting(file);
        ErrorStreamTest.assertNotExisting(this.fileStreamFile);
        ErrorStreamTest.assertIsEmpty(this.methodStreamFile);
        ErrorStreamTest.assertIsEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertNotEmpty(this.errStreamFile);
    }

    public void testDefaultRollingDefaultConfig() throws IOException, SQLException {
        int n;
        ErrorStreamTest.setSystemProperty(STYLE_PROP, ROLLING_FILE_STYLE);
        ErrorStreamTest.setSystemProperty(DERBYLANGUAGELOG_QUERY_PLAN, "true");
        this.bootDerby();
        for (n = 0; n < 3699; ++n) {
            this.checkAllConsistency(this.getConnection());
        }
        ErrorStreamTest.removeSystemProperty(DERBYLANGUAGELOG_QUERY_PLAN);
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        for (n = 0; n < 10; ++n) {
            File file = new File(ErrorStreamTest.getSystemProperty("derby.system.home"), "derby-" + n + ".log");
            ErrorStreamTest.assertIsExisting(file);
            ErrorStreamTest.assertNotDirectory(file);
            ErrorStreamTest.assertNotEmpty(file);
            if (n == 9) {
                ErrorStreamTest.assertFileSize(file, 1024000);
            }
            boolean bl = ErrorStreamTest.deleteFile(file);
            ErrorStreamTest.assertTrue((String)("File " + String.valueOf(file) + " could not be deleted"), (boolean)bl);
        }
        ErrorStreamTest.assertNotExisting(this.fileStreamFile);
        ErrorStreamTest.assertIsEmpty(this.methodStreamFile);
        ErrorStreamTest.assertIsEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertIsEmpty(this.errStreamFile);
    }

    public void testDefaultRollingUserConfig() throws IOException, SQLException {
        int n;
        ErrorStreamTest.setSystemProperty(STYLE_PROP, ROLLING_FILE_STYLE);
        ErrorStreamTest.setSystemProperty(ROLLING_FILE_PATTERN_PROP, "%d/db-%g.log");
        ErrorStreamTest.setSystemProperty(ROLLING_FILE_COUNT_PROP, "3");
        ErrorStreamTest.setSystemProperty(ROLLING_FILE_LIMIT_PROP, "10000");
        ErrorStreamTest.setSystemProperty(DERBYLANGUAGELOG_QUERY_PLAN, "true");
        this.bootDerby();
        for (n = 0; n < 10; ++n) {
            this.checkAllConsistency(this.getConnection());
        }
        ErrorStreamTest.removeSystemProperty(DERBYLANGUAGELOG_QUERY_PLAN);
        ErrorStreamTest.removeSystemProperty(ROLLING_FILE_PATTERN_PROP);
        ErrorStreamTest.removeSystemProperty(ROLLING_FILE_COUNT_PROP);
        ErrorStreamTest.removeSystemProperty(ROLLING_FILE_LIMIT_PROP);
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        for (n = 0; n < 3; ++n) {
            File file = new File(ErrorStreamTest.getSystemProperty("derby.system.home"), "db-" + n + ".log");
            ErrorStreamTest.assertIsExisting(file);
            ErrorStreamTest.assertNotDirectory(file);
            ErrorStreamTest.assertNotEmpty(file);
            if (n == 2) {
                ErrorStreamTest.assertFileSize(file, 10000);
            }
            boolean bl = ErrorStreamTest.deleteFile(file);
            ErrorStreamTest.assertTrue((String)("File " + String.valueOf(file) + " could not be deleted"), (boolean)bl);
        }
        ErrorStreamTest.assertNotExisting(this.fileStreamFile);
        ErrorStreamTest.assertIsEmpty(this.methodStreamFile);
        ErrorStreamTest.assertIsEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertIsEmpty(this.errStreamFile);
    }

    public void testRollingFileStyleOverFile() throws IOException, SQLException {
        ErrorStreamTest.setSystemProperty(STYLE_PROP, ROLLING_FILE_STYLE);
        File file = new File(ErrorStreamTest.getSystemProperty("derby.system.home"), DERBY_0_LOG);
        ErrorStreamTest.setSystemProperty(FILE_PROP, ErrorStreamTest.getCanonicalPath(this.fileStreamFile));
        this.bootDerby();
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        ErrorStreamTest.assertNotEmpty(file);
        ErrorStreamTest.assertNotExisting(this.fileStreamFile);
        ErrorStreamTest.assertIsEmpty(this.methodStreamFile);
        ErrorStreamTest.assertIsEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertIsEmpty(this.errStreamFile);
    }

    public void testRollingFileStyleOverMethod() throws IOException, SQLException {
        ErrorStreamTest.setSystemProperty(STYLE_PROP, ROLLING_FILE_STYLE);
        File file = new File(ErrorStreamTest.getSystemProperty("derby.system.home"), DERBY_0_LOG);
        ErrorStreamTest.setSystemProperty(METHOD_PROP, "org.apache.derbyTesting.functionTests.tests.engine.ErrorStreamTest.getStream");
        this.bootDerby();
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        ErrorStreamTest.assertNotEmpty(file);
        ErrorStreamTest.assertNotExisting(this.fileStreamFile);
        ErrorStreamTest.assertIsEmpty(this.methodStreamFile);
        ErrorStreamTest.assertIsEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertIsEmpty(this.errStreamFile);
        boolean bl = ErrorStreamTest.deleteFile(file);
        ErrorStreamTest.assertTrue((String)("File " + String.valueOf(file) + " could not be deleted"), (boolean)bl);
    }

    public void testRollingFileStyleOverField() throws IOException, SQLException {
        ErrorStreamTest.setSystemProperty(STYLE_PROP, ROLLING_FILE_STYLE);
        File file = new File(ErrorStreamTest.getSystemProperty("derby.system.home"), DERBY_0_LOG);
        ErrorStreamTest.setSystemProperty(FIELD_PROP, "org.apache.derbyTesting.functionTests.tests.engine.ErrorStreamTest.fieldStream");
        this.bootDerby();
        this.getTestConfiguration().shutdownEngine();
        this.closeStreams();
        ErrorStreamTest.assertNotEmpty(file);
        ErrorStreamTest.assertNotExisting(this.fileStreamFile);
        ErrorStreamTest.assertIsEmpty(this.methodStreamFile);
        ErrorStreamTest.assertIsEmpty(this.fieldStreamFile);
        ErrorStreamTest.assertIsEmpty(this.errStreamFile);
        boolean bl = ErrorStreamTest.deleteFile(file);
        ErrorStreamTest.assertTrue((String)("File " + String.valueOf(file) + " could not be deleted"), (boolean)bl);
    }

    public static OutputStream getStream() {
        return methodStream;
    }

    private static String makeStreamFilename(String string) {
        return string + "-" + runNo + ".log";
    }

    private void openStreams() throws IOException {
        String string = ErrorStreamTest.getSystemProperty("derby.system.home");
        String string2 = string + File.separatorChar + LOGFILESDIR;
        ErrorStreamTest.makeDirIfNotExisting(string);
        ErrorStreamTest.makeDirIfNotExisting(string2);
        ++runNo;
        this.methodStreamFile = new File(string2, ErrorStreamTest.makeStreamFilename("method"));
        this.fileStreamFile = new File(string2, ErrorStreamTest.makeStreamFilename("file"));
        this.fieldStreamFile = new File(string2, ErrorStreamTest.makeStreamFilename("field"));
        this.errStreamFile = new File(string2, ErrorStreamTest.makeStreamFilename("err"));
        methodStream = ErrorStreamTest.newFileOutputStream(this.methodStreamFile);
        fieldStream = ErrorStreamTest.newFileOutputStream(this.fieldStreamFile);
        this.errStream = ErrorStreamTest.newFileOutputStream(this.errStreamFile);
        ErrorStreamTest.setSystemErr(new PrintStream(this.errStream));
    }

    private void closeStreams() throws IOException {
        try {
            methodStream.close();
            fieldStream.close();
            this.errStream.close();
            ErrorStreamTest.setSystemErr(System.out);
        }
        catch (IOException iOException) {
            ErrorStreamTest.println("Could not close stream files");
            throw iOException;
        }
    }

    private static void assertNotDirectory(File file) throws IOException {
        ErrorStreamTest.assertFalse((String)("assertNotDirectory failed: " + file.getCanonicalPath()), (boolean)file.isDirectory());
    }

    private static void assertIsEmpty(File file) throws IOException {
        String string = ErrorStreamTest.getCanonicalPath(file);
        ErrorStreamTest.assertTrue((String)(string + " doesn't exist"), (boolean)PrivilegedFileOpsForTests.exists(file));
        ErrorStreamTest.assertEquals((String)(string + " is not empty"), (long)0L, (long)PrivilegedFileOpsForTests.length(file));
    }

    private static void assertNotEmpty(File file) throws IOException {
        ErrorStreamTest.assertTrue((String)("assertNotEmpty failed: " + file.getCanonicalPath() + " does not exist."), (boolean)file.exists());
        FileInputStream fileInputStream = new FileInputStream(file);
        int n = fileInputStream.read();
        fileInputStream.close();
        ErrorStreamTest.assertTrue((String)("assertNotEmpty failed: " + file.getCanonicalPath() + " is empty."), (-1 != n ? 1 : 0) != 0);
    }

    private static void assertFileSize(File file, int n) throws IOException {
        ErrorStreamTest.assertEquals((String)("assertFileEize failed for file " + file.getName() + ": "), (long)n, (long)file.length());
    }

    private static void assertIsExisting(File file) throws IOException {
        String string = ErrorStreamTest.getCanonicalPath(file);
        ErrorStreamTest.assertTrue((String)(string + " doesn't exist"), (boolean)PrivilegedFileOpsForTests.exists(file));
    }

    private static void assertNotExisting(File file) throws IOException {
        String string = ErrorStreamTest.getCanonicalPath(file);
        ErrorStreamTest.assertFalse((String)(string + " exists"), (boolean)PrivilegedFileOpsForTests.exists(file));
    }

    private static boolean deleteFile(File file) {
        return PrivilegedFileOpsForTests.delete(file);
    }

    private static String getCanonicalPath(File file) throws IOException {
        return file.getCanonicalPath();
    }

    private static void makeDirIfNotExisting(String string) {
        File file = new File(string);
        if (!file.exists()) {
            file.mkdir();
        }
    }

    private static FileOutputStream newFileOutputStream(File file) throws FileNotFoundException {
        return new FileOutputStream(file);
    }

    private static void resetProps() {
        ErrorStreamTest.removeSystemProperty(FILE_PROP);
        ErrorStreamTest.removeSystemProperty(METHOD_PROP);
        ErrorStreamTest.removeSystemProperty(FIELD_PROP);
        ErrorStreamTest.removeSystemProperty(STYLE_PROP);
    }

    private void deleteStreamFiles() {
        ErrorStreamTest.deleteFile(this.fileStreamFile);
        ErrorStreamTest.deleteFile(this.methodStreamFile);
        ErrorStreamTest.deleteFile(this.fieldStreamFile);
        ErrorStreamTest.deleteFile(this.errStreamFile);
    }

    private void nullFields() {
        this.fileStreamFile = null;
        this.methodStreamFile = null;
        this.fieldStreamFile = null;
        this.errStreamFile = null;
        methodStream = null;
        fieldStream = null;
        this.errStream = null;
    }

    private void bootDerby() throws SQLException {
        this.getConnection();
        this.getConnection().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runBareOverridable() throws Throwable {
        PrintStream printStream = System.out;
        TestConfiguration testConfiguration = this.getTestConfiguration();
        boolean bl = testConfiguration.stopAfterFirstFail();
        try {
            super.runBareOverridable();
        }
        catch (Throwable throwable) {
            PrintWriter printWriter = null;
            try {
                this.copyFileToFail(LOGFILESDIR);
                this.nullFields();
                this.deleteFile(LOGFILESDIR);
                this.copyFileToFail(DERBY_0_LOG);
                this.copyFileToFail("derby-0.log.lck");
                for (int i = 0; i < 3; ++i) {
                    this.copyFileToFail("db-" + i + ".log");
                    this.deleteFile("db-" + i + ".log");
                }
            }
            catch (IOException iOException) {
                BaseTestCase.printStackTrace(iOException);
                if (printWriter != null) {
                    printWriter.println("Copying derby.log or database failed:");
                    iOException.printStackTrace(printWriter);
                    printWriter.println();
                }
            }
            finally {
                if (printWriter != null) {
                    printWriter.close();
                }
                if (!bl) {
                    throw throwable;
                }
                throwable.printStackTrace(printStream);
                System.exit(1);
            }
        }
        finally {
            this.getTestConfiguration().shutdownEngine();
            File file = new File("system", LOGFILESDIR);
            this.nullFields();
            ErrorStreamTest.removeDirectory(file);
            this.deleteFile("derby-0.log.lck");
            this.deleteFile(DERBY_0_LOG);
            this.deleteFile("derby.log");
        }
    }

    private void copyFileToFail(String string) throws IOException {
        String string2 = PrivilegedFileOpsForTests.getAbsolutePath(this.getFailureFolder());
        File file = new File("system", string);
        File file2 = new File(string2, string);
        PrivilegedFileOpsForTests.copy(file, file2);
    }

    private void deleteFile(String string) throws IOException {
        File file = new File("system", string);
        PrivilegedFileOpsForTests.delete(file);
    }
}

