/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.derby.iapi.db.DatabaseContext;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.DataValueFactoryImpl;
import org.apache.derby.iapi.types.DateTimeDataValue;
import org.apache.derby.iapi.types.DateTimeParser;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.SQLDate;
import org.apache.derby.iapi.types.SQLDouble;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.iapi.types.SQLTime;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.LocaleFinder;
import org.apache.derby.shared.common.sanity.SanityManager;

public final class SQLTimestamp
extends DataType
implements DateTimeDataValue {
    static final int MAX_FRACTION_DIGITS = 9;
    static final int FRACTION_TO_NANO = 1;
    static final int ONE_BILLION = 1000000000;
    private int encodedDate;
    private int encodedTime;
    private int nanos;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLTimestamp.class);
    static final char DATE_SEPARATOR = '-';
    private static final char[] DATE_SEPARATORS = new char[]{'-'};
    private static final char IBM_DATE_TIME_SEPARATOR = '-';
    private static final char ODBC_DATE_TIME_SEPARATOR = ' ';
    private static final char[] DATE_TIME_SEPARATORS = new char[]{'-', ' '};
    private static final char[] DATE_TIME_SEPARATORS_OR_END = new char[]{'-', ' ', '\u0000'};
    private static final char IBM_TIME_SEPARATOR = '.';
    private static final char ODBC_TIME_SEPARATOR = ':';
    private static final char[] TIME_SEPARATORS = new char[]{'.', ':'};
    private static final char[] TIME_SEPARATORS_OR_END = new char[]{'.', ':', '\u0000'};
    private static final char[] END_OF_STRING = new char[]{'\u0000'};

    @Override
    public int estimateMemoryUsage() {
        int sz = BASE_MEMORY_USAGE;
        return sz;
    }

    @Override
    public String getString() {
        if (!this.isNull()) {
            String valueString = this.getTimestamp(null).toString();
            int separatorIdx = valueString.indexOf(45);
            if (separatorIdx >= 0 && separatorIdx < 4) {
                StringBuffer sb = new StringBuffer();
                while (separatorIdx < 4) {
                    sb.append('0');
                    ++separatorIdx;
                }
                sb.append(valueString);
                valueString = sb.toString();
            }
            return valueString;
        }
        return null;
    }

    @Override
    public Date getDate(Calendar cal) throws StandardException {
        if (this.isNull()) {
            return null;
        }
        if (cal == null) {
            cal = new GregorianCalendar();
        }
        cal.clear();
        SQLDate.setDateInCalendar(cal, this.encodedDate);
        return new Date(cal.getTimeInMillis());
    }

    @Override
    public Time getTime(Calendar cal) throws StandardException {
        if (this.isNull()) {
            return null;
        }
        return SQLTime.getTime(cal, this.encodedTime, this.nanos);
    }

    @Override
    public Object getObject() {
        return this.getTimestamp(null);
    }

    @Override
    public int getLength() {
        return 12;
    }

    @Override
    public String getTypeName() {
        return "TIMESTAMP";
    }

    @Override
    public int getTypeFormatId() {
        return 31;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SanityManager.ASSERT(!this.isNull(), "writeExternal() is not supposed to be called for null values.");
        out.writeInt(this.encodedDate);
        out.writeInt(this.encodedTime);
        out.writeInt(this.nanos);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.encodedDate = in.readInt();
        this.encodedTime = in.readInt();
        this.nanos = in.readInt();
    }

    @Override
    public DataValueDescriptor cloneValue(boolean forceMaterialization) {
        return new SQLTimestamp(this.encodedDate, this.encodedTime, this.nanos);
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLTimestamp();
    }

    @Override
    public void restoreToNull() {
        this.encodedDate = 0;
        this.encodedTime = 0;
        this.nanos = 0;
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) throws SQLException, StandardException {
        this.setValue(resultSet.getTimestamp(colNumber), (Calendar)null);
    }

    @Override
    public int compare(DataValueDescriptor other) throws StandardException {
        if (this.typePrecedence() < other.typePrecedence()) {
            return -other.compare(this);
        }
        boolean thisNull = this.isNull();
        boolean otherNull = other.isNull();
        if (thisNull || otherNull) {
            if (!thisNull) {
                return -1;
            }
            if (!otherNull) {
                return 1;
            }
            return 0;
        }
        int otherEncodedDate = 0;
        int otherEncodedTime = 0;
        int otherNanos = 0;
        if (other instanceof SQLTimestamp) {
            SQLTimestamp st = (SQLTimestamp)other;
            otherEncodedDate = st.encodedDate;
            otherEncodedTime = st.encodedTime;
            otherNanos = st.nanos;
        } else {
            GregorianCalendar cal = new GregorianCalendar();
            Timestamp otherts = other.getTimestamp(cal);
            otherEncodedDate = SQLTimestamp.computeEncodedDate(otherts, cal);
            otherEncodedTime = SQLTimestamp.computeEncodedTime(otherts, cal);
            otherNanos = otherts.getNanos();
        }
        int comparison = this.encodedDate < otherEncodedDate ? -1 : (this.encodedDate > otherEncodedDate ? 1 : (this.encodedTime < otherEncodedTime ? -1 : (this.encodedTime > otherEncodedTime ? 1 : (this.nanos < otherNanos ? -1 : (this.nanos > otherNanos ? 1 : 0)))));
        return comparison;
    }

    @Override
    public boolean compare(int op, DataValueDescriptor other, boolean orderedNulls, boolean unknownRV) throws StandardException {
        if (!orderedNulls && (this.isNull() || other.isNull())) {
            return unknownRV;
        }
        return super.compare(op, other, orderedNulls, unknownRV);
    }

    public SQLTimestamp() {
    }

    public SQLTimestamp(Timestamp value, Calendar cal) throws StandardException {
        this.setValue(value, cal);
    }

    public SQLTimestamp(Timestamp value) throws StandardException {
        this(value, (Calendar)null);
    }

    SQLTimestamp(int encodedDate, int encodedTime, int nanos) {
        this.encodedDate = encodedDate;
        this.encodedTime = encodedTime;
        this.nanos = nanos;
    }

    public SQLTimestamp(DataValueDescriptor date, DataValueDescriptor time) throws StandardException {
        GregorianCalendar cal = null;
        if (date == null || date.isNull() || time == null || time.isNull()) {
            return;
        }
        if (date instanceof SQLDate) {
            SQLDate sqlDate = (SQLDate)date;
            this.encodedDate = sqlDate.getEncodedDate();
        } else {
            cal = new GregorianCalendar();
            this.encodedDate = SQLTimestamp.computeEncodedDate(date.getDate(cal), cal);
        }
        if (time instanceof SQLTime) {
            SQLTime sqlTime = (SQLTime)time;
            this.encodedTime = sqlTime.getEncodedTime();
        } else {
            if (cal == null) {
                cal = new GregorianCalendar();
            }
            this.encodedTime = SQLTimestamp.computeEncodedTime(time.getTime(cal), cal);
        }
    }

    public SQLTimestamp(String timestampStr, boolean isJDBCEscape, LocaleFinder localeFinder) throws StandardException {
        this.parseTimestamp(timestampStr, isJDBCEscape, localeFinder, null);
    }

    public SQLTimestamp(String timestampStr, boolean isJDBCEscape, LocaleFinder localeFinder, Calendar cal) throws StandardException {
        this.parseTimestamp(timestampStr, isJDBCEscape, localeFinder, cal);
    }

    private void parseTimestamp(String timestampStr, boolean isJDBCEscape, LocaleFinder localeFinder, Calendar cal) throws StandardException {
        StandardException thrownSE = null;
        DateTimeParser parser = new DateTimeParser(timestampStr);
        try {
            int[] dateTimeNano = SQLTimestamp.parseDateOrTimestamp(parser, true);
            this.encodedDate = dateTimeNano[0];
            this.encodedTime = dateTimeNano[1];
            this.nanos = dateTimeNano[2];
            return;
        }
        catch (StandardException se) {
            thrownSE = se;
            try {
                timestampStr = StringUtil.trimTrailing(timestampStr);
                int[] dateAndTime = SQLTimestamp.parseLocalTimestamp(timestampStr, localeFinder, cal);
                this.encodedDate = dateAndTime[0];
                this.encodedTime = dateAndTime[1];
                return;
            }
            catch (ParseException parseException) {
            }
            catch (StandardException standardException) {
                // empty catch block
            }
            if (thrownSE != null) {
                throw thrownSE;
            }
            throw StandardException.newException("22007.S.181", new Object[0]);
        }
    }

    static int[] parseLocalTimestamp(String str, LocaleFinder localeFinder, Calendar cal) throws StandardException, ParseException {
        DateFormat timestampFormat = null;
        timestampFormat = localeFinder == null ? DateFormat.getDateTimeInstance() : (cal == null ? localeFinder.getTimestampFormat() : (DateFormat)localeFinder.getTimestampFormat().clone());
        if (cal == null) {
            cal = new GregorianCalendar();
        } else {
            timestampFormat.setCalendar(cal);
        }
        java.util.Date date = timestampFormat.parse(str);
        return new int[]{SQLTimestamp.computeEncodedDate(date, cal), SQLTimestamp.computeEncodedTime(date, cal)};
    }

    static int[] parseDateOrTimestamp(DateTimeParser parser, boolean timeRequired) throws StandardException {
        int year = parser.parseInt(4, false, DATE_SEPARATORS, false);
        int month = parser.parseInt(2, true, DATE_SEPARATORS, false);
        int day = parser.parseInt(2, true, timeRequired ? DATE_TIME_SEPARATORS : DATE_TIME_SEPARATORS_OR_END, false);
        int hour = 0;
        int minute = 0;
        int second = 0;
        int nano = 0;
        if (parser.getCurrentSeparator() != '\u0000') {
            char timeSeparator = parser.getCurrentSeparator() == ' ' ? (char)':' : '.';
            hour = parser.parseInt(2, true, TIME_SEPARATORS, false);
            if (timeSeparator == parser.getCurrentSeparator()) {
                minute = parser.parseInt(2, false, TIME_SEPARATORS, false);
                if (timeSeparator == parser.getCurrentSeparator()) {
                    second = parser.parseInt(2, false, TIME_SEPARATORS_OR_END, false);
                    if (parser.getCurrentSeparator() == '.') {
                        nano = parser.parseInt(9, true, END_OF_STRING, true) * 1;
                    }
                }
            }
        }
        parser.checkEnd();
        return new int[]{SQLDate.computeEncodedDate(year, month, day), SQLTime.computeEncodedTime(hour, minute, second), nano};
    }

    @Override
    void setObject(Object theValue) throws StandardException {
        this.setValue((Timestamp)theValue);
    }

    @Override
    protected void setFrom(DataValueDescriptor theValue) throws StandardException {
        if (theValue instanceof SQLTimestamp) {
            this.restoreToNull();
            SQLTimestamp tvst = (SQLTimestamp)theValue;
            this.encodedDate = tvst.encodedDate;
            this.encodedTime = tvst.encodedTime;
            this.nanos = tvst.nanos;
        } else {
            GregorianCalendar cal = new GregorianCalendar();
            this.setValue(theValue.getTimestamp(cal), (Calendar)cal);
        }
    }

    @Override
    public void setValue(Date value, Calendar cal) throws StandardException {
        this.restoreToNull();
        if (value != null) {
            if (cal == null) {
                cal = new GregorianCalendar();
            }
            this.encodedDate = SQLTimestamp.computeEncodedDate(value, cal);
        }
    }

    @Override
    public void setValue(Timestamp value, Calendar cal) throws StandardException {
        this.restoreToNull();
        this.setNumericTimestamp(value, cal);
    }

    @Override
    public void setValue(String theValue) throws StandardException {
        this.restoreToNull();
        if (theValue != null) {
            DatabaseContext databaseContext = (DatabaseContext)DataValueFactoryImpl.getContext("Database");
            this.parseTimestamp(theValue, false, databaseContext == null ? null : databaseContext.getDatabase(), null);
        }
    }

    NumberDataValue nullValueInt() {
        return new SQLInteger();
    }

    NumberDataValue nullValueDouble() {
        return new SQLDouble();
    }

    @Override
    public NumberDataValue getYear(NumberDataValue result) throws StandardException {
        if (this.isNull()) {
            return this.nullValueInt();
        }
        return SQLDate.setSource(SQLDate.getYear(this.encodedDate), result);
    }

    @Override
    public NumberDataValue getMonth(NumberDataValue result) throws StandardException {
        if (this.isNull()) {
            return this.nullValueInt();
        }
        return SQLDate.setSource(SQLDate.getMonth(this.encodedDate), result);
    }

    @Override
    public NumberDataValue getDate(NumberDataValue result) throws StandardException {
        if (this.isNull()) {
            return this.nullValueInt();
        }
        return SQLDate.setSource(SQLDate.getDay(this.encodedDate), result);
    }

    @Override
    public NumberDataValue getHours(NumberDataValue result) throws StandardException {
        if (this.isNull()) {
            return this.nullValueInt();
        }
        return SQLDate.setSource(SQLTime.getHour(this.encodedTime), result);
    }

    @Override
    public NumberDataValue getMinutes(NumberDataValue result) throws StandardException {
        if (this.isNull()) {
            return this.nullValueInt();
        }
        return SQLDate.setSource(SQLTime.getMinute(this.encodedTime), result);
    }

    @Override
    public NumberDataValue getSeconds(NumberDataValue source) throws StandardException {
        SanityManager.ASSERT(source == null || source instanceof SQLDouble, "getSeconds for a timestamp was given a source other than a SQLDouble");
        if (this.isNull()) {
            return this.nullValueDouble();
        }
        NumberDataValue result = source != null ? source : new SQLDouble();
        result.setValue((double)SQLTime.getSecond(this.encodedTime) + (double)this.nanos / 1.0E9);
        return result;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return this.getTimestamp(null).toString();
    }

    public int hashCode() {
        if (this.isNull()) {
            return 0;
        }
        return this.encodedDate + this.encodedTime + this.nanos;
    }

    @Override
    public int typePrecedence() {
        return 110;
    }

    @Override
    public final boolean isNull() {
        return this.encodedDate == 0;
    }

    @Override
    public Timestamp getTimestamp(Calendar cal) {
        if (this.isNull()) {
            return null;
        }
        if (cal == null) {
            cal = new GregorianCalendar();
        }
        this.setCalendar(cal);
        Timestamp t = new Timestamp(cal.getTimeInMillis());
        t.setNanos(this.nanos);
        return t;
    }

    private void setCalendar(Calendar cal) {
        cal.clear();
        SQLDate.setDateInCalendar(cal, this.encodedDate);
        SQLTime.setTimeInCalendar(cal, this.encodedTime);
        cal.set(14, 0);
    }

    private void setNumericTimestamp(Timestamp value, Calendar cal) throws StandardException {
        SanityManager.ASSERT(this.isNull(), "setNumericTimestamp called when already set");
        if (value != null) {
            if (cal == null) {
                cal = new GregorianCalendar();
            }
            this.encodedDate = SQLTimestamp.computeEncodedDate(value, cal);
            this.encodedTime = SQLTimestamp.computeEncodedTime(value, cal);
            this.nanos = value.getNanos();
        }
    }

    private static int computeEncodedDate(java.util.Date value, Calendar currentCal) throws StandardException {
        if (value == null) {
            return 0;
        }
        currentCal.setTime(value);
        return SQLDate.computeEncodedDate(currentCal);
    }

    private static int computeEncodedTime(java.util.Date value, Calendar currentCal) throws StandardException {
        currentCal.setTime(value);
        return SQLTime.computeEncodedTime(currentCal);
    }

    @Override
    public void setInto(PreparedStatement ps, int position) throws SQLException, StandardException {
        ps.setTimestamp(position, this.getTimestamp(null));
    }

    public static DateTimeDataValue computeTimestampFunction(DataValueDescriptor operand, DataValueFactory dvf) throws StandardException {
        try {
            if (operand.isNull()) {
                return new SQLTimestamp();
            }
            if (operand instanceof SQLTimestamp) {
                return (SQLTimestamp)operand.cloneValue(false);
            }
            String str = operand.getString();
            if (str.length() == 14) {
                int year = SQLTimestamp.parseDateTimeInteger(str, 0, 4);
                int month = SQLTimestamp.parseDateTimeInteger(str, 4, 2);
                int day = SQLTimestamp.parseDateTimeInteger(str, 6, 2);
                int hour = SQLTimestamp.parseDateTimeInteger(str, 8, 2);
                int minute = SQLTimestamp.parseDateTimeInteger(str, 10, 2);
                int second = SQLTimestamp.parseDateTimeInteger(str, 12, 2);
                return new SQLTimestamp(SQLDate.computeEncodedDate(year, month, day), SQLTime.computeEncodedTime(hour, minute, second), 0);
            }
            return dvf.getTimestampValue(str, false);
        }
        catch (StandardException se) {
            if ("22007.S.181".startsWith(se.getSQLState())) {
                throw StandardException.newException("22008.S", operand.getString(), "timestamp");
            }
            throw se;
        }
    }

    static int parseDateTimeInteger(String str, int start, int ndigits) throws StandardException {
        int end = start + ndigits;
        int retVal = 0;
        for (int i = start; i < end; ++i) {
            char c = str.charAt(i);
            if (!Character.isDigit(c)) {
                throw StandardException.newException("22007.S.181", new Object[0]);
            }
            retVal = 10 * retVal + Character.digit(c, 10);
        }
        return retVal;
    }

    @Override
    public DateTimeDataValue timestampAdd(int intervalType, NumberDataValue count, Date currentDate, DateTimeDataValue resultHolder) throws StandardException {
        if (resultHolder == null) {
            resultHolder = new SQLTimestamp();
        }
        SQLTimestamp tsResult = (SQLTimestamp)resultHolder;
        if (this.isNull() || count.isNull()) {
            tsResult.restoreToNull();
            return resultHolder;
        }
        tsResult.setFrom(this);
        int intervalCount = count.getInt();
        switch (intervalType) {
            case 0: {
                long nanos = this.nanos + intervalCount;
                if (nanos >= 0L && nanos < 1000000000L) {
                    tsResult.nanos = (int)nanos;
                    break;
                }
                int secondsInc = (int)(nanos / 1000000000L);
                tsResult.nanos = nanos >= 0L ? (int)(nanos % 1000000000L) : (int)(nanos -= (long)(--secondsInc) * 1000000000L);
                this.addInternal(13, secondsInc, tsResult);
                break;
            }
            case 1: {
                this.addInternal(13, intervalCount, tsResult);
                break;
            }
            case 2: {
                this.addInternal(12, intervalCount, tsResult);
                break;
            }
            case 3: {
                this.addInternal(10, intervalCount, tsResult);
                break;
            }
            case 4: {
                this.addInternal(5, intervalCount, tsResult);
                break;
            }
            case 5: {
                this.addInternal(5, intervalCount * 7, tsResult);
                break;
            }
            case 6: {
                this.addInternal(2, intervalCount, tsResult);
                break;
            }
            case 7: {
                this.addInternal(2, intervalCount * 3, tsResult);
                break;
            }
            case 8: {
                this.addInternal(1, intervalCount, tsResult);
                break;
            }
            default: {
                throw StandardException.newException("22008.S", intervalType, "TIMESTAMPADD");
            }
        }
        return tsResult;
    }

    private void addInternal(int calIntervalType, int count, SQLTimestamp tsResult) throws StandardException {
        GregorianCalendar cal = new GregorianCalendar();
        this.setCalendar(cal);
        try {
            ((Calendar)cal).add(calIntervalType, count);
            tsResult.encodedTime = SQLTime.computeEncodedTime(cal);
            tsResult.encodedDate = SQLDate.computeEncodedDate(cal);
        }
        catch (StandardException se) {
            String state = se.getSQLState();
            if (state != null && state.length() > 0 && "22007.S.180".startsWith(state)) {
                throw StandardException.newException("22003", "TIMESTAMP");
            }
            throw se;
        }
    }

    @Override
    public NumberDataValue timestampDiff(int intervalType, DateTimeDataValue time1, Date currentDate, NumberDataValue resultHolder) throws StandardException {
        if (resultHolder == null) {
            resultHolder = new SQLLongint();
        }
        if (this.isNull() || time1.isNull()) {
            resultHolder.setToNull();
            return resultHolder;
        }
        SQLTimestamp ts1 = SQLTimestamp.promote(time1, currentDate);
        GregorianCalendar cal = new GregorianCalendar();
        this.setCalendar(cal);
        long thisInSeconds = cal.getTime().getTime() / 1000L;
        ts1.setCalendar(cal);
        long ts1InSeconds = cal.getTime().getTime() / 1000L;
        long secondsDiff = thisInSeconds - ts1InSeconds;
        int nanosDiff = this.nanos - ts1.nanos;
        if (nanosDiff < 0 && secondsDiff > 0L) {
            --secondsDiff;
            nanosDiff += 1000000000;
        } else if (nanosDiff > 0 && secondsDiff < 0L) {
            ++secondsDiff;
            nanosDiff -= 1000000000;
        }
        long ldiff = 0L;
        switch (intervalType) {
            case 0: {
                ldiff = secondsDiff * 1000000000L + (long)nanosDiff;
                break;
            }
            case 1: {
                ldiff = secondsDiff;
                break;
            }
            case 2: {
                ldiff = secondsDiff / 60L;
                break;
            }
            case 3: {
                ldiff = secondsDiff / 3600L;
                break;
            }
            case 4: {
                ldiff = secondsDiff / 86400L;
                break;
            }
            case 5: {
                ldiff = secondsDiff / 604800L;
                break;
            }
            case 6: 
            case 7: {
                ldiff = Math.abs(secondsDiff) > 31622400L ? 12L * (secondsDiff / 31622400L) : secondsDiff / 2678400L;
                if (secondsDiff >= 0L) {
                    if (ldiff >= Integer.MAX_VALUE) {
                        throw StandardException.newException("22003", "INTEGER");
                    }
                    ((Calendar)cal).add(2, (int)(ldiff + 1L));
                    while (cal.getTime().getTime() / 1000L <= thisInSeconds) {
                        ((Calendar)cal).add(2, 1);
                        ++ldiff;
                    }
                } else {
                    if (ldiff <= Integer.MIN_VALUE) {
                        throw StandardException.newException("22003", "INTEGER");
                    }
                    ((Calendar)cal).add(2, (int)(ldiff - 1L));
                    while (cal.getTime().getTime() / 1000L >= thisInSeconds) {
                        ((Calendar)cal).add(2, -1);
                        --ldiff;
                    }
                }
                if (intervalType != 7) break;
                ldiff /= 3L;
                break;
            }
            case 8: {
                ldiff = secondsDiff / 31622400L;
                if (secondsDiff >= 0L) {
                    if (ldiff >= Integer.MAX_VALUE) {
                        throw StandardException.newException("22003", "INTEGER");
                    }
                    ((Calendar)cal).add(1, (int)(ldiff + 1L));
                    while (cal.getTime().getTime() / 1000L <= thisInSeconds) {
                        ((Calendar)cal).add(1, 1);
                        ++ldiff;
                    }
                } else {
                    if (ldiff <= Integer.MIN_VALUE) {
                        throw StandardException.newException("22003", "INTEGER");
                    }
                    ((Calendar)cal).add(1, (int)(ldiff - 1L));
                    while (cal.getTime().getTime() / 1000L >= thisInSeconds) {
                        ((Calendar)cal).add(1, -1);
                        --ldiff;
                    }
                }
                break;
            }
            default: {
                throw StandardException.newException("22008.S", intervalType, "TIMESTAMPDIFF");
            }
        }
        resultHolder.setValue(ldiff);
        return resultHolder;
    }

    static SQLTimestamp promote(DateTimeDataValue dateTime, Date currentDate) throws StandardException {
        if (dateTime instanceof SQLTimestamp) {
            return (SQLTimestamp)dateTime;
        }
        if (dateTime instanceof SQLTime) {
            return new SQLTimestamp(SQLDate.computeEncodedDate(currentDate, null), ((SQLTime)dateTime).getEncodedTime(), 0);
        }
        if (dateTime instanceof SQLDate) {
            return new SQLTimestamp(((SQLDate)dateTime).getEncodedDate(), 0, 0);
        }
        return new SQLTimestamp(dateTime.getTimestamp(new GregorianCalendar()));
    }
}

