/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.nstest.init;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derbyTesting.system.nstest.NsTest;

public class DbSetup {
    public static boolean doIt(Connection connection) throws Throwable {
        Statement statement = null;
        ResultSet resultSet = null;
        boolean bl = false;
        NsTest.logger.println("dbSetup.doIt() starting...");
        try {
            connection.setAutoCommit(false);
        }
        catch (Exception exception) {
            NsTest.logger.println("FAIL - setAutoCommit() failed:");
            DbSetup.printException("setting autocommit in dbSetup", exception);
            return false;
        }
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery("select tablename from sys.systables  where tablename = 'NSTESTTAB'");
            if (resultSet.next()) {
                resultSet.close();
                NsTest.logger.println("table 'NSTESTTAB' already exists");
                bl = true;
                NsTest.schemaCreated = true;
            }
        }
        catch (Exception exception) {
            NsTest.logger.println("dbSetup.doIt() check existance of table: FAIL -- unexpected exception:");
            DbSetup.printException("executing query or processing resultSet to check for table existence", exception);
            return false;
        }
        if (!bl) {
            try {
                NsTest.logger.println("creating table 'NSTESTTAB' and corresponding indices");
                statement.execute("create table nstesttab (id int,t_char char(100),t_date date,t_decimal decimal,t_decimal_nn decimal(10,10),t_double double precision,t_float float,t_int int,t_longint bigint,t_numeric_large numeric(30,10),t_real real,t_smallint smallint,t_time time,t_timestamp timestamp,t_varchar varchar(100),t_clob clob(1K),t_blob blob(10K),serialkey bigint generated always as identity, sequenceColumn bigint, unique (serialkey)) ");
                statement.execute("create index t_char_ind on nstesttab ( t_char)");
                statement.execute("create index t_date_ind on nstesttab ( t_date)");
                statement.execute("create index t_decimal_ind on nstesttab ( t_decimal)");
                statement.execute("create index t_decimal_nn_ind on nstesttab ( t_decimal_nn)");
                statement.execute("create index t_double_ind on nstesttab ( t_double)");
                statement.execute("create index t_float_ind on nstesttab ( t_float)");
                statement.execute("create index t_int_ind on nstesttab ( t_int)");
                statement.execute("create index t_longint_ind on nstesttab ( t_longint)");
                statement.execute("create index t_num_lrg_ind on nstesttab ( t_numeric_large)");
                statement.execute("create index t_real_ind on nstesttab ( t_real)");
                statement.execute("create index t_smallint_ind on nstesttab ( t_smallint)");
                statement.execute("create index t_time_ind on nstesttab ( t_time)");
                statement.execute("create index t_timestamp_ind on nstesttab ( t_timestamp)");
                statement.execute("create index t_varchar_ind on nstesttab ( t_varchar)");
                statement.execute("create index t_serialkey_ind on nstesttab (serialkey)");
                NsTest.logger.println("Creating nstesttab_seq sequence");
                statement.execute("create sequence nstesttab_seq as bigint start with 0");
                NsTest.logger.println("creating table 'NSTRIGTAB' and corresponding indices");
                statement.execute("create table NSTRIGTAB (id int,t_char char(100),t_date date,t_decimal decimal,t_decimal_nn decimal(10,10),t_double double precision,t_float float,t_int int,t_longint bigint,t_numeric_large numeric(30,10),t_real real,t_smallint smallint,t_time time,t_timestamp timestamp,t_varchar varchar(100),t_clob clob(1K),t_blob blob(10K),serialkey bigint, sequenceColumn bigint )");
                statement.execute("CREATE TRIGGER NSTEST_TRIG AFTER DELETE ON nstesttab REFERENCING OLD AS OLDROW FOR EACH ROW MODE DB2SQL INSERT INTO NSTRIGTAB values(OLDROW.ID, OLDROW.T_CHAR,OLDROW.T_DATE,OLDROW.T_DECIMAL,OLDROW.T_DECIMAL_NN,OLDROW.T_DOUBLE,OLDROW.T_FLOAT, OLDROW.T_INT,OLDROW.T_LONGINT, OLDROW.T_numeric_large,OLDROW.T_real,OLDROW.T_smallint,OLDROW.T_time,OLDROW.T_timestamp,OLDROW.T_varchar,OLDROW.T_clob,OLDROW.T_blob, OLDROW.serialkey, OLDROW.sequenceColumn )");
            }
            catch (Exception exception) {
                if (NsTest.justCountErrors()) {
                    NsTest.printException(DbSetup.class.getName(), exception);
                } else {
                    exception.printStackTrace(NsTest.logger);
                }
                NsTest.logger.println("FAIL - unexpected exception in dbSetup.doIt() while creating schema:");
                DbSetup.printException("executing statements to create schema", exception);
                return false;
            }
        }
        connection.commit();
        return true;
    }

    public static synchronized void printException(String string, Exception exception) {
        if (NsTest.justCountErrors()) {
            NsTest.addError(exception);
            return;
        }
        if (exception instanceof SQLException) {
            SQLException sQLException = (SQLException)exception;
            if (sQLException.getSQLState().equals("40001")) {
                NsTest.logger.println("deadlocked detected");
            }
            if (sQLException.getSQLState().equals("40XL1")) {
                NsTest.logger.println(" lock timeout exception");
            }
            if (sQLException.getSQLState().equals("23500")) {
                NsTest.logger.println(" duplicate key violation");
            }
            if (sQLException.getNextException() != null) {
                String string2 = sQLException.getNextException().getSQLState();
                NsTest.logger.println(sQLException.getNextException().getMessage() + " SQLSTATE: " + string2);
            }
        }
        if (exception.getMessage() == null) {
            NsTest.logger.println("NULL error message detected");
            NsTest.logger.println("Here is the NULL exection - " + exception.toString());
            NsTest.logger.println("Stack trace of the NULL exception - ");
            exception.printStackTrace(NsTest.logger);
        }
        NsTest.logger.println("During " + string + ", exception thrown was : " + exception.getMessage());
    }
}

