/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.PrintStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.derby.tools.JDBCDisplayUtil;
import org.apache.derbyTesting.functionTests.util.TestUtil;

public class OnlineBackup
implements Runnable {
    private String dbName;
    private boolean beginBackup = false;
    private boolean endBackup = false;
    private boolean backupFailed = false;
    private Throwable backupError = null;
    private String backupPath;

    OnlineBackup(String string, String string2) {
        this.dbName = string;
        this.backupPath = string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.backupFailed = false;
        try {
            this.performBackup();
        }
        catch (Throwable throwable) {
            OnlineBackup onlineBackup = this;
            synchronized (onlineBackup) {
                this.backupFailed = true;
                this.backupError = throwable;
                this.notifyAll();
            }
            JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)throwable);
            throwable.printStackTrace(System.out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performBackup() throws SQLException {
        Connection connection = TestUtil.getConnection(this.dbName, "");
        CallableStatement callableStatement = connection.prepareCall("CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE(?)");
        callableStatement.setString(1, this.backupPath);
        OnlineBackup onlineBackup = this;
        synchronized (onlineBackup) {
            this.beginBackup = true;
            this.endBackup = false;
            this.notifyAll();
        }
        callableStatement.execute();
        callableStatement.close();
        connection.close();
        onlineBackup = this;
        synchronized (onlineBackup) {
            this.beginBackup = false;
            this.endBackup = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForBackupToBegin() throws Exception {
        OnlineBackup onlineBackup = this;
        synchronized (onlineBackup) {
            while (!this.beginBackup) {
                if (this.backupFailed) {
                    throw new Exception("BACKUP FAILED:" + this.backupError.getMessage());
                }
                this.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForBackupToEnd() throws Exception {
        OnlineBackup onlineBackup = this;
        synchronized (onlineBackup) {
            if (!this.endBackup) {
                if (!this.beginBackup) {
                    System.out.println("BACKUP IS NOT STARTED BY THE TEST YET");
                } else {
                    while (!this.endBackup) {
                        if (this.backupFailed) {
                            throw new Exception("BACKUP FAILED:" + this.backupError.getMessage());
                        }
                        this.wait();
                    }
                }
            }
        }
    }

    public synchronized boolean isRunning() {
        return this.beginBackup;
    }

    public void createFromBackup(String string) throws SQLException {
        Connection connection = TestUtil.getConnection(string, "createFrom=" + this.backupPath + "/" + this.dbName);
        connection.close();
    }

    public void restoreFromBackup() throws SQLException {
        Connection connection = TestUtil.getConnection(this.dbName, "restoreFrom=" + this.backupPath + "/" + this.dbName);
        connection.close();
    }
}

