/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import junit.extensions.TestSetup;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ClosedObjectTest
extends BaseJDBCTestCase {
    private final Method method_;
    private final ObjectDecorator decorator_;
    private String name_;

    public ClosedObjectTest(Method method, ObjectDecorator objectDecorator) {
        super("testClosedObjects");
        this.method_ = method;
        this.decorator_ = objectDecorator;
        this.name_ = method.getDeclaringClass().getName() + "." + method.getName();
    }

    public String getName() {
        return this.name_;
    }

    public void testClosedObjects() throws Throwable {
        try {
            Object object = this.decorator_.getClosedObject();
            String string = object.getClass().getName();
            this.name_ = string + "." + this.method_.getName();
            if (JDBC.vmSupportsJDBC4() && !this.isImplemented()) {
                ClosedObjectTest.println("Skipping testing of " + String.valueOf(this.method_) + " on " + string + " because it is not implemented");
                this.name_ = this.name_ + "_SKIPPED";
                return;
            }
            this.method_.invoke(object, ClosedObjectTest.getNullArguments(this.method_.getParameterTypes()));
            ClosedObjectTest.assertFalse((String)("No exception was thrown for method " + String.valueOf(this.method_)), (boolean)this.decorator_.expectsException(this.method_));
        }
        catch (InvocationTargetException invocationTargetException) {
            try {
                throw invocationTargetException.getCause();
            }
            catch (SQLException sQLException) {
                this.decorator_.checkException(this.method_, sQLException);
            }
        }
    }

    private boolean isImplemented() throws NoSuchMethodException {
        for (Class<?> clazz = this.decorator_.getClosedObject().getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            if (!clazz.getName().startsWith("org.apache.derby.")) continue;
            try {
                Method method = clazz.getDeclaredMethod(this.method_.getName(), this.method_.getParameterTypes());
                if (method.isSynthetic()) continue;
                return true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return false;
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("ClosedObjectTest suite");
        baseTestSuite.addTest(ClosedObjectTest.baseSuite(false));
        baseTestSuite.addTest(ClosedObjectTest.baseSuite(true));
        return baseTestSuite;
    }

    private static Test baseSuite(boolean bl) {
        BaseTestSuite baseTestSuite = new BaseTestSuite("ClosedObjectTest:" + (bl ? "client" : "embedded"));
        BaseTestSuite baseTestSuite2 = new BaseTestSuite("ClosedObjectTest DataSource");
        DataSourceDecorator dataSourceDecorator = new DataSourceDecorator((Test)baseTestSuite2);
        baseTestSuite.addTest((Test)dataSourceDecorator);
        ClosedObjectTest.fillDataSourceSuite(baseTestSuite2, dataSourceDecorator);
        if (JDBC.vmSupportsJDBC3()) {
            baseTestSuite.addTest(ClosedObjectTest.poolSuite(Collections.emptyMap()));
            if (bl) {
                baseTestSuite.addTest(ClosedObjectTest.poolSuite(Collections.singletonMap("maxStatements", 5)));
            }
            BaseTestSuite baseTestSuite3 = new BaseTestSuite("ClosedObjectTest XA");
            XADataSourceDecorator xADataSourceDecorator = new XADataSourceDecorator((Test)baseTestSuite3);
            baseTestSuite.addTest((Test)xADataSourceDecorator);
            ClosedObjectTest.fillDataSourceSuite(baseTestSuite3, xADataSourceDecorator);
        }
        return bl ? TestConfiguration.clientServerDecorator((Test)baseTestSuite) : baseTestSuite;
    }

    private static Test poolSuite(Map map) {
        BaseTestSuite baseTestSuite = new BaseTestSuite("ClosedObjectTest ConnectionPoolDataSource");
        PoolDataSourceDecorator poolDataSourceDecorator = new PoolDataSourceDecorator((Test)baseTestSuite, map);
        ClosedObjectTest.fillDataSourceSuite(baseTestSuite, poolDataSourceDecorator);
        return poolDataSourceDecorator;
    }

    private static void fillDataSourceSuite(BaseTestSuite baseTestSuite, DataSourceDecorator dataSourceDecorator) {
        BaseTestSuite baseTestSuite2 = new BaseTestSuite("Closed ResultSet");
        ResultSetObjectDecorator resultSetObjectDecorator = new ResultSetObjectDecorator((Test)baseTestSuite2, dataSourceDecorator);
        baseTestSuite.addTest((Test)resultSetObjectDecorator);
        ClosedObjectTest.fillObjectSuite(baseTestSuite2, resultSetObjectDecorator, ResultSet.class);
        BaseTestSuite baseTestSuite3 = new BaseTestSuite("Closed Statement");
        StatementObjectDecorator statementObjectDecorator = new StatementObjectDecorator((Test)baseTestSuite3, dataSourceDecorator);
        baseTestSuite.addTest((Test)statementObjectDecorator);
        ClosedObjectTest.fillObjectSuite(baseTestSuite3, statementObjectDecorator, Statement.class);
        BaseTestSuite baseTestSuite4 = new BaseTestSuite("Closed PreparedStatement");
        PreparedStatementObjectDecorator preparedStatementObjectDecorator = new PreparedStatementObjectDecorator((Test)baseTestSuite4, dataSourceDecorator);
        baseTestSuite.addTest((Test)preparedStatementObjectDecorator);
        ClosedObjectTest.fillObjectSuite(baseTestSuite4, preparedStatementObjectDecorator, PreparedStatement.class);
        BaseTestSuite baseTestSuite5 = new BaseTestSuite("Closed CallableStatement");
        CallableStatementObjectDecorator callableStatementObjectDecorator = new CallableStatementObjectDecorator((Test)baseTestSuite5, dataSourceDecorator);
        baseTestSuite.addTest((Test)callableStatementObjectDecorator);
        ClosedObjectTest.fillObjectSuite(baseTestSuite5, callableStatementObjectDecorator, CallableStatement.class);
        BaseTestSuite baseTestSuite6 = new BaseTestSuite("Closed Connection");
        ConnectionObjectDecorator connectionObjectDecorator = new ConnectionObjectDecorator((Test)baseTestSuite6, dataSourceDecorator);
        baseTestSuite.addTest((Test)connectionObjectDecorator);
        ClosedObjectTest.fillObjectSuite(baseTestSuite6, connectionObjectDecorator, Connection.class);
    }

    private static void fillObjectSuite(BaseTestSuite baseTestSuite, ObjectDecorator objectDecorator, Class clazz) {
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            ClosedObjectTest closedObjectTest = new ClosedObjectTest(methodArray[i], objectDecorator);
            baseTestSuite.addTest((Test)closedObjectTest);
        }
    }

    private static Object[] getNullArguments(Class[] classArray) {
        Object[] objectArray = new Object[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            objectArray[i] = ClosedObjectTest.getNullValueForType(classArray[i]);
        }
        return objectArray;
    }

    private static Object getNullValueForType(Class clazz) {
        if (!clazz.isPrimitive()) {
            return null;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (clazz == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (clazz == Byte.TYPE) {
            return (byte)0;
        }
        if (clazz == Short.TYPE) {
            return (short)0;
        }
        if (clazz == Integer.TYPE) {
            return 0;
        }
        if (clazz == Long.TYPE) {
            return 0L;
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (clazz == Double.TYPE) {
            return 0.0;
        }
        ClosedObjectTest.fail((String)("Don't know how to handle type " + String.valueOf(clazz)));
        return null;
    }

    private static abstract class ObjectDecorator
    extends TestSetup {
        private final DataSourceDecorator decorator_;
        protected Object object_;

        public ObjectDecorator(Test test, DataSourceDecorator dataSourceDecorator) {
            super(test);
            this.decorator_ = dataSourceDecorator;
        }

        protected void tearDown() throws Exception {
            this.object_ = null;
        }

        public Object getClosedObject() {
            return this.object_;
        }

        public boolean expectsException(Method method) {
            String string = method.getName();
            return !string.equals("close") && !string.equals("isClosed") && !string.equals("isValid") && !string.equals("abort");
        }

        public final void checkException(Method method, SQLException sQLException) throws SQLException {
            if (!this.expectsException(method)) {
                throw sQLException;
            }
            if (sQLException.getSQLState().startsWith("0A")) {
                return;
            }
            this.checkSQLState(method, sQLException);
        }

        protected abstract void checkSQLState(Method var1, SQLException var2) throws SQLException;

        protected Connection createConnection() throws SQLException {
            return this.decorator_.newConnection();
        }

        protected Statement createStatement() throws SQLException {
            return this.decorator_.getConnection().createStatement();
        }

        protected PreparedStatement prepareStatement(String string) throws SQLException {
            return this.decorator_.getConnection().prepareStatement(string);
        }

        protected CallableStatement prepareCall(String string) throws SQLException {
            return this.decorator_.getConnection().prepareCall(string);
        }
    }

    private static class DataSourceDecorator
    extends TestSetup {
        private Connection connection_;

        public DataSourceDecorator(Test test) {
            super(test);
        }

        public final void setUp() throws SQLException {
            this.connection_ = this.newConnection();
        }

        public final Connection getConnection() {
            return this.connection_;
        }

        public final Connection newConnection() throws SQLException {
            Connection connection = this.newConnection_();
            connection.setAutoCommit(false);
            return connection;
        }

        public final void tearDown() throws SQLException {
            this.connection_.rollback();
            this.connection_.close();
            this.connection_ = null;
        }

        protected Connection newConnection_() throws SQLException {
            DataSource dataSource = JDBCDataSource.getDataSource();
            JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", "create=true");
            return dataSource.getConnection();
        }
    }

    private static class XADataSourceDecorator
    extends DataSourceDecorator {
        public XADataSourceDecorator(Test test) {
            super(test);
        }

        @Override
        protected Connection newConnection_() throws SQLException {
            XADataSource xADataSource = J2EEDataSource.getXADataSource();
            XAConnection xAConnection = xADataSource.getXAConnection();
            return xAConnection.getConnection();
        }
    }

    private static class PoolDataSourceDecorator
    extends DataSourceDecorator {
        private final Map dsProps;

        public PoolDataSourceDecorator(Test test, Map map) {
            super(test);
            this.dsProps = map;
        }

        @Override
        protected Connection newConnection_() throws SQLException {
            ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
            for (Map.Entry entry : this.dsProps.entrySet()) {
                J2EEDataSource.setBeanProperty(connectionPoolDataSource, (String)entry.getKey(), entry.getValue());
            }
            PooledConnection pooledConnection = connectionPoolDataSource.getPooledConnection();
            return pooledConnection.getConnection();
        }
    }

    private static class ResultSetObjectDecorator
    extends ObjectDecorator {
        private Statement stmt_;

        public ResultSetObjectDecorator(Test test, DataSourceDecorator dataSourceDecorator) {
            super(test, dataSourceDecorator);
        }

        public void setUp() throws SQLException {
            this.stmt_ = this.createStatement();
            ResultSet resultSet = this.stmt_.executeQuery("VALUES(1)");
            resultSet.close();
            this.object_ = resultSet;
        }

        @Override
        public void tearDown() throws Exception {
            this.stmt_.close();
            this.stmt_ = null;
            super.tearDown();
        }

        @Override
        protected void checkSQLState(Method method, SQLException sQLException) throws SQLException {
            String string;
            if (sQLException.getSQLState().equals("XCL16")) {
                string = method.getName();
                if (string.indexOf("(") > 1) {
                    string = string.substring(0, string.length() - 2);
                }
            } else {
                throw sQLException;
            }
            ResultSetObjectDecorator.assertTrue((String)("method = " + method.toString() + ", but message: " + sQLException.getMessage()), (sQLException.getMessage().indexOf(string) > 0 ? 1 : 0) != 0);
        }
    }

    private static class StatementObjectDecorator
    extends ObjectDecorator {
        public StatementObjectDecorator(Test test, DataSourceDecorator dataSourceDecorator) {
            super(test, dataSourceDecorator);
        }

        public void setUp() throws SQLException {
            Statement statement = this.createStatement();
            statement.close();
            this.object_ = statement;
        }

        @Override
        protected void checkSQLState(Method method, SQLException sQLException) throws SQLException {
            String string = sQLException.getSQLState();
            if (!string.equals("XJ012")) {
                throw sQLException;
            }
        }
    }

    private static class PreparedStatementObjectDecorator
    extends StatementObjectDecorator {
        public PreparedStatementObjectDecorator(Test test, DataSourceDecorator dataSourceDecorator) {
            super(test, dataSourceDecorator);
        }

        @Override
        public void setUp() throws SQLException {
            PreparedStatement preparedStatement = this.prepareStatement("VALUES(1)");
            preparedStatement.close();
            this.object_ = preparedStatement;
        }

        @Override
        protected void checkSQLState(Method method, SQLException sQLException) throws SQLException {
            if (method.getDeclaringClass() != Statement.class || !sQLException.getSQLState().equals("XJ016")) {
                super.checkSQLState(method, sQLException);
            }
        }
    }

    private static class CallableStatementObjectDecorator
    extends PreparedStatementObjectDecorator {
        public CallableStatementObjectDecorator(Test test, DataSourceDecorator dataSourceDecorator) {
            super(test, dataSourceDecorator);
        }

        @Override
        public void setUp() throws SQLException {
            CallableStatement callableStatement = this.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
            callableStatement.close();
            this.object_ = callableStatement;
        }
    }

    private static class ConnectionObjectDecorator
    extends ObjectDecorator {
        public ConnectionObjectDecorator(Test test, DataSourceDecorator dataSourceDecorator) {
            super(test, dataSourceDecorator);
        }

        public void setUp() throws SQLException {
            Connection connection = this.createConnection();
            connection.rollback();
            connection.close();
            this.object_ = connection;
        }

        @Override
        protected void checkSQLState(Method method, SQLException sQLException) throws SQLException {
            if (method.getName().equals("setClientInfo") && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == Properties.class) {
                if (!sQLException.getClass().getName().equals("java.sql.SQLClientInfoException")) {
                    throw sQLException;
                }
            } else if (!sQLException.getSQLState().equals("08003")) {
                throw sQLException;
            }
        }
    }
}

