/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestSetup;
import org.apache.derbyTesting.junit.ChangeUserSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DatabasePropertyTestSetup
extends BaseJDBCTestSetup {
    private Properties newValues;
    private Properties oldValues;
    private final boolean staticProperties;

    public static Test setLockTimeouts(Test test, int n, int n2) {
        Properties properties = new Properties();
        if (n >= 0) {
            properties.setProperty("derby.locks.deadlockTimeout", Integer.toString(n));
        }
        if (n2 >= 0) {
            properties.setProperty("derby.locks.waitTimeout", Integer.toString(n2));
        }
        if (properties.isEmpty()) {
            return test;
        }
        return new DatabasePropertyTestSetup(test, properties, true);
    }

    public static Test builtinAuthentication(Test object, String[] stringArray, String string) {
        Properties properties = new Properties();
        Properties properties2 = new Properties();
        properties2.setProperty("derby.connection.requireAuthentication", "true");
        properties2.setProperty("derby.authentication.provider", "BUILTIN");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            properties.setProperty("derby.user." + string2, TestConfiguration.getPassword(string2, string));
        }
        object = new DatabasePropertyTestSetup((Test)object, properties2, true);
        object = new ChangeUserSetup((Test)object, stringArray[0], TestConfiguration.getPassword(stringArray[0], string), string);
        object = new DatabasePropertyTestSetup((Test)object, properties, false);
        return object;
    }

    public static Test builtinAuthenticationNoTeardown(Test object, String[] stringArray, String string) {
        Properties properties = new Properties();
        Properties properties2 = new Properties();
        properties2.setProperty("derby.connection.requireAuthentication", "true");
        properties2.setProperty("derby.authentication.provider", "BUILTIN");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            properties.setProperty("derby.user." + string2, TestConfiguration.getPassword(string2, string));
        }
        object = DatabasePropertyTestSetup.getNoTeardownInstance(object, properties2, true);
        object = new ChangeUserSetup((Test)object, stringArray[0], TestConfiguration.getPassword(stringArray[0], string), string);
        object = DatabasePropertyTestSetup.getNoTeardownInstance(object, properties, false);
        return object;
    }

    static DatabasePropertyTestSetup getNoTeardownInstance(Test test, Properties properties, boolean bl) {
        return new DatabasePropertyTestSetup(test, properties, bl){

            @Override
            protected void tearDown() throws Exception {
                this.clearConnection();
            }
        };
    }

    public static Test singleProperty(Test test, String string, String string2) {
        return DatabasePropertyTestSetup.singleProperty(test, string, string2, false);
    }

    public static Test singleProperty(Test test, String string, String string2, boolean bl) {
        Properties properties = new Properties();
        properties.setProperty(string, string2);
        return new DatabasePropertyTestSetup(test, properties, bl);
    }

    public DatabasePropertyTestSetup(Test test, Properties properties) {
        this(test, properties, false);
    }

    public DatabasePropertyTestSetup(Test test, Properties properties, boolean bl) {
        super(test);
        this.newValues = properties;
        this.oldValues = new Properties();
        this.staticProperties = bl;
    }

    protected void setUp() throws Exception {
        this.setProperties(this.newValues);
        if (this.staticProperties) {
            TestConfiguration.getCurrent().shutdownDatabase();
        }
    }

    @Override
    protected void tearDown() throws Exception {
        block9: {
            Connection connection = this.getConnection();
            try {
                this.clearProperties(connection);
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState().equals("25502")) {
                    block8: {
                        System.out.println("Apparently this is a read-only connection in teardown()? Get some data:");
                        System.out.println("conn.isClosed: " + connection.isClosed());
                        System.out.println("conn.isReadOnly: " + connection.isReadOnly());
                        System.out.println("conn.getHoldability: " + connection.getHoldability());
                        System.out.println("conn.getTransactionIsolation: " + connection.getTransactionIsolation());
                        System.out.println("conn.getAutoCommit: " + connection.getAutoCommit());
                        try {
                            connection.close();
                        }
                        catch (SQLException sQLException2) {
                            if (sQLException.getSQLState() == "25001") {
                                connection.commit();
                                connection.close();
                                break block8;
                            }
                            System.out.println("close failed - see SQLState.");
                            throw sQLException;
                        }
                    }
                    Connection connection2 = this.getConnection();
                    if (connection2.isReadOnly()) {
                        System.out.println("Sorry, conn2 is also read-only, won't retry");
                        throw sQLException;
                    }
                    System.out.println("retrying clearing the Properties");
                    this.clearProperties(connection2);
                }
                if (sQLException.getSQLState().equals("XCY02")) break block9;
                throw sQLException;
            }
        }
        this.setProperties(this.oldValues);
        super.tearDown();
        this.newValues = null;
        this.oldValues = null;
        if (this.staticProperties) {
            TestConfiguration.getCurrent().shutdownDatabase();
        }
    }

    private void clearProperties(Connection connection) throws SQLException {
        connection.setAutoCommit(false);
        CallableStatement callableStatement = connection.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(?, NULL)");
        Enumeration<?> enumeration = this.newValues.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.oldValues.getProperty(string) != null) continue;
            callableStatement.setString(1, string);
            callableStatement.executeUpdate();
        }
    }

    private void setProperties(Properties properties) throws SQLException {
        block6: {
            Connection connection = this.getConnection();
            try {
                this.attemptSetProperties(properties, connection);
            }
            catch (SQLException sQLException) {
                block7: {
                    if (!sQLException.getSQLState().equals("25502")) break block6;
                    System.out.println("Apparently this is a read-only connection? Get some data:");
                    System.out.println("conn.isClosed: " + connection.isClosed());
                    System.out.println("conn.isReadOnly: " + connection.isReadOnly());
                    System.out.println("conn.getHoldability: " + connection.getHoldability());
                    System.out.println("conn.getTransactionIsolation: " + connection.getTransactionIsolation());
                    System.out.println("conn.getAutoCommit: " + connection.getAutoCommit());
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException2) {
                        if (sQLException.getSQLState() == "25001") {
                            connection.commit();
                            connection.close();
                            break block7;
                        }
                        System.out.println("close failed - see SQLState.");
                        throw sQLException;
                    }
                }
                Connection connection2 = this.getConnection();
                if (connection2.isReadOnly()) {
                    System.out.println("Sorry, conn2 is also read-only, won't retry");
                    throw sQLException;
                }
                System.out.println("retrying to set the Properties");
                this.attemptSetProperties(properties, connection2);
            }
        }
    }

    private void attemptSetProperties(Properties properties, Connection connection) throws SQLException {
        Connection connection2 = this.getConnection();
        connection2.setAutoCommit(false);
        PreparedStatement preparedStatement = connection2.prepareStatement("VALUES SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY(?)");
        CallableStatement callableStatement = connection2.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(?, ?)");
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            boolean bl;
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            preparedStatement.setString(1, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            String string3 = resultSet.getString(1);
            resultSet.close();
            if (string3 != null) {
                boolean bl2 = bl = !string3.equals(string2);
                if (bl && properties != this.oldValues) {
                    this.oldValues.setProperty(string, string3);
                }
            } else {
                bl = true;
            }
            if (!bl) continue;
            callableStatement.setString(1, string);
            callableStatement.setString(2, string2);
            callableStatement.executeUpdate();
        }
        connection2.commit();
        preparedStatement.close();
        callableStatement.close();
        connection2.close();
    }
}

