/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.Formatters;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class BigDataTest
extends BaseJDBCTestCase {
    private static final String BIG_TABLE_NAME = "big";

    public BigDataTest(String string) throws SQLException {
        super(string);
    }

    public static String getSelectSql(String string) {
        return "select * from " + string;
    }

    private void createTable(String string, int[] nArray, boolean[] blArray) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("create table ");
        stringBuffer.append(string);
        stringBuffer.append(" (");
        for (int i = 0; i < nArray.length - 1; ++i) {
            stringBuffer.append("c" + (i + 1) + (blArray[i] ? " clob(" : " varchar(") + nArray[i] + "),");
        }
        stringBuffer.append("c" + nArray.length + (blArray[nArray.length - 1] ? " clob(" : " varchar(") + nArray[nArray.length - 1] + ")");
        stringBuffer.append(")");
        String string2 = stringBuffer.toString();
        this.createTable(string2);
    }

    private void createTable(String string) throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate(string);
        statement.close();
    }

    private String[] getStringArray(String[] stringArray, int[] nArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = new String(Formatters.repeatChar(stringArray[i], nArray[i]));
        }
        return stringArray2;
    }

    private String[][] getRowsWithOnlyOneColumn(String[] stringArray, int[] nArray) {
        String[][] stringArray2 = new String[stringArray.length][1];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i][0] = new String(Formatters.repeatChar(stringArray[i], nArray[i]));
        }
        return stringArray2;
    }

    private void insertOneRow(String string, String[] stringArray, int[] nArray) throws SQLException {
        String[] stringArray2 = this.getStringArray(stringArray, nArray);
        this.insertOneRow(string, stringArray2);
    }

    private void insertOneRow(String string, String[] stringArray) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("insert into ");
        stringBuffer.append(string);
        stringBuffer.append(" values (");
        for (int i = 0; i < stringArray.length - 1; ++i) {
            stringBuffer.append("?, ");
        }
        stringBuffer.append("?)");
        String string2 = stringBuffer.toString();
        PreparedStatement preparedStatement = this.prepareStatement(string2);
        for (int i = 1; i <= stringArray.length; ++i) {
            preparedStatement.setString(i, stringArray[i - 1]);
        }
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    private void insertMultipleRows(String string, String[][] stringArray) throws SQLException {
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i];
            this.insertOneRow(string, stringArray2);
        }
    }

    private void validTable(String[][] stringArray, String string) throws SQLException {
        String string2 = BigDataTest.getSelectSql(string);
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery(string2);
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.close();
    }

    private void validSingleRow(String[] stringArray, boolean[] blArray, ResultSet resultSet) throws SQLException {
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            if (blArray[i]) {
                Clob clob = resultSet.getClob(i + 1);
                string = clob.getSubString(1L, (int)clob.length());
            } else {
                string = resultSet.getString(i + 1);
            }
            BigDataTest.assertEquals((String)("Compare column " + (i + 1)), (String)stringArray[i], (String)string);
        }
    }

    @Override
    public void tearDown() throws Exception {
        this.dropTable(BIG_TABLE_NAME);
        super.tearDown();
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("BigDataTest");
        baseTestSuite.addTest(TestConfiguration.defaultSuite(BigDataTest.class));
        return baseTestSuite;
    }

    public void testMixture() throws SQLException {
        int[] nArray = new int[]{32672, 32672, 32672, 32672};
        boolean[] blArray = new boolean[]{true, false, false, true};
        this.createTable(BIG_TABLE_NAME, nArray, blArray);
        String[] stringArray = new String[]{"a", "b", "c", "d"};
        this.insertOneRow(BIG_TABLE_NAME, stringArray, nArray);
        String[] stringArray2 = this.getStringArray(stringArray, nArray);
        String[][] stringArray3 = new String[][]{stringArray2};
        this.validTable(stringArray3, BIG_TABLE_NAME);
        this.insertOneRow(BIG_TABLE_NAME, stringArray, nArray);
        this.insertOneRow(BIG_TABLE_NAME, stringArray, nArray);
        stringArray3 = new String[][]{stringArray2, stringArray2, stringArray2};
        this.validTable(stringArray3, BIG_TABLE_NAME);
        String string = BigDataTest.getSelectSql(BIG_TABLE_NAME);
        Statement statement = this.createStatement(1004, 1007);
        ResultSet resultSet = statement.executeQuery(string);
        BigDataTest.assertEquals((String)"Before operation, row No. is 0.", (int)0, (int)resultSet.getRow());
        resultSet.first();
        BigDataTest.assertEquals((String)"After calling first(), row No. is 1.", (int)1, (int)resultSet.getRow());
        this.validSingleRow(stringArray2, blArray, resultSet);
        resultSet.next();
        BigDataTest.assertEquals((String)"After calling next(), row No. is 2.", (int)2, (int)resultSet.getRow());
        this.validSingleRow(stringArray2, blArray, resultSet);
        resultSet.previous();
        BigDataTest.assertEquals((String)"After calling previous(), row No. is 1.", (int)1, (int)resultSet.getRow());
        this.validSingleRow(stringArray2, blArray, resultSet);
        resultSet.last();
        BigDataTest.assertEquals((String)"After calling last(), row No. is 3.", (int)3, (int)resultSet.getRow());
        this.validSingleRow(stringArray2, blArray, resultSet);
        resultSet.close();
        statement.close();
    }

    public void testScrolling() throws SQLException {
        int[] nArray = new int[]{10000, 10000, 10000, 10000};
        boolean[] blArray = new boolean[]{false, false, false, false};
        this.createTable(BIG_TABLE_NAME, nArray, blArray);
        String[] stringArray = new String[]{"a", "b", "c", "d"};
        this.insertOneRow(BIG_TABLE_NAME, stringArray, nArray);
        String[] stringArray2 = new String[]{"e", "f", "g", "h"};
        this.insertOneRow(BIG_TABLE_NAME, stringArray2, nArray);
        String[] stringArray3 = new String[]{"i", "j", "k", "l"};
        this.insertOneRow(BIG_TABLE_NAME, stringArray3, nArray);
        String[] stringArray4 = new String[]{"m", "n", "o", "p"};
        this.insertOneRow(BIG_TABLE_NAME, stringArray4, nArray);
        String[] stringArray5 = this.getStringArray(stringArray, nArray);
        String[] stringArray6 = this.getStringArray(stringArray2, nArray);
        String[] stringArray7 = this.getStringArray(stringArray3, nArray);
        String[] stringArray8 = this.getStringArray(stringArray4, nArray);
        String[][] stringArray9 = new String[][]{stringArray5, stringArray6, stringArray7, stringArray8};
        this.validTable(stringArray9, BIG_TABLE_NAME);
        String string = BigDataTest.getSelectSql(BIG_TABLE_NAME);
        Statement statement = this.createStatement(1004, 1007);
        ResultSet resultSet = statement.executeQuery(string);
        resultSet.first();
        this.validSingleRow(stringArray5, blArray, resultSet);
        resultSet.next();
        this.validSingleRow(stringArray6, blArray, resultSet);
        resultSet.previous();
        this.validSingleRow(stringArray5, blArray, resultSet);
        resultSet.last();
        this.validSingleRow(stringArray8, blArray, resultSet);
        resultSet.close();
        resultSet = statement.executeQuery(string);
        resultSet.last();
        this.validSingleRow(stringArray8, blArray, resultSet);
        resultSet.close();
        statement.close();
    }

    public void testBigColumn() throws SQLException {
        int[] nArray = new int[]{40000};
        boolean[] blArray = new boolean[]{true};
        this.createTable(BIG_TABLE_NAME, nArray, blArray);
        String[] stringArray = new String[]{"a"};
        this.insertOneRow(BIG_TABLE_NAME, stringArray, nArray);
        String[][] stringArray2 = new String[][]{this.getStringArray(stringArray, nArray)};
        this.validTable(stringArray2, BIG_TABLE_NAME);
    }

    public void testSeveralBigColumns() throws SQLException {
        int[] nArray = new int[]{40000, 40000, 40000};
        boolean[] blArray = new boolean[]{true, true, true};
        this.createTable(BIG_TABLE_NAME, nArray, blArray);
        String[] stringArray = new String[]{"a", "b", "c"};
        this.insertOneRow(BIG_TABLE_NAME, stringArray, nArray);
        String[] stringArray2 = new String[]{"d", "e", "f"};
        this.insertOneRow(BIG_TABLE_NAME, stringArray2, nArray);
        String[][] stringArray3 = new String[][]{this.getStringArray(stringArray, nArray), this.getStringArray(stringArray2, nArray)};
        this.validTable(stringArray3, BIG_TABLE_NAME);
    }

    public void testBigRow() throws SQLException {
        int[] nArray = new int[]{10000, 10000, 10000, 10000};
        boolean[] blArray = new boolean[]{false, false, false, false};
        this.createTable(BIG_TABLE_NAME, nArray, blArray);
        String[] stringArray = new String[]{"a", "b", "c", "d"};
        this.insertOneRow(BIG_TABLE_NAME, stringArray, nArray);
        String[][] stringArray2 = new String[][]{this.getStringArray(stringArray, nArray)};
        this.validTable(stringArray2, BIG_TABLE_NAME);
        String[] stringArray3 = new String[]{"e", "f", "g", "h"};
        this.insertOneRow(BIG_TABLE_NAME, stringArray3, nArray);
        stringArray2 = new String[][]{stringArray2[0], this.getStringArray(stringArray3, nArray)};
        this.validTable(stringArray2, BIG_TABLE_NAME);
    }

    public void testDefaultQueryBlock() throws SQLException {
        int[] nArray = new int[]{30000, 2752};
        boolean[] blArray = new boolean[]{false, false};
        this.createTable(BIG_TABLE_NAME, nArray, blArray);
        String[] stringArray = new String[]{"a", "b"};
        this.insertOneRow(BIG_TABLE_NAME, stringArray, nArray);
        String[][] stringArray2 = new String[][]{this.getStringArray(stringArray, nArray)};
        this.validTable(stringArray2, BIG_TABLE_NAME);
    }

    public void testSpanQRYDTABlocks() throws SQLException {
        int[] nArray = new int[]{32672, 32672, 32672, 32672};
        boolean[] blArray = new boolean[]{false, false, false, false};
        this.createTable(BIG_TABLE_NAME, nArray, blArray);
        String[] stringArray = new String[]{"a", "b", "c", "d"};
        this.insertOneRow(BIG_TABLE_NAME, stringArray, nArray);
        String[] stringArray2 = this.getStringArray(stringArray, nArray);
        String[][] stringArray3 = new String[][]{stringArray2};
        this.validTable(stringArray3, BIG_TABLE_NAME);
        this.insertOneRow(BIG_TABLE_NAME, stringArray, nArray);
        this.insertOneRow(BIG_TABLE_NAME, stringArray, nArray);
        stringArray3 = new String[][]{stringArray2, stringArray2, stringArray2};
        this.validTable(stringArray3, BIG_TABLE_NAME);
        String string = BigDataTest.getSelectSql(BIG_TABLE_NAME);
        Statement statement = this.createStatement(1004, 1007);
        ResultSet resultSet = statement.executeQuery(string);
        BigDataTest.assertEquals((String)"Before operation, row No. is 0.", (int)0, (int)resultSet.getRow());
        resultSet.first();
        BigDataTest.assertEquals((String)"After calling first(), row No. is 1.", (int)1, (int)resultSet.getRow());
        this.validSingleRow(stringArray2, blArray, resultSet);
        resultSet.next();
        BigDataTest.assertEquals((String)"After calling next(), row No. is 2.", (int)2, (int)resultSet.getRow());
        this.validSingleRow(stringArray2, blArray, resultSet);
        resultSet.previous();
        BigDataTest.assertEquals((String)"After calling previous(), row No. is 1.", (int)1, (int)resultSet.getRow());
        this.validSingleRow(stringArray2, blArray, resultSet);
        resultSet.last();
        BigDataTest.assertEquals((String)"After calling last(), row No. is 3.", (int)3, (int)resultSet.getRow());
        this.validSingleRow(stringArray2, blArray, resultSet);
        resultSet.close();
        statement.close();
    }

    public void testTooBigSQLCARD() throws SQLException {
        int[] nArray = new int[]{30000, 2750};
        boolean[] blArray = new boolean[]{false, false};
        this.createTable(BIG_TABLE_NAME, nArray, blArray);
        String[] stringArray = new String[]{"a", "b"};
        this.insertOneRow(BIG_TABLE_NAME, stringArray, nArray);
        String[][] stringArray2 = new String[][]{this.getStringArray(stringArray, nArray)};
        this.validTable(stringArray2, BIG_TABLE_NAME);
    }

    public void testLongVarchar() throws SQLException {
        String string = "create table big(lvc long varchar )";
        this.createTable(string);
        String[] stringArray = new String[]{"a", "a", "a", "a", "a"};
        int[] nArray = new int[]{1000, 2000, 3000, 32000, 32700};
        String[][] stringArray2 = this.getRowsWithOnlyOneColumn(stringArray, nArray);
        this.insertMultipleRows(BIG_TABLE_NAME, stringArray2);
        this.validTable(stringArray2, BIG_TABLE_NAME);
    }

    public void testVarchar() throws SQLException {
        String string = "create table big(vc varchar(32672))";
        this.createTable(string);
        String[] stringArray = new String[]{"a", "a", "a", "a", "a"};
        int[] nArray = new int[]{1000, 2000, 3000, 32000, 32672};
        String[][] stringArray2 = this.getRowsWithOnlyOneColumn(stringArray, nArray);
        this.insertMultipleRows(BIG_TABLE_NAME, stringArray2);
        this.validTable(stringArray2, BIG_TABLE_NAME);
    }
}

