/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import junit.framework.Test;
import org.apache.derby.iapi.types.HarmonySerialClob;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.DummyReader;
import org.apache.derbyTesting.functionTests.util.streams.CharAlphabet;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseJDBCTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ClobTest
extends BaseJDBCTestCase {
    private static final int TRANSFER_BUFFER_SIZE = 4096;
    private static final int SET_STRING = 1;
    private static final int SET_ASCII_STREAM = 2;
    private static final int SET_CHARACTER_STREAM = 4;
    private static int nextUniqueId = 150000;
    private static final String NORWEGIAN_LETTERS = "\u00e6\u00f8\u00e5\u00e6\u00f8\u00e5\u00e6\u00f8\u00e5\u00e6\u00f8\u00e5\u00e6\u00f8\u00e5\u00e6\u00f8\u00e5";
    private Clob clob = null;

    public ClobTest(String string) {
        super(string);
    }

    public void testGetSubString_PosOneTooBig() throws SQLException {
        long l = this.clob.length();
        ClobTest.assertEquals((String)"", (String)this.clob.getSubString(l + 1L, 10));
    }

    public void testGetSubString_PosTooBig() {
        try {
            this.clob.getSubString(999L, 10);
            ClobTest.fail((String)"getSubString with pos larger than clob length must fail");
        }
        catch (SQLException sQLException) {
            ClobTest.assertSQLState("XJ076", sQLException);
        }
    }

    public void testGetSubString_PosNegative() throws SQLException {
        try {
            this.clob.getSubString(-123L, 10);
            ClobTest.fail((String)"getSubString with negative position should fail");
        }
        catch (SQLException sQLException) {
            ClobTest.assertSQLState("XJ070", sQLException);
        }
    }

    public void testGetSubString_RequestZeroLength_PosValid() throws SQLException {
        ClobTest.assertEquals((String)"", (String)this.clob.getSubString(1L, 0));
    }

    public void testGetSubString_RequestZeroLength_PosTooBig() throws SQLException {
        try {
            this.clob.getSubString(999L, 0);
        }
        catch (SQLException sQLException) {
            ClobTest.assertSQLState("XJ076", sQLException);
        }
    }

    public void testGetSubString_BiggerThanInternalBuffer() throws IOException, SQLException {
        int n = 0x100000;
        this.transferData(new LoopingAlphabetReader(n), this.clob.setCharacterStream(1L), 4096);
        String string = this.clob.getSubString(1L, n);
        ClobTest.assertEquals((String)"Incorrect string length", (int)n, (int)string.length());
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        this.transferData(new LoopingAlphabetReader(n), charArrayWriter, 4096);
        ClobTest.assertEquals((String)"String do not match", (String)charArrayWriter.toString(), (String)string);
    }

    public void testLengthOnEmptyClob() throws SQLException {
        ClobTest.assertEquals((long)0L, (long)this.clob.length());
    }

    public void testInsertStringOnEmptyClob_Singlebyte() throws SQLException {
        String string = "This is the new Clob content.";
        this.clob.setString(1L, string);
        ClobTest.assertEquals((String)"Incorrect length reported", (long)string.length(), (long)this.clob.length());
        ClobTest.assertEquals((String)"Clob content is incorrect", (String)string, (String)this.clob.getSubString(1L, string.length()));
    }

    public void testInsertStringOnEmptyClob_Multibyte() throws SQLException {
        String string = "A few Norwegian letters: \u00e6, \u00e5, \u00f8.";
        this.clob.setString(1L, string);
        ClobTest.assertEquals((String)"Incorrect length reported", (long)string.length(), (long)this.clob.length());
        ClobTest.assertEquals((String)"Clob content is incorrect", (String)string, (String)this.clob.getSubString(1L, string.length()));
    }

    public void testInsertStringInMiddle_Multibyte() throws SQLException {
        this.clob.setString(1L, NORWEGIAN_LETTERS);
        ClobTest.assertEquals((String)NORWEGIAN_LETTERS, (String)this.clob.getSubString(1L, NORWEGIAN_LETTERS.length()));
        char[] cArray = NORWEGIAN_LETTERS.toCharArray();
        cArray[4] = 97;
        cArray[5] = 98;
        cArray[8] = 99;
        String string = String.copyValueOf(cArray);
        ClobTest.assertEquals((int)1, (int)this.clob.setString(9L, "c"));
        ClobTest.assertEquals((int)1, (int)this.clob.setString(5L, "a"));
        ClobTest.assertEquals((int)1, (int)this.clob.setString(6L, "b"));
        ClobTest.assertEquals((String)"Clob content is incorrect", (String)string, (String)this.clob.getSubString(1L, string.length()));
    }

    public void testLengthAfterInsertOnEmpty() throws IOException, SQLException {
        this.insertDataWithToken("", 0L, 0L, 1);
        ClobTest.assertEquals((long)0L, (long)this.clob.length());
        this.clob.setString(1L, "TEST");
        ClobTest.assertEquals((long)4L, (long)this.clob.length());
        this.clob.setString(1L, "TEST");
        ClobTest.assertEquals((long)4L, (long)this.clob.length());
        this.clob.setString(5L, "TEST");
        ClobTest.assertEquals((long)8L, (long)this.clob.length());
        this.clob.setString(7L, "TEST");
        ClobTest.assertEquals((long)10L, (long)this.clob.length());
        this.clob.truncate(4L);
        ClobTest.assertEquals((long)4L, (long)this.clob.length());
        this.clob.setString(4L, "TEST");
        ClobTest.assertEquals((long)7L, (long)this.clob.length());
    }

    public void testLengthAfterInsertOnLarge() throws IOException, SQLException {
        long l = 41984 + "SWEETSPOT".length();
        this.insertDataWithToken("SWEETSPOT", 32768L, 9216L, 4);
        ClobTest.assertEquals((long)l, (long)this.clob.length());
        this.clob.setString(1L, "TEST");
        ClobTest.assertEquals((long)l, (long)this.clob.length());
        this.clob.setString(l, "X");
        ClobTest.assertEquals((long)l, (long)this.clob.length());
        ClobTest.assertEquals((long)32769L, (long)this.clob.position("SWEETSPOT", 17408L));
        this.clob.setString(32769L, "FUNNYSPOT");
        ClobTest.assertEquals((long)l, (long)this.clob.length());
        ClobTest.assertEquals((long)-1L, (long)this.clob.position("SWEETSPOT", 17408L));
        this.clob.setString(l + 1L, "TEST");
        ClobTest.assertEquals((long)(l += 4L), (long)this.clob.length());
    }

    public void testReplaceMultibyteWithSingleByteForwards() throws IOException, SQLException {
        this.clob.setString(1L, NORWEGIAN_LETTERS);
        ClobTest.assertEquals((String)NORWEGIAN_LETTERS, (String)this.clob.getSubString(1L, NORWEGIAN_LETTERS.length()));
        char[] cArray = NORWEGIAN_LETTERS.toCharArray();
        String string = "abcdefghijklmnopqr";
        for (int i = 0; i < string.length(); ++i) {
            cArray[i] = string.charAt(i);
            ClobTest.assertEquals((int)1, (int)this.clob.setString(i + 1, string.substring(i, i + 1)));
            ClobTest.assertEquals((String)String.copyValueOf(cArray), (String)this.clob.getSubString(1L, 100));
            ClobTest.assertEquals(new StringReader(String.copyValueOf(cArray)), this.clob.getCharacterStream());
        }
    }

    public void testReplaceMultibyteWithSingleByteBackwards() throws IOException, SQLException {
        this.clob.setString(1L, NORWEGIAN_LETTERS);
        ClobTest.assertEquals((String)NORWEGIAN_LETTERS, (String)this.clob.getSubString(1L, NORWEGIAN_LETTERS.length()));
        char[] cArray = NORWEGIAN_LETTERS.toCharArray();
        String string = "abcdefghijklmnopqr";
        for (int i = string.length() - 1; i >= 0; --i) {
            cArray[i] = string.charAt(i);
            ClobTest.assertEquals((int)1, (int)this.clob.setString(i + 1, string.substring(i, i + 1)));
            ClobTest.assertEquals((String)String.copyValueOf(cArray), (String)this.clob.getSubString(1L, 100));
            ClobTest.assertEquals(new StringReader(String.copyValueOf(cArray)), this.clob.getCharacterStream());
        }
    }

    public void testInsertCharacter_ReadOnlyToTemporary() throws IOException, SQLException {
        long l;
        this.setAutoCommit(false);
        PreparedStatement preparedStatement = this.prepareStatement("insert into ClobTestData values (?,?)");
        int n = 131072;
        preparedStatement.setInt(1, 2);
        preparedStatement.setCharacterStream(2, (Reader)new LoopingAlphabetReader(n), n);
        preparedStatement.executeUpdate();
        PreparedStatement preparedStatement2 = this.prepareStatement("select dClob from ClobTestData where id = ?");
        preparedStatement2.setInt(1, 2);
        ResultSet resultSet = preparedStatement2.executeQuery();
        resultSet.next();
        Clob clob = resultSet.getClob(1);
        clob.setString(1L, "K");
        Reader reader = clob.getCharacterStream();
        ClobTest.assertEquals((int)75, (int)reader.read());
        long l2 = 1L;
        while ((l = reader.skip(4096L)) > 0L) {
            l2 += l;
        }
        resultSet.close();
        ClobTest.assertEquals((String)"Wrong length!", (long)n, (long)l2);
        preparedStatement.setInt(1, 10003);
        preparedStatement.setClob(2, clob);
        preparedStatement.executeUpdate();
        preparedStatement2.setInt(1, 10003);
        resultSet = preparedStatement2.executeQuery();
        resultSet.next();
        Clob clob2 = resultSet.getClob(1);
        ClobTest.assertEquals(clob.getCharacterStream(), clob2.getCharacterStream());
        ClobTest.assertEquals((long)n, (long)clob2.length());
    }

    public void testPositionWithString_ASCII_SimplePartialRecurringPattern() throws IOException, SQLException {
        String string = "xxSPOTxx";
        String string2 = "abcdexxSPxabcdexabxxSPxxxSPOTxabcxxSPOTxxabc";
        this.clob.setString(1L, string2);
        ClobTest.assertEquals((String)"Invalid match position", (long)(string2.indexOf(string, 0) + 1), (long)this.clob.position(string, 1L));
    }

    public void testPositionWithString_USASCII() throws IOException, SQLException {
        String string = "xxSPOTxx";
        this.insertDataWithToken(string, 93191L, 12288L, 2);
        this.executeTestPositionWithStringToken(string, 93191L);
    }

    public void testPositionWithString_IOS88591() throws IOException, SQLException {
        String string = "xx\u00c6\u00c6\u00c6xx";
        this.insertDataWithToken(string, 68608L, 1022L, 2);
        this.executeTestPositionWithStringToken(string, 68608L);
    }

    public void testPositionWithString_CJK() throws IOException, SQLException {
        char[] cArray = new char[1];
        LoopingAlphabetReader loopingAlphabetReader = new LoopingAlphabetReader(1L, CharAlphabet.cjkSubset());
        loopingAlphabetReader.read(cArray);
        String string = String.copyValueOf(cArray);
        this.insertDataWithToken(string, 11L, 90L, 4);
        this.executeTestPositionWithStringToken(string, 11L);
    }

    public void testSetStringOnWrongOffset() throws SQLException {
        this.clob.setString(1L, "TEST");
        long l = this.clob.length() + 1L;
        String string = "AGAIN";
        try {
            this.clob.setString(l, string, -1, 2);
            ClobTest.fail((String)"setString() refuses negative offset!");
        }
        catch (SQLException sQLException) {
            ClobTest.assertSQLState("XJ078", sQLException);
        }
        try {
            this.clob.setString(l, string, string.length() + 1, 1);
            ClobTest.fail((String)"setString() refuses offset greater than str.length()!");
        }
        catch (SQLException sQLException) {
            ClobTest.assertSQLState("XJ078", sQLException);
        }
        this.clob.setString(l, string, string.length() - 1, 1);
        try {
            this.clob.setString(l, string, string.length(), 0);
            ClobTest.fail((String)"offset should be smaller than the length of str");
        }
        catch (SQLException sQLException) {
            ClobTest.assertSQLState("XJ078", sQLException);
        }
        try {
            this.clob.setString(l, string, string.length() - 1, 2);
            ClobTest.fail((String)"setString() refuses offset + len > str.length()!");
        }
        catch (SQLException sQLException) {
            ClobTest.assertSQLState("22011", sQLException);
        }
    }

    public void testSetStringWithWrongLen() throws SQLException {
        this.clob.setString(1L, "TEST");
        long l = this.clob.length() + 1L;
        String string = "AGAIN";
        try {
            this.clob.setString(l, string, 0, -1);
            ClobTest.fail((String)"setString() refuses negative len!");
        }
        catch (SQLException sQLException) {
            ClobTest.assertSQLState("XJ071", sQLException);
        }
        try {
            this.clob.setString(l, string, 0, string.length() + 1);
            ClobTest.fail((String)"setString() refuses wrong len out of range!");
        }
        catch (SQLException sQLException) {
            ClobTest.assertSQLState("22011", sQLException);
        }
    }

    public void testSetStringWithBigPos() throws SQLException {
        this.clob.setString(1L, "TEST");
        long l = this.clob.length() + 1L;
        try {
            this.clob.setString(l + 1L, "AGAIN", 0, 2);
            ClobTest.fail((String)"pos is out of range!");
        }
        catch (SQLException sQLException) {
            ClobTest.assertSQLState("XJ076", sQLException);
        }
    }

    public void testSetStringWithNull() throws SQLException {
        this.clob.setString(1L, "TEST");
        long l = this.clob.length() + 1L;
        try {
            this.clob.setString(l, null, 0, 2);
            ClobTest.fail((String)"can not accepted null String!");
        }
        catch (SQLException sQLException) {
            ClobTest.assertSQLState("XJ072", sQLException);
        }
    }

    public void testSetStringWithEmptyString() throws SQLException {
        this.clob.setString(1L, "TEST");
        long l = this.clob.length() + 1L;
        ClobTest.assertEquals((int)0, (int)this.clob.setString(l, "", 0, 0));
    }

    public void testTruncateZeroOnDisk() throws IOException, SQLException {
        long l = 33799L;
        this.insertDataWithToken("", l, 0L, 4);
        this.truncateToZero(l);
    }

    public void testTruncateZeroInMemory() throws IOException, SQLException {
        long l = 33L;
        this.insertDataWithToken("", l, 0L, 1);
        this.truncateToZero(l);
    }

    private void truncateToZero(long l) throws IOException, SQLException {
        ClobTest.assertEquals((long)l, (long)this.clob.length());
        this.clob.truncate(0L);
        ClobTest.assertEquals((long)0L, (long)this.clob.length());
        ClobTest.assertEquals((String)"", (String)this.clob.getSubString(1L, 0));
        ClobTest.assertEquals((String)"", (String)this.clob.getSubString(1L, 1));
        ClobTest.assertEquals((int)-1, (int)this.clob.getCharacterStream().read());
    }

    public void testTruncateExactOnDisk() throws IOException, SQLException {
        long l = 33799L;
        this.insertDataWithToken("", l, 0L, 4);
        ClobTest.assertEquals((long)l, (long)this.clob.length());
        this.clob.truncate(l);
        ClobTest.assertEquals((long)l, (long)this.clob.length());
    }

    public void testTruncateExactInMemory() throws IOException, SQLException {
        long l = 33L;
        this.insertDataWithToken("", l, 0L, 1);
        ClobTest.assertEquals((long)l, (long)this.clob.length());
        this.clob.truncate(l);
        ClobTest.assertEquals((long)l, (long)this.clob.length());
    }

    public void testTruncateTooLongOnDisk() throws IOException, SQLException {
        long l = 45064L;
        this.insertDataWithToken("", l, 0L, 4);
        try {
            this.clob.truncate(l * 2L);
            ClobTest.fail((String)"Truncate should have failed, position too large");
        }
        catch (SQLException sQLException) {
            ClobTest.assertSQLState("XJ079", sQLException);
        }
    }

    public void testTruncateTooLongInMemory() throws IOException, SQLException {
        long l = 44L;
        this.insertDataWithToken("", l, 0L, 1);
        try {
            this.clob.truncate(l * 2L);
            ClobTest.fail((String)"Truncate should have failed, position too large");
        }
        catch (SQLException sQLException) {
            ClobTest.assertSQLState("XJ079", sQLException);
        }
    }

    public void testGetLengthAfterTruncate() throws IOException, SQLException {
        this.insertDataWithToken("", 89086L, 0L, 2);
        ClobTest.assertEquals((long)89086L, (long)this.clob.length());
        this.clob.truncate(87049L);
        ClobTest.assertEquals((long)87049L, (long)this.clob.length());
        this.clob.truncate(2065L);
        ClobTest.assertEquals((long)2065L, (long)this.clob.length());
        this.clob.truncate(2065L);
        ClobTest.assertEquals((long)2065L, (long)this.clob.length());
    }

    public void testCloningThroughAddBatchWithStream() throws SQLException {
        this.testCloningThroughAddBatch(true, true);
        this.testCloningThroughAddBatch(true, false);
    }

    public void testCloningThroughAddBatchWithString() throws SQLException {
        this.testCloningThroughAddBatch(false, true);
        this.testCloningThroughAddBatch(false, false);
    }

    private void testCloningThroughAddBatch(boolean bl, boolean bl2) throws SQLException {
        boolean bl3 = this.getConnection().getAutoCommit();
        this.setAutoCommit(bl2);
        int[] nArray = new int[100];
        Arrays.fill(nArray, 1);
        PreparedStatement preparedStatement = this.prepareStatement("insert into ClobTestData values (?,?)");
        int n = nextUniqueId;
        for (int i = 0; i < 100; ++i) {
            preparedStatement.setInt(1, nextUniqueId++);
            String string = "Clob-" + i;
            if (bl) {
                preparedStatement.setCharacterStream(2, (Reader)new StringReader(string), string.length());
            } else {
                preparedStatement.setString(2, "Clob-" + i);
            }
            preparedStatement.addBatch();
        }
        ClobTest.assertTrue((boolean)Arrays.equals(nArray, preparedStatement.executeBatch()));
        this.commit();
        PreparedStatement preparedStatement2 = this.prepareStatement("delete from ClobTestData where id = ?");
        for (int i = 0; i < 100; ++i) {
            preparedStatement2.setInt(1, n + i);
            preparedStatement2.addBatch();
        }
        ClobTest.assertTrue((boolean)Arrays.equals(nArray, preparedStatement2.executeBatch()));
        this.commit();
        this.setAutoCommit(bl3);
    }

    public void test_4544() throws Exception {
        int n = 100;
        this.prepareStatement("create table t_4544_0 ( myclob clob )").execute();
        this.insertClob(n, "t_4544_0");
        this.prepareStatement("create function replace_4544( inclob clob, target varchar( 32672 ), replacement varchar( 32672 ) )\nreturns clob\nlanguage java parameter style java no sql deterministic\nexternal name '" + ((Object)((Object)this)).getClass().getName() + ".replace'").execute();
        this.vetTable(n, "generated always as (length(myclob))", Integer.toString(n));
        this.vetTable(n, "varchar( 3 ) generated always as ( substr(myclob, 1, 3) )", " ab");
        this.vetTable(n, "generated always as (locate( 'def', myclob ))", "5");
        this.vetTable(n, "clob generated always as (upper( myclob ))", new DummyReader(n).toString().toUpperCase());
        this.vetTable(n, "clob generated always as (trim( myclob ))", new DummyReader(n).toString().trim());
        this.vetTable(n, "clob generated always as (replace_4544( myclob, 'b', 'B' ))", new DummyReader(n).toString().replace('b', 'B'));
        this.dropTable("t_4544_0");
        this.prepareStatement("drop function replace_4544").execute();
    }

    private void vetTable(int n, String string, String string2) throws Exception {
        String string3 = "t_4544_1";
        this.prepareStatement("create table " + string3 + "( myclob clob, gencol " + string + " )").execute();
        this.insertClob(n, string3);
        this.vetTable(string3, string2);
        this.vetClob(n, string3);
        this.prepareStatement("delete from " + string3).executeUpdate();
        this.prepareStatement("insert into " + string3 + "( myclob ) select myclob from t_4544_0").executeUpdate();
        this.vetTable(string3, string2);
        this.vetClob(n, string3);
        this.dropTable(string3);
    }

    private void vetTable(String string, String string2) throws Exception {
        ResultSet resultSet = this.prepareStatement("select gencol from " + string).executeQuery();
        resultSet.next();
        ClobTest.assertEquals((String)string2, (String)resultSet.getString(1));
        resultSet.close();
    }

    private void insertClob(int n, String string) throws Exception {
        PreparedStatement preparedStatement = this.prepareStatement("insert into " + string + "( myclob ) values ( ? )");
        preparedStatement.setCharacterStream(1, (Reader)new DummyReader(n), n);
        preparedStatement.executeUpdate();
    }

    private void vetClob(int n, String string) throws Exception {
        PreparedStatement preparedStatement = this.prepareStatement("select myclob from " + string);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        Reader reader = resultSet.getCharacterStream(1);
        DummyReader dummyReader = new DummyReader(n);
        for (int i = 0; i < n; ++i) {
            int n2 = reader.read();
            if (n2 < 0) {
                ClobTest.fail((String)("    Read stream was only " + i + " characters long."));
            }
            int n3 = dummyReader.read();
            ClobTest.assertEquals((int)n3, (int)n2);
        }
        ClobTest.assertTrue((reader.read() < 0 ? 1 : 0) != 0);
        resultSet.close();
    }

    public static Clob replace(Clob clob, String string, String string2) throws Exception {
        char c = string.charAt(0);
        char c2 = string2.charAt(0);
        String string3 = clob.getSubString(1L, (int)clob.length());
        String string4 = string3.replace(c, c2);
        return new HarmonySerialClob(string4);
    }

    private void executeTestPositionWithStringToken(String string, long l) throws IOException, SQLException {
        long l2 = l + 1L;
        ClobTest.assertEquals((long)-1L, (long)this.clob.position(string, l2 + 1L));
        ClobTest.assertEquals((long)l2, (long)this.clob.position(string, l2));
        ClobTest.assertEquals((long)l2, (long)this.clob.position(string, 1L));
    }

    protected void setUp() throws Exception {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select dClob from ClobTestData where id = 1");
        ClobTest.assertTrue((boolean)resultSet.next());
        this.clob = resultSet.getClob(1);
    }

    @Override
    protected void tearDown() throws Exception {
        this.clob = null;
        super.tearDown();
    }

    public static Test suite() {
        return new ClobTestSetup(TestConfiguration.defaultSuite(ClobTest.class, false));
    }

    private int transferData(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        int n2;
        if (n < 1) {
            throw new IllegalArgumentException("Buffer size must be 1 or greater: " + n);
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream, n);
        byte[] byArray = new byte[n];
        int n3 = 0;
        while ((n2 = bufferedInputStream.read(byArray, 0, n)) != -1) {
            bufferedOutputStream.write(byArray, 0, n2);
            n3 += n2;
        }
        bufferedInputStream.close();
        bufferedOutputStream.flush();
        return n3;
    }

    private int transferData(Reader reader, Writer writer, int n) throws IOException {
        int n2;
        if (n < 1) {
            throw new IllegalArgumentException("Buffer size must be 1 or greater: " + n);
        }
        BufferedReader bufferedReader = new BufferedReader(reader);
        BufferedWriter bufferedWriter = new BufferedWriter(writer, n);
        char[] cArray = new char[n];
        int n3 = 0;
        while ((n2 = bufferedReader.read(cArray, 0, n)) != -1) {
            bufferedWriter.write(cArray, 0, n2);
            n3 += n2;
        }
        bufferedReader.close();
        bufferedWriter.flush();
        return n3;
    }

    private int transferData(Reader reader, int n) throws IOException, SQLException {
        int n2;
        if (n < 1) {
            throw new IllegalArgumentException("Buffer size must be 1 or greater: " + n);
        }
        BufferedReader bufferedReader = new BufferedReader(reader);
        char[] cArray = new char[n];
        int n3 = 0;
        while ((n2 = bufferedReader.read(cArray, 0, n)) != -1) {
            this.clob.setString((long)n3 + 1L, String.copyValueOf(cArray, 0, n2));
            n3 += n2;
        }
        bufferedReader.close();
        return n3;
    }

    private void insertDataWithToken(String string, long l, long l2, int n) throws IOException, SQLException {
        long l3 = 0L;
        switch (n) {
            case 1: {
                LoopingAlphabetReader loopingAlphabetReader = new LoopingAlphabetReader(l);
                l3 += (long)this.transferData(loopingAlphabetReader, 4096);
                this.clob.setString(l + 1L, string);
                l3 += (long)string.length();
                loopingAlphabetReader = new LoopingAlphabetReader(l2);
                l3 += (long)this.transferData(loopingAlphabetReader, 4096);
                break;
            }
            case 2: {
                OutputStream outputStream = this.clob.setAsciiStream(1L);
                LoopingAlphabetStream loopingAlphabetStream = new LoopingAlphabetStream(l);
                l3 += (long)this.transferData(loopingAlphabetStream, outputStream, 4096);
                byte[] byArray = string.getBytes("ISO-8859-1");
                outputStream.write(byArray, 0, byArray.length);
                l3 += (long)byArray.length;
                loopingAlphabetStream = new LoopingAlphabetStream(l2);
                l3 += (long)this.transferData(loopingAlphabetStream, outputStream, 4096);
                break;
            }
            case 4: {
                Writer writer = this.clob.setCharacterStream(1L);
                LoopingAlphabetReader loopingAlphabetReader = new LoopingAlphabetReader(l);
                l3 += (long)this.transferData(loopingAlphabetReader, writer, 4096);
                writer.write(string);
                l3 += (long)string.length();
                loopingAlphabetReader = new LoopingAlphabetReader(l2);
                l3 += (long)this.transferData(loopingAlphabetReader, writer, 4096);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown insertion mode: " + n);
            }
        }
        ClobTest.assertEquals((String)"Invalid length after insertion", (long)(l + l2 + (long)string.length()), (long)this.clob.length());
    }

    private static class ClobTestSetup
    extends BaseJDBCTestSetup {
        ClobTestSetup(Test test) {
            super(test);
        }

        protected void setUp() throws SQLException {
            Connection connection = this.getConnection();
            Statement statement = connection.createStatement();
            statement.execute("create table ClobTestData (id int unique, dClob CLOB)");
            statement.executeUpdate("insert into ClobTestData values (1, '')");
            statement.close();
        }

        @Override
        protected void tearDown() throws Exception {
            Connection connection = this.getConnection();
            Statement statement = connection.createStatement();
            statement.execute("drop table ClobTestData");
            statement.close();
            super.tearDown();
        }
    }
}

