/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.compatibility;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.DerbyVersion;
import org.apache.derbyTesting.junit.Version;

abstract class AbstractCompatibilityTest
extends BaseJDBCTestCase {
    public static final String SERVER_VERSION_FUNCTION = "getVMVersion";
    private static final String VERSION_PROPERTY = "java.version";
    private static Version _clientVMLevel;
    private static Version _serverVMLevel;
    private static DerbyVersion _driverLevel;
    private static final int JDBC_BOOLEAN = 16;
    private static final String FUNCTION = "function";
    private static final String PROCEDURE = "procedure";
    private static final String TYPE = "type";

    public AbstractCompatibilityTest(String string) {
        super(string);
    }

    public DerbyVersion getServerVersion() throws SQLException {
        return AbstractCompatibilityTest.getServerVersion(this.getConnection());
    }

    protected static DerbyVersion getServerVersion(Connection connection) throws SQLException {
        return DerbyVersion.parseVersionString(connection.getMetaData().getDatabaseProductVersion());
    }

    public DerbyVersion getDriverVersion() throws SQLException {
        if (_driverLevel == null) {
            _driverLevel = DerbyVersion.parseVersionString(this.getConnection().getMetaData().getDriverVersion());
        }
        return _driverLevel;
    }

    public static Version getServerVMVersion() {
        return _serverVMLevel;
    }

    public Version getClientVMVersion() {
        return _clientVMLevel;
    }

    public boolean serverSupportsUDTs() throws SQLException {
        return AbstractCompatibilityTest.serverSupportsUDTs(this.getConnection());
    }

    public static boolean serverSupportsUDTs(Connection connection) throws SQLException {
        return AbstractCompatibilityTest.getServerVersion(connection).atLeast(DerbyVersion._10_6);
    }

    public static String getVMVersion() {
        return System.getProperty(VERSION_PROPERTY);
    }

    public void compareObjects(String object, Object object2, Object object3) throws SQLException {
        object = (String)object + "\n\t expected = " + String.valueOf(object2) + "\n\t actual = " + String.valueOf(object3);
        if (object2 == null) {
            AbstractCompatibilityTest.assertNull((String)object, (Object)object3);
        } else {
            AbstractCompatibilityTest.assertNotNull((String)object, (Object)object3);
            if (object2 instanceof byte[]) {
                this.compareBytes((String)object, object2, object3);
            } else if (object2 instanceof Date) {
                this.compareDates((String)object, object2, object3);
            } else {
                AbstractCompatibilityTest.assertTrue((String)object, (boolean)object2.equals(object3));
            }
        }
    }

    public void compareBytes(String string, Object object, Object object2) {
        if (object == null) {
            AbstractCompatibilityTest.assertNull((String)string, (Object)object2);
        } else {
            AbstractCompatibilityTest.assertNotNull((Object)object2);
        }
        if (!(object instanceof byte[])) {
            AbstractCompatibilityTest.fail((String)string);
        }
        if (!(object2 instanceof byte[])) {
            AbstractCompatibilityTest.fail((String)string);
        }
        byte[] byArray = (byte[])object;
        byte[] byArray2 = (byte[])object2;
        int n = byArray.length;
        AbstractCompatibilityTest.assertEquals((String)string, (int)n, (int)byArray2.length);
        for (int i = 0; i < n; ++i) {
            AbstractCompatibilityTest.assertEquals((String)(string + "[ " + i + " ]"), (byte)byArray[i], (byte)byArray2[i]);
        }
    }

    public void compareDates(String string, Object object, Object object2) {
        if (object == null) {
            AbstractCompatibilityTest.assertNull((String)string, (Object)object2);
        } else {
            AbstractCompatibilityTest.assertNotNull((Object)object2);
        }
        if (!(object instanceof Date)) {
            AbstractCompatibilityTest.fail((String)string);
        }
        if (!(object2 instanceof Date)) {
            AbstractCompatibilityTest.fail((String)string);
        }
        AbstractCompatibilityTest.assertEquals((String)string, (String)object.toString(), (String)object2.toString());
    }

    protected Object getColumn(ResultSet resultSet, String string, int n) throws SQLException {
        Object object = null;
        switch (n) {
            case 16: {
                object = resultSet.getBoolean(string);
                break;
            }
            case -5: {
                object = resultSet.getLong(string);
                break;
            }
            case 2004: {
                object = resultSet.getBlob(string);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                object = resultSet.getString(string);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                object = resultSet.getBytes(string);
                break;
            }
            case 2005: {
                object = resultSet.getClob(string);
                break;
            }
            case 91: {
                object = resultSet.getDate(string);
                break;
            }
            case 2: 
            case 3: {
                object = resultSet.getBigDecimal(string);
                break;
            }
            case 8: {
                object = resultSet.getDouble(string);
                break;
            }
            case 7: {
                object = Float.valueOf(resultSet.getFloat(string));
                break;
            }
            case 4: {
                object = resultSet.getInt(string);
                break;
            }
            case 5: {
                object = resultSet.getShort(string);
                break;
            }
            case 92: {
                object = resultSet.getTime(string);
                break;
            }
            case 93: {
                object = resultSet.getTimestamp(string);
                break;
            }
            default: {
                AbstractCompatibilityTest.fail((String)("Unknown jdbc type " + n + " used to retrieve column: " + string));
            }
        }
        if (resultSet.wasNull()) {
            object = null;
        }
        return object;
    }

    protected void setParameter(PreparedStatement preparedStatement, int n, int n2, Object object) throws SQLException {
        if (object == null) {
            preparedStatement.setNull(n, n2);
            return;
        }
        switch (n2) {
            case 16: {
                preparedStatement.setBoolean(n, (Boolean)object);
                break;
            }
            case -5: {
                preparedStatement.setLong(n, (Long)object);
                break;
            }
            case 2004: {
                preparedStatement.setBlob(n, (Blob)object);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                preparedStatement.setString(n, (String)object);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                preparedStatement.setBytes(n, (byte[])object);
                break;
            }
            case 2005: {
                preparedStatement.setClob(n, (Clob)object);
                break;
            }
            case 91: {
                preparedStatement.setDate(n, (java.sql.Date)object);
                break;
            }
            case 2: 
            case 3: {
                preparedStatement.setBigDecimal(n, (BigDecimal)object);
                break;
            }
            case 8: {
                preparedStatement.setDouble(n, (Double)object);
                break;
            }
            case 7: {
                preparedStatement.setFloat(n, ((Float)object).floatValue());
                break;
            }
            case 4: {
                preparedStatement.setInt(n, (Integer)object);
                break;
            }
            case 5: {
                preparedStatement.setShort(n, (Short)object);
                break;
            }
            case 92: {
                preparedStatement.setTime(n, (Time)object);
                break;
            }
            case 93: {
                preparedStatement.setTimestamp(n, (Timestamp)object);
                break;
            }
            default: {
                AbstractCompatibilityTest.fail((String)("Unknown jdbc type: " + n2));
            }
        }
    }

    protected void dropFunction(String string) {
        this.dropSchemaObject(FUNCTION, string, false);
    }

    protected void dropProcedure(String string) {
        this.dropSchemaObject(PROCEDURE, string, false);
    }

    protected void dropUDT(String string) {
        this.dropSchemaObject(TYPE, string, true);
    }

    protected void dropSchemaObject(String string, String string2, boolean bl) {
        try {
            String string3 = "drop " + string + " " + string2;
            if (bl) {
                string3 = string3 + " restrict";
            }
            PreparedStatement preparedStatement = this.prepareStatement(string3);
            preparedStatement.execute();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

