/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.junit;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.Test;
import org.apache.derby.iapi.services.io.InputStreamUtil;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;

public class InputStreamUtilTest
extends BaseTestCase {
    public InputStreamUtilTest(String string) {
        super(string);
    }

    public void testNullStream() throws IOException {
        try {
            InputStreamUtil.skipUntilEOF(null);
            InputStreamUtilTest.fail((String)"Null InputStream is accepted!");
        }
        catch (NullPointerException nullPointerException) {
            InputStreamUtilTest.assertTrue((boolean)true);
        }
        try {
            InputStreamUtil.skipFully(null, (long)0L);
            InputStreamUtilTest.fail((String)"Null InputStream is accepted!");
        }
        catch (NullPointerException nullPointerException) {
            InputStreamUtilTest.assertTrue((boolean)true);
        }
    }

    public void testSkipUtilEOFWithOddLength() throws IOException {
        int[] nArray = new int[]{0, 1};
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[n]);
            InputStreamUtilTest.assertEquals((long)n, (long)InputStreamUtil.skipUntilEOF((InputStream)byteArrayInputStream));
        }
    }

    public void testSkipUtilEOF() throws IOException {
        int[] nArray = new int[]{1024, 0x100000};
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[n]);
            InputStreamUtilTest.assertEquals((long)n, (long)InputStreamUtil.skipUntilEOF((InputStream)byteArrayInputStream));
        }
    }

    public void testSkipFully() throws IOException {
        int n = 1024;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[n]);
        InputStreamUtil.skipFully((InputStream)byteArrayInputStream, (long)n);
        InputStreamUtilTest.assertEquals((long)0L, (long)InputStreamUtil.skipUntilEOF((InputStream)byteArrayInputStream));
        byteArrayInputStream = new ByteArrayInputStream(new byte[n]);
        InputStreamUtil.skipFully((InputStream)byteArrayInputStream, (long)(n - 1));
        InputStreamUtilTest.assertEquals((long)1L, (long)InputStreamUtil.skipUntilEOF((InputStream)byteArrayInputStream));
        byteArrayInputStream = new ByteArrayInputStream(new byte[n]);
        try {
            InputStreamUtil.skipFully((InputStream)byteArrayInputStream, (long)(n + 1));
            InputStreamUtilTest.fail((String)"Should have Meet EOF!");
        }
        catch (EOFException eOFException) {
            InputStreamUtilTest.assertTrue((boolean)true);
        }
        InputStreamUtilTest.assertEquals((long)0L, (long)InputStreamUtil.skipUntilEOF((InputStream)byteArrayInputStream));
    }

    public static Test suite() {
        return new BaseTestSuite(InputStreamUtilTest.class, "InputStreamUtil tests");
    }
}

