/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.junit;

import java.io.IOException;
import java.util.Arrays;
import junit.framework.Test;
import org.apache.derby.impl.io.vfmem.BlockedByteArray;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;

public class BlockedByteArrayTest
extends BaseTestCase {
    public BlockedByteArrayTest(String string) {
        super(string);
    }

    public void testLengthNoInitialBlocksWriteSingleByte() {
        BlockedByteArray blockedByteArray = new BlockedByteArray();
        BlockedByteArrayTest.assertEquals((long)0L, (long)blockedByteArray.length());
        blockedByteArray.writeByte(0L, (byte)1);
        BlockedByteArrayTest.assertEquals((long)1L, (long)blockedByteArray.length());
        for (int i = 0; i < 67584; ++i) {
            blockedByteArray.writeByte((long)(1 + i), (byte)i);
            BlockedByteArrayTest.assertEquals((long)(i + 2), (long)blockedByteArray.length());
        }
    }

    public void testLengthNoInitialBlocksWriteMultipleBytes4K() {
        BlockedByteArray blockedByteArray = new BlockedByteArray();
        byte[] byArray = new byte[4096];
        Arrays.fill(byArray, (byte)1);
        blockedByteArray.writeBytes(0L, byArray, 0, byArray.length);
        BlockedByteArrayTest.assertEquals((long)byArray.length, (long)blockedByteArray.length());
        Arrays.fill(byArray, (byte)2);
        blockedByteArray.writeBytes((long)byArray.length, byArray, 0, byArray.length);
        BlockedByteArrayTest.assertEquals((long)(2 * byArray.length), (long)blockedByteArray.length());
        blockedByteArray.writeByte(69L, (byte)8);
        BlockedByteArrayTest.assertEquals((long)(2 * byArray.length), (long)blockedByteArray.length());
    }

    public void testLengthNoInitialBlocksWriteMultipleBytes4KPlussAFew() {
        BlockedByteArray blockedByteArray = new BlockedByteArray();
        byte[] byArray = new byte[4133];
        Arrays.fill(byArray, (byte)1);
        blockedByteArray.writeBytes(0L, byArray, 0, byArray.length);
        BlockedByteArrayTest.assertEquals((long)byArray.length, (long)blockedByteArray.length());
        Arrays.fill(byArray, (byte)2);
        blockedByteArray.writeBytes((long)byArray.length, byArray, 0, byArray.length);
        BlockedByteArrayTest.assertEquals((long)(2 * byArray.length), (long)blockedByteArray.length());
        blockedByteArray.writeByte(54L, (byte)7);
        BlockedByteArrayTest.assertEquals((long)(2 * byArray.length), (long)blockedByteArray.length());
    }

    public void testReadArray() throws IOException {
        int n;
        int n2 = 66560;
        BlockedByteArray blockedByteArray = this.createBlockedByteArray(n2);
        byte[] byArray = new byte[4096];
        for (n = 0; n < n2; n += blockedByteArray.read((long)n, byArray, 0, byArray.length)) {
        }
        blockedByteArray = this.createBlockedByteArray(n2);
        byArray = new byte[2567];
        for (n = 0; n < n2; n += blockedByteArray.read((long)n, byArray, 0, byArray.length)) {
        }
        blockedByteArray = this.createBlockedByteArray(n2);
        byArray = new byte[16384];
        for (n = 0; n < n2; n += blockedByteArray.read((long)n, byArray, 0, byArray.length)) {
        }
    }

    public void testReadSingle() throws IOException {
        int n = 66560;
        BlockedByteArray blockedByteArray = this.createBlockedByteArray(n);
        int n2 = 0;
        while (blockedByteArray.read((long)n2) != -1) {
            ++n2;
        }
    }

    public void testLength() throws IOException {
        BlockedByteArray blockedByteArray = this.createBlockedByteArray(0L);
        BlockedByteArrayTest.assertEquals((long)0L, (long)blockedByteArray.length());
        blockedByteArray.writeByte(0L, (byte)1);
        BlockedByteArrayTest.assertEquals((long)1L, (long)blockedByteArray.length());
        blockedByteArray.writeByte(0L, (byte)1);
        BlockedByteArrayTest.assertEquals((long)1L, (long)blockedByteArray.length());
        blockedByteArray.writeByte(9L, (byte)2);
        BlockedByteArrayTest.assertEquals((long)10L, (long)blockedByteArray.length());
        byte[] byArray = new byte[4096];
        Arrays.fill(byArray, (byte)7);
        blockedByteArray.writeBytes(0L, byArray, 0, byArray.length);
        BlockedByteArrayTest.assertEquals((long)byArray.length, (long)blockedByteArray.length());
        blockedByteArray.writeBytes((long)byArray.length, byArray, 0, byArray.length);
        BlockedByteArrayTest.assertEquals((long)(2 * byArray.length), (long)blockedByteArray.length());
        blockedByteArray.setLength(55555L);
        BlockedByteArrayTest.assertEquals((long)55555L, (long)blockedByteArray.length());
        blockedByteArray.setLength(44444L);
        BlockedByteArrayTest.assertEquals((long)44444L, (long)blockedByteArray.length());
    }

    public void testCapacityGrowth() throws IOException {
        BlockedByteArray blockedByteArray = this.createBlockedByteArray(0L);
        blockedByteArray.setLength(0x100000L);
        blockedByteArray.setLength(0xA00000L);
        blockedByteArray.setLength(0x500000L);
        blockedByteArray.setLength(0x700000L);
        BlockedByteArrayTest.assertEquals((long)0x700000L, (long)blockedByteArray.length());
        blockedByteArray.setLength(0L);
        BlockedByteArrayTest.assertEquals((long)0L, (long)blockedByteArray.length());
        blockedByteArray.setLength(0x2700000L);
        blockedByteArray.setLength(40894465L);
        BlockedByteArrayTest.assertEquals((long)40894465L, (long)blockedByteArray.length());
        blockedByteArray.setLength(0x2700000L);
        BlockedByteArrayTest.assertEquals((long)0x2700000L, (long)blockedByteArray.length());
        blockedByteArray.setLength(0x2700000L);
        BlockedByteArrayTest.assertEquals((long)0x2700000L, (long)blockedByteArray.length());
        blockedByteArray.setLength(-1L);
        BlockedByteArrayTest.assertEquals((long)0L, (long)blockedByteArray.length());
    }

    public static Test suite() {
        return new BaseTestSuite(BlockedByteArrayTest.class);
    }

    private BlockedByteArray createBlockedByteArray(long l) throws IOException {
        int n;
        BlockedByteArray blockedByteArray = new BlockedByteArray();
        LoopingAlphabetStream loopingAlphabetStream = new LoopingAlphabetStream(l);
        byte[] byArray = new byte[4096];
        for (long i = 0L; i < l; i += (long)blockedByteArray.writeBytes(i, byArray, 0, n)) {
            n = loopingAlphabetStream.read(byArray);
        }
        return blockedByteArray;
    }
}

