/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.StatisticsImpl;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatisticsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.GroupFetchScanController;
import org.apache.derby.iapi.store.access.RowLocationRetRowSource;
import org.apache.derby.iapi.store.access.RowSource;
import org.apache.derby.iapi.store.access.SortController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.services.daemon.IndexStatisticsDaemonImpl;
import org.apache.derby.impl.sql.execute.BasicSortObserver;
import org.apache.derby.impl.sql.execute.CardinalityCounter;
import org.apache.derby.impl.sql.execute.IndexColumnOrder;
import org.apache.derby.impl.sql.execute.IndexConstantAction;
import org.apache.derby.impl.sql.execute.RowUtil;
import org.apache.derby.impl.sql.execute.UniqueIndexSortObserver;
import org.apache.derby.impl.sql.execute.UniqueWithDuplicateNullsIndexSortObserver;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class CreateIndexConstantAction
extends IndexConstantAction {
    private final boolean forCreateTable;
    private boolean unique;
    private boolean uniqueWithDuplicateNulls;
    private boolean uniqueDeferrable;
    private final boolean hasDeferrableChecking;
    private final boolean initiallyDeferred;
    private final int constraintType;
    private String indexType;
    private String[] columnNames;
    private boolean[] isAscending;
    private boolean isConstraint;
    private UUID conglomerateUUID;
    private Properties properties;
    private ExecRow indexTemplateRow;
    private long conglomId;
    private long droppedConglomNum;

    CreateIndexConstantAction(boolean forCreateTable, boolean unique, boolean uniqueWithDuplicateNulls, boolean hasDeferrableChecking, boolean initiallyDeferred, int constraintType, String indexType, String schemaName, String indexName, String tableName, UUID tableId, String[] columnNames, boolean[] isAscending, boolean isConstraint, UUID conglomerateUUID, Properties properties) {
        super(tableId, indexName, tableName, schemaName);
        this.forCreateTable = forCreateTable;
        this.unique = unique && !hasDeferrableChecking;
        this.uniqueWithDuplicateNulls = uniqueWithDuplicateNulls;
        this.hasDeferrableChecking = hasDeferrableChecking;
        this.initiallyDeferred = initiallyDeferred;
        this.constraintType = constraintType;
        this.uniqueDeferrable = unique && hasDeferrableChecking;
        this.indexType = indexType;
        this.columnNames = columnNames;
        this.isAscending = isAscending;
        this.isConstraint = isConstraint;
        this.conglomerateUUID = conglomerateUUID;
        this.properties = properties;
        this.conglomId = -1L;
        this.droppedConglomNum = -1L;
    }

    CreateIndexConstantAction(ConglomerateDescriptor srcCD, TableDescriptor td, Properties properties) {
        super(td.getUUID(), srcCD.getConglomerateName(), td.getName(), td.getSchemaName());
        this.forCreateTable = false;
        this.droppedConglomNum = srcCD.getConglomerateNumber();
        IndexRowGenerator irg = srcCD.getIndexDescriptor();
        this.unique = irg.isUnique();
        this.uniqueWithDuplicateNulls = irg.isUniqueWithDuplicateNulls();
        this.hasDeferrableChecking = false;
        this.uniqueDeferrable = false;
        this.initiallyDeferred = false;
        this.constraintType = -1;
        this.indexType = irg.indexType();
        this.columnNames = srcCD.getColumnNames();
        this.isAscending = irg.isAscending();
        this.isConstraint = srcCD.isConstraint();
        this.conglomerateUUID = srcCD.getUUID();
        this.properties = properties;
        this.conglomId = -1L;
        if (this.columnNames == null) {
            int[] baseCols = irg.baseColumnPositions();
            this.columnNames = new String[baseCols.length];
            ColumnDescriptorList colDL = td.getColumnDescriptorList();
            for (int i = 0; i < baseCols.length; ++i) {
                this.columnNames[i] = colDL.elementAt(baseCols[i] - 1).getColumnName();
            }
        }
    }

    public String toString() {
        return "CREATE INDEX " + this.indexName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        CardinalityCounter cCount;
        long numRows;
        IndexRowGenerator indexRowGenerator = null;
        int maxBaseColumnPosition = -1;
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        dd.startWriting(lcc);
        SchemaDescriptor sd = dd.getSchemaDescriptor(this.schemaName, tc, true);
        TableDescriptor td = activation.getDDLTableDescriptor();
        if (td == null) {
            td = this.tableId != null ? dd.getTableDescriptor(this.tableId) : dd.getTableDescriptor(this.tableName, sd, tc);
        }
        if (td == null) {
            throw StandardException.newException("X0Y38.S", this.indexName, this.tableName);
        }
        if (td.getTableType() == 1) {
            throw StandardException.newException("X0Y28.S", this.indexName, this.tableName);
        }
        this.lockTableForDDL(tc, td.getHeapConglomerateId(), false);
        if (!this.forCreateTable) {
            dm.invalidateFor(td, 3, lcc);
        }
        int[] baseColumnPositions = new int[this.columnNames.length];
        for (int i = 0; i < this.columnNames.length; ++i) {
            ClassFactory cf;
            ColumnDescriptor columnDescriptor = td.getColumnDescriptor(this.columnNames[i]);
            if (columnDescriptor == null) {
                throw StandardException.newException("42X14", this.columnNames[i], this.tableName);
            }
            TypeId typeId = columnDescriptor.getType().getTypeId();
            boolean isIndexable = typeId.orderable(cf = lcc.getLanguageConnectionFactory().getClassFactory());
            if (isIndexable && typeId.userType()) {
                String userClass = typeId.getCorrespondingJavaTypeName();
                try {
                    if (cf.isApplicationClass(cf.loadApplicationClass(userClass))) {
                        isIndexable = false;
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    isIndexable = false;
                }
            }
            if (!isIndexable) {
                throw StandardException.newException("X0X67.S", typeId.getSQLTypeName());
            }
            baseColumnPositions[i] = columnDescriptor.getPosition();
            if (maxBaseColumnPosition >= baseColumnPositions[i]) continue;
            maxBaseColumnPosition = baseColumnPositions[i];
        }
        ConglomerateDescriptor[] congDescs = td.getConglomerateDescriptors();
        boolean shareExisting = false;
        for (int i = 0; i < congDescs.length; ++i) {
            boolean possibleShare;
            ConglomerateDescriptor cd = congDescs[i];
            if (!cd.isIndex() || this.droppedConglomNum == cd.getConglomerateNumber()) continue;
            IndexRowGenerator irg = cd.getIndexDescriptor();
            int[] bcps = irg.baseColumnPositions();
            boolean[] ia = irg.isAscending();
            int j = 0;
            boolean bl = possibleShare = (irg.isUnique() || !this.unique) && bcps.length == baseColumnPositions.length && !this.hasDeferrableChecking;
            if (possibleShare && !irg.isUnique()) {
                boolean bl2 = possibleShare = irg.isUniqueWithDuplicateNulls() || !this.uniqueWithDuplicateNulls;
            }
            if (possibleShare && this.indexType.equals(irg.indexType())) {
                while (j < bcps.length && bcps[j] == baseColumnPositions[j] && ia[j] == this.isAscending[j]) {
                    ++j;
                }
            }
            if (j != baseColumnPositions.length) continue;
            if (!this.isConstraint) {
                activation.addWarning(StandardException.newWarning("01504", this.indexName, cd.getConglomerateName()));
                return;
            }
            this.conglomId = cd.getConglomerateNumber();
            indexRowGenerator = new IndexRowGenerator(this.indexType, this.unique, this.uniqueWithDuplicateNulls, false, false, baseColumnPositions, this.isAscending, baseColumnPositions.length);
            this.conglomerateUUID = dd.getUUIDFactory().createUUID();
            shareExisting = true;
            break;
        }
        boolean alreadyHaveConglomDescriptor = this.droppedConglomNum > -1L;
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        if (shareExisting && !alreadyHaveConglomDescriptor) {
            ConglomerateDescriptor cgd = ddg.newConglomerateDescriptor(this.conglomId, this.indexName, true, indexRowGenerator, this.isConstraint, this.conglomerateUUID, td.getUUID(), sd.getUUID());
            dd.addDescriptor(cgd, sd, 0, false, tc);
            ConglomerateDescriptorList cdl = td.getConglomerateDescriptorList();
            cdl.add(cgd);
        }
        Properties indexProperties = this.properties != null ? this.properties : new Properties();
        indexProperties.put("baseConglomerateId", Long.toString(td.getHeapConglomerateId()));
        if (this.uniqueWithDuplicateNulls && !this.hasDeferrableChecking) {
            if (dd.checkVersion(160, null)) {
                indexProperties.put("uniqueWithDuplicateNulls", Boolean.toString(true));
            } else if (this.uniqueWithDuplicateNulls) {
                this.unique = true;
            }
        }
        indexProperties.put("nUniqueColumns", Integer.toString(this.unique ? baseColumnPositions.length : baseColumnPositions.length + 1));
        indexProperties.put("rowLocationColumn", Integer.toString(baseColumnPositions.length));
        indexProperties.put("nKeyFields", Integer.toString(baseColumnPositions.length + 1));
        if (!shareExisting) {
            indexRowGenerator = dd.checkVersion(160, null) ? new IndexRowGenerator(this.indexType, this.unique, this.uniqueWithDuplicateNulls, this.uniqueDeferrable, this.hasDeferrableChecking && this.constraintType != 6, baseColumnPositions, this.isAscending, baseColumnPositions.length) : new IndexRowGenerator(this.indexType, this.unique, false, false, false, baseColumnPositions, this.isAscending, baseColumnPositions.length);
        }
        RowSource rowSource = null;
        long sortId = 0L;
        boolean needToDropSort = false;
        int bulkFetchSize = this.forCreateTable ? 1 : 16;
        int numColumns = td.getNumberOfColumns();
        int approximateRowSize = 0;
        FormatableBitSet bitSet = new FormatableBitSet(numColumns + 1);
        for (int index = 0; index < baseColumnPositions.length; ++index) {
            bitSet.set(baseColumnPositions[index]);
        }
        FormatableBitSet zeroBasedBitSet = RowUtil.shift(bitSet, 1);
        GroupFetchScanController scan = tc.openGroupFetchScan(td.getHeapConglomerateId(), false, 0, 7, 5, zeroBasedBitSet, null, 0, null, null, 0);
        ExecRow[] baseRows = new ExecRow[bulkFetchSize];
        ExecIndexRow[] indexRows = new ExecIndexRow[bulkFetchSize];
        ExecRow[] compactBaseRows = new ExecRow[bulkFetchSize];
        try {
            BasicSortObserver sortObserver;
            int numColumnOrderings;
            for (int i = 0; i < bulkFetchSize; ++i) {
                baseRows[i] = activation.getExecutionFactory().getValueRow(maxBaseColumnPosition);
                indexRows[i] = indexRowGenerator.getIndexRowTemplate();
                compactBaseRows[i] = activation.getExecutionFactory().getValueRow(baseColumnPositions.length);
            }
            this.indexTemplateRow = indexRows[0];
            ColumnDescriptorList cdl = td.getColumnDescriptorList();
            int cdlSize = cdl.size();
            int numSet = 0;
            for (int index = 0; index < cdlSize; ++index) {
                if (!zeroBasedBitSet.get(index)) continue;
                ++numSet;
                ColumnDescriptor cd = cdl.elementAt(index);
                DataTypeDescriptor dts = cd.getType();
                for (int i = 0; i < bulkFetchSize; ++i) {
                    baseRows[i].setColumn(index + 1, dts.getNull());
                    compactBaseRows[i].setColumn(numSet, baseRows[i].getColumn(index + 1));
                }
                approximateRowSize += dts.getTypeId().getApproximateLengthInBytes(dts);
            }
            RowLocation[] rl = new RowLocation[bulkFetchSize];
            for (int i = 0; i < bulkFetchSize; ++i) {
                rl[i] = scan.newRowLocationTemplate();
                indexRowGenerator.getIndexRow(compactBaseRows[i], rl[i], indexRows[i], bitSet);
            }
            if (shareExisting) {
                return;
            }
            Properties sortProperties = null;
            if (this.unique || this.uniqueWithDuplicateNulls || this.uniqueDeferrable) {
                String indexOrConstraintName = this.indexName;
                if (this.conglomerateUUID != null) {
                    ConglomerateDescriptor cd = dd.getConglomerateDescriptor(this.conglomerateUUID);
                    if (this.isConstraint && cd != null && cd.getUUID() != null && td != null) {
                        ConstraintDescriptor conDesc = dd.getConstraintDescriptor(td, cd.getUUID());
                        indexOrConstraintName = conDesc.getConstraintName();
                    }
                }
                if (this.unique || this.uniqueDeferrable) {
                    numColumnOrderings = this.unique ? baseColumnPositions.length : baseColumnPositions.length + 1;
                    sortObserver = new UniqueIndexSortObserver(lcc, this.constraintID, true, this.uniqueDeferrable, this.initiallyDeferred, indexOrConstraintName, this.indexTemplateRow, true, td.getName());
                } else {
                    numColumnOrderings = baseColumnPositions.length + 1;
                    sortProperties = new Properties();
                    sortProperties.put("implType", "sort almost unique external");
                    sortObserver = new UniqueWithDuplicateNullsIndexSortObserver(lcc, this.constraintID, true, this.hasDeferrableChecking && this.constraintType != 6, this.initiallyDeferred, indexOrConstraintName, this.indexTemplateRow, true, td.getName());
                }
            } else {
                numColumnOrderings = baseColumnPositions.length + 1;
                sortObserver = new BasicSortObserver(true, false, this.indexTemplateRow, true);
            }
            ColumnOrdering[] order = new ColumnOrdering[numColumnOrderings];
            for (int i = 0; i < numColumnOrderings; ++i) {
                order[i] = new IndexColumnOrder(i, this.unique || i < numColumnOrderings - 1 ? this.isAscending[i] : true);
            }
            sortId = tc.createSort(sortProperties, this.indexTemplateRow.getRowArrayClone(), order, sortObserver, false, scan.getEstimatedRowCount(), approximateRowSize);
            needToDropSort = true;
            rowSource = this.loadSorter(baseRows, indexRows, tc, scan, sortId, rl);
            this.conglomId = tc.createAndLoadConglomerate(this.indexType, this.indexTemplateRow.getRowArray(), order, indexRowGenerator.getColumnCollationIds(td.getColumnDescriptorList()), indexProperties, 0, (RowLocationRetRowSource)rowSource, null);
        }
        finally {
            if (scan != null) {
                scan.close();
            }
            if (rowSource != null) {
                rowSource.closeRowSource();
            }
            if (needToDropSort) {
                tc.dropSort(sortId);
            }
        }
        ConglomerateController indexController = tc.openConglomerate(this.conglomId, false, 0, 7, 5);
        if (!indexController.isKeyed()) {
            indexController.close();
            throw StandardException.newException("X0X85.S", this.indexName, this.indexType);
        }
        indexController.close();
        if (!alreadyHaveConglomDescriptor) {
            ConglomerateDescriptor cgd = ddg.newConglomerateDescriptor(this.conglomId, this.indexName, true, indexRowGenerator, this.isConstraint, this.conglomerateUUID, td.getUUID(), sd.getUUID());
            dd.addDescriptor(cgd, sd, 0, false, tc);
            ConglomerateDescriptorList cdl = td.getConglomerateDescriptorList();
            cdl.add(cgd);
            this.conglomerateUUID = cgd.getUUID();
        }
        if (this.addStatistics(dd, indexRowGenerator, numRows = (cCount = (CardinalityCounter)rowSource).getRowCount())) {
            long[] c = cCount.getCardinality();
            for (int i = 0; i < c.length; ++i) {
                StatisticsDescriptor statDesc = new StatisticsDescriptor(dd, dd.getUUIDFactory().createUUID(), this.conglomerateUUID, td.getUUID(), "I", new StatisticsImpl(numRows, c[i]), i + 1);
                dd.addDescriptor(statDesc, null, 14, true, tc);
            }
        }
    }

    private boolean addStatistics(DataDictionary dd, IndexRowGenerator irg, long numRows) throws StandardException {
        boolean add;
        boolean bl = add = numRows > 0L;
        if (dd.checkVersion(210, null) && ((IndexStatisticsDaemonImpl)dd.getIndexStatsRefresher((boolean)false)).skipDisposableStats && add && irg.isUnique() && irg.numberOfOrderedColumns() == 1) {
            add = false;
        }
        return add;
    }

    ExecRow getIndexTemplateRow() {
        return this.indexTemplateRow;
    }

    long getCreatedConglomNumber() {
        if (this.conglomId == -1L) {
            SanityManager.THROWASSERT("Called getCreatedConglomNumber() on a CreateIndexConstantAction before the action was executed.");
        }
        return this.conglomId;
    }

    long getReplacedConglomNumber() {
        return this.droppedConglomNum;
    }

    UUID getCreatedUUID() {
        return this.conglomerateUUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RowLocationRetRowSource loadSorter(ExecRow[] baseRows, ExecIndexRow[] indexRows, TransactionController tc, GroupFetchScanController scan, long sortId, RowLocation[] rl) throws StandardException {
        long rowCount = 0L;
        SortController sorter = tc.openSort(sortId);
        try {
            int bulkFetched;
            int bulkFetchSize = baseRows.length;
            SanityManager.ASSERT(bulkFetchSize == indexRows.length, "number of base rows and index rows does not match");
            SanityManager.ASSERT(bulkFetchSize == rl.length, "number of base rows and row locations does not match");
            DataValueDescriptor[][] baseRowArray = new DataValueDescriptor[bulkFetchSize][];
            for (int i = 0; i < bulkFetchSize; ++i) {
                baseRowArray[i] = baseRows[i].getRowArray();
            }
            while ((bulkFetched = scan.fetchNextGroup(baseRowArray, rl)) > 0) {
                for (int i = 0; i < bulkFetched; ++i) {
                    sorter.insert(indexRows[i].getRowArray());
                    ++rowCount;
                }
            }
            scan.setEstimatedRowCount(rowCount);
        }
        finally {
            sorter.completedInserts();
        }
        return new CardinalityCounter(tc.openSortRowSource(sortId));
    }
}

