/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.shared.common.error.StandardException;

class SystemColumnImpl
implements SystemColumn {
    private final String name;
    private final DataTypeDescriptor type;

    static SystemColumn getColumn(String name, int jdbcTypeId, boolean nullability) {
        return new SystemColumnImpl(name, DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdbcTypeId, nullability));
    }

    static SystemColumn getColumn(String name, int jdbcTypeId, boolean nullability, int maxLength) {
        return new SystemColumnImpl(name, DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdbcTypeId, nullability, maxLength));
    }

    static SystemColumn getIdentifierColumn(String name, boolean nullability) {
        return new SystemColumnImpl(name, DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, nullability, 128));
    }

    static SystemColumn getUUIDColumn(String name, boolean nullability) {
        return new SystemColumnImpl(name, DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, nullability, 36));
    }

    static SystemColumn getIndicatorColumn(String name) {
        return new SystemColumnImpl(name, DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, false, 1));
    }

    static SystemColumn getJavaColumn(String name, String javaClassName, boolean nullability) throws StandardException {
        TypeId typeId = TypeId.getUserDefinedTypeId(javaClassName);
        DataTypeDescriptor dtd = new DataTypeDescriptor(typeId, nullability);
        return new SystemColumnImpl(name, dtd);
    }

    private SystemColumnImpl(String name, DataTypeDescriptor type) {
        this.name = name;
        this.type = type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DataTypeDescriptor getType() {
        return this.type;
    }
}

