/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.File;
import java.util.Enumeration;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class GetCurrentPropertiesTest
extends BaseJDBCTestCase {
    public GetCurrentPropertiesTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite test = new BaseTestSuite(GetCurrentPropertiesTest.class);
        test = TestConfiguration.clientServerDecorator((Test)test);
        return TestConfiguration.singleUseDatabaseDecorator((Test)test);
    }

    public void test_01_propertiesBeforeConnection() throws Exception {
        Properties p = null;
        String userDir = GetCurrentPropertiesTest.getSystemProperty("user.dir");
        String traceDir = userDir + File.separator + "system";
        Properties expectedValues = new Properties();
        expectedValues.setProperty("derby.drda.traceDirectory", traceDir);
        expectedValues.setProperty("derby.drda.maxThreads", "0");
        expectedValues.setProperty("derby.drda.sslMode", "off");
        expectedValues.setProperty("derby.drda.keepAlive", "true");
        expectedValues.setProperty("derby.drda.minThreads", "0");
        expectedValues.setProperty("derby.drda.portNumber", "" + TestConfiguration.getCurrent().getPort());
        expectedValues.setProperty("derby.drda.logConnections", "false");
        expectedValues.setProperty("derby.drda.timeSlice", "0");
        expectedValues.setProperty("derby.drda.startNetworkServer", "false");
        expectedValues.setProperty("derby.drda.host", "127.0.0.1");
        expectedValues.setProperty("derby.drda.traceAll", "false");
        p = NetworkServerTestSetup.getNetworkServerControl().getCurrentProperties();
        Enumeration<?> expectedProps = expectedValues.propertyNames();
        while (expectedProps.hasMoreElements()) {
            String propName = (String)expectedProps.nextElement();
            String propVal = (String)p.get(propName);
            GetCurrentPropertiesTest.println(expectedValues.getProperty(propName));
            GetCurrentPropertiesTest.println(propVal);
            GetCurrentPropertiesTest.assertEquals((String)expectedValues.getProperty(propName), (String)propVal);
        }
    }

    public void test_02_propertiesAfterConnection() throws Exception {
        Properties p = null;
        String userDir = GetCurrentPropertiesTest.getSystemProperty("user.dir");
        String traceDir = userDir + File.separator + "system";
        Properties expectedValues = new Properties();
        expectedValues.setProperty("derby.drda.traceDirectory", traceDir);
        expectedValues.setProperty("derby.drda.maxThreads", "0");
        expectedValues.setProperty("derby.drda.sslMode", "off");
        expectedValues.setProperty("derby.drda.trace.4", "true");
        expectedValues.setProperty("derby.drda.keepAlive", "true");
        expectedValues.setProperty("derby.drda.minThreads", "0");
        expectedValues.setProperty("derby.drda.portNumber", "" + TestConfiguration.getCurrent().getPort());
        expectedValues.setProperty("derby.drda.logConnections", "true");
        expectedValues.setProperty("derby.drda.timeSlice", "0");
        expectedValues.setProperty("derby.drda.startNetworkServer", "false");
        expectedValues.setProperty("derby.drda.host", "127.0.0.1");
        expectedValues.setProperty("derby.drda.traceAll", "false");
        this.getConnection().setAutoCommit(false);
        NetworkServerControl nsctrl = NetworkServerTestSetup.getNetworkServerControl();
        nsctrl.trace(4, true);
        nsctrl.logConnections(true);
        p = NetworkServerTestSetup.getNetworkServerControl().getCurrentProperties();
        Enumeration<?> expectedProps = expectedValues.propertyNames();
        while (expectedProps.hasMoreElements()) {
            String propName = (String)expectedProps.nextElement();
            String propVal = (String)p.get(propName);
            GetCurrentPropertiesTest.println(expectedValues.getProperty(propName));
            GetCurrentPropertiesTest.println(propVal);
            GetCurrentPropertiesTest.assertEquals((String)expectedValues.getProperty(propName), (String)propVal);
        }
    }

    public void test_03_propertiesTraceOn() throws Exception {
        Properties p = null;
        NetworkServerControl nsctrl = NetworkServerTestSetup.getNetworkServerControl();
        nsctrl.trace(true);
        String derbySystemHome = GetCurrentPropertiesTest.getSystemProperty("derby.system.home");
        nsctrl.setTraceDirectory(derbySystemHome);
        Properties expectedValues = new Properties();
        expectedValues.setProperty("derby.drda.traceDirectory", derbySystemHome);
        expectedValues.setProperty("derby.drda.maxThreads", "0");
        expectedValues.setProperty("derby.drda.sslMode", "off");
        expectedValues.setProperty("derby.drda.keepAlive", "true");
        expectedValues.setProperty("derby.drda.minThreads", "0");
        expectedValues.setProperty("derby.drda.portNumber", "" + TestConfiguration.getCurrent().getPort());
        expectedValues.setProperty("derby.drda.logConnections", "true");
        expectedValues.setProperty("derby.drda.timeSlice", "0");
        expectedValues.setProperty("derby.drda.startNetworkServer", "false");
        expectedValues.setProperty("derby.drda.host", "127.0.0.1");
        expectedValues.setProperty("derby.drda.traceAll", "true");
        p = NetworkServerTestSetup.getNetworkServerControl().getCurrentProperties();
        Enumeration<?> expectedProps = expectedValues.propertyNames();
        while (expectedProps.hasMoreElements()) {
            String propName = (String)expectedProps.nextElement();
            String propVal = (String)p.get(propName);
            GetCurrentPropertiesTest.println(expectedValues.getProperty(propName));
            GetCurrentPropertiesTest.println(propVal);
            GetCurrentPropertiesTest.assertEquals((String)("Unexpected value for property " + propName), (String)expectedValues.getProperty(propName), (String)propVal);
        }
    }
}

