/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.InputStream;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.lang.DummyBinary;
import org.apache.derbyTesting.functionTests.tests.lang.DummyReader;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;

public class StreamsTest
extends BaseJDBCTestCase {
    private int pkCount;

    public StreamsTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite(StreamsTest.class, "StreamsTest");
        baseTestSuite = DatabasePropertyTestSetup.singleProperty((Test)baseTestSuite, "derby.storage.pageSize", "2048");
        return new CleanDatabaseTestSetup((Test)baseTestSuite){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.executeUpdate("create table t1 (id int, pid int, lvc long varchar, lvb long varchar for bit data)");
                statement.executeUpdate("create table t2 (id int, pid int, lvc long varchar, lvb long varchar for bit data)");
                statement.executeUpdate("create trigger tr21 after insert on t2 for each statement values 1");
                statement.executeUpdate("create table t3 (id int not null primary key, pid int, lvc long varchar, lvb long varchar for bit data, CONSTRAINT FK1 Foreign Key(pid) REFERENCES T3 (id))");
                statement.executeUpdate("create table t4 (id int, longcol long varchar)");
                statement.executeUpdate("create table t5 (id int, longcol long varchar)");
            }
        };
    }

    public void testStreams() throws Exception {
        int n;
        this.getConnection().setAutoCommit(false);
        Statement statement = this.createStatement();
        PreparedStatement preparedStatement = this.prepareStatement("insert into  t1 values(?, ?, ?,?)");
        int n2 = this.insertLongString(preparedStatement, 8, true);
        preparedStatement.close();
        preparedStatement = this.prepareStatement("insert into  t2 values(?, ?, ?,?)");
        int n3 = this.insertLongString(preparedStatement, 8, true);
        StreamsTest.assertEquals((String)"FAILED!! level difference not expected since streams are materialized.", (int)n2, (int)n3);
        preparedStatement.close();
        preparedStatement = this.prepareStatement("insert into  t3 values(?, ?, ?,?)");
        int n4 = this.insertLongString(preparedStatement, 8, true);
        preparedStatement.close();
        StreamsTest.assertEquals((String)"FAILED!! should not materialize in this case.", (int)n4, (int)n2);
        this.rollback();
        statement.executeUpdate("insert into t3 values (1,1,'a',null),(2,2,'b',null), (3,3,'c',null)");
        preparedStatement = this.prepareStatement("update t3 set id = ?, lvc = ? where pid = 2");
        n2 = this.insertLongString(preparedStatement, 8, false);
        preparedStatement.close();
        preparedStatement = this.prepareStatement("update t3 set id = ?, lvc = ? where pid = 2 and id = 2");
        n3 = this.insertLongString(preparedStatement, 8, false);
        preparedStatement.close();
        StreamsTest.assertEquals((String)"FAILED!! level difference not expected because streams are materialized with fix for bug 5592.", (int)n2, (int)n3);
        statement.executeUpdate("insert into t4 values (1, 'ccccc')");
        preparedStatement = this.prepareStatement("insert into t4 values(?, ?)");
        this.insertLongString(preparedStatement, 6, false);
        statement.executeUpdate("insert into t4 values (3, 'abbb')");
        statement.executeUpdate("insert into t4 values (4, 'bbbbbb')");
        this.insertLongString(preparedStatement, 5, false);
        preparedStatement.close();
        ResultSet resultSet = statement.executeQuery("select id, cast(longcol as varchar(8192)) lcol from t4 order by lcol");
        StreamsTest.assertTrue((boolean)resultSet.next());
        StreamsTest.assertEquals((int)3, (int)resultSet.getInt(1));
        StreamsTest.assertEquals((String)"abbb", (String)resultSet.getString(2));
        StreamsTest.assertTrue((boolean)resultSet.next());
        StreamsTest.assertEquals((int)4, (int)resultSet.getInt(1));
        StreamsTest.assertEquals((String)"bbbbbb", (String)resultSet.getString(2));
        StreamsTest.assertTrue((boolean)resultSet.next());
        StreamsTest.assertEquals((int)2, (int)resultSet.getInt(1));
        String string = resultSet.getString(2);
        StreamsTest.assertNotNull((Object)string);
        StreamsTest.assertEquals((int)5393, (int)string.length());
        for (n = 0; n < string.length(); ++n) {
            StreamsTest.assertEquals((char)'b', (char)string.charAt(n));
        }
        StreamsTest.assertTrue((boolean)resultSet.next());
        StreamsTest.assertEquals((int)2, (int)resultSet.getInt(1));
        string = resultSet.getString(2);
        StreamsTest.assertNotNull((Object)string);
        StreamsTest.assertEquals((int)6417, (int)string.length());
        for (n = 0; n < string.length(); ++n) {
            StreamsTest.assertEquals((char)'b', (char)string.charAt(n));
        }
        StreamsTest.assertTrue((boolean)resultSet.next());
        StreamsTest.assertEquals((int)1, (int)resultSet.getInt(1));
        StreamsTest.assertEquals((String)"ccccc", (String)resultSet.getString(2));
        StreamsTest.assertFalse((boolean)resultSet.next());
        resultSet.close();
        statement.executeUpdate("insert into t5 values (1, 'bbbbbb')");
        preparedStatement = this.prepareStatement("insert into t5 values(?, ?)");
        this.insertLongString(preparedStatement, 5, false);
        this.insertLongString(preparedStatement, 7, false);
        preparedStatement.close();
        statement.executeUpdate("insert into t5 values (3, 'aaaaabbbbbba')");
        statement.executeUpdate("insert into t5 values (4, 'bbbbbbbbb')");
        resultSet = statement.executeQuery("select t4.id, t4.longcol, t5.id, cast(t5.longcol as varchar(8192)) lcol from t4, t5 where cast(t4.longcol as varchar(8192)) = cast(t5.longcol as varchar(8192)) order by lcol");
        StreamsTest.assertTrue((boolean)resultSet.next());
        StreamsTest.assertEquals((int)4, (int)resultSet.getInt(1));
        StreamsTest.assertEquals((int)6, (int)resultSet.getString(2).length());
        StreamsTest.assertEquals((int)1, (int)resultSet.getInt(3));
        StreamsTest.assertEquals((int)6, (int)resultSet.getString(4).length());
        StreamsTest.assertTrue((boolean)resultSet.next());
        StreamsTest.assertEquals((int)2, (int)resultSet.getInt(1));
        StreamsTest.assertEquals((int)5393, (int)resultSet.getString(2).length());
        StreamsTest.assertEquals((int)2, (int)resultSet.getInt(3));
        StreamsTest.assertEquals((int)5393, (int)resultSet.getString(4).length());
        StreamsTest.assertFalse((boolean)resultSet.next());
        resultSet.close();
        this.rollback();
        preparedStatement = this.prepareStatement("insert into  t1 values(?, ?, ?,?)");
        n2 = this.insertLongBinary(preparedStatement, 8);
        preparedStatement.close();
        preparedStatement = this.prepareStatement("insert into  t2 values(?, ?, ?,?)");
        n3 = this.insertLongBinary(preparedStatement, 8);
        preparedStatement.close();
        StreamsTest.assertTrue((String)"FAILED, check stack level change.", (n2 > n3 + 5 ? 1 : 0) != 0);
        preparedStatement = this.prepareStatement("insert into  t3 values(?, ?, ?,?)");
        n4 = this.insertLongBinary(preparedStatement, 8);
        preparedStatement.close();
        StreamsTest.assertEquals((String)"FAILED!! should not materialize stream in this case.", (int)n4, (int)n2);
        statement.close();
        this.rollback();
    }

    private int insertLongString(PreparedStatement preparedStatement, int n, boolean bl) throws SQLException {
        int n2 = n * 1024 + 273;
        DummyReader dummyReader = new DummyReader(n2);
        if (bl) {
            preparedStatement.setInt(1, this.pkCount);
            preparedStatement.setInt(2, this.pkCount++);
            preparedStatement.setCharacterStream(3, (Reader)dummyReader, n2);
            preparedStatement.setNull(4, -3);
        } else {
            preparedStatement.setInt(1, 2);
            preparedStatement.setCharacterStream(2, (Reader)dummyReader, n2);
        }
        preparedStatement.executeUpdate();
        return dummyReader.readerStackLevel;
    }

    private int insertLongBinary(PreparedStatement preparedStatement, int n) throws SQLException {
        int n2 = n * 1024 + 273;
        preparedStatement.setInt(1, this.pkCount);
        preparedStatement.setInt(2, this.pkCount++);
        preparedStatement.setNull(3, -1);
        DummyBinary dummyBinary = new DummyBinary(n2);
        preparedStatement.setBinaryStream(4, (InputStream)dummyBinary, n2);
        preparedStatement.executeUpdate();
        return dummyBinary.readerStackLevel;
    }
}

