/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.TestUtil;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class UnsupportedVetter
extends BaseJDBCTestCase {
    public static final String SQL_PACKAGE_NAME = "java.sql";
    private static final boolean STRICT_ENFORCEMENT = false;
    private static Exclusions[] rawExcludables = new Exclusions[]{new Exclusions(Connection.class, new MD[]{new MD("createArrayOf", new Class[]{String.class, Object[].class}), new MD("createNClob", new Class[0]), new MD("createSQLXML", new Class[0]), new MD("createStruct", new Class[]{String.class, Object[].class}), new MD("getNetworkTimeout", new Class[0], JDBC.vmSupportsJDBC41()), new MD("getTypeMap", new Class[0]), new MD("prepareStatement", new Class[]{String.class, int[].class}), new MD("prepareStatement", new Class[]{String.class, String[].class}), new MD("setNetworkTimeout", new Class[]{Executor.class, Integer.TYPE}, JDBC.vmSupportsJDBC41()), new MD("setTypeMap", new Class[]{Map.class})}), new Exclusions(Statement.class, new MD[]{new MD("cancel", new Class[0]), new MD("execute", new Class[]{String.class, int[].class}), new MD("execute", new Class[]{String.class, String[].class}), new MD("executeUpdate", new Class[]{String.class, int[].class}), new MD("executeUpdate", new Class[]{String.class, String[].class})}), new Exclusions(PreparedStatement.class, new MD[]{new MD("setArray", new Class[]{Integer.TYPE, Array.class}), new MD("setNCharacterStream", new Class[]{Integer.TYPE, Reader.class}), new MD("setNCharacterStream", new Class[]{Integer.TYPE, Reader.class, Long.TYPE}), new MD("setNClob", new Class[]{Integer.TYPE, NClob.class}), new MD("setNClob", new Class[]{Integer.TYPE, Reader.class}), new MD("setNClob", new Class[]{Integer.TYPE, Reader.class, Long.TYPE}), new MD("setNString", new Class[]{Integer.TYPE, String.class}), new MD("setRef", new Class[]{Integer.TYPE, Ref.class}), new MD("setRowId", new Class[]{Integer.TYPE, RowId.class}), new MD("setSQLXML", new Class[]{Integer.TYPE, SQLXML.class}), new MD("setURL", new Class[]{Integer.TYPE, URL.class}), new MD("setNull", new Class[]{Integer.TYPE, Integer.TYPE, String.class}), new MD("setUnicodeStream", new Class[]{Integer.TYPE, InputStream.class, Integer.TYPE})}), new Exclusions(CallableStatement.class, new MD[]{new FD("getBlob", new Class[]{Integer.TYPE}), new FD("getClob", new Class[]{Integer.TYPE}), new MD("getArray", new Class[]{Integer.TYPE}), new MD("getArray", new Class[]{String.class}), new MD("getBigDecimal", new Class[]{String.class}), new MD("getBoolean", new Class[]{String.class}), new MD("getBlob", new Class[]{String.class}), new MD("getBoolean", new Class[]{String.class}), new MD("getByte", new Class[]{String.class}), new MD("getBytes", new Class[]{String.class}), new MD("getCharacterStream", new Class[]{String.class}), new MD("getClob", new Class[]{String.class}), new MD("getDate", new Class[]{String.class}), new MD("getDate", new Class[]{String.class, Calendar.class}), new MD("getDouble", new Class[]{String.class}), new MD("getFloat", new Class[]{String.class}), new MD("getInt", new Class[]{String.class}), new MD("getLong", new Class[]{String.class}), new MD("getNCharacterStream", new Class[]{Integer.TYPE}), new MD("getNCharacterStream", new Class[]{String.class}), new MD("getNClob", new Class[]{Integer.TYPE}), new MD("getNClob", new Class[]{String.class}), new MD("getNString", new Class[]{Integer.TYPE}), new MD("getNString", new Class[]{String.class}), new MD("getObject", new Class[]{String.class}), new MD("getObject", new Class[]{String.class, Class.class}, JDBC.vmSupportsJDBC41()), new MD("getRef", new Class[]{Integer.TYPE}), new MD("getRef", new Class[]{String.class}), new MD("getRowId", new Class[]{Integer.TYPE}), new MD("getRowId", new Class[]{String.class}), new MD("getShort", new Class[]{String.class}), new MD("getSQLXML", new Class[]{Integer.TYPE}), new MD("getSQLXML", new Class[]{String.class}), new MD("getString", new Class[]{String.class}), new MD("getTime", new Class[]{String.class}), new MD("getTime", new Class[]{String.class, Calendar.class}), new MD("getTimestamp", new Class[]{String.class}), new MD("getTimestamp", new Class[]{String.class, Calendar.class}), new MD("getURL", new Class[]{Integer.TYPE}), new MD("getURL", new Class[]{String.class}), new MD("registerOutParameter", new Class[]{String.class, Integer.TYPE}), new MD("registerOutParameter", new Class[]{String.class, Integer.TYPE, Integer.TYPE}), new MD("registerOutParameter", new Class[]{String.class, Integer.TYPE, String.class}), new MD("registerOutParameter", new Class[]{Integer.TYPE, Integer.TYPE, String.class}), UnsupportedVetter.makeMD("registerOutParameter", new String[]{"java.lang.String", "java.sql.SQLType"}, JDBC.vmSupportsJDBC42()), UnsupportedVetter.makeMD("registerOutParameter", new String[]{"java.lang.String", "java.sql.SQLType", "int"}, JDBC.vmSupportsJDBC42()), UnsupportedVetter.makeMD("registerOutParameter", new String[]{"java.lang.String", "java.sql.SQLType", "java.lang.String"}, JDBC.vmSupportsJDBC42()), new MD("setArray", new Class[]{Integer.TYPE, Array.class}), new MD("setAsciiStream", new Class[]{String.class, InputStream.class}), new MD("setAsciiStream", new Class[]{String.class, InputStream.class, Integer.TYPE}), new MD("setAsciiStream", new Class[]{String.class, InputStream.class, Long.TYPE}), new MD("setBigDecimal", new Class[]{String.class, BigDecimal.class}), new MD("setBinaryStream", new Class[]{String.class, InputStream.class}), new MD("setBinaryStream", new Class[]{String.class, InputStream.class, Integer.TYPE}), new MD("setBinaryStream", new Class[]{String.class, InputStream.class, Long.TYPE}), new MD("setBlob", new Class[]{String.class, InputStream.class}), new MD("setBlob", new Class[]{String.class, InputStream.class, Long.TYPE}), new MD("setBlob", new Class[]{String.class, Blob.class}), new MD("setBoolean", new Class[]{String.class, Boolean.TYPE}), new MD("setByte", new Class[]{String.class, Byte.TYPE}), new MD("setBytes", new Class[]{String.class, byte[].class}), new MD("setCharacterStream", new Class[]{String.class, Reader.class}), new MD("setCharacterStream", new Class[]{String.class, Reader.class, Integer.TYPE}), new MD("setCharacterStream", new Class[]{String.class, Reader.class, Long.TYPE}), new MD("setClob", new Class[]{String.class, Reader.class}), new MD("setClob", new Class[]{String.class, Reader.class, Long.TYPE}), new MD("setClob", new Class[]{String.class, Clob.class}), new MD("setDate", new Class[]{String.class, Date.class}), new MD("setDate", new Class[]{String.class, Date.class, Calendar.class}), new MD("setDouble", new Class[]{String.class, Double.TYPE}), new MD("setFloat", new Class[]{String.class, Float.TYPE}), new MD("setInt", new Class[]{String.class, Integer.TYPE}), new MD("setLong", new Class[]{String.class, Long.TYPE}), new MD("setNCharacterStream", new Class[]{Integer.TYPE, Reader.class, Long.TYPE}), new MD("setNCharacterStream", new Class[]{String.class, Reader.class}), new MD("setNCharacterStream", new Class[]{String.class, Reader.class, Long.TYPE}), new MD("setNClob", new Class[]{Integer.TYPE, Reader.class, Long.TYPE}), new MD("setNClob", new Class[]{Integer.TYPE, NClob.class}), new MD("setNClob", new Class[]{String.class, Reader.class}), new MD("setNClob", new Class[]{String.class, Reader.class, Long.TYPE}), new MD("setNClob", new Class[]{String.class, NClob.class}), new MD("setNString", new Class[]{Integer.TYPE, String.class}), new MD("setNString", new Class[]{String.class, String.class}), new MD("setNull", new Class[]{String.class, Integer.TYPE}), new MD("setNull", new Class[]{String.class, Integer.TYPE, String.class}), new MD("setObject", new Class[]{String.class, Object.class}), new MD("setObject", new Class[]{String.class, Object.class, Integer.TYPE}), new MD("setObject", new Class[]{String.class, Object.class, Integer.TYPE, Integer.TYPE}), new MD("setRef", new Class[]{Integer.TYPE, Ref.class}), new MD("setRowId", new Class[]{Integer.TYPE, RowId.class}), new MD("setRowId", new Class[]{String.class, RowId.class}), new MD("setSQLXML", new Class[]{Integer.TYPE, SQLXML.class}), new MD("setSQLXML", new Class[]{String.class, SQLXML.class}), new MD("setShort", new Class[]{String.class, Short.TYPE}), new MD("setString", new Class[]{String.class, String.class}), new MD("setTime", new Class[]{String.class, Time.class}), new MD("setTime", new Class[]{String.class, Time.class, Calendar.class}), new MD("setTimestamp", new Class[]{String.class, Timestamp.class}), new MD("setTimestamp", new Class[]{String.class, Timestamp.class, Calendar.class}), new MD("setURL", new Class[]{Integer.TYPE, URL.class}), new MD("setURL", new Class[]{String.class, URL.class})}), new Exclusions(ResultSet.class, new MD[]{new FD("updateNClob", new Class[]{Integer.TYPE, Reader.class, Long.TYPE}), new FD("updateNClob", new Class[]{String.class, Reader.class, Long.TYPE}), new MD("getNCharacterStream", new Class[]{Integer.TYPE}), new MD("getNCharacterStream", new Class[]{String.class}), new MD("getNString", new Class[]{Integer.TYPE}), new MD("getNString", new Class[]{String.class}), new MD("getURL", new Class[]{Integer.TYPE}), new MD("getURL", new Class[]{String.class}), new MD("getArray", new Class[]{Integer.TYPE}), new MD("getArray", new Class[]{String.class}), new MD("getNClob", new Class[]{Integer.TYPE}), new MD("getNClob", new Class[]{String.class}), new MD("getRef", new Class[]{Integer.TYPE}), new MD("getRef", new Class[]{String.class}), new MD("getRowId", new Class[]{Integer.TYPE}), new MD("getRowId", new Class[]{String.class}), new MD("getSQLXML", new Class[]{Integer.TYPE}), new MD("getSQLXML", new Class[]{String.class}), new MD("getUnicodeStream", new Class[]{Integer.TYPE}), new MD("getUnicodeStream", new Class[]{String.class}), new MD("refreshRow", new Class[0]), new MD("updateArray", new Class[]{Integer.TYPE, Array.class}), new MD("updateArray", new Class[]{String.class, Array.class}), new MD("updateNCharacterStream", new Class[]{Integer.TYPE, Reader.class}), new MD("updateNCharacterStream", new Class[]{Integer.TYPE, Reader.class, Long.TYPE}), new MD("updateNCharacterStream", new Class[]{String.class, Reader.class}), new MD("updateNCharacterStream", new Class[]{String.class, Reader.class, Long.TYPE}), new MD("updateNClob", new Class[]{Integer.TYPE, NClob.class}), new MD("updateNClob", new Class[]{Integer.TYPE, Reader.class}), new MD("updateNClob", new Class[]{String.class, NClob.class}), new MD("updateNClob", new Class[]{String.class, Reader.class}), new MD("updateNString", new Class[]{Integer.TYPE, String.class}), new MD("updateNString", new Class[]{String.class, String.class}), new MD("updateRef", new Class[]{Integer.TYPE, Ref.class}), new MD("updateRef", new Class[]{String.class, Ref.class}), new MD("updateRowId", new Class[]{Integer.TYPE, RowId.class}), new MD("updateRowId", new Class[]{String.class, RowId.class}), new MD("updateSQLXML", new Class[]{Integer.TYPE, SQLXML.class}), new MD("updateSQLXML", new Class[]{String.class, SQLXML.class})})};
    private static Hashtable<Class, HashSet<Method>> excludableMap;
    private boolean savedVerbosity;

    private static MD makeMD(String string, String[] stringArray, boolean bl) {
        int n = stringArray.length;
        Class[] classArray = new Class[n];
        try {
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray[i];
                classArray[i] = "int".equals(string2) ? Integer.TYPE : Class.forName(stringArray[i]);
            }
        }
        catch (Exception exception) {
            return null;
        }
        return new MD(string, classArray, bl);
    }

    public UnsupportedVetter() {
        super("UnsupportedVetter");
    }

    public void testSupportedMethods() throws Exception {
        this.getTestConfiguration().setVerbosity(true);
        if (UnsupportedVetter.vmAtLeast(1, 9)) {
            return;
        }
        if (this.savedVerbosity) {
            UnsupportedVetter.println("Supports JDBC 4.2 = " + JDBC.vmSupportsJDBC42());
        }
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<String> hashSet3 = new HashSet<String>();
        this.initializeExcludableMap(hashSet);
        this.vetDataSource(hashSet2, hashSet3);
        this.vetConnectionPooledDataSource(hashSet2, hashSet3);
        this.vetXADataSource(hashSet2, hashSet3);
        this.printVanishedMethodList(hashSet);
        this.printUnsupportedList(hashSet2);
        this.printNotUnderstoodList(hashSet3);
        UnsupportedVetter.assertEquals((String)"vanishedMethodList", (int)0, (int)hashSet.size());
        UnsupportedVetter.assertEquals((String)"unsupportedList", (int)0, (int)hashSet2.size());
        UnsupportedVetter.assertEquals((String)"notUnderstoodList", (int)0, (int)hashSet3.size());
    }

    private void vetDataSource(HashSet<String> hashSet, HashSet<String> hashSet2) throws Exception {
        DataSource dataSource = JDBCDataSource.getDataSource();
        Connection connection = dataSource.getConnection();
        this.vetObject(dataSource, hashSet, hashSet2);
        this.connectionWorkhorse(connection, hashSet, hashSet2);
    }

    private void vetConnectionPooledDataSource(HashSet<String> hashSet, HashSet<String> hashSet2) throws Exception {
        ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
        PooledConnection pooledConnection = connectionPoolDataSource.getPooledConnection(this.getTestConfiguration().getUserName(), this.getTestConfiguration().getUserPassword());
        Connection connection = pooledConnection.getConnection();
        this.vetObject(connectionPoolDataSource, hashSet, hashSet2);
        this.vetObject(pooledConnection, hashSet, hashSet2);
        this.connectionWorkhorse(connection, hashSet, hashSet2);
    }

    private void vetXADataSource(HashSet<String> hashSet, HashSet<String> hashSet2) throws Exception {
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        XAConnection xAConnection = xADataSource.getXAConnection(this.getTestConfiguration().getUserName(), this.getTestConfiguration().getUserPassword());
        Connection connection = xAConnection.getConnection();
        this.vetObject(xADataSource, hashSet, hashSet2);
        this.vetObject(xAConnection, hashSet, hashSet2);
        this.connectionWorkhorse(connection, hashSet, hashSet2);
    }

    private void connectionWorkhorse(Connection connection, HashSet<String> hashSet, HashSet<String> hashSet2) throws Exception {
        this.vetSavepoint(connection, hashSet, hashSet2);
        this.vetLargeObjects(connection, hashSet, hashSet2);
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        PreparedStatement preparedStatement = connection.prepareStatement("select * from sys.systables where tablename = ?");
        preparedStatement.setString(1, "foo");
        ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
        ResultSet resultSet = preparedStatement.executeQuery();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        Statement statement = connection.createStatement();
        CallableStatement callableStatement = connection.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(0)");
        ParameterMetaData parameterMetaData2 = callableStatement.getParameterMetaData();
        this.vetObject(databaseMetaData, hashSet, hashSet2);
        this.vetObject(statement, hashSet, hashSet2);
        this.vetObject(parameterMetaData2, hashSet, hashSet2);
        this.vetObject(callableStatement, hashSet, hashSet2);
        this.vetObject(resultSetMetaData, hashSet, hashSet2);
        this.vetObject(resultSet, hashSet, hashSet2);
        this.vetObject(parameterMetaData, hashSet, hashSet2);
        this.vetObject(preparedStatement, hashSet, hashSet2);
        this.vetObject(connection, hashSet, hashSet2);
    }

    private void vetSavepoint(Connection connection, HashSet<String> hashSet, HashSet<String> hashSet2) throws Exception {
        connection.setAutoCommit(false);
        Savepoint savepoint = connection.setSavepoint();
        this.vetObject(savepoint, hashSet, hashSet2);
        connection.releaseSavepoint(savepoint);
    }

    private void vetLargeObjects(Connection connection, HashSet<String> hashSet, HashSet<String> hashSet2) throws Exception {
        Statement statement = connection.createStatement();
        statement.execute("CREATE TABLE t (id INT PRIMARY KEY, b BLOB(10), c CLOB(10))");
        statement.execute("INSERT INTO t (id, b, c) VALUES (1, CAST (" + TestUtil.stringToHexLiteral("101010001101") + "AS BLOB(10)), CAST ('hello' AS CLOB(10)))");
        ResultSet resultSet = statement.executeQuery("SELECT id, b, c FROM t");
        resultSet.next();
        Blob blob = resultSet.getBlob(2);
        Clob clob = resultSet.getClob(3);
        this.vetObject(blob, hashSet, hashSet2);
        this.vetObject(clob, hashSet, hashSet2);
        statement.close();
        connection.rollback();
    }

    private void initializeExcludableMap(HashSet<String> hashSet) throws Exception {
        excludableMap = new Hashtable();
        for (Exclusions exclusions : rawExcludables) {
            Class clazz = exclusions.getInterface();
            MD[] mDArray = exclusions.getExcludedMethods();
            int n = mDArray.length;
            HashSet<Method> hashSet2 = new HashSet<Method>();
            for (int i = 0; i < n; ++i) {
                MD mD = mDArray[i];
                if (mD == null || !mD.requiredAtThisLevel()) continue;
                Method method = null;
                try {
                    method = clazz.getMethod(mD.getMethodName(), mD.getArgTypes());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (method == null) {
                    hashSet.add("Method has vanished from SQL interface: " + clazz.getName() + "." + mD);
                }
                hashSet2.add(method);
            }
            excludableMap.put(clazz, hashSet2);
        }
    }

    private void vetObject(Object object, HashSet<String> hashSet, HashSet<String> hashSet2) throws Exception {
        Class<?> clazz = object.getClass();
        this.vetInterfaces(object, clazz, hashSet, hashSet2);
    }

    private void vetInterfaces(Object object, Class clazz, HashSet<String> hashSet, HashSet<String> hashSet2) throws Exception {
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            this.vetInterfaces(object, clazz2, hashSet, hashSet2);
        }
        for (Class<?> clazz3 : clazz.getInterfaces()) {
            if (clazz3.getPackage().getName().equals(SQL_PACKAGE_NAME)) {
                this.vetInterfaceMethods(object, clazz3, hashSet, hashSet2);
            }
            this.vetInterfaces(object, clazz3, hashSet, hashSet2);
        }
    }

    private void vetInterfaceMethods(Object object, Class clazz, HashSet<String> hashSet, HashSet<String> hashSet2) throws Exception {
        for (Method method : this.sortMethods(clazz)) {
            this.vetMethod(object, clazz, method, hashSet, hashSet2);
        }
    }

    private Method[] sortMethods(Class clazz) throws Exception {
        int n;
        Method[] methodArray = clazz.getMethods();
        int n2 = methodArray.length;
        Method[] methodArray2 = new Method[n2];
        Object[] objectArray = new MethodSortable[n2];
        for (n = 0; n < n2; ++n) {
            objectArray[n] = new MethodSortable(methodArray[n]);
        }
        Arrays.sort(objectArray);
        for (n = 0; n < n2; ++n) {
            methodArray2[n] = ((MethodSortable)objectArray[n]).getMethod();
        }
        return methodArray2;
    }

    private void vetMethod(Object object, Class clazz, Method method, HashSet<String> hashSet, HashSet<String> hashSet2) throws Exception {
        block8: {
            try {
                method.invoke(object, this.getNullArguments(method.getParameterTypes()));
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof InvocationTargetException)) {
                    this.recordUnexpectedError(object, clazz, method, hashSet2, throwable);
                }
                Throwable throwable2 = throwable.getCause();
                if (throwable2 instanceof SQLFeatureNotSupportedException) {
                    boolean bl = this.isExcludable(method);
                    if (!bl) {
                        int n;
                        StackTraceElement[] stackTraceElementArray = throwable2.getStackTrace();
                        for (n = 0; n < stackTraceElementArray.length && !stackTraceElementArray[n].getMethodName().equals("notImplemented"); ++n) {
                        }
                        while (n < stackTraceElementArray.length && stackTraceElementArray[n].getMethodName().equals("notImplemented")) {
                            ++n;
                        }
                        if (n == stackTraceElementArray.length) {
                            // empty if block
                        }
                        hashSet.add(object.getClass().getName() + ": " + method + "@" + (Serializable)(n == stackTraceElementArray.length ? "no source" : throwable2.getStackTrace()[n]));
                    }
                }
                if (throwable2 instanceof SQLException || throwable2 instanceof NullPointerException || throwable2 instanceof ArrayIndexOutOfBoundsException) break block8;
                this.recordUnexpectedError(object, clazz, method, hashSet2, throwable2);
            }
        }
    }

    private void recordUnexpectedError(Object object, Class clazz, Method method, HashSet<String> hashSet, Throwable throwable) throws Exception {
        hashSet.add(object.getClass().getName() + " " + method + " raises " + throwable);
    }

    private boolean isExcludable(Method method) throws Exception {
        Class<?> clazz = method.getDeclaringClass();
        HashSet<Method> hashSet = excludableMap.get(clazz);
        if (hashSet == null) {
            return false;
        }
        return hashSet.contains(method);
    }

    private Object[] getNullArguments(Class[] classArray) {
        Object[] objectArray = new Object[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            objectArray[i] = this.getNullValueForType(classArray[i]);
        }
        return objectArray;
    }

    private Object getNullValueForType(Class clazz) {
        if (!clazz.isPrimitive()) {
            return null;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (clazz == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (clazz == Byte.TYPE) {
            return (byte)0;
        }
        if (clazz == Short.TYPE) {
            return (short)0;
        }
        if (clazz == Integer.TYPE) {
            return 1;
        }
        if (clazz == Long.TYPE) {
            return 0L;
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (clazz == Double.TYPE) {
            return 0.0;
        }
        UnsupportedVetter.fail((String)("Don't know how to handle type " + clazz));
        return null;
    }

    private void printUnsupportedList(HashSet<String> hashSet) {
        int n = hashSet.size();
        if (n == 0) {
            return;
        }
        UnsupportedVetter.println("--------------- UNSUPPORTED METHODS ------------------");
        UnsupportedVetter.println("--");
        Object[] objectArray = new String[n];
        hashSet.toArray(objectArray);
        Arrays.sort(objectArray);
        for (int i = 0; i < n; ++i) {
            UnsupportedVetter.println((String)objectArray[i]);
        }
    }

    private void printVanishedMethodList(HashSet<String> hashSet) {
        int n = hashSet.size();
        if (n == 0) {
            return;
        }
        UnsupportedVetter.println("--------------- VANISHED METHODS ------------------");
        UnsupportedVetter.println("--");
        Object[] objectArray = new String[n];
        hashSet.toArray(objectArray);
        Arrays.sort(objectArray);
        for (int i = 0; i < n; ++i) {
            UnsupportedVetter.println((String)objectArray[i]);
        }
    }

    private void printNotUnderstoodList(HashSet<String> hashSet) {
        int n = hashSet.size();
        if (n == 0) {
            return;
        }
        UnsupportedVetter.println("\n\n");
        UnsupportedVetter.println("--------------- NOT UNDERSTOOD METHODS ------------------");
        UnsupportedVetter.println("--");
        Object[] objectArray = new String[n];
        hashSet.toArray(objectArray);
        Arrays.sort(objectArray);
        for (int i = 0; i < n; ++i) {
            UnsupportedVetter.println((String)objectArray[i]);
        }
    }

    protected void setUp() {
        this.savedVerbosity = this.getTestConfiguration().isVerbose();
    }

    @Override
    protected void tearDown() throws Exception {
        this.getTestConfiguration().setVerbosity(this.savedVerbosity);
        super.tearDown();
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(UnsupportedVetter.class);
    }

    public static class MD {
        private String _methodName;
        private Class[] _argTypes;
        private boolean _requiredAtThisLevel;

        public MD(String string, Class[] classArray) {
            this(string, classArray, true);
        }

        public MD(String string, Class[] classArray, boolean bl) {
            this._methodName = string;
            this._argTypes = classArray;
            this._requiredAtThisLevel = bl;
        }

        public String getMethodName() {
            return this._methodName;
        }

        public Class[] getArgTypes() {
            return this._argTypes;
        }

        public boolean isOptional() {
            return true;
        }

        public boolean requiredAtThisLevel() {
            return this._requiredAtThisLevel;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this._methodName);
            stringBuffer.append("( ");
            if (this._argTypes != null) {
                int n = this._argTypes.length;
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(this._argTypes[i].getName());
                }
            }
            stringBuffer.append(" )");
            return stringBuffer.toString();
        }
    }

    public static final class Exclusions {
        private Class _class;
        private MD[] _excludedMethods;

        public Exclusions(Class clazz, MD[] mDArray) {
            this._class = clazz;
            this._excludedMethods = mDArray;
        }

        public Class getInterface() {
            return this._class;
        }

        public MD[] getExcludedMethods() {
            return this._excludedMethods;
        }
    }

    public static final class MethodSortable
    implements Comparable {
        private Method _method;

        public MethodSortable(Method method) {
            this._method = method;
        }

        public Method getMethod() {
            return this._method;
        }

        public int compareTo(Object object) {
            MethodSortable methodSortable = (MethodSortable)object;
            boolean bl = this.isCloseMethod();
            boolean bl2 = methodSortable.isCloseMethod();
            if (bl) {
                if (bl2) {
                    return 0;
                }
                return 1;
            }
            if (bl2) {
                return -1;
            }
            return this.toString().compareTo(methodSortable.toString());
        }

        public String toString() {
            return this._method.toString();
        }

        private boolean isCloseMethod() {
            return this.toString().startsWith("close()");
        }
    }

    public static final class FD
    extends MD {
        private String _methodName;
        private Class[] _argTypes;

        public FD(String string, Class[] classArray) {
            super(string, classArray);
        }

        @Override
        public boolean isOptional() {
            return false;
        }
    }
}

