/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import junit.extensions.TestSetup;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SysinfoTest
extends BaseJDBCTestCase {
    private static final String POLICY_FILE_NAME = "org/apache/derbyTesting/functionTests/tests/derbynet/SysinfoTest.policy";
    private ArrayList<String> OUTPUT;
    private static boolean useProperties = false;

    public SysinfoTest(String string) {
        super(string);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add("--------- Derby Network Server Information --------");
        arrayList.add("derby.drda.maxThreads=0");
        arrayList.add("derby.drda.sslMode=off");
        arrayList.add("derby.drda.keepAlive=true");
        arrayList.add("derby.drda.minThreads=0");
        arrayList.add("derby.drda.portNumber=" + TestConfiguration.getCurrent().getPort());
        arrayList.add("derby.drda.logConnections=false");
        arrayList.add("derby.drda.timeSlice=0");
        arrayList.add("derby.drda.startNetworkServer=false");
        arrayList.add("derby.drda.traceAll=false");
        arrayList.add("--------- Derby Information --------");
        arrayList.add("------------------------------------------------------");
        arrayList.add("----------------- Locale Information -----------------");
        arrayList.add("------------------------------------------------------");
        ArrayList<String> arrayList2 = new ArrayList<String>(arrayList);
        arrayList2.add("--------- Derby Network Server Information --------");
        arrayList2.add("derby.drda.securityMechanism=USER_ONLY_SECURITY");
        this.OUTPUT = useProperties ? arrayList2 : arrayList;
    }

    public static Test suite() {
        Properties properties;
        BaseTestSuite baseTestSuite = new BaseTestSuite("SysinfoTest");
        if (!Derby.hasServer()) {
            return baseTestSuite;
        }
        if (JDBC.vmSupportsJSR169()) {
            return baseTestSuite;
        }
        useProperties = false;
        if (!TestConfiguration.loadingFromJars()) {
            properties = new Properties();
            properties.put("sysinfotest.classesdir", SysinfoTest.findClassDir());
            baseTestSuite.addTest((Test)new SystemPropertyTestSetup(SysinfoTest.decorateTest(), properties));
        } else {
            baseTestSuite.addTest(SysinfoTest.decorateTest());
        }
        useProperties = true;
        properties = new Properties();
        if (!TestConfiguration.loadingFromJars()) {
            properties.put("sysinfotest.classesdir", SysinfoTest.findClassDir());
        }
        properties.put("derby.infolog.append", "true");
        properties.put("derby.language.logStatementText", "true");
        properties.put("derby.drda.securityMechanism", "USER_ONLY_SECURITY");
        TestSetup testSetup = new SystemPropertyTestSetup(SysinfoTest.decorateTest(), properties);
        Properties properties2 = new Properties();
        properties2.put("derby.locks.waitTimeout", "120");
        testSetup = new DatabasePropertyTestSetup((Test)testSetup, properties2);
        baseTestSuite.addTest((Test)testSetup);
        return baseTestSuite;
    }

    private static Test decorateTest() {
        Test test = TestConfiguration.clientServerSuite(SysinfoTest.class);
        return TestConfiguration.singleUseDatabaseDecorator(test);
    }

    public void testSysinfo() throws Exception {
        String[] stringArray = new String[]{"org.apache.derby.drda.NetworkServerControl", "sysinfo", "-p", String.valueOf(TestConfiguration.getCurrent().getPort())};
        Process process = SysinfoTest.execJavaCmd(stringArray);
        String string = SysinfoTest.readProcessOutput(process);
        this.print("testSysinfo", string);
        this.assertMatchingStringExists(string);
    }

    public void testSysinfoMethod() throws Exception {
        String string = NetworkServerTestSetup.getNetworkServerControl(TestConfiguration.getCurrent().getPort()).getSysinfo();
        this.print("testSysinfoMethod", string);
        this.assertMatchingStringExists(string);
    }

    public void testSysinfoLocale() throws Exception {
        String[] stringArray = new String[]{"-Duser.language=de", "-Duser.country=DE", "org.apache.derby.drda.NetworkServerControl", "sysinfo", "-p", String.valueOf(TestConfiguration.getCurrent().getPort())};
        Process process = SysinfoTest.execJavaCmd(stringArray);
        String string = SysinfoTest.readProcessOutput(process);
        this.print("testSysinfoLocale", string);
        this.assertMatchingStringExists(string);
    }

    private void print(String string, String string2) {
        SysinfoTest.println("\n\n>>>" + string + ">>>");
        SysinfoTest.println(string2);
        SysinfoTest.println("<<<" + string + "<<<\n\n");
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.OUTPUT = null;
    }

    private static String findClassDir() {
        URL uRL = TestConfiguration.getURL("org.apache.derbyTesting.functionTests.tests.derbynet.SysinfoTest");
        return uRL.getPath();
    }

    private void assertMatchingStringExists(String string) {
        for (String string2 : this.OUTPUT) {
            SysinfoTest.assertTrue((String)("cannot find " + string2 + " in actualOutput:" + string), (string.indexOf(string2) >= 0 ? 1 : 0) != 0);
        }
    }
}

