/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.junit;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Pattern;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derby.shared.common.info.JVMInfo;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.SpawnedProcess;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class MissingPermissionsTest
extends BaseJDBCTestCase {
    private static final String AUTH_MSG = "derby.connection.requireAuthentication";
    private static final String SYSTEM_HOME = "derby.system.home";
    private static final String resourcePrefix = "unitTests/junit/";
    private static final String testPrefix = "org/apache/derbyTesting/unitTests/junit/";
    private static final String OK_POLICY = "MissingPermissionsTest.policy";
    private static final String OK_POLICY_T = "org/apache/derbyTesting/unitTests/junit/MissingPermissionsTest.policy";
    private static final String OK_POLICY_R = "unitTests/junit/MissingPermissionsTest.policy";
    private static final String POLICY_MINUS_PROPERTYPERMISSION = "MissingPermissionsTest1.policy";
    private static final String POLICY_MINUS_PROPERTYPERMISSION_T = "org/apache/derbyTesting/unitTests/junit/MissingPermissionsTest1.policy";
    private static final String POLICY_MINUS_FILEPERMISSION = "MissingPermissionsTest2.policy";
    private static final String POLICY_MINUS_FILEPERMISSION_T = "org/apache/derbyTesting/unitTests/junit/MissingPermissionsTest2.policy";
    private static final String POLICY_MINUS_FILEPERMISSION_R = "unitTests/junit/MissingPermissionsTest2.policy";
    private final int KIND_EXPECT_ERROR_MSG_PRESENT = 0;
    private final int KIND_EXPECT_ERROR_MSG_ABSENT = 1;
    private static boolean inSubProcess = false;

    public MissingPermissionsTest(String string) {
        super(string);
    }

    private static Test makeTest(String string, String string2) {
        Object object = new MissingPermissionsTest(string);
        object = new SecurityManagerSetup((Test)object, string2);
        Properties properties = new Properties();
        properties.setProperty(AUTH_MSG, "true");
        properties.setProperty("derby.database.sqlAuthorization", "true");
        properties.setProperty("derby.authentication.provider", "BUILTIN");
        properties.setProperty("derby.user.APP", "APPPW");
        object = new SystemPropertyTestSetup((Test)object, properties, true);
        object = TestConfiguration.changeUserDecorator((Test)object, "APP", "APPPW");
        object = TestConfiguration.singleUseDatabaseDecorator((Test)object);
        return object;
    }

    public static Test suite() {
        inSubProcess = Boolean.getBoolean("inSubProcess");
        BaseTestSuite baseTestSuite = new BaseTestSuite("SystemPrivilegesPermissionTest");
        if (!inSubProcess && !TestConfiguration.loadingFromJars()) {
            return baseTestSuite;
        }
        if (!inSubProcess) {
            baseTestSuite.addTest((Test)new SupportFilesSetup(MissingPermissionsTest.makeTest("testMissingFilePermission", POLICY_MINUS_FILEPERMISSION_T), new String[]{POLICY_MINUS_FILEPERMISSION_R}));
            baseTestSuite.addTest(MissingPermissionsTest.makeTest("testPresentPropertiesPermission", OK_POLICY_T));
            baseTestSuite.addTest(MissingPermissionsTest.makeTest("testMissingPropertiesPermission", POLICY_MINUS_PROPERTYPERMISSION_T));
        }
        baseTestSuite.addTest((Test)new SupportFilesSetup(MissingPermissionsTest.makeTest("testModifyThreadGroup", OK_POLICY_T), new String[]{OK_POLICY_R}));
        return baseTestSuite;
    }

    public void testPresentPropertiesPermission() throws SQLException, IOException, PrivilegedActionException {
        this.openDefaultConnection("APP", "APPPW").close();
        try (Connection connection = null;){
            connection = this.openDefaultConnection("Donald", "Duck");
            MissingPermissionsTest.fail();
        }
        this.verifyMessagesInDerbyLog(1);
    }

    public void testMissingPropertiesPermission() throws SQLException, IOException, PrivilegedActionException {
        this.openDefaultConnection("APP", "APPPW").close();
        this.openDefaultConnection("Donald", "Duck").close();
        this.verifyMessagesInDerbyLog(0);
    }

    public void testMissingFilePermission() throws SQLException, IOException, PrivilegedActionException, ClassNotFoundException, InterruptedException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add("-Djava.security.manager");
        arrayList.add("-Djava.security.policy=extin/MissingPermissionsTest2.policy");
        arrayList.add("-DderbyTesting.engine=" + MissingPermissionsTest.getSystemProperty("derbyTesting.engine"));
        arrayList.add("-DderbyTesting.tools=" + MissingPermissionsTest.getSystemProperty("derbyTesting.tools"));
        arrayList.add("-DderbyTesting.testing=" + MissingPermissionsTest.getSystemProperty("derbyTesting.testing"));
        arrayList.add("-DderbyTesting.shared=" + MissingPermissionsTest.getSystemProperty("derbyTesting.shared"));
        arrayList.add("-DderbyTesting.junit=" + MissingPermissionsTest.getSystemProperty("derbyTesting.junit"));
        String string = MissingPermissionsTest.getSystemProperty("derbyTesting.antjunit");
        if (string != null) {
            arrayList.add("-DderbyTesting.antjunit=" + string);
        }
        arrayList.add("-Dderby.system.home=system/nested");
        arrayList.add("-Dij.connection.test=jdbc:derby:wombat;create=true");
        arrayList.add("org.apache.derby.tools.ij");
        String[] stringArray = arrayList.toArray(new String[0]);
        Process process = MissingPermissionsTest.execJavaCmd(stringArray);
        SpawnedProcess spawnedProcess = new SpawnedProcess(process, "MPT");
        spawnedProcess.suppressOutputOnComplete();
        process.getOutputStream().close();
        int n = spawnedProcess.complete(120000L);
        MissingPermissionsTest.assertTrue((String)spawnedProcess.getFailMessage("subprocess run failed: "), (n == 0 ? 1 : 0) != 0);
        String string2 = spawnedProcess.getFullServerOutput();
        String string3 = spawnedProcess.getFullServerError();
        MissingPermissionsTest.assertTrue((string3.contains("java.security.AccessControlException") && string3.contains("ccess denied") && string3.contains("java.io.FilePermission") && string3.contains("system") && string3.contains("nested") && string3.contains("write") ? 1 : 0) != 0);
    }

    private String makeMessage(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(?s).*WARNING: the property ");
        stringBuilder.append(Pattern.quote(string));
        stringBuilder.append(" could not be read due to a security exception: ");
        stringBuilder.append("java\\.security\\.AccessControlException: [Aa]ccess denied \\(");
        stringBuilder.append("\"?java\\.util\\.PropertyPermission\"? \"?");
        stringBuilder.append(Pattern.quote(string));
        stringBuilder.append("\"? \"?read\"?.*");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyMessagesInDerbyLog(int n) throws FileNotFoundException, IOException, PrivilegedActionException {
        String string = null;
        if (n == 0) {
            string = "derby.log";
        } else if (n == 1) {
            string = "system/derby.log";
        }
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader bufferedReader = MissingPermissionsTest.getReader(string);){
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                stringBuilder.append(string2);
                stringBuilder.append('\n');
                string2 = bufferedReader.readLine();
            }
            string2 = stringBuilder.toString();
            if (n == 0) {
                MissingPermissionsTest.assertTrue((String)string2, (boolean)string2.matches(this.makeMessage(AUTH_MSG)));
                MissingPermissionsTest.assertTrue((String)string2, (boolean)string2.matches(this.makeMessage(SYSTEM_HOME)));
            } else if (n == 1) {
                MissingPermissionsTest.assertFalse((String)string2, (boolean)string2.matches(this.makeMessage(AUTH_MSG)));
                MissingPermissionsTest.assertFalse((String)string2, (boolean)string2.matches(this.makeMessage(SYSTEM_HOME)));
            }
        }
    }

    private static BufferedReader getReader(final String string) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<BufferedReader>(){

            @Override
            public BufferedReader run() throws FileNotFoundException {
                return new BufferedReader(new FileReader(string));
            }
        });
    }

    public void testModifyThreadGroup() throws Throwable {
        if (!inSubProcess) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add("-DinSubProcess=true");
            arrayList.add("-Djava.security.manager");
            arrayList.add("-Djava.security.policy=extin/MissingPermissionsTest.policy");
            arrayList.add("-DderbyTesting.engine=" + MissingPermissionsTest.getSystemProperty("derbyTesting.engine"));
            arrayList.add("-DderbyTesting.tools=" + MissingPermissionsTest.getSystemProperty("derbyTesting.tools"));
            arrayList.add("-DderbyTesting.testing=" + MissingPermissionsTest.getSystemProperty("derbyTesting.testing"));
            arrayList.add("-DderbyTesting.shared=" + MissingPermissionsTest.getSystemProperty("derbyTesting.shared"));
            arrayList.add("-DderbyTesting.junit=" + MissingPermissionsTest.getSystemProperty("derbyTesting.junit"));
            String string = MissingPermissionsTest.getSystemProperty("derbyTesting.antjunit");
            if (string != null) {
                arrayList.add("-DderbyTesting.antjunit=" + string);
            }
            arrayList.add("-Dderby.system.home=system/nested_tMTG");
            arrayList.add("-Dderby.system.durability=" + MissingPermissionsTest.getSystemProperty("derby.system.durability"));
            arrayList.add("-Dderby.tests.trace=" + MissingPermissionsTest.getSystemProperty("derby.tests.trace"));
            arrayList.add("-Dderby.system.debug=" + MissingPermissionsTest.getSystemProperty("derby.tests.debug"));
            String string2 = "junit.textui.TestRunner";
            if (JVMInfo.isModuleAware()) {
                arrayList.add("-m");
                arrayList.add("junit/" + string2);
            } else {
                arrayList.add(string2);
            }
            arrayList.add(((Object)((Object)this)).getClass().getName());
            String[] stringArray = arrayList.toArray(new String[0]);
            Process process = MissingPermissionsTest.execJavaCmd(stringArray);
            SpawnedProcess spawnedProcess = new SpawnedProcess(process, "MPT");
            spawnedProcess.suppressOutputOnComplete();
            process.getOutputStream().close();
            int n = spawnedProcess.complete(120000L);
            MissingPermissionsTest.assertTrue((String)spawnedProcess.getFailMessage("subprocess run failed: "), (n == 1 ? 1 : 0) != 0);
            String string3 = JVMInfo.isModuleAware() ? "java.security.AccessControlException: access denied (\"java.lang.RuntimePermission\" \"modifyThreadGroup\")" : "WARNING: could not do ThreadGroup#setDaemon on Derby daemons due to a security exception";
            String string4 = spawnedProcess.getFullServerOutput();
            String string5 = spawnedProcess.getFullServerError();
            MissingPermissionsTest.assertTrue((String)("Full error is '" + string5 + "'"), (boolean)string5.contains(string3));
            if (Boolean.parseBoolean(MissingPermissionsTest.getSystemProperty("derby.tests.trace")) || Boolean.parseBoolean(MissingPermissionsTest.getSystemProperty("derby.tests.debug"))) {
                System.out.println("\n[ (subprocess) " + string4.replace("\n", "\n  (subprocess) ") + "]\n");
            }
        } else {
            final SystemThreadRun systemThreadRun = new SystemThreadRun(this);
            Thread thread = AccessController.doPrivileged(new PrivilegedAction<Thread>(){

                @Override
                public Thread run() {
                    return new Thread(Thread.currentThread().getThreadGroup().getParent(), systemThreadRun);
                }
            });
            thread.start();
            thread.join();
            MissingPermissionsTest.assertTrue((boolean)(systemThreadRun.f instanceof AccessControlException));
            this.openDefaultConnection("APP", "APPPW").close();
        }
    }

    private class SystemThreadRun
    implements Runnable {
        public Throwable f;
        private final BaseJDBCTestCase test;

        public SystemThreadRun(BaseJDBCTestCase baseJDBCTestCase) {
            this.test = baseJDBCTestCase;
        }

        @Override
        public void run() {
            try {
                Assert.assertEquals((String)Thread.currentThread().getThreadGroup().getName(), (String)"system");
                this.test.openDefaultConnection("APP", "APPPW").close();
                Assert.fail();
            }
            catch (Throwable throwable) {
                this.f = throwable;
            }
        }
    }
}

