/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.DerbyVersion;

public class DerbyDistribution
implements Comparable<DerbyDistribution> {
    private static File[] EMPTY_FILE_ARRAY = new File[0];
    public static final String JAR_RUN = "derbyrun.jar";
    public static final String JAR_CLIENT = "derbyclient.jar";
    public static final String JAR_ENGINE = "derby.jar";
    public static final String JAR_NET = "derbynet.jar";
    public static final String JAR_SHARED = "derbyshared.jar";
    public static final String JAR_TOOLS = "derbytools.jar";
    public static final String JAR_TESTING = "derbyTesting.jar";
    private static final String[] REQUIRED_JARS = new String[]{"derby.jar", "derbynet.jar", "derbyclient.jar"};
    private final DerbyVersion version;
    private final String derbyRunJarPath;
    private final String derbyClientJarPath;
    private final String derbyEngineJarPath;
    private final String derbyNetJarPath;
    private final String derbySharedJarPath;
    private final String derbyToolsJarPath;
    private final String productionClasspath;
    private final String testingClasspath;

    private DerbyDistribution(DerbyVersion derbyVersion, File[] fileArray, File[] fileArray2) {
        if (derbyVersion == null) {
            throw new NullPointerException("version is null");
        }
        this.version = derbyVersion;
        this.productionClasspath = DerbyDistribution.constructJarClasspath(fileArray);
        this.testingClasspath = DerbyDistribution.constructJarClasspath(fileArray2);
        File file = fileArray[0].getParentFile();
        this.derbyRunJarPath = this.getPath(file, JAR_RUN);
        this.derbyClientJarPath = this.getPath(file, JAR_CLIENT);
        this.derbyEngineJarPath = this.getPath(file, JAR_ENGINE);
        this.derbyNetJarPath = this.getPath(file, JAR_NET);
        this.derbySharedJarPath = this.getPath(file, JAR_SHARED);
        this.derbyToolsJarPath = this.getPath(file, JAR_TOOLS);
    }

    private String getPath(File file, String string) {
        File file2 = new File(file, string);
        if (PrivilegedFileOpsForTests.exists(file2)) {
            return file2.getAbsolutePath();
        }
        return null;
    }

    public boolean hasDerbyRunJar() {
        return this.derbyRunJarPath != null;
    }

    public String getDerbyRunJarPath() {
        return this.derbyRunJarPath;
    }

    public String getDerbyClientJarPath() {
        Object object = this.derbyClientJarPath;
        if (this.version.atLeast(DerbyVersion.FIRST_JIGSAW_VERSION)) {
            object = (String)object + File.pathSeparator + this.getDerbySharedJarPath() + File.pathSeparator + this.getDerbyToolsJarPath();
        }
        return object;
    }

    public String getDerbyEngineJarPath() {
        Object object = this.derbyEngineJarPath;
        if (this.version.atLeast(DerbyVersion.FIRST_JIGSAW_VERSION)) {
            object = (String)object + File.pathSeparator + this.getDerbySharedJarPath() + File.pathSeparator + this.getDerbyToolsJarPath();
        }
        return object;
    }

    public String getDerbyNetJarPath() {
        return this.derbyEngineJarPath;
    }

    public String getDerbySharedJarPath() {
        return this.derbySharedJarPath;
    }

    public String getDerbyToolsJarPath() {
        return this.derbyToolsJarPath;
    }

    public String getServerClasspath() {
        return this.derbyNetJarPath + File.pathSeparator + this.getDerbyEngineJarPath();
    }

    public String getProductionClasspath() {
        return this.productionClasspath;
    }

    public String getTestingClasspath() {
        return this.testingClasspath;
    }

    public String getFullClassPath() {
        return this.productionClasspath + File.pathSeparatorChar + this.testingClasspath;
    }

    public DerbyVersion getVersion() {
        return this.version;
    }

    @Override
    public int compareTo(DerbyDistribution derbyDistribution) {
        return this.version.compareTo(derbyDistribution.version);
    }

    private static boolean hasRequiredJars(List list) {
        for (int i = 0; i < REQUIRED_JARS.length; ++i) {
            boolean bl = false;
            for (File file : list) {
                if (!file.getName().equalsIgnoreCase(REQUIRED_JARS[i])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            BaseTestCase.println("missing jar: " + REQUIRED_JARS[i]);
            return false;
        }
        return true;
    }

    private static File[] getProductionJars(File file) {
        File[] fileArray = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.toUpperCase().endsWith(".JAR") && !DerbyDistribution.isTestingJar(string);
            }
        });
        if (fileArray == null) {
            return EMPTY_FILE_ARRAY;
        }
        return fileArray;
    }

    private static File[] getTestingJars(File file) {
        File[] fileArray = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return DerbyDistribution.isTestingJar(string);
            }
        });
        if (fileArray == null) {
            return EMPTY_FILE_ARRAY;
        }
        return fileArray;
    }

    public static File[] getJars(File file) {
        File[] fileArray = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.toUpperCase().endsWith(".JAR");
            }
        });
        return fileArray;
    }

    private static boolean isTestingJar(String string) {
        return string.toUpperCase().endsWith(JAR_TESTING.toUpperCase());
    }

    private static String constructJarClasspath(File[] fileArray) {
        StringBuffer stringBuffer = new StringBuffer(512);
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                stringBuffer.append(fileArray[i].getCanonicalPath());
            }
            catch (IOException iOException) {
                String string = fileArray[i].getAbsolutePath();
                stringBuffer.append(string);
                BaseTestCase.println("obtaining canonical path for " + string + " failed: " + iOException.getMessage());
            }
            stringBuffer.append(File.pathSeparatorChar);
        }
        if (fileArray.length > 0) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public static DerbyDistribution newInstance(DerbyVersion derbyVersion, File file) {
        return DerbyDistribution.newInstance(derbyVersion, file, file);
    }

    public static DerbyDistribution newInstance(DerbyVersion derbyVersion, File file, File file2) {
        File[] fileArray = DerbyDistribution.getProductionJars(file);
        File[] fileArray2 = DerbyDistribution.getTestingJars(file2);
        ArrayList<File> arrayList = new ArrayList<File>();
        arrayList.addAll(Arrays.asList(fileArray));
        arrayList.addAll(Arrays.asList(fileArray2));
        if (DerbyDistribution.hasRequiredJars(arrayList)) {
            return new DerbyDistribution(derbyVersion, fileArray, fileArray2);
        }
        BaseTestCase.println("Distribution deemed invalid (note that running off classes isn't supported): " + file.getAbsolutePath() + (String)(file.equals(file2) ? "" : ", " + file2.getAbsolutePath()));
        return null;
    }
}

