/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.derbyTesting.functionTests.tests.jdbc4.Wrapper41;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;

public class Wrapper41Test
extends BaseJDBCTestCase {
    private static final String UNSUPPORTED_COERCION = "22005";
    private static final String BAD_FORMAT = "22018";
    private static final String BAD_DATETIME = "22007";
    private static final String VARIABLE_STRING = "XXXXX";
    public static final byte[] BINARY_VALUE = new byte[]{-34};
    static final long TIME_VALUE = 83342000L;
    static final long TIMESTAMP_VALUE = -229527385766L;
    private Class _byteArrayClass;
    private boolean _rowOfNulls;

    public Wrapper41Test(String string) {
        super(string);
    }

    protected void examineJDBC4_1extensions(Wrapper41 wrapper41, boolean bl) throws Exception {
        Wrapper41Test.println("Vetting a " + wrapper41.getWrappedObject().getClass().getName() + ". rowOfNulls = " + bl);
        this._byteArrayClass = Class.forName("[B");
        this._rowOfNulls = bl;
        this.vetWrappedNull(wrapper41);
        this.vetWrappedInteger(wrapper41, 1, "BIGINTCOL");
        this.vetWrappedBlob(wrapper41);
        this.vetWrappedBoolean(wrapper41);
        this.vetWrappedString(wrapper41, 4, "CHARCOL");
        this.vetWrappedBinary(wrapper41, 5, "CHARFORBITDATACOL");
        this.vetWrappedClob(wrapper41);
        this.vetWrappedDate(wrapper41);
        this.vetWrappedFloatingPoint(wrapper41, 8, "DOUBLECOL");
        this.vetWrappedFloatingPoint(wrapper41, 9, "FLOATCOL");
        this.vetWrappedInteger(wrapper41, 10, "INTCOL");
        this.vetWrappedString(wrapper41, 11, "LONGVARCHARCOL");
        this.vetWrappedBinary(wrapper41, 12, "LONGVARCHARFORBITDATACOL");
        this.vetWrappedInteger(wrapper41, 13, "NUMERICCOL");
        this.vetWrappedFloatingPoint(wrapper41, 14, "REALCOL");
        this.vetWrappedInteger(wrapper41, 15, "SMALLINTCOL");
        this.vetWrappedTime(wrapper41);
        this.vetWrappedTimestamp(wrapper41);
        this.vetWrappedString(wrapper41, 18, "VARCHARCOL");
        this.vetWrappedBinary(wrapper41, 19, "VARCHARFORBITDATACOL");
    }

    private void vetWrappedNull(Wrapper41 wrapper41) throws Exception {
        try {
            wrapper41.getObject(1, (Class)null);
            Wrapper41Test.fail((String)"Did not expect to get a result for a null class type.");
        }
        catch (SQLException sQLException) {
            Wrapper41Test.assertSQLState("Null type", UNSUPPORTED_COERCION, sQLException);
        }
        if (wrapper41.getWrappedObject() instanceof CallableStatement) {
            return;
        }
        try {
            wrapper41.getObject("BIGINTCOL", (Class)null);
            Wrapper41Test.fail((String)"Did not expect to get a result for a null class type.");
        }
        catch (SQLException sQLException) {
            Wrapper41Test.assertSQLState("Null type", UNSUPPORTED_COERCION, sQLException);
        }
    }

    private void vetWrappedInteger(Wrapper41 wrapper41, int n, String string) throws Exception {
        this.vetWrapperOK(wrapper41, n, string, this._rowOfNulls ? null : "1", new Class[]{String.class, BigDecimal.class, Byte.class, Short.class, Integer.class, Long.class, Number.class, Object.class});
        this.vetWrapperOK(wrapper41, n, string, this._rowOfNulls ? null : "1.0", new Class[]{Float.class, Double.class});
        this.vetWrapperOK(wrapper41, n, string, this._rowOfNulls ? null : "true", new Class[]{Boolean.class});
        this.vetNoWrapper(wrapper41, n, string, new Class[]{Date.class, Time.class, Timestamp.class, Blob.class, Clob.class, this._byteArrayClass, ((Object)((Object)this)).getClass()});
    }

    private void vetWrappedBlob(Wrapper41 wrapper41) throws Exception {
        this.vetWrapperOK(wrapper41, 2, "BLOBCOL", this._rowOfNulls ? null : BINARY_VALUE, new Class[]{Blob.class, Object.class, this._byteArrayClass, String.class});
        this.vetNoWrapper(wrapper41, 2, "BLOBCOL", new Class[]{BigDecimal.class, Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Date.class, Time.class, Timestamp.class});
    }

    private void vetWrappedBoolean(Wrapper41 wrapper41) throws Exception {
        this.vetWrapperOK(wrapper41, 3, "BOOLEANCOL", this._rowOfNulls ? null : "true", new Class[]{String.class, Boolean.class, Object.class});
        this.vetWrapperOK(wrapper41, 3, "BOOLEANCOL", this._rowOfNulls ? null : "1", new Class[]{BigDecimal.class, Byte.class, Short.class, Integer.class, Long.class});
        this.vetWrapperOK(wrapper41, 3, "BOOLEANCOL", this._rowOfNulls ? null : "1.0", new Class[]{Float.class, Double.class});
        this.vetNoWrapper(wrapper41, 3, "BOOLEANCOL", new Class[]{Date.class, Time.class, Timestamp.class, Blob.class, Clob.class, this._byteArrayClass, ((Object)((Object)this)).getClass()});
    }

    private void vetWrappedString(Wrapper41 wrapper41, int n, String string) throws Exception {
        this.vetWrapperOK(wrapper41, n, string, this._rowOfNulls ? null : "a", new Class[]{String.class, Object.class});
        this.vetWrapperOK(wrapper41, n, string, this._rowOfNulls ? null : "true", new Class[]{Boolean.class});
        this.vetCoercionError(wrapper41, n, string, new Class[]{BigDecimal.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class}, BAD_FORMAT);
        this.vetCoercionError(wrapper41, n, string, new Class[]{Date.class, Time.class, Timestamp.class}, BAD_DATETIME);
        this.vetNoWrapper(wrapper41, n, string, new Class[]{Blob.class, Clob.class, this._byteArrayClass, ((Object)((Object)this)).getClass()});
    }

    private void vetWrappedBinary(Wrapper41 wrapper41, int n, String string) throws Exception {
        this.vetWrapperOK(wrapper41, n, string, this._rowOfNulls ? null : "de", new Class[]{String.class});
        this.vetWrapperOK(wrapper41, n, string, this._rowOfNulls ? null : BINARY_VALUE, new Class[]{this._byteArrayClass, Object.class});
        this.vetNoWrapper(wrapper41, n, string, new Class[]{Boolean.class, BigDecimal.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Date.class, Time.class, Timestamp.class, Blob.class, Clob.class, ((Object)((Object)this)).getClass()});
    }

    private void vetWrappedClob(Wrapper41 wrapper41) throws Exception {
        this.vetWrapperOK(wrapper41, 6, "CLOBCOL", this._rowOfNulls ? null : "abc", new Class[]{String.class, Clob.class, Object.class});
        this.vetNoWrapper(wrapper41, 6, "CLOBCOL", new Class[]{Boolean.class, BigDecimal.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Date.class, Time.class, Timestamp.class, this._byteArrayClass});
    }

    private void vetWrappedDate(Wrapper41 wrapper41) throws Exception {
        this.vetWrapperOK(wrapper41, 7, "DATECOL", this._rowOfNulls ? null : "1994-02-23", new Class[]{String.class, Date.class, Object.class});
        this.vetWrapperOK(wrapper41, 7, "DATECOL", this._rowOfNulls ? null : "1994-02-23 00:00:00.0", new Class[]{Timestamp.class});
        this.vetNoWrapper(wrapper41, 7, "DATECOL", new Class[]{Boolean.class, BigDecimal.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Time.class, Blob.class, Clob.class, this._byteArrayClass, ((Object)((Object)this)).getClass()});
    }

    private void vetWrappedFloatingPoint(Wrapper41 wrapper41, int n, String string) throws Exception {
        this.vetWrapperOK(wrapper41, n, string, this._rowOfNulls ? null : "1.0", new Class[]{String.class, Float.class, Double.class, BigDecimal.class, Number.class, Object.class});
        this.vetWrapperOK(wrapper41, n, string, this._rowOfNulls ? null : "1", new Class[]{Byte.class, Short.class, Integer.class, Long.class});
        this.vetWrapperOK(wrapper41, n, string, this._rowOfNulls ? null : "true", new Class[]{Boolean.class});
        this.vetNoWrapper(wrapper41, n, string, new Class[]{Date.class, Time.class, Timestamp.class, Blob.class, Clob.class, this._byteArrayClass, ((Object)((Object)this)).getClass()});
    }

    private void vetWrappedTime(Wrapper41 wrapper41) throws Exception {
        Time time = new Time(83342000L);
        this.vetWrapperOK(wrapper41, 16, "TIMECOL", this._rowOfNulls ? null : time.toString(), new Class[]{String.class, Time.class, Object.class});
        this.vetWrapperOK(wrapper41, 16, "TIMECOL", this._rowOfNulls ? null : Wrapper41Test.timeToTimestamp(time).toString(), new Class[]{Timestamp.class});
        this.vetNoWrapper(wrapper41, 16, "TIMECOL", new Class[]{Boolean.class, BigDecimal.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Date.class, Blob.class, Clob.class, this._byteArrayClass, ((Object)((Object)this)).getClass()});
    }

    private void vetWrappedTimestamp(Wrapper41 wrapper41) throws Exception {
        String string = new Timestamp(-229527385766L).toString();
        this.vetWrapperOK(wrapper41, 17, "TIMESTAMPCOL", this._rowOfNulls ? null : string, new Class[]{String.class, Timestamp.class, Object.class});
        String string2 = new Time(-229527385766L).toString();
        this.vetWrapperOK(wrapper41, 17, "TIMESTAMPCOL", this._rowOfNulls ? null : string2, new Class[]{Time.class});
        String string3 = new Date(-229527385766L).toString();
        this.vetWrapperOK(wrapper41, 17, "TIMESTAMPCOL", this._rowOfNulls ? null : string3, new Class[]{Date.class});
        this.vetNoWrapper(wrapper41, 17, "TIMESTAMPCOL", new Class[]{Boolean.class, BigDecimal.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Blob.class, Clob.class, this._byteArrayClass, ((Object)((Object)this)).getClass()});
    }

    private void vetWrapperOK(Wrapper41 wrapper41, int n, String string, Object object, Class[] classArray) throws Exception {
        for (Class clazz : classArray) {
            this.vetCandidate(clazz, object, wrapper41.getObject(n, clazz));
            if (clazz == Blob.class || clazz == Clob.class) {
                return;
            }
            if (wrapper41.getWrappedObject() instanceof CallableStatement) continue;
            this.vetCandidate(clazz, object, wrapper41.getObject(string, clazz));
        }
    }

    private void vetCandidate(Class<?> clazz, Object object, Object object2) throws Exception {
        String string;
        if (object2 != null) {
            Wrapper41Test.assertTrue((String)clazz.getName(), (boolean)clazz.isAssignableFrom(object2.getClass()));
        }
        if (object == null) {
            Wrapper41Test.assertNull((Object)object2);
            return;
        }
        if (VARIABLE_STRING.equals(object)) {
            return;
        }
        if (object2 instanceof Blob) {
            Blob blob = (Blob)object2;
            this.vetBytes((byte[])object, blob.getBytes(1L, (int)blob.length()));
            return;
        }
        if (object2 instanceof byte[]) {
            this.vetBytes((byte[])object, (byte[])object2);
            return;
        }
        if (object2 instanceof Clob) {
            Clob clob = (Clob)object2;
            string = clob.getSubString(1L, (int)clob.length());
        } else {
            string = object2.toString();
        }
        Wrapper41Test.assertEquals((String)clazz.getName(), (String)((String)object), (String)string);
    }

    private void vetBytes(byte[] byArray, byte[] byArray2) throws Exception {
        int n = byArray.length;
        Wrapper41Test.assertEquals((int)n, (int)byArray2.length);
        for (int i = 0; i < n; ++i) {
            Wrapper41Test.assertEquals((byte)byArray[i], (byte)byArray2[i]);
        }
    }

    private void vetNoWrapper(Wrapper41 wrapper41, int n, String string, Class[] classArray) throws Exception {
        this.vetCoercionError(wrapper41, n, string, classArray, UNSUPPORTED_COERCION);
    }

    private void vetCoercionError(Wrapper41 wrapper41, int n, String string, Class[] classArray, String string2) throws Exception {
        if (this._rowOfNulls) {
            return;
        }
        for (Class clazz : classArray) {
            try {
                wrapper41.getObject(n, clazz);
                Wrapper41Test.fail((String)("Did not expect to get a " + clazz.getName()));
            }
            catch (SQLException sQLException) {
                Wrapper41Test.assertSQLState(clazz.getName(), string2, sQLException);
            }
            if (clazz == Blob.class || clazz == Clob.class) {
                return;
            }
            if (wrapper41.getWrappedObject() instanceof CallableStatement) {
                return;
            }
            try {
                wrapper41.getObject(string, clazz);
                Wrapper41Test.fail((String)("Did not expect to get a " + clazz.getName()));
            }
            catch (SQLException sQLException) {
                Wrapper41Test.assertSQLState(clazz.getName(), string2, sQLException);
            }
        }
    }

    protected PreparedStatement prepareStatement(Connection connection, String string) throws Exception {
        Wrapper41Test.println(string);
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        return preparedStatement;
    }

    protected CallableStatement prepareCall(Connection connection, String string) throws Exception {
        Wrapper41Test.println(string);
        CallableStatement callableStatement = connection.prepareCall(string);
        return callableStatement;
    }

    private static Timestamp timeToTimestamp(Time time) {
        int[] nArray;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        Calendar calendar2 = Calendar.getInstance();
        for (int n : nArray = new int[]{11, 12, 13, 14}) {
            calendar2.set(n, calendar.get(n));
        }
        return new Timestamp(calendar2.getTimeInMillis());
    }
}

