/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseJDBCTestSetup;
import org.apache.derbyTesting.junit.BaseTestCase;

public class SURDataModelSetup
extends BaseJDBCTestSetup {
    private final SURDataModel model;
    static final int recordCount = 10;

    public SURDataModelSetup(Test test, SURDataModel sURDataModel) {
        super(test);
        this.model = sURDataModel;
    }

    public static void createDataModel(SURDataModel sURDataModel, Connection connection, int n) throws SQLException {
        BaseJDBCTestCase.dropTable(connection, "T1");
        Statement statement = connection.createStatement();
        statement.execute(sURDataModel.getCreateTableStatement());
        BaseTestCase.println(sURDataModel.getCreateTableStatement());
        if (sURDataModel.hasSecondaryKey()) {
            statement.execute("create index a_on_t on t1(a)");
            BaseTestCase.println("create index a_on_t on t1(a)");
        }
        PreparedStatement preparedStatement = connection.prepareStatement("insert into t1 values (?,?,?,?,?)");
        for (int i = 0; i < n; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setInt(2, i);
            preparedStatement.setInt(3, i * 2 + 17);
            preparedStatement.setString(4, "Tuple " + i);
            preparedStatement.setString(5, "C-tuple " + i);
            preparedStatement.addBatch();
        }
        preparedStatement.executeBatch();
        preparedStatement.close();
        statement.close();
        connection.commit();
    }

    public static void createDataModel(SURDataModel sURDataModel, Connection connection) throws SQLException {
        SURDataModelSetup.createDataModel(sURDataModel, connection, 10);
    }

    protected void setUp() throws Exception {
        this.println("Setting up datamodel: " + this.model);
        try {
            Connection connection = this.getConnection();
            connection.setAutoCommit(false);
            SURDataModelSetup.createDataModel(this.model, connection);
        }
        catch (SQLException sQLException) {
            SURDataModelSetup.printStackTrace(sQLException);
            throw sQLException;
        }
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            Connection connection = this.getConnection();
            connection.rollback();
            connection.createStatement().execute("drop table t1");
            connection.commit();
        }
        catch (SQLException sQLException) {
            SURDataModelSetup.printStackTrace(sQLException);
        }
        super.tearDown();
    }

    public String toString() {
        return "SURDataModel tests with model: " + this.model;
    }

    static void printStackTrace(Throwable throwable) {
        BaseJDBCTestCase.printStackTrace(throwable);
    }

    public static final class SURDataModel {
        public static final SURDataModel MODEL_WITH_NO_KEYS = new SURDataModel("NO_KEYS");
        public static final SURDataModel MODEL_WITH_PK = new SURDataModel("PK");
        public static final SURDataModel MODEL_WITH_SECONDARY_KEY = new SURDataModel("SECONDARY_KEY");
        public static final SURDataModel MODEL_WITH_PK_AND_SECONDARY_KEY = new SURDataModel("PK_AND_SECONDARY_KEY");
        private static final Set values = Collections.unmodifiableSet(new HashSet<SURDataModel>(Arrays.asList(MODEL_WITH_NO_KEYS, MODEL_WITH_PK, MODEL_WITH_SECONDARY_KEY, MODEL_WITH_PK_AND_SECONDARY_KEY)));
        private final String name;

        public static final Set values() {
            return values;
        }

        public boolean hasPrimaryKey() {
            return this == MODEL_WITH_PK || this == MODEL_WITH_PK_AND_SECONDARY_KEY;
        }

        public boolean hasSecondaryKey() {
            return this == MODEL_WITH_SECONDARY_KEY || this == MODEL_WITH_PK_AND_SECONDARY_KEY;
        }

        public String getCreateTableStatement() {
            return this.hasPrimaryKey() ? "create table t1 (id int primary key, a int, b int, c varchar(5000), d clob)" : "create table t1 (id int, a int, b int, c varchar(5000), d clob)";
        }

        public String toString() {
            return this.name;
        }

        private SURDataModel(String string) {
            this.name = string;
        }
    }
}

