/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ServerPropertiesTest
extends BaseJDBCTestCase {
    private static final String POLICY_FILE_NAME = "org/apache/derbyTesting/functionTests/tests/derbynet/ServerPropertiesTest.policy";
    private int[] portsSoFar;
    private int basePort = TestConfiguration.getCurrent().getPort();

    public ServerPropertiesTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("ServerPropertiesTest");
        if (!Derby.hasServer()) {
            return baseTestSuite;
        }
        if (JDBC.vmSupportsJSR169()) {
            return baseTestSuite;
        }
        baseTestSuite.addTest(ServerPropertiesTest.decorateTest("ttestSetPortPriority", new String[0], new String[0], false));
        String[] stringArray = new String[]{"derby.drda.logConnections=", "derby.drda.traceAll=", "derby.drda.traceDirectory=", "derby.drda.keepAlive=", "derby.drda.timeSlice=", "derby.drda.host=", "derby.drda.portNumber=", "derby.drda.minThreads=", "derby.drda.maxThreads=", "derby.drda.startNetworkServer=", "derby.drda.debug="};
        if (TestConfiguration.loadingFromJars()) {
            baseTestSuite.addTest(ServerPropertiesTest.decorateTest("ttestDefaultProperties", stringArray, new String[0], true));
        }
        if (!Locale.getDefault().getLanguage().equals("en")) {
            return baseTestSuite;
        }
        Test test = TestConfiguration.clientServerSuite(ServerPropertiesTest.class);
        test = ServerPropertiesTest.decorateWithPolicy(test);
        baseTestSuite.addTest(test);
        return baseTestSuite;
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.portsSoFar != null) {
            for (int i = 0; i < this.portsSoFar.length; ++i) {
                try {
                    this.shutdownServer(this.portsSoFar[i], true);
                    continue;
                }
                catch (SQLException sQLException) {
                    ServerPropertiesTest.fail((String)("could not shutdown server at port " + this.portsSoFar[i]));
                }
            }
            this.portsSoFar = null;
        }
    }

    private static Test decorateTest(String string, String[] stringArray, String[] stringArray2, boolean bl) {
        ServerPropertiesTest serverPropertiesTest = new ServerPropertiesTest(string);
        String[] stringArray3 = stringArray == null ? new String[]{} : stringArray;
        if (stringArray2 == null) {
            stringArray2 = new String[]{};
        }
        NetworkServerTestSetup networkServerTestSetup = bl ? new NetworkServerTestSetup((Test)serverPropertiesTest, stringArray3, stringArray2, true) : new NetworkServerTestSetup((Test)serverPropertiesTest, true, false);
        Test test = ServerPropertiesTest.decorateWithPolicy((Test)networkServerTestSetup);
        test = TestConfiguration.defaultServerDecorator(test);
        return test;
    }

    private static Test decorateWithPolicy(Test test) {
        return new SecurityManagerSetup(test, POLICY_FILE_NAME);
    }

    private static Properties getTheProperties() {
        Properties properties;
        try {
            properties = NetworkServerTestSetup.getNetworkServerControl().getCurrentProperties();
        }
        catch (Exception exception) {
            properties = null;
            exception.printStackTrace();
            ServerPropertiesTest.fail((String)"unexpected exception getting properties from server");
        }
        return properties;
    }

    private static void verifyProperties(String string) {
        Properties properties = ServerPropertiesTest.getTheProperties();
        ServerPropertiesTest.assertPropertyValueCorrect(properties, string);
        properties = null;
    }

    private static void verifyProperties(String[] stringArray) {
        int n;
        Properties properties = ServerPropertiesTest.getTheProperties();
        for (n = 0; n < stringArray.length; ++n) {
            ServerPropertiesTest.println("expV: " + stringArray[n]);
        }
        ServerPropertiesTest.assertEquals((int)stringArray.length, (int)properties.size());
        for (n = 0; n < stringArray.length; ++n) {
            ServerPropertiesTest.assertPropertyValueCorrect(properties, stringArray[n]);
        }
        properties = null;
    }

    private static void assertPropertyValueCorrect(Properties properties, String string) {
        String[] stringArray = string.split("=");
        try {
            String string2 = properties.getProperty(stringArray[0]);
            ServerPropertiesTest.println("exppropName: " + stringArray[0]);
            ServerPropertiesTest.println("exppropValue: " + stringArray[1]);
            ServerPropertiesTest.println("actualpropValue: " + string2);
            ServerPropertiesTest.assertEquals((String)stringArray[1], (String)string2);
        }
        catch (Exception exception) {
            ServerPropertiesTest.fail((String)("could not find property " + stringArray[0]));
        }
    }

    private boolean canPingServer(int n, boolean bl) throws SQLException {
        boolean bl2 = false;
        try {
            bl2 = NetworkServerTestSetup.pingForServerUp(NetworkServerTestSetup.getNetworkServerControl(n), null, bl);
        }
        catch (Exception exception) {
            ServerPropertiesTest.fail((String)"unexpected Exception while pinging");
        }
        return bl2;
    }

    private String shutdownServer(int n, boolean bl) throws SQLException {
        try {
            if (bl) {
                NetworkServerControl networkServerControl = NetworkServerTestSetup.getNetworkServerControl(n);
                networkServerControl.shutdown();
            } else {
                NetworkServerControl networkServerControl = NetworkServerTestSetup.getNetworkServerControlDefault();
                networkServerControl.shutdown();
            }
        }
        catch (Exception exception) {
            return "failed to shutdown server with API parameter (" + exception + ")";
        }
        if (this.canPingServer(n, false)) {
            return "Can still ping server";
        }
        return null;
    }

    public String startServer(int n, boolean bl) throws SQLException {
        try {
            if (bl) {
                NetworkServerControl networkServerControl = NetworkServerTestSetup.getNetworkServerControl(n);
                networkServerControl.start(null);
                NetworkServerTestSetup.waitForServerStart(networkServerControl);
            } else {
                NetworkServerControl networkServerControl = NetworkServerTestSetup.getNetworkServerControlDefault();
                networkServerControl.start(null);
                NetworkServerTestSetup.waitForServerStart(networkServerControl);
            }
        }
        catch (Exception exception) {
            return "failed to start server with port " + n;
        }
        if (!this.canPingServer(n, true)) {
            return "Cannot ping server started with port set to " + n;
        }
        return null;
    }

    public void checkWhetherNeedToShutdown(int[] nArray, String string) {
        this.portsSoFar = nArray;
        if (string != null) {
            ServerPropertiesTest.fail((String)string);
        }
    }

    private void assertSuccessfulCmd(String string, String[] stringArray) throws InterruptedException, IOException {
        ServerPropertiesTest.assertExecJavaCmdAsExpected(new String[]{string}, stringArray, 0);
    }

    public void ttestSetPortPriority() throws SQLException, InterruptedException, IOException {
        NetworkServerTestSetup.setWaitTime(0L);
        if (this.canPingServer(this.basePort, false)) {
            this.shutdownServer(this.basePort, false);
        }
        NetworkServerTestSetup.setDefaultWaitTime();
        NetworkServerTestSetup.waitForAvailablePort();
        String string = this.startServer(this.basePort, true);
        this.checkWhetherNeedToShutdown(new int[]{this.basePort}, string);
        int n = TestConfiguration.getCurrent().getNextAvailablePort();
        final Properties properties = new Properties();
        properties.put("derby.drda.portNumber", Integer.toString(n));
        final String string2 = ServerPropertiesTest.getSystemProperty("derby.system.home");
        boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                boolean bl = false;
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(string2 + File.separator + "derby.properties");
                    properties.store(fileOutputStream, "testing derby.properties");
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    bl = true;
                }
                return bl;
            }
        });
        if (bl) {
            this.checkWhetherNeedToShutdown(new int[]{TestConfiguration.getCurrent().getPort()}, "failed to write derby.properties");
        }
        TestConfiguration.getCurrent().shutdownEngine();
        string = this.startServer(n, false);
        this.checkWhetherNeedToShutdown(new int[]{this.basePort, n}, string);
        int n2 = TestConfiguration.getCurrent().getNextAvailablePort();
        ServerPropertiesTest.setSystemProperty("derby.drda.portNumber", Integer.toString(n2));
        string = this.startServer(n2, false);
        this.checkWhetherNeedToShutdown(new int[]{this.basePort, n, n2}, string);
        int n3 = TestConfiguration.getCurrent().getNextAvailablePort();
        string = this.startServer(n3, true);
        this.checkWhetherNeedToShutdown(new int[]{this.basePort, n, n2, n3}, string);
        int n4 = TestConfiguration.getCurrent().getNextAvailablePort();
        String[] stringArray = new String[]{"-Dderby.system.home=" + string2, "org.apache.derby.drda.NetworkServerControl", "-p", String.valueOf(n4).toString(), "-noSecurityManager", "start"};
        ServerPropertiesTest.execJavaCmd(stringArray);
        if (!this.canPingServer(n4, true)) {
            string = "Can not ping server specified with -p";
        }
        this.checkWhetherNeedToShutdown(new int[]{this.basePort, n, n2, n3, n4}, string);
        stringArray = new String[]{"-Dderby.system.home=" + string2, "org.apache.derby.drda.NetworkServerControl", "-p", String.valueOf(n4).toString(), "-noSecurityManager", "shutdown"};
        ServerPropertiesTest.execJavaCmd(stringArray);
        if (this.canPingServer(n4, false)) {
            string = "Can still ping server specified with -p";
        }
        this.checkWhetherNeedToShutdown(new int[]{this.basePort, n, n2, n3, n4}, string);
        string = this.shutdownServer(n3, true);
        this.checkWhetherNeedToShutdown(new int[]{this.basePort, n, n2, n3}, string);
        string = this.shutdownServer(n2, false);
        this.checkWhetherNeedToShutdown(new int[]{this.basePort, n, n2}, string);
        ServerPropertiesTest.removeSystemProperty("derby.drda.portNumber");
        string = this.shutdownServer(n, false);
        this.checkWhetherNeedToShutdown(new int[]{this.basePort, n}, string);
        if (!PrivilegedFileOpsForTests.delete(new File(string2, "derby.properties"))) {
            this.checkWhetherNeedToShutdown(new int[]{this.basePort, n}, "unable to remove derby.properties");
        }
        TestConfiguration.getCurrent().shutdownEngine();
        string = this.shutdownServer(this.basePort, true);
        this.checkWhetherNeedToShutdown(new int[]{this.basePort}, string);
    }

    public void ttestDefaultProperties() throws SQLException {
        ServerPropertiesTest.verifyProperties(new String[]{"derby.drda.maxThreads=0", "derby.drda.sslMode=off", "derby.drda.keepAlive=true", "derby.drda.minThreads=0", "derby.drda.portNumber=" + String.valueOf(TestConfiguration.getCurrent().getPort()), "derby.drda.logConnections=false", "derby.drda.timeSlice=0", "derby.drda.startNetworkServer=false", "derby.drda.host=" + String.valueOf(TestConfiguration.getCurrent().getHostName()), "derby.drda.traceAll=false"});
    }

    public void testToggleTrace() throws SQLException, IOException, InterruptedException {
        String string = "derby.drda.traceAll=false";
        String string2 = "derby.drda.traceAll=true";
        ServerPropertiesTest.verifyProperties(string);
        int n = TestConfiguration.getCurrent().getPort();
        String[] stringArray = new String[]{"org.apache.derby.drda.NetworkServerControl", "trace", "on", "-p", String.valueOf(n)};
        this.assertSuccessfulCmd("Trace turned on for all sessions.", stringArray);
        ServerPropertiesTest.verifyProperties(string2);
        stringArray = new String[]{"org.apache.derby.drda.NetworkServerControl", "trace", "off", "-p", String.valueOf(n)};
        this.assertSuccessfulCmd("Trace turned off for all sessions", stringArray);
        ServerPropertiesTest.verifyProperties(string);
    }

    public void testToggleLogConnections() throws SQLException, IOException, InterruptedException {
        String string = "derby.drda.logConnections=false";
        String string2 = "derby.drda.logConnections=true";
        ServerPropertiesTest.verifyProperties(string);
        int n = TestConfiguration.getCurrent().getPort();
        String[] stringArray = new String[]{"org.apache.derby.drda.NetworkServerControl", "logconnections", "on", "-p", String.valueOf(n)};
        this.assertSuccessfulCmd("Log Connections turned on.", stringArray);
        ServerPropertiesTest.verifyProperties(string2);
        stringArray = new String[]{"org.apache.derby.drda.NetworkServerControl", "logconnections", "off", "-p", String.valueOf(n)};
        this.assertSuccessfulCmd("Log Connections turned off.", stringArray);
        ServerPropertiesTest.verifyProperties(string);
    }
}

