/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.junit;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.Test;
import org.apache.derby.iapi.services.io.InputStreamUtil;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;

public class InputStreamUtilTest
extends BaseTestCase {
    public InputStreamUtilTest(String name) {
        super(name);
    }

    public void testNullStream() throws IOException {
        try {
            InputStreamUtil.skipUntilEOF(null);
            InputStreamUtilTest.fail((String)"Null InputStream is accepted!");
        }
        catch (NullPointerException e) {
            InputStreamUtilTest.assertTrue((boolean)true);
        }
        try {
            InputStreamUtil.skipFully(null, (long)0L);
            InputStreamUtilTest.fail((String)"Null InputStream is accepted!");
        }
        catch (NullPointerException e) {
            InputStreamUtilTest.assertTrue((boolean)true);
        }
    }

    public void testSkipUtilEOFWithOddLength() throws IOException {
        int[] lengths = new int[]{0, 1};
        for (int i = 0; i < lengths.length; ++i) {
            int length = lengths[i];
            ByteArrayInputStream is = new ByteArrayInputStream(new byte[length]);
            InputStreamUtilTest.assertEquals((long)length, (long)InputStreamUtil.skipUntilEOF((InputStream)is));
        }
    }

    public void testSkipUtilEOF() throws IOException {
        int[] lengths = new int[]{1024, 0x100000};
        for (int i = 0; i < lengths.length; ++i) {
            int length = lengths[i];
            ByteArrayInputStream is = new ByteArrayInputStream(new byte[length]);
            InputStreamUtilTest.assertEquals((long)length, (long)InputStreamUtil.skipUntilEOF((InputStream)is));
        }
    }

    public void testSkipFully() throws IOException {
        int length = 1024;
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[length]);
        InputStreamUtil.skipFully((InputStream)is, (long)length);
        InputStreamUtilTest.assertEquals((long)0L, (long)InputStreamUtil.skipUntilEOF((InputStream)is));
        is = new ByteArrayInputStream(new byte[length]);
        InputStreamUtil.skipFully((InputStream)is, (long)(length - 1));
        InputStreamUtilTest.assertEquals((long)1L, (long)InputStreamUtil.skipUntilEOF((InputStream)is));
        is = new ByteArrayInputStream(new byte[length]);
        try {
            InputStreamUtil.skipFully((InputStream)is, (long)(length + 1));
            InputStreamUtilTest.fail((String)"Should have Meet EOF!");
        }
        catch (EOFException e) {
            InputStreamUtilTest.assertTrue((boolean)true);
        }
        InputStreamUtilTest.assertEquals((long)0L, (long)InputStreamUtil.skipUntilEOF((InputStream)is));
    }

    public static Test suite() {
        return new BaseTestSuite(InputStreamUtilTest.class, "InputStreamUtil tests");
    }
}

