/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.sql.DataSource;
import junit.extensions.TestSetup;
import junit.framework.Test;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.ConcurrentAutoloadTest;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.JDBCDriversAllTest;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.JDBCDriversClientTest;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.JDBCDriversEmbeddedTest;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.SpawnedProcess;
import org.apache.derbyTesting.junit.TestConfiguration;

public class AutoloadTest
extends BaseJDBCTestCase {
    private Class<?> spawnedTestClass;

    public AutoloadTest(String name) {
        super(name);
    }

    private AutoloadTest(Class<?> wrapper) {
        this("spawnProcess");
        this.spawnedTestClass = wrapper;
    }

    public String getName() {
        Object name = super.getName();
        if (this.spawnedTestClass != null) {
            name = (String)name + ":" + this.spawnedTestClass.getSimpleName();
        }
        return name;
    }

    public static Test suite() {
        BaseTestSuite suite;
        if (!JDBC.vmSupportsJDBC3()) {
            return new BaseTestSuite("empty: no java.sql.DriverManager");
        }
        boolean embeddedAutoLoad = false;
        boolean clientAutoLoad = false;
        boolean jdbc4Autoload = false;
        if (JDBC.vmSupportsJDBC4() && TestConfiguration.loadingFromJars()) {
            jdbc4Autoload = true;
        }
        try {
            String jdbcDrivers = AutoloadTest.getSystemProperty("jdbc.drivers");
            if (jdbcDrivers == null) {
                jdbcDrivers = "";
            }
            embeddedAutoLoad = jdbcDrivers.contains("org.apache.derby.jdbc.EmbeddedDriver");
            clientAutoLoad = jdbcDrivers.contains("org.apache.derby.jdbc.ClientDriver");
        }
        catch (SecurityException jdbcDrivers) {
            // empty catch block
        }
        if (jdbc4Autoload || embeddedAutoLoad || clientAutoLoad) {
            suite = new BaseTestSuite("AutoloadTest");
            if (jdbc4Autoload && !embeddedAutoLoad) {
                suite.addTest(SecurityManagerSetup.noSecurityManager((Test)new AutoloadTest("testEmbeddedNotStarted")));
            }
            if (jdbc4Autoload || embeddedAutoLoad) {
                suite.addTest(AutoloadTest.baseAutoLoadSuite("embedded"));
            }
            if (jdbc4Autoload || clientAutoLoad) {
                suite.addTest(TestConfiguration.clientServerDecorator(AutoloadTest.baseAutoLoadSuite("client")));
            }
            if (jdbc4Autoload || embeddedAutoLoad) {
                suite.addTest((Test)new AutoloadTest("testAssertShutdownOK"));
                suite.addTest((Test)new AutoloadTest("testShutdownDeRegister"));
                suite.addTest((Test)new AutoloadTest("testExplicitReload"));
            }
            return suite;
        }
        suite = new BaseTestSuite("AutoloadTest: no autoloading expected");
        suite.addTest(SecurityManagerSetup.noSecurityManager((Test)new AutoloadTest("testEmbeddedNotStarted")));
        suite.addTest((Test)new AutoloadTest("noloadTestNodriverLoaded"));
        suite.addTest(TestConfiguration.clientServerDecorator((Test)new AutoloadTest("noloadTestNodriverLoaded")));
        return suite;
    }

    private static Test baseAutoLoadSuite(String which) {
        BaseTestSuite suite = new BaseTestSuite("AutoloadTest: " + which);
        suite.addTest((Test)new AutoloadTest("testRegisteredDriver"));
        if ("embedded".equals(which) && Derby.hasServer()) {
            suite.addTest((Test)new AutoloadTest("testAutoNetworkServerBoot"));
        }
        suite.addTest((Test)new AutoloadTest("testSuccessfulConnect"));
        if ("embedded".equals(which)) {
            suite.addTest(SecurityManagerSetup.noSecurityManager((Test)new AutoloadTest("testEmbeddedStarted")));
        }
        suite.addTest((Test)new AutoloadTest("testUnsuccessfulConnect"));
        suite.addTest((Test)new AutoloadTest("testExplicitLoad"));
        if ("embedded".equals(which)) {
            suite.addTest((Test)new AutoloadTest("testAutoloadDriverUnregister"));
        }
        return suite;
    }

    static Test fullAutoloadSuite() {
        BaseTestSuite suite = new BaseTestSuite("AutoloadTest:All");
        suite.addTest((Test)new AutoloadTest(AutoloadTest.class));
        suite.addTest((Test)new AutoloadTest(JDBCDriversEmbeddedTest.class));
        suite.addTest((Test)new AutoloadTest(JDBCDriversClientTest.class));
        suite.addTest((Test)new AutoloadTest(JDBCDriversAllTest.class));
        suite.addTest((Test)new AutoloadTest(ConcurrentAutoloadTest.class));
        return new TestSetup((Test)suite){

            protected void setUp() {
                TestConfiguration.getCurrent().shutdownEngine();
            }
        };
    }

    public void spawnProcess() throws Exception {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add("-Dderby.system.durability=" + AutoloadTest.getSystemProperty("derby.system.durability"));
        args.add("-Dderby.tests.trace=" + AutoloadTest.getSystemProperty("derby.tests.trace"));
        args.add("-Dderby.system.debug=" + AutoloadTest.getSystemProperty("derby.tests.debug"));
        if (!TestConfiguration.isDefaultBasePort()) {
            args.add("-Dderby.tests.basePort=" + TestConfiguration.getBasePort());
        }
        args.add("junit.textui.TestRunner");
        args.add(this.spawnedTestClass.getName());
        String[] cmd = args.toArray(new String[0]);
        SpawnedProcess proc = new SpawnedProcess(AutoloadTest.execJavaCmd(cmd), this.spawnedTestClass.getName());
        proc.suppressOutputOnComplete();
        boolean completed = proc.waitForExit(120000L, 1000L);
        StringBuilder jstackReport = new StringBuilder();
        if (!completed) {
            jstackReport.append("\n\n\n[Subprocess ");
            jstackReport.append(proc.getPid());
            jstackReport.append(" hanging, jstack result:");
            jstackReport.append(proc.jstack());
            jstackReport.append("End of jstack output]\n\n");
        }
        int exitCode = proc.complete(0L);
        String output = proc.getFullServerOutput();
        String err = proc.getFullServerError();
        String headerOut = "\n[ (stdout subprocess) ";
        String headerErr = "\n[ (stdout subprocess) ".replace("out", "err");
        String contLineOut = "\n[ (stdout subprocess) ".replace('[', ' ');
        String contLineErr = contLineOut.replace("out", "err");
        if (exitCode != 0) {
            StringBuilder errMsg = new StringBuilder();
            errMsg.append("subprocess run failed: exit code==");
            errMsg.append(exitCode);
            errMsg.append("\n");
            errMsg.append("\n[ (stdout subprocess) ");
            errMsg.append(output.replaceAll("\n", contLineOut));
            errMsg.append("]\n");
            errMsg.append(headerErr);
            errMsg.append(err.replaceAll("\n", contLineErr));
            errMsg.append("]\n");
            errMsg.append((CharSequence)jstackReport);
            AutoloadTest.fail((String)errMsg.toString());
        }
        if (Boolean.parseBoolean(AutoloadTest.getSystemProperty("derby.tests.trace")) || Boolean.parseBoolean(AutoloadTest.getSystemProperty("derby.tests.debug"))) {
            System.out.println("\n[ (stdout subprocess) " + output.replace("\n", contLineOut) + "]\n");
            System.out.println(headerErr + err.replace("\n", contLineErr) + "]\n");
        }
    }

    public void testAutoloadDriverUnregister() throws Exception {
        if (AutoloadTest.usingEmbedded()) {
            String AutoloadedDriver2 = this.getAutoloadedDriverName();
            String Driver40 = "org.apache.derby.jdbc.Driver40";
            String Driver30 = "org.apache.derby.jdbc.Driver30";
            String Driver20 = "org.apache.derby.jdbc.Driver20";
            String url = this.getTestConfiguration().getJDBCUrl();
            url = url.concat(";create=true");
            String user = this.getTestConfiguration().getUserName();
            String password = this.getTestConfiguration().getUserPassword();
            DriverManager.getConnection(url, user, password);
            AutoloadTest.assertTrue((boolean)this.getRegisteredDrivers(AutoloadedDriver2));
            TestConfiguration.getCurrent().shutdownEngine();
            AutoloadTest.assertFalse((boolean)this.getRegisteredDrivers(AutoloadedDriver2));
            String driverClass = this.getTestConfiguration().getJDBCClient().getJDBCDriverName();
            Class<?> clazz = Class.forName(driverClass);
            clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            url = this.getTestConfiguration().getJDBCUrl();
            user = this.getTestConfiguration().getUserName();
            password = this.getTestConfiguration().getUserPassword();
            DriverManager.getConnection(url, user, password);
            AutoloadTest.assertTrue((boolean)this.getRegisteredDrivers(AutoloadedDriver2));
            TestConfiguration.getCurrent().shutdownEngine();
            AutoloadTest.assertFalse((boolean)this.getRegisteredDrivers(AutoloadedDriver2));
            AutoloadTest.assertFalse((boolean)this.getRegisteredDrivers(Driver40));
            AutoloadTest.assertFalse((boolean)this.getRegisteredDrivers(Driver30));
            AutoloadTest.assertFalse((boolean)this.getRegisteredDrivers(Driver20));
        }
    }

    private String getAutoloadedDriverName() {
        return "org.apache.derby.iapi.jdbc.AutoloadedDriver";
    }

    private String getClientDriverName() {
        return "org.apache.derby.client.ClientAutoloadedDriver";
    }

    public void testRegisteredDriver() throws SQLException {
        String protocol = this.getTestConfiguration().getJDBCClient().getUrlBase();
        AutoloadTest.println("Test case '" + this.getName() + "'. Looking up driver for protocol " + protocol);
        Driver driver = DriverManager.getDriver(protocol);
        AutoloadTest.assertNotNull((String)"Expected registered driver", (Object)driver);
    }

    public void testShutdownDeRegister() throws SQLException {
        AutoloadTest.assertTrue((boolean)this.isEmbeddedDriverRegistered());
        TestConfiguration.getCurrent().shutdownEngine();
        AutoloadTest.assertFalse((boolean)this.isEmbeddedDriverRegistered());
    }

    private boolean isEmbeddedDriverRegistered() {
        String clientDriverName = this.getClientDriverName();
        Enumeration<Driver> e = DriverManager.getDrivers();
        while (e.hasMoreElements()) {
            Driver d = e.nextElement();
            String driverClass = d.getClass().getName();
            if (!driverClass.startsWith("org.apache.derby.") || driverClass.equals(clientDriverName)) continue;
            AutoloadTest.println("Found " + driverClass);
            return true;
        }
        return false;
    }

    public void testSuccessfulConnect() throws SQLException {
        AutoloadTest.println("We ARE autoloading...");
        String url = this.getTestConfiguration().getJDBCUrl();
        url = url.concat(";create=true");
        String user = this.getTestConfiguration().getUserName();
        String password = this.getTestConfiguration().getUserPassword();
        DriverManager.getConnection(url, user, password).close();
    }

    public void testUnsuccessfulConnect() throws SQLException {
        String url = this.getTestConfiguration().getJDBCUrl("nonexistentDatabase");
        String user = this.getTestConfiguration().getUserName();
        String password = this.getTestConfiguration().getUserPassword();
        try {
            DriverManager.getConnection(url, user, password).close();
            AutoloadTest.fail((String)"connected to nonexistentDatabase");
        }
        catch (SQLException e) {
            String expectedError = AutoloadTest.usingEmbedded() ? "XJ004" : "08004";
            AutoloadTest.assertSQLState(expectedError, e);
        }
    }

    public void testExplicitLoad() throws Exception {
        this.explicitLoad(false);
    }

    public void testExplicitReload() throws Exception {
        this.explicitLoad(true);
    }

    private void explicitLoad(boolean instanceOnly) throws Exception {
        String driverClass = this.getTestConfiguration().getJDBCClient().getJDBCDriverName();
        if (!instanceOnly) {
            Class.forName(driverClass);
            this.testSuccessfulConnect();
            this.testUnsuccessfulConnect();
        }
        Class<?> clazz = Class.forName(driverClass);
        clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        this.testSuccessfulConnect();
        this.testUnsuccessfulConnect();
    }

    public void noloadTestNodriverLoaded() {
        try {
            this.testRegisteredDriver();
            AutoloadTest.fail((String)"Derby junit setup code is loading driver!");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void testAutoNetworkServerBoot() throws Exception {
        boolean nsAutoBoot = "true".equalsIgnoreCase(AutoloadTest.getSystemProperty("derby.drda.startNetworkServer"));
        boolean serverShouldBeUp = nsAutoBoot && this.fullEngineAutoBoot();
        String user = this.getTestConfiguration().getUserName();
        String pw = this.getTestConfiguration().getUserPassword();
        int port = TestConfiguration.getBasePort();
        InetAddress host = InetAddress.getByName(TestConfiguration.getCurrent().getHostName());
        NetworkServerControl control = new NetworkServerControl(host, port, user, pw);
        if (!serverShouldBeUp) {
            Thread.sleep(5000L);
        }
        boolean isServerUp = NetworkServerTestSetup.pingForServerUp(control, null, serverShouldBeUp);
        AutoloadTest.assertEquals((String)"Network Server state incorrect", (boolean)serverShouldBeUp, (boolean)isServerUp);
        if (isServerUp) {
            control.shutdown();
        }
    }

    private boolean fullEngineAutoBoot() {
        String jdbcDrivers = AutoloadTest.getSystemProperty("jdbc.drivers");
        return jdbcDrivers.contains("org.apache.derby.jdbc.EmbeddedDriver");
    }

    public void testEmbeddedNotStarted() {
        AutoloadTest.assertFalse((boolean)this.hasDerbyThreadGroup());
    }

    public void testEmbeddedStarted() {
        AutoloadTest.assertTrue((boolean)this.hasDerbyThreadGroup());
    }

    private boolean getRegisteredDrivers(String driver) {
        Enumeration<Driver> e = DriverManager.getDrivers();
        while (e.hasMoreElements()) {
            Driver drv = e.nextElement();
            if (!drv.getClass().getName().equals(driver)) continue;
            return true;
        }
        return false;
    }

    public void testAssertShutdownOK() throws SQLException {
        String AutoloadedDriver2 = this.getAutoloadedDriverName();
        Connection conn = this.getConnection();
        if (AutoloadTest.usingEmbedded()) {
            DataSource ds = JDBCDataSource.getDataSource();
            JDBCDataSource.setBeanProperty(ds, "shutdownDatabase", "shutdown");
            try {
                ds.getConnection();
                AutoloadTest.fail((String)"expected shutdown to fail");
            }
            catch (SQLException e) {
                AutoloadTest.assertSQLState("08006", e);
            }
            AutoloadTest.assertTrue((boolean)conn.isClosed());
        } else if (AutoloadTest.usingDerbyNetClient()) {
            DataSource ds = JDBCDataSource.getDataSource();
            JDBCDataSource.setBeanProperty(ds, "connectionAttributes", "shutdown=true;deregiste=false");
            try {
                ds.getConnection();
                AutoloadTest.fail((String)"expected shutdown to fail");
            }
            catch (SQLException e) {
                AutoloadTest.assertSQLState("08006", e);
            }
            JDBCDataSource.setBeanProperty(ds, "connectionAttributes", "shutdown=true;deregister=false");
            try {
                ds.getConnection();
                AutoloadTest.fail((String)"expected shutdown to fail");
            }
            catch (SQLException e) {
                AutoloadTest.assertSQLState("08006", e);
            }
            AutoloadTest.assertTrue((boolean)this.getRegisteredDrivers(AutoloadedDriver2));
            String url = this.getTestConfiguration().getJDBCUrl();
            conn = DriverManager.getConnection(url);
            Statement stmt = conn.createStatement();
            stmt.executeUpdate("values 1");
            JDBCDataSource.setBeanProperty(ds, "connectonAttributes", "shutdown=true;deregister=true");
            try {
                ds.getConnection();
                AutoloadTest.fail((String)"expected shutdown to fail");
            }
            catch (SQLException e) {
                AutoloadTest.assertSQLState("08006", e);
            }
            AutoloadTest.assertFalse((boolean)this.getRegisteredDrivers(AutoloadedDriver2));
        }
    }

    private boolean hasDerbyThreadGroup() {
        int actual;
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        while (tg.getParent() != null) {
            tg = tg.getParent();
        }
        ThreadGroup[] allGroups = new ThreadGroup[tg.activeGroupCount()];
        while ((actual = tg.enumerate(allGroups, true)) >= allGroups.length) {
            allGroups = new ThreadGroup[allGroups.length * 2];
        }
        for (int i = 0; i < actual; ++i) {
            if (!allGroups[i].getName().startsWith("derby.")) continue;
            return true;
        }
        return false;
    }
}

