/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.harness;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BackgroundStreamSaver
implements Runnable {
    protected InputStream in;
    protected OutputStream out;
    protected boolean finished;
    protected IOException ioe;

    public BackgroundStreamSaver(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
        Thread myThread = new Thread((Runnable)this, this.getClass().getName());
        myThread.setPriority(1);
        myThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            int valid;
            byte[] ca = new byte[1024];
            while ((valid = this.in.read(ca, 0, ca.length)) != -1) {
                this.out.write(ca, 0, valid);
            }
            this.out.flush();
        }
        catch (IOException ioe) {
            this.ioe = ioe;
        }
        BackgroundStreamSaver backgroundStreamSaver = this;
        synchronized (backgroundStreamSaver) {
            this.finished = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() throws IOException {
        if (this.ioe != null) {
            throw this.ioe;
        }
        BackgroundStreamSaver backgroundStreamSaver = this;
        synchronized (backgroundStreamSaver) {
            try {
                while (!this.finished) {
                    this.wait();
                }
            }
            catch (InterruptedException ie) {
                throw new IOException(ie.toString());
            }
        }
    }
}

