/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.ExpressionClassBuilderInterface;
import org.apache.derby.iapi.sql.compile.JoinStrategy;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.util.PropertyUtil;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.shared.common.error.StandardException;

abstract class BaseJoinStrategy
implements JoinStrategy {
    BaseJoinStrategy() {
    }

    @Override
    public boolean bulkFetchOK() {
        return true;
    }

    @Override
    public boolean ignoreBulkFetch() {
        return false;
    }

    void fillInScanArgs1(TransactionController tc, MethodBuilder mb, Optimizable innerTable, OptimizablePredicateList predList, ExpressionClassBuilderInterface acbi, int resultRowTemplate) throws StandardException {
        boolean sameStartStopPosition = predList.sameStartStopPosition();
        ExpressionClassBuilder acb = (ExpressionClassBuilder)acbi;
        long conglomNumber = innerTable.getTrulyTheBestAccessPath().getConglomerateDescriptor().getConglomerateNumber();
        StaticCompiledOpenConglomInfo scoci = tc.getStaticCompiledConglomInfo(conglomNumber);
        acb.pushThisAsActivation(mb);
        mb.push(conglomNumber);
        mb.push(acb.addItem(scoci));
        mb.push(resultRowTemplate);
        mb.push(innerTable.getResultSetNumber());
        predList.generateStartKey(acb, mb, innerTable);
        mb.push(predList.startOperator(innerTable));
        if (!sameStartStopPosition) {
            predList.generateStopKey(acb, mb, innerTable);
        } else {
            mb.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
        }
        mb.push(predList.stopOperator(innerTable));
        mb.push(sameStartStopPosition);
        predList.generateQualifiers(acb, mb, innerTable, true);
        mb.upCast("org.apache.derby.iapi.store.access.Qualifier[][]");
    }

    final void fillInScanArgs2(MethodBuilder mb, Optimizable innerTable, int bulkFetch, int colRefItem, int indexColItem, int lockMode, boolean tableLocked, int isolationLevel) throws StandardException {
        mb.push(innerTable.getBaseTableName());
        if (innerTable.getProperties() != null) {
            mb.push(PropertyUtil.sortProperties(innerTable.getProperties()));
        } else {
            mb.pushNull("java.lang.String");
        }
        ConglomerateDescriptor cd = innerTable.getTrulyTheBestAccessPath().getConglomerateDescriptor();
        if (cd.isConstraint()) {
            DataDictionary dd = innerTable.getDataDictionary();
            TableDescriptor td = innerTable.getTableDescriptor();
            ConstraintDescriptor constraintDesc = dd.getConstraintDescriptor(td, cd.getUUID());
            mb.push(constraintDesc.getConstraintName());
        } else if (cd.isIndex()) {
            mb.push(cd.getConglomerateName());
        } else {
            mb.pushNull("java.lang.String");
        }
        mb.push(cd.isConstraint());
        mb.push(innerTable.forUpdate());
        mb.push(colRefItem);
        mb.push(indexColItem);
        mb.push(lockMode);
        mb.push(tableLocked);
        mb.push(isolationLevel);
        if (bulkFetch > 0) {
            mb.push(bulkFetch);
            mb.push(innerTable.hasLargeObjectColumns());
        }
        if (this.validForOutermostTable()) {
            mb.push(innerTable.isOneRowScan());
        }
        mb.push(innerTable.getTrulyTheBestAccessPath().getCostEstimate().rowCount());
        mb.push(innerTable.getTrulyTheBestAccessPath().getCostEstimate().getEstimatedCost());
    }

    @Override
    public boolean isHashJoin() {
        return false;
    }

    protected boolean validForOutermostTable() {
        return false;
    }
}

