/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.derby.iapi.store.raw.data.DataFactory;
import org.apache.derby.impl.jdbc.LOBFile;
import org.apache.derby.io.StorageFile;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.MessageService;

class EncryptedLOBFile
extends LOBFile {
    private final int blockSize;
    private final byte[] tail;
    private int tailSize;
    private long currentPos;
    private final DataFactory df;

    EncryptedLOBFile(StorageFile lobFile, DataFactory df) throws FileNotFoundException {
        super(lobFile);
        this.df = df;
        this.blockSize = df.getEncryptionBlockSize();
        this.tail = new byte[this.blockSize];
        this.tailSize = 0;
    }

    private byte[] getBlocks(long pos, int len) throws IOException, StandardException {
        if (len < 0) {
            throw new IndexOutOfBoundsException(MessageService.getTextMessage("XJ071.S", len));
        }
        long startPos = pos - pos % (long)this.blockSize;
        long endPos = (pos + (long)len + (long)this.blockSize - 1L) / (long)this.blockSize * (long)this.blockSize;
        byte[] data = new byte[(int)(endPos - startPos)];
        super.seek(startPos);
        super.read(data, 0, data.length);
        return data;
    }

    @Override
    long length() throws IOException {
        return super.length() + (long)this.tailSize;
    }

    @Override
    long getFilePointer() {
        return this.currentPos;
    }

    @Override
    void seek(long pos) throws IOException {
        long fileLength = super.length();
        if (pos > fileLength + (long)this.tailSize) {
            throw new IllegalArgumentException("Internal Error");
        }
        if (pos < fileLength) {
            super.seek(pos);
        }
        this.currentPos = pos;
    }

    @Override
    void write(int b) throws IOException, StandardException {
        long length = super.length();
        if (this.currentPos >= length) {
            int pos = (int)(this.currentPos - length);
            this.tail[pos] = (byte)b;
            if (pos >= this.tailSize) {
                this.tailSize = pos + 1;
            }
            if (this.tailSize == this.blockSize) {
                byte[] cypherText = new byte[this.blockSize];
                this.df.encrypt(this.tail, 0, this.tailSize, cypherText, 0, false);
                super.seek(length);
                super.write(cypherText);
                this.tailSize = 0;
            }
        } else {
            byte[] cypherText = this.getBlocks(this.currentPos, 1);
            byte[] clearText = new byte[this.blockSize];
            this.df.decrypt(cypherText, 0, this.blockSize, clearText, 0);
            clearText[(int)(this.currentPos % (long)this.blockSize)] = (byte)b;
            this.df.encrypt(clearText, 0, this.blockSize, cypherText, 0, false);
            super.seek(this.currentPos - this.currentPos % (long)this.blockSize);
            super.write(cypherText);
        }
        ++this.currentPos;
    }

    @Override
    void write(byte[] b, int off, int len) throws IOException, StandardException {
        int pos;
        int finalPos;
        byte[] clearText;
        long fileLength = super.length();
        if (this.currentPos < fileLength) {
            int i;
            int overFlow = (int)Math.max(0L, this.currentPos + (long)len - fileLength);
            long oldPos = this.currentPos;
            byte[] cypherText = this.getBlocks(this.currentPos, len - overFlow);
            clearText = new byte[cypherText.length];
            for (i = 0; i < cypherText.length / this.blockSize; ++i) {
                this.df.decrypt(cypherText, i * this.blockSize, this.blockSize, clearText, i * this.blockSize);
            }
            System.arraycopy(b, off, clearText, (int)(this.currentPos % (long)this.blockSize), len - overFlow);
            for (i = 0; i < cypherText.length / this.blockSize; ++i) {
                this.df.encrypt(clearText, i * this.blockSize, this.blockSize, cypherText, i * this.blockSize, false);
            }
            super.seek(oldPos - oldPos % (long)this.blockSize);
            super.write(cypherText);
            this.currentPos = oldPos + (long)cypherText.length;
            if (overFlow == 0) {
                return;
            }
            off = off + len - overFlow;
            len = overFlow;
            this.currentPos = fileLength;
        }
        if ((finalPos = (pos = (int)(this.currentPos - fileLength)) + len) < this.blockSize) {
            System.arraycopy(b, off, this.tail, pos, len);
            this.tailSize = Math.max(this.tailSize, pos + len);
            this.currentPos += (long)len;
            return;
        }
        int encLength = finalPos - finalPos % this.blockSize;
        int leftOver = finalPos % this.blockSize;
        clearText = new byte[encLength];
        System.arraycopy(this.tail, 0, clearText, 0, pos);
        System.arraycopy(b, off, clearText, pos, encLength - pos);
        byte[] cypherText = new byte[clearText.length];
        for (int offset = 0; offset < cypherText.length; offset += this.blockSize) {
            this.df.encrypt(clearText, offset, this.blockSize, cypherText, offset, false);
        }
        super.seek(fileLength);
        super.write(cypherText);
        System.arraycopy(b, off + len - leftOver, this.tail, 0, leftOver);
        this.tailSize = leftOver;
        this.currentPos = (long)this.tailSize + fileLength + (long)cypherText.length;
    }

    @Override
    void write(byte[] b) throws IOException, StandardException {
        this.write(b, 0, b.length);
    }

    @Override
    int readByte() throws IOException, StandardException {
        long fileLength = super.length();
        if (this.currentPos >= fileLength + (long)this.tailSize) {
            throw new EOFException();
        }
        if (this.currentPos >= fileLength) {
            return this.tail[(int)(this.currentPos++ - fileLength)] & 0xFF;
        }
        byte[] cypherText = this.getBlocks(this.currentPos, 1);
        byte[] clearText = new byte[cypherText.length];
        this.df.decrypt(cypherText, 0, cypherText.length, clearText, 0);
        return clearText[(int)(this.currentPos++ % (long)this.blockSize)] & 0xFF;
    }

    @Override
    int read(byte[] buff, int off, int len) throws IOException, StandardException {
        long fileLength = super.length();
        if (this.currentPos < fileLength) {
            int overFlow = (int)Math.max(0L, this.currentPos + (long)len - fileLength);
            byte[] cypherText = this.getBlocks(this.currentPos, len - overFlow);
            byte[] tmpByte = new byte[cypherText.length];
            for (int offset = 0; offset < cypherText.length; offset += this.blockSize) {
                this.df.decrypt(cypherText, offset, this.blockSize, tmpByte, offset);
            }
            System.arraycopy(tmpByte, (int)(this.currentPos % (long)this.blockSize), buff, off, len - overFlow);
            if (overFlow == 0) {
                this.currentPos += (long)len;
                return len;
            }
            int newLen = Math.min(overFlow, this.tailSize);
            System.arraycopy(this.tail, 0, buff, off + len - overFlow, newLen);
            this.currentPos += (long)(len - overFlow + newLen);
            return len - overFlow + newLen;
        }
        int newLen = (int)Math.min((long)this.tailSize - this.currentPos + fileLength, (long)len);
        if (newLen == 0 && len != 0) {
            return -1;
        }
        System.arraycopy(this.tail, (int)(this.currentPos - fileLength), buff, off, newLen);
        this.currentPos += (long)newLen;
        return newLen;
    }

    @Override
    void setLength(long size) throws IOException, StandardException {
        long fileLength = super.length();
        if (size > fileLength + (long)this.tailSize) {
            throw new IllegalArgumentException("Internal Error");
        }
        if (size < fileLength) {
            byte[] block = this.getBlocks(size, 1);
            super.setLength(size - size % (long)this.blockSize);
            this.df.decrypt(block, 0, this.blockSize, this.tail, 0);
            this.tailSize = (int)(size % (long)this.blockSize);
        } else {
            this.tailSize = (int)(size - fileLength);
        }
    }
}

