/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.optional.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.shared.common.error.PublicAPI;
import org.apache.derby.shared.common.error.StandardException;

public class ToolUtilities {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean sqlAuthorizationEnabled(Connection conn) throws SQLException {
        ResultSet rs;
        block11: {
            try {
                rs = conn.prepareStatement("select count(*) from sys.sysusers").executeQuery();
                rs.next();
                try {
                    if (rs.getInt(1) > 0) {
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    rs.close();
                }
            }
            catch (SQLException se) {
                if (!"4251D".equals(se.getSQLState())) break block11;
                return true;
            }
        }
        rs = conn.prepareStatement("values syscs_util.syscs_get_database_property( 'derby.database.sqlAuthorization' )").executeQuery();
        try {
            if (!rs.next()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = "true".equals(rs.getString(1));
            return bl;
        }
        finally {
            rs.close();
        }
    }

    public static void mustBeOwner(Connection conn, String schema) throws SQLException {
        if (!ToolUtilities.sqlAuthorizationEnabled(conn)) {
            return;
        }
        String dbo = ToolUtilities.getOwner(conn, "SYS");
        String schemaOwner = ToolUtilities.getOwner(conn, schema);
        String currentUser = ToolUtilities.getCurrentUser(conn);
        if (schemaOwner != null && (schemaOwner.equals(currentUser) || dbo.equals(currentUser))) {
            return;
        }
        throw ToolUtilities.newSQLException("42XBF", new Object[0]);
    }

    public static void mustBeDBO(Connection conn) throws SQLException {
        String currentUser;
        if (!ToolUtilities.sqlAuthorizationEnabled(conn)) {
            return;
        }
        String dbo = ToolUtilities.getOwner(conn, "SYS");
        if (dbo.equals(currentUser = ToolUtilities.getCurrentUser(conn))) {
            return;
        }
        throw ToolUtilities.newSQLException("4251D", new Object[0]);
    }

    public static String getCurrentUser(Connection conn) throws SQLException {
        try (ResultSet rs = conn.prepareStatement("values current_user").executeQuery();){
            rs.next();
            String string = rs.getString(1);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOwner(Connection conn, String schema) throws SQLException {
        PreparedStatement ps = conn.prepareStatement("select authorizationID from sys.sysschemas where schemaName = ?");
        ps.setString(1, ToolUtilities.derbyIdentifier(schema));
        try (ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                String string = rs.getString(1);
                return string;
            }
            String string = null;
            return string;
        }
    }

    public static SQLException newSQLException(String sqlState, Object ... args) {
        StandardException se = StandardException.newException(sqlState, args);
        return ToolUtilities.sqlException(se);
    }

    public static String derbyIdentifier(String rawString) throws SQLException {
        try {
            return IdUtil.parseSQLIdentifier((String)rawString);
        }
        catch (StandardException se) {
            throw ToolUtilities.sqlException(se);
        }
    }

    public static SQLException sqlException(StandardException se) {
        return PublicAPI.wrapStandardException(se);
    }

    public static SQLException wrap(Throwable t) {
        return ToolUtilities.sqlException(StandardException.plainWrapException(t));
    }
}

