/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.store;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.raw.Compensation;
import org.apache.derby.iapi.store.raw.GlobalTransactionId;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.Undoable;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.store.T_Compensation;

public class T_Undoable
implements Undoable {
    static final int REMOVE_NONE = 0;
    static final int REMOVE_ME = 1;
    static final int REMOVE_TO_ME = 2;
    protected ByteArray preparedLog;
    protected DynamicByteArrayOutputStream logBuffer;
    GlobalTransactionId tid = null;
    int tranSeq = -1;
    int recordSeq = -1;
    int removeWhat = 0;
    int LWMTranSeq = 0;
    boolean rollBack = true;
    int lastRecord = -1;
    boolean lastTransaction = false;
    int optionalDataLen;
    boolean verbose;

    public T_Undoable() {
    }

    T_Undoable(GlobalTransactionId globalTransactionId, int n, int n2, int n3, int n4, boolean bl, int n5, boolean bl2, int n6, boolean bl3) throws T_Fail {
        T_Fail.T_ASSERT(n3 >= 0 && n3 <= 2);
        T_Fail.T_ASSERT(bl == n2 < 0);
        T_Fail.T_ASSERT(bl == n < 0);
        this.tid = globalTransactionId;
        this.tranSeq = n;
        this.recordSeq = n2;
        this.removeWhat = n3;
        this.LWMTranSeq = n4;
        this.rollBack = bl;
        this.lastRecord = n5;
        this.lastTransaction = bl2;
        this.optionalDataLen = n6;
        this.verbose = bl3;
        try {
            this.writeOptionalDataToBuffer();
        }
        catch (IOException iOException) {
            throw T_Fail.exceptionFail(iOException);
        }
        catch (StandardException standardException) {
            throw T_Fail.exceptionFail(standardException);
        }
    }

    private void writeOptionalDataToBuffer() throws StandardException, IOException {
        if (this.logBuffer == null) {
            this.logBuffer = new DynamicByteArrayOutputStream(1024);
        } else {
            this.logBuffer.reset();
        }
        int n = this.logBuffer.getPosition();
        if (this.optionalDataLen > 0) {
            byte[] byArray = new byte[this.optionalDataLen];
            for (int i = 0; i < this.optionalDataLen; ++i) {
                byArray[i] = (byte)i;
            }
            this.logBuffer.write(byArray);
        }
        int n2 = this.logBuffer.getPosition() - n;
        this.logBuffer.setPosition(n);
        this.preparedLog = new ByteArray(this.logBuffer.getByteArray(), n, n2);
    }

    public void doMe(Transaction transaction, LogInstant logInstant, LimitObjectInput limitObjectInput) {
        if (this.verbose) {
            System.out.println("Loggable.doMe(" + this.toString() + ")");
        }
    }

    public ByteArray getPreparedLog() {
        return this.preparedLog;
    }

    public boolean needsRedo(Transaction transaction) {
        return false;
    }

    public void releaseResource(Transaction transaction) {
    }

    public int group() {
        return 256;
    }

    public Compensation generateUndo(Transaction transaction, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        return new T_Compensation();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.tid);
        objectOutput.writeInt(this.tranSeq);
        objectOutput.writeInt(this.recordSeq);
        objectOutput.writeInt(this.removeWhat);
        objectOutput.writeInt(this.LWMTranSeq);
        objectOutput.writeBoolean(this.rollBack);
        objectOutput.writeInt(this.lastRecord);
        objectOutput.writeBoolean(this.lastTransaction);
        objectOutput.writeInt(this.optionalDataLen);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        try {
            this.tid = (GlobalTransactionId)objectInput.readObject();
            this.tranSeq = objectInput.readInt();
            this.recordSeq = objectInput.readInt();
            this.removeWhat = objectInput.readInt();
            this.LWMTranSeq = objectInput.readInt();
            this.rollBack = objectInput.readBoolean();
            this.lastRecord = objectInput.readInt();
            this.lastTransaction = objectInput.readBoolean();
            this.optionalDataLen = objectInput.readInt();
        }
        catch (ClassCastException classCastException) {
            throw new StreamCorruptedException();
        }
    }

    public int getTypeFormatId() {
        return 2;
    }

    public String toString() {
        String string;
        Object object = "tid: null";
        if (this.tid != null) {
            object = "tid: " + this.tid;
        }
        switch (this.removeWhat) {
            case 0: {
                string = "REMOVE_NONE";
                break;
            }
            case 1: {
                string = "REMOVE_ME";
                break;
            }
            case 2: {
                string = "REMOVE_TO_ME";
                break;
            }
            default: {
                string = "removeWhat: invalidValue";
            }
        }
        return (String)object + " tranSeq: " + this.tranSeq + " recordSeq: " + this.recordSeq + " " + string + " LWMTranSeq: " + this.LWMTranSeq + " rollback: " + this.rollBack + " lastRecord: " + this.lastRecord + " optionalDataLen: " + this.optionalDataLen + " lastTransaction: " + this.lastTransaction;
    }
}

