/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class HoldCursorTest
extends BaseJDBCTestCase {
    public HoldCursorTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("HoldCursorTest");
        baseTestSuite.addTest(HoldCursorTest.baseSuite(true));
        baseTestSuite.addTest(HoldCursorTest.baseSuite(false));
        return baseTestSuite;
    }

    private static Test baseSuite(boolean bl) {
        String string = "HoldCursorTest:" + (bl ? "embedded" : "client");
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        baseTestSuite.addTestSuite(HoldCursorTest.class);
        if (!JDBC.vmSupportsJSR169()) {
            baseTestSuite.addTest((Test)new HoldCursorTest("StatementsInProcedureTest"));
        }
        BaseTestSuite baseTestSuite2 = baseTestSuite;
        if (!bl) {
            baseTestSuite2 = TestConfiguration.clientServerDecorator((Test)baseTestSuite);
        }
        return new CleanDatabaseTestSetup((Test)baseTestSuite2);
    }

    protected void setUp() throws SQLException {
        int n;
        this.getConnection().setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE TABLE T1 (c11 int, c12 int, junk varchar(400))");
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO T1 VALUES(?,1,?)");
        StringBuffer stringBuffer = new StringBuffer(400);
        for (n = 0; n < 400; ++n) {
            stringBuffer.append(" ");
        }
        for (n = 1; n <= 100; ++n) {
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, stringBuffer.toString());
            preparedStatement.executeUpdate();
        }
        preparedStatement.close();
        statement.executeUpdate("CREATE TABLE T2 (c21 int, c22 int)");
        statement.executeUpdate("INSERT INTO T2 VALUES(1,1)");
        statement.executeUpdate("INSERT INTO T2 VALUES(1,2)");
        statement.executeUpdate("INSERT INTO T2 VALUES(1,3)");
        statement.execute("create table testtable1 (id integer, vc varchar(100))");
        statement.execute("insert into testtable1 values (11, 'testtable1-one'), (12, 'testtable1-two')");
        statement.execute("create table testtable2 (id integer, vc varchar(100))");
        statement.execute("insert into testtable2 values (21, 'testtable2-one'), (22, 'testtable2-two')");
        statement.execute("create procedure MYPROC() language java parameter style java external name 'org.apache.derbyTesting.functionTests.tests.lang.HoldCursorTest.testProc' result sets 2");
        statement.executeUpdate("Create table bug4385 (i int not null primary key, c int generated always as identity)");
        statement.close();
        this.commit();
    }

    @Override
    protected void tearDown() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("DROP PROCEDURE MYPROC");
        statement.executeUpdate("DROP TABLE T1");
        statement.executeUpdate("DROP TABLE T2");
        statement.executeUpdate("DROP TABLE testtable1");
        statement.executeUpdate("DROP TABLE testtable2");
        statement.executeUpdate("DROP TABLE BUG4385");
        statement.close();
        statement.close();
        this.commit();
        super.tearDown();
    }

    public void testHoldCursorOnMultiTableQuery() throws Exception {
        Statement statement = this.createStatement(1003, 1007, 1);
        ResultSet resultSet = statement.executeQuery("select t1.c11, t2.c22 from t1, t2 where t1.c11=t2.c21");
        resultSet.next();
        HoldCursorTest.assertEquals((String)"1", (String)resultSet.getString(2));
        this.commit();
        resultSet.next();
        HoldCursorTest.assertEquals((String)"2", (String)resultSet.getString(2));
        resultSet.close();
    }

    public void testIsolationLevelChange() throws Exception {
        this.setTransactionIsolation(2);
        Statement statement = this.createStatement(1003, 1007, 1);
        ResultSet resultSet = statement.executeQuery("select * from t1");
        resultSet.next();
        this.assertIsolationError("X0X03", 8);
        resultSet.close();
        this.setTransactionIsolation(8);
        this.setHoldability(1);
        this.setTransactionIsolation(1);
        this.createStatement().executeUpdate("SET ISOLATION RS");
        PreparedStatement preparedStatement = this.prepareStatement("insert into bug4385(i) values(?)", 1);
        preparedStatement.setInt(1, 199);
        preparedStatement.executeUpdate();
        HoldCursorTest.assertGetIntEquals(1, 1, preparedStatement.getGeneratedKeys());
        resultSet.close();
        preparedStatement.setInt(1, 299);
        preparedStatement.executeUpdate();
        HoldCursorTest.assertGetIntEquals(1, 2, preparedStatement.getGeneratedKeys());
        resultSet.close();
        preparedStatement.close();
        this.rollback();
        this.setHoldability(2);
        this.setTransactionIsolation(2);
    }

    public void testDropTable() throws SQLException {
        this.setHoldability(1);
        Statement statement = this.createStatement();
        Statement statement2 = this.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT * FROM T1");
        resultSet.next();
        HoldCursorTest.assertStatementError("X0X95", statement2, "DROP TABLE T1");
        HoldCursorTest.assertStatementError("X0X95", statement2, "DROP TABLE T1");
        this.commit();
        HoldCursorTest.assertStatementError("X0X95", statement2, "DROP TABLE T1");
        resultSet.close();
        statement2.executeUpdate("DROP TABLE T1");
        statement.close();
        statement2.close();
        this.rollback();
    }

    public void testHoldabilityOverCommit() throws SQLException {
        this.testStatements(1);
        this.testStatements(2);
    }

    public void StatementsInProcedureTest() throws SQLException {
        this.StatementsInProcedure(1);
        this.StatementsInProcedure(2);
    }

    public void testStatements(int n) throws SQLException {
        this.setHoldability(n);
        Statement statement = this.createStatement(1004, 1007, 1);
        ResultSet resultSet = statement.executeQuery("select * from testtable1");
        resultSet.next();
        HoldCursorTest.assertEquals((int)11, (int)resultSet.getInt(1));
        this.commit();
        resultSet.next();
        HoldCursorTest.assertEquals((int)12, (int)resultSet.getInt(1));
        statement.close();
        Statement statement2 = this.createStatement(1004, 1007, 2);
        ResultSet resultSet2 = statement2.executeQuery("select * from testtable2");
        resultSet2.next();
        HoldCursorTest.assertEquals((int)21, (int)resultSet2.getInt(1));
        this.commit();
        HoldCursorTest.assertNextError("XCL16", resultSet2);
        statement2.close();
        resultSet.close();
        resultSet2.close();
    }

    public void StatementsInProcedure(int n) throws SQLException {
        this.setHoldability(n);
        CallableStatement callableStatement = this.prepareCall("call MYPROC()");
        callableStatement.execute();
        ResultSet resultSet = callableStatement.getResultSet();
        resultSet.next();
        HoldCursorTest.assertEquals((int)11, (int)resultSet.getInt(1));
        resultSet.next();
        HoldCursorTest.assertEquals((int)12, (int)resultSet.getInt(1));
        CallableStatement callableStatement2 = this.prepareCall("call MYPROC()");
        callableStatement2.execute();
        this.commit();
        ResultSet resultSet2 = callableStatement2.getResultSet();
        resultSet2.next();
        HoldCursorTest.assertEquals((int)11, (int)resultSet2.getInt(1));
        if (resultSet2.next()) {
            HoldCursorTest.assertEquals((int)12, (int)resultSet2.getInt(1));
        } else {
            HoldCursorTest.assertNull((Object)resultSet2);
        }
        callableStatement.close();
        callableStatement2.close();
        resultSet2.close();
        resultSet.close();
    }

    public void testCloseCursor() throws SQLException {
        String[] stringArray = new String[]{"T1", "T2"};
        Statement statement = this.createStatement();
        Statement statement2 = this.createStatement();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            ResultSet resultSet = statement.executeQuery("SELECT * FROM " + string);
            resultSet.next();
            resultSet.close();
            statement2.executeUpdate("DROP TABLE " + string);
        }
        statement.close();
        statement2.close();
        this.rollback();
    }

    public void assertIsolationError(String string, int n) {
        try {
            this.getConnection().setTransactionIsolation(n);
            HoldCursorTest.fail((String)("expected compile error: " + string));
        }
        catch (SQLException sQLException) {
            HoldCursorTest.assertSQLState(string, sQLException);
        }
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        return this.getConnection().createStatement(n, n2, n3);
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.getConnection().setTransactionIsolation(n);
    }

    public void setHoldability(int n) throws SQLException {
        this.getConnection().setHoldability(n);
    }

    public static void assertGetIntEquals(int n, int n2, ResultSet resultSet) {
        try {
            while (resultSet.next()) {
                if (n2 == resultSet.getInt(n)) {
                    return;
                }
                HoldCursorTest.fail((String)("Wrong value returned: " + resultSet.getInt(n)));
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public static void testProc(ResultSet[] resultSetArray, ResultSet[] resultSetArray2) throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = connection.createStatement(1004, 1007, 1);
        resultSetArray[0] = statement.executeQuery("select * from testtable1");
        Statement statement2 = connection.createStatement(1004, 1007, 2);
        resultSetArray2[0] = statement2.executeQuery("select * from testtable2");
    }
}

