/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import junit.framework.Test;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.IsoLevel;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class CacheSessionDataTest
extends BaseJDBCTestCase {
    private static IsoLevel[] isoLevels;
    private static int isolationIndex;

    public CacheSessionDataTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("CacheSessionDataTest");
        if (JDBC.vmSupportsJDBC3()) {
            baseTestSuite.addTest(CacheSessionDataTest.baseSuite("CacheSessionDataTest:embedded"));
            baseTestSuite.addTest(TestConfiguration.clientServerDecorator(CacheSessionDataTest.baseSuite("CacheSessionDataTest:client")));
        }
        return baseTestSuite;
    }

    private static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        baseTestSuite.addTestSuite(CacheSessionDataTest.class);
        return new CleanDatabaseTestSetup((Test)baseTestSuite){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.execute("CREATE TABLE ISOLATION_NAMES(ISOLEVEL INT, JDBCNAME VARCHAR(30), SQLNAME VARCHAR(2))");
                PreparedStatement preparedStatement = statement.getConnection().prepareStatement("INSERT INTO ISOLATION_NAMES VALUES (?, ?, ?)");
                preparedStatement.setInt(1, 0);
                preparedStatement.setString(2, "TRANSACTION_NONE");
                preparedStatement.setNull(3, 12);
                preparedStatement.execute();
                preparedStatement.setInt(1, 1);
                preparedStatement.setString(2, "TRANSACTION_READ_UNCOMMITTED");
                preparedStatement.setString(3, "UR");
                preparedStatement.execute();
                preparedStatement.setInt(1, 2);
                preparedStatement.setString(2, "TRANSACTION_READ_COMMITTED");
                preparedStatement.setString(3, "CS");
                preparedStatement.execute();
                preparedStatement.setInt(1, 4);
                preparedStatement.setString(2, "TRANSACTION_REPEATABLE_READ");
                preparedStatement.setString(3, "RS");
                preparedStatement.execute();
                preparedStatement.setInt(1, 8);
                preparedStatement.setString(2, "TRANSACTION_SERIALIZABLE");
                preparedStatement.setString(3, "RR");
                preparedStatement.execute();
                preparedStatement.close();
                statement.execute("CREATE TABLE BIG(C1 VARCHAR(32672), C2 VARCHAR(32672), C3 VARCHAR(32672), C4 VARCHAR(32672))");
                statement.execute("CREATE PROCEDURE INSERTDATA1(IN A INT) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.ProcedureTest.bigTestData'");
                CallableStatement callableStatement = statement.getConnection().prepareCall("CALL INSERTDATA1(?)");
                callableStatement.setInt(1, 9);
                for (int i = 0; i < 10; ++i) {
                    callableStatement.execute();
                }
                ResultSet resultSet = statement.executeQuery("SELECT COUNT(*) FROM BIG");
                resultSet.next();
                this.println("BIG has " + resultSet.getInt(1) + " rows");
                statement.execute("CREATE PROCEDURE SET_ISOLATION_JDBC (ISO INT) NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + CacheSessionDataTest.class.getName() + ".setIsolationJDBC'");
                statement.execute("CREATE PROCEDURE SET_ISOLATION_SQL (SQLNAME VARCHAR(2)) MODIFIES SQL DATA LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + CacheSessionDataTest.class.getName() + ".setIsolationSQL'");
                statement.execute("CREATE FUNCTION GET_TRANSACTION_ISOLATION_JDBC () RETURNS INT NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + CacheSessionDataTest.class.getName() + ".getTransactionIsolationJDBC'");
                statement.execute("CREATE FUNCTION GET_CYCLE_ISOLATION_JDBC () RETURNS INT NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + CacheSessionDataTest.class.getName() + ".getCycleIsolationJDBC'");
                statement.execute("CREATE FUNCTION GET_CYCLE_ISOLATION_SQL () RETURNS VARCHAR(2) READS SQL DATA LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + CacheSessionDataTest.class.getName() + ".getCycleIsolationSQL'");
                statement.execute("CREATE SCHEMA FOO");
                String string = "\u00bbMY\u20ac\u00ab";
                statement.execute("CREATE SCHEMA \"" + string + "\"");
                statement.execute("CREATE PROCEDURE APP.SET_SCHEMA (SCHEMANAME VARCHAR(128)) MODIFIES SQL DATA LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + CacheSessionDataTest.class.getName() + ".setSchema'");
                statement.execute("CREATE FUNCTION APP.GET_SCHEMA_TRANSITION (SCHEMANAME VARCHAR(128)) RETURNS VARCHAR(128) READS SQL DATA LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + CacheSessionDataTest.class.getName() + ".getSchemaTransition'");
                statement.execute("CREATE TABLE APP.LARGE(X VARCHAR(32000), SCHEMANAME VARCHAR(128), Y VARCHAR(32000))");
                char[] cArray = new char[32000];
                Arrays.fill(cArray, 'x');
                String string2 = new String(cArray);
                Arrays.fill(cArray, 'y');
                String string3 = new String(cArray);
                statement.execute("INSERT INTO APP.LARGE (SELECT '" + string2 + "', SCHEMANAME,  '" + string3 + "' FROM SYS.SYSSCHEMAS)");
            }
        };
    }

    public void setUp() throws SQLException {
        Connection connection = this.getConnection();
        connection.setAutoCommit(false);
        CacheSessionDataTest.assertEquals((int)2, (int)connection.getTransactionIsolation());
        if (isoLevels == null) {
            Statement statement = this.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT * FROM ISOLATION_NAMES WHERE ISOLEVEL > 0 ORDER BY ISOLEVEL");
            isoLevels = new IsoLevel[4];
            for (int i = 0; i < 4; ++i) {
                CacheSessionDataTest.isoLevels[i] = new IsoLevel(resultSet);
                CacheSessionDataTest.println(isoLevels[i].toString());
            }
            CacheSessionDataTest.assertFalse((boolean)resultSet.next());
            resultSet.close();
            statement.close();
        }
        CacheSessionDataTest.assertNotNull((Object)isoLevels[0]);
        CacheSessionDataTest.assertNotNull((Object)isoLevels[1]);
        CacheSessionDataTest.assertNotNull((Object)isoLevels[2]);
        CacheSessionDataTest.assertNotNull((Object)isoLevels[3]);
    }

    @Override
    public void tearDown() throws Exception {
        DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
        ResultSet resultSet = databaseMetaData.getTables(null, "APP", "T%", null);
        Statement statement = this.createStatement();
        while (resultSet.next()) {
            statement.execute("DROP TABLE " + resultSet.getString("TABLE_NAME"));
        }
        resultSet.close();
        statement.close();
        this.commit();
        super.tearDown();
    }

    public static void setIsolationJDBC(int n) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        connection.setTransactionIsolation(n);
    }

    public static void setIsolationSQL(String string) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = connection.createStatement();
        statement.execute("SET ISOLATION " + string);
        statement.close();
    }

    public static int getTransactionIsolationJDBC() throws SQLException {
        return DriverManager.getConnection("jdbc:default:connection").getTransactionIsolation();
    }

    public static int getCycleIsolationJDBC() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        connection.setTransactionIsolation(CacheSessionDataTest.cycleIsolation().getIsoLevel());
        CacheSessionDataTest.println("getCycleIsolationJDBC() -> " + connection.getTransactionIsolation());
        return connection.getTransactionIsolation();
    }

    public static String getCycleIsolationSQL() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = connection.createStatement();
        statement.execute("SET ISOLATION " + CacheSessionDataTest.cycleIsolation().getSqlName());
        ResultSet resultSet = statement.executeQuery("VALUES CURRENT ISOLATION");
        resultSet.next();
        String string = resultSet.getString(1);
        resultSet.close();
        statement.close();
        CacheSessionDataTest.println("getCycleIsolationSQL() -> " + string);
        return string;
    }

    public static void setSchema(String string) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = connection.createStatement();
        statement.execute("SET SCHEMA " + string);
        statement.close();
    }

    public static String getSchemaTransition(String string) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("VALUES CURRENT SCHEMA");
        resultSet.next();
        String string2 = resultSet.getString(1);
        resultSet.close();
        statement.execute("SET SCHEMA \"" + string + "\"");
        statement.close();
        return string2 + "->" + string;
    }

    private static IsoLevel cycleIsolation() {
        ++isolationIndex;
        return isoLevels[isolationIndex %= 4];
    }

    private void verifyCachedIsolation(Connection connection) throws SQLException {
        int n = connection.getTransactionIsolation();
        Statement statement = this.createStatement();
        IsoLevel isoLevel = new IsoLevel(statement.executeQuery("SELECT * FROM ISOLATION_NAMES WHERE SQLNAME = (VALUES CURRENT ISOLATION)"));
        IsoLevel isoLevel2 = new IsoLevel(statement.executeQuery("SELECT * FROM ISOLATION_NAMES WHERE ISOLEVEL = GET_TRANSACTION_ISOLATION_JDBC()"));
        IsoLevel isoLevel3 = new IsoLevel(statement.executeQuery("SELECT * FROM ISOLATION_NAMES WHERE ISOLEVEL = " + n));
        statement.getResultSet().close();
        statement.close();
        CacheSessionDataTest.assertEquals((Object)isoLevel, (Object)isoLevel3);
        CacheSessionDataTest.assertEquals((Object)isoLevel2, (Object)isoLevel3);
    }

    private void verifyCachedSchema(Connection connection) throws SQLException {
        if (CacheSessionDataTest.usingDerbyNetClient()) {
            String string = ((ClientConnection)connection).getCurrentSchemaName();
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("VALUES CURRENT SCHEMA");
            resultSet.next();
            String string2 = resultSet.getString(1);
            CacheSessionDataTest.assertEquals((String)string2, (String)string);
        } else {
            CacheSessionDataTest.println("Cannot verify cached schema for " + connection.getClass());
        }
    }

    public void testChangeIsoLevelStatementSQL() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = this.createStatement();
        for (int i = 0; i < 4; ++i) {
            statement.execute("SET ISOLATION " + isoLevels[i].getSqlName());
            this.verifyCachedIsolation(connection);
        }
        statement.close();
    }

    public void testChangeIsoLevelPreparedStatementSQL() throws SQLException {
        Connection connection = this.getConnection();
        for (int i = 0; i < 4; ++i) {
            PreparedStatement preparedStatement = this.prepareStatement("SET ISOLATION " + isoLevels[i].getSqlName());
            preparedStatement.execute();
            this.verifyCachedIsolation(connection);
            preparedStatement.close();
        }
    }

    public void testChangeIsoLevelFunctionJDBC() throws SQLException {
        Connection connection = this.getConnection();
        connection.setAutoCommit(true);
        Statement statement = this.createStatement();
        statement.execute("CREATE TABLE T1(ISOLEVEL INT)");
        for (int i = 0; i < 4; ++i) {
            statement.execute("INSERT INTO T1 VALUES GET_CYCLE_ISOLATION_JDBC()");
            this.verifyCachedIsolation(connection);
        }
        statement.close();
    }

    public void testChangeIsoLevelFunctionSQL() throws SQLException {
        Connection connection = this.getConnection();
        connection.setAutoCommit(true);
        Statement statement = this.createStatement();
        statement.execute("CREATE TABLE T1(SQLNAME VARCHAR(2))");
        for (int i = 0; i < 4; ++i) {
            statement.executeUpdate("INSERT INTO T1 VALUES GET_CYCLE_ISOLATION_SQL()");
            this.verifyCachedIsolation(connection);
        }
        statement.close();
    }

    public void testChangeIsoLevelPreparedFunctionJDBC() throws SQLException {
        Connection connection = this.getConnection();
        connection.setAutoCommit(true);
        Statement statement = this.createStatement();
        statement.execute("CREATE TABLE T1(ISOLEVEL INT)");
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO T1 VALUES GET_CYCLE_ISOLATION_JDBC()");
        for (int i = 0; i < 4; ++i) {
            preparedStatement.executeUpdate();
            this.verifyCachedIsolation(connection);
        }
        preparedStatement.close();
    }

    public void testChangeIsoLevelPreparedFunctionSQL() throws SQLException {
        Connection connection = this.getConnection();
        connection.setAutoCommit(true);
        Statement statement = this.createStatement();
        statement.execute("CREATE TABLE T1(SQLNAME VARCHAR(2))");
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO T1 VALUES GET_CYCLE_ISOLATION_SQL()");
        for (int i = 0; i < 4; ++i) {
            preparedStatement.executeUpdate();
            this.verifyCachedIsolation(connection);
        }
        preparedStatement.close();
    }

    public void testChangeIsoLevelProcedureJDBC() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = this.createStatement();
        for (int i = 0; i < 4; ++i) {
            statement.execute("CALL SET_ISOLATION_JDBC(" + isoLevels[i].getIsoLevel() + ")");
            this.verifyCachedIsolation(connection);
        }
        statement.close();
    }

    public void testChangeIsoLevelProcedureSQL() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = this.createStatement();
        for (int i = 0; i < 4; ++i) {
            statement.execute("CALL SET_ISOLATION_SQL('" + isoLevels[i].getSqlName() + "')");
            this.verifyCachedIsolation(connection);
        }
        statement.close();
    }

    public void testChangeIsoLevelCallableStatementJDBC() throws SQLException {
        Connection connection = this.getConnection();
        CallableStatement callableStatement = this.prepareCall("CALL SET_ISOLATION_JDBC(?)");
        for (int i = 0; i < 4; ++i) {
            callableStatement.setInt(1, isoLevels[i].getIsoLevel());
            callableStatement.execute();
            this.verifyCachedIsolation(connection);
        }
        callableStatement.close();
    }

    public void testChangeIsoLevelCallableStatementSQL() throws SQLException {
        Connection connection = this.getConnection();
        CallableStatement callableStatement = this.prepareCall("CALL SET_ISOLATION_SQL(?)");
        for (int i = 0; i < 4; ++i) {
            callableStatement.setString(1, isoLevels[i].getSqlName());
            callableStatement.execute();
            this.verifyCachedIsolation(connection);
        }
        callableStatement.close();
    }

    public void testChangeIsoLevelSQLInBatch() throws SQLException {
        Statement statement = this.createStatement();
        for (int i = 0; i < isoLevels.length; ++i) {
            statement.addBatch("SET ISOLATION " + isoLevels[i].getSqlName());
        }
        try {
            statement.executeBatch();
        }
        catch (SQLException sQLException) {
            SQLException sQLException2;
            SQLException sQLException3 = sQLException;
            while (sQLException2 != null) {
                sQLException3 = sQLException2;
                sQLException2 = sQLException2.getNextException();
            }
            throw sQLException3;
        }
        this.verifyCachedIsolation(statement.getConnection());
        statement.close();
    }

    public void testChangeIsoLevelProcedureJdbcBatch() throws SQLException {
        Statement statement = this.createStatement();
        for (int i = 0; i < isoLevels.length; ++i) {
            statement.addBatch("CALL SET_ISOLATION_JDBC(" + isoLevels[i].getIsoLevel() + ")");
        }
        try {
            statement.executeBatch();
        }
        catch (SQLException sQLException) {
            SQLException sQLException2;
            SQLException sQLException3 = sQLException;
            while (sQLException2 != null) {
                sQLException3 = sQLException2;
                sQLException2 = sQLException2.getNextException();
            }
            throw sQLException3;
        }
        this.verifyCachedIsolation(statement.getConnection());
        statement.close();
    }

    public void testChangeIsoLevelProcedureSqlBatch() throws SQLException {
        Statement statement = this.createStatement();
        for (int i = 0; i < isoLevels.length; ++i) {
            statement.addBatch("CALL SET_ISOLATION_SQL('" + isoLevels[i].getSqlName() + "')");
        }
        try {
            statement.executeBatch();
        }
        catch (SQLException sQLException) {
            SQLException sQLException2;
            SQLException sQLException3 = sQLException;
            while (sQLException2 != null) {
                sQLException3 = sQLException2;
                sQLException2 = sQLException2.getNextException();
            }
            throw sQLException3;
        }
        this.verifyCachedIsolation(statement.getConnection());
        statement.close();
    }

    public void testChangeIsoLevelProcedureJdbcCallableBatch() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("CALL SET_ISOLATION_JDBC(?)");
        for (int i = 0; i < isoLevels.length; ++i) {
            callableStatement.setInt(1, isoLevels[i].getIsoLevel());
            callableStatement.addBatch();
        }
        try {
            callableStatement.executeBatch();
        }
        catch (SQLException sQLException) {
            SQLException sQLException2;
            SQLException sQLException3 = sQLException;
            while (sQLException2 != null) {
                sQLException3 = sQLException2;
                sQLException2 = sQLException2.getNextException();
            }
            throw sQLException3;
        }
        this.verifyCachedIsolation(callableStatement.getConnection());
        callableStatement.close();
    }

    public void testChangeIsoLevelProcedureSqlCallableBatch() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("CALL SET_ISOLATION_SQL(?)");
        for (int i = 0; i < isoLevels.length; ++i) {
            callableStatement.setString(1, isoLevels[i].getSqlName());
            callableStatement.addBatch();
        }
        try {
            callableStatement.executeBatch();
        }
        catch (SQLException sQLException) {
            SQLException sQLException2;
            SQLException sQLException3 = sQLException;
            while (sQLException2 != null) {
                sQLException3 = sQLException2;
                sQLException2 = sQLException2.getNextException();
            }
            throw sQLException3;
        }
        this.verifyCachedIsolation(callableStatement.getConnection());
        callableStatement.close();
    }

    private void cursorTest(String string, int n, int n2) throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = this.createStatement(n, n2);
        ResultSet resultSet = statement.executeQuery("SELECT * FROM " + string);
        this.verifyCachedIsolation(connection);
        while (resultSet.next()) {
            this.verifyCachedIsolation(connection);
        }
        resultSet.close();
        statement.close();
    }

    private void preparedCursorTest(String string, int n, int n2) throws SQLException {
        Connection connection = this.getConnection();
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM " + string, n, n2);
        ResultSet resultSet = preparedStatement.executeQuery();
        this.verifyCachedIsolation(connection);
        while (resultSet.next()) {
            this.verifyCachedIsolation(connection);
        }
        resultSet.close();
        preparedStatement.close();
    }

    public void testSmallForwardOnlyReadOnly() throws SQLException {
        this.cursorTest("ISOLATION_NAMES", 1003, 1007);
    }

    public void testSmallScrollInsensitiveReadOnly() throws SQLException {
        this.cursorTest("ISOLATION_NAMES", 1004, 1007);
    }

    public void testSmallScrollSensitiveReadOnly() throws SQLException {
        this.cursorTest("ISOLATION_NAMES", 1005, 1007);
    }

    public void testSmallForwardOnlyUpdatable() throws SQLException {
        this.cursorTest("ISOLATION_NAMES", 1003, 1008);
    }

    public void testSmallScrollInsensitiveUpdatable() throws SQLException {
        this.cursorTest("ISOLATION_NAMES", 1004, 1008);
    }

    public void testSmallScrollSensitiveUpdatable() throws SQLException {
        this.cursorTest("ISOLATION_NAMES", 1005, 1008);
    }

    public void testSmallPreparedForwardOnlyReadOnly() throws SQLException {
        this.preparedCursorTest("ISOLATION_NAMES", 1003, 1007);
    }

    public void testSmallPreparedScrollSensitiveReadOnly() throws SQLException {
        this.preparedCursorTest("ISOLATION_NAMES", 1005, 1007);
    }

    public void testSmallPreparedScrollInsensitiveReadOnly() throws SQLException {
        this.preparedCursorTest("ISOLATION_NAMES", 1004, 1007);
    }

    public void testSmallPreparedForwardOnlyUpdatable() throws SQLException {
        this.preparedCursorTest("ISOLATION_NAMES", 1003, 1008);
    }

    public void testSmallPreparedScrollSensitiveUpdatable() throws SQLException {
        this.preparedCursorTest("ISOLATION_NAMES", 1005, 1008);
    }

    public void testSmallPreparedScrollInsensitiveUpdatable() throws SQLException {
        this.preparedCursorTest("ISOLATION_NAMES", 1004, 1008);
    }

    public void testLargeForwardOnlyReadOnly() throws SQLException {
        this.cursorTest("BIG", 1003, 1007);
    }

    public void testLargeScrollSensitiveReadOnly() throws SQLException {
        this.cursorTest("BIG", 1005, 1007);
    }

    public void testLargeScrollInsensitiveReadOnly() throws SQLException {
        this.cursorTest("BIG", 1004, 1007);
    }

    public void testLargeForwardOnlyUpdatable() throws SQLException {
        this.cursorTest("BIG", 1003, 1008);
    }

    public void testLargeScrollSensitiveUpdatable() throws SQLException {
        this.cursorTest("BIG", 1005, 1008);
    }

    public void testLargeScrollInsensitiveUpdatable() throws SQLException {
        this.cursorTest("BIG", 1004, 1008);
    }

    public void testLargePreparedForwardOnlyReadOnly() throws SQLException {
        this.preparedCursorTest("BIG", 1003, 1007);
    }

    public void testLargePreparedScrollSensitiveReadOnly() throws SQLException {
        this.preparedCursorTest("BIG", 1005, 1007);
    }

    public void testLargePreparedScrollInsensitiveReadOnly() throws SQLException {
        this.preparedCursorTest("BIG", 1004, 1007);
    }

    public void testLargePreparedForwardOnlyUpdatable() throws SQLException {
        this.preparedCursorTest("BIG", 1003, 1008);
    }

    public void testLargePreparedScrollSensitiveUpdatable() throws SQLException {
        this.preparedCursorTest("BIG", 1005, 1008);
    }

    public void testLargePreparedScrollInsensitiveUpdatable() throws SQLException {
        this.preparedCursorTest("BIG", 1004, 1008);
    }

    public void testSetSchema() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("SET SCHEMA FOO");
        this.verifyCachedSchema(this.getConnection());
        statement.execute("SET SCHEMA \"\u00bbMY\u20ac\u00ab\"");
        this.verifyCachedSchema(this.getConnection());
    }

    public void testPreparedSetSchema() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("SET SCHEMA ?");
        preparedStatement.setString(1, "FOO");
        preparedStatement.execute();
        this.verifyCachedSchema(this.getConnection());
        preparedStatement.setString(1, "\u00bbMY\u20ac\u00ab");
        preparedStatement.execute();
        this.verifyCachedSchema(this.getConnection());
    }

    public void testSetSchemaProcedure() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("CALL APP.SET_SCHEMA('FOO')");
        this.verifyCachedSchema(this.getConnection());
        statement.execute("CALL APP.SET_SCHEMA('\"\u00bbMY\u20ac\u00ab\"')");
        this.verifyCachedSchema(this.getConnection());
    }

    public void testPreparedSetSchemaProcedure() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("CALL APP.SET_SCHEMA(?)");
        callableStatement.setString(1, "FOO");
        callableStatement.execute();
        this.verifyCachedSchema(this.getConnection());
        callableStatement.setString(1, "\"\u00bbMY\u20ac\u00ab\"");
        callableStatement.execute();
        this.verifyCachedSchema(this.getConnection());
    }

    public void testSetSchemaFunction() throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT APP.GET_SCHEMA_TRANSITION(SCHEMANAME) FROM SYS.SYSSCHEMAS");
        while (resultSet.next()) {
            CacheSessionDataTest.assertTrue((resultSet.getString(1).length() > 2 ? 1 : 0) != 0);
            this.verifyCachedSchema(this.getConnection());
        }
    }

    public void testPreparedSetSchemaFunction() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("SELECT APP.GET_SCHEMA_TRANSITION(SCHEMANAME) FROM SYS.SYSSCHEMAS");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            CacheSessionDataTest.assertTrue((resultSet.getString(1).length() > 2 ? 1 : 0) != 0);
            this.verifyCachedSchema(this.getConnection());
        }
    }

    public void testSetSchemaFunctionLarge() throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT X, APP.GET_SCHEMA_TRANSITION(SCHEMANAME), Y FROM APP.LARGE");
        while (resultSet.next()) {
            CacheSessionDataTest.assertTrue((resultSet.getString(2).length() > 2 ? 1 : 0) != 0);
            this.verifyCachedSchema(this.getConnection());
        }
    }

    public void testPreparedSetSchemaFunctionLarge() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("SELECT X, APP.GET_SCHEMA_TRANSITION(SCHEMANAME), Y FROM APP.LARGE");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            CacheSessionDataTest.assertTrue((resultSet.getString(2).length() > 2 ? 1 : 0) != 0);
            this.verifyCachedSchema(this.getConnection());
        }
    }

    static {
        isolationIndex = -1;
    }
}

