/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derby.client.ClientDataSourceInterface;
import org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationRun;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SecurityManagerSetup;

public class ReplicationRun_Local_1Indexing
extends ReplicationRun {
    public ReplicationRun_Local_1Indexing(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("ReplicationRun_Local_1Indexing Suite");
        baseTestSuite.addTestSuite(ReplicationRun_Local_1Indexing.class);
        return SecurityManagerSetup.noSecurityManager((Test)baseTestSuite);
    }

    public void testReplication_Local_1_Indexing() throws Exception {
        this.makeReadyForReplication();
        String string = masterDatabasePath + FS + masterDbSubPath + FS + replicatedDb;
        int n = 10000;
        this.executeOnMaster("create table t(i integer primary key, s varchar(64), ii integer)");
        this.executeOnMaster("create index index1ii on t(ii)");
        this.executeOnMaster("create index index1s on t(s)");
        int n2 = 0;
        this._fillTableOnServer(masterServerHost, masterServerPort, string, n2, n);
        n2 += n;
        this.executeOnMaster("drop index index1ii");
        this.executeOnMaster("drop index index1s");
        this.executeOnMaster("create index index2ii on t(ii)");
        this.executeOnMaster("create index index2s on t(s)");
        this._fillTableOnServer(masterServerHost, masterServerPort, string, n, n);
        this.failOver(jvmVersion, masterDatabasePath, masterDbSubPath, replicatedDb, masterServerHost, masterServerPort, testClientHost);
        this.connectPing(slaveDatabasePath + FS + slaveDbSubPath + FS + replicatedDb, slaveServerHost, slaveServerPort, testClientHost);
        String string2 = slaveDatabasePath + FS + slaveDbSubPath + FS + replicatedDb;
        this._verifyDatabase(slaveServerHost, slaveServerPort, string2, n2 += n);
        this._verifyIndexOnSlave("index2ii");
        this._verifyIndexOnSlave("index2s");
        string = masterDatabasePath + FS + masterDbSubPath + FS + replicatedDb;
        this._verifyDatabase(masterServerHost, masterServerPort, string, n2);
    }

    void _fillTableOnServer(String string, int n, String string2, int n2, int n3) throws Exception {
        ClientDataSourceInterface clientDataSourceInterface;
        Class<?> clazz;
        if (JDBC.vmSupportsJNDI()) {
            clazz = Class.forName("org.apache.derby.jdbc.ClientDataSource");
            clientDataSourceInterface = (ClientDataSourceInterface)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        } else {
            clazz = Class.forName("org.apache.derby.jdbc.BasicClientDataSource40");
            clientDataSourceInterface = (ClientDataSourceInterface)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        clientDataSourceInterface.setDatabaseName(string2);
        clientDataSourceInterface.setServerName(string);
        clientDataSourceInterface.setPortNumber(n);
        clientDataSourceInterface.setConnectionAttributes(this.useEncryption(false));
        Connection connection = clientDataSourceInterface.getConnection();
        PreparedStatement preparedStatement = connection.prepareStatement("insert into t values (?,?,?)");
        for (int i = 0; i < n3; ++i) {
            preparedStatement.setInt(1, i + n2);
            preparedStatement.setString(2, "dilldall" + (i + n2));
            preparedStatement.setInt(3, (i + n2) % (n3 / 10));
            preparedStatement.execute();
            if (i % 10000 != 0) continue;
            connection.commit();
        }
        this._verify(connection, n2 + n3);
        connection.close();
    }

    private void _verifyIndexOnSlave(String string) throws SQLException {
        this.executeOnSlave("drop index " + string);
    }
}

