/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.sql.Timestamp;

public class Price
implements Externalizable {
    private static final long serialVersionUID = 102726277789621992L;
    private static final int FIRST_VERSION = 0;
    private static final int TIMESTAMPED_VERSION = 1;
    private static final Timestamp DEFAULT_TIMESTAMP = new Timestamp(0L);
    private static Price _savedPrice;
    public String currencyCode;
    public BigDecimal amount;
    public Timestamp timeInstant;

    public static Price makePrice() {
        return Price.makePrice(BigDecimal.valueOf(1L));
    }

    public static Price makePrice(BigDecimal bigDecimal) {
        return new Price("USD", bigDecimal, DEFAULT_TIMESTAMP);
    }

    public static Price makePrice(String string, BigDecimal bigDecimal, Timestamp timestamp) {
        return new Price(string, bigDecimal, timestamp);
    }

    public static String getCurrencyCode(Price price) {
        return price.currencyCode;
    }

    public static BigDecimal getAmount(Price price) {
        return price.amount;
    }

    public static Timestamp getTimeInstant(Price price) {
        return price.timeInstant;
    }

    public static void savePrice(Price price) {
        _savedPrice = price;
    }

    public static Price getSavedPrice() {
        return _savedPrice;
    }

    public Price() {
    }

    public Price(String string, BigDecimal bigDecimal, Timestamp timestamp) {
        this.currencyCode = string;
        this.amount = bigDecimal;
        this.timeInstant = timestamp;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Price( " + this.currencyCode + ", " + this.amount + ", ");
        if (DEFAULT_TIMESTAMP.equals(this.timeInstant)) {
            stringBuffer.append("XXX");
        } else {
            stringBuffer.append(this.timeInstant);
        }
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Price)) {
            return false;
        }
        Price price = (Price)object;
        return this.toString().equals(price.toString());
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(1);
        objectOutput.writeObject(this.currencyCode);
        objectOutput.writeObject(this.amount);
        objectOutput.writeObject(this.timeInstant);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        if (n < 0) {
            throw new IOException("Corrupt data stream.");
        }
        if (n > 1) {
            throw new IOException("Can't deserialize from the future.");
        }
        this.currencyCode = (String)objectInput.readObject();
        this.amount = (BigDecimal)objectInput.readObject();
        this.timeInstant = n >= 1 ? (Timestamp)objectInput.readObject() : DEFAULT_TIMESTAMP;
    }
}

