/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.jdbc4.ConnectionMethodsTest;
import org.apache.derbyTesting.functionTests.tests.jdbc4.Wrapper41Conn;
import org.apache.derbyTesting.functionTests.tests.jdbc4.Wrapper41Test;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class AbortTest
extends Wrapper41Test {
    private boolean _hasSecurityManager;

    public AbortTest(String string, boolean bl) {
        super(string);
        this._hasSecurityManager = bl;
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("AbortTest");
        baseTestSuite.addTest(AbortTest.baseSuite(true));
        baseTestSuite.addTest(AbortTest.baseSuite(false));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(AbortTest.baseSuite(true)));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(AbortTest.baseSuite(false)));
        return baseTestSuite;
    }

    public static Test baseSuite(boolean bl) {
        AbortTest abortTest = new AbortTest("test_basic", bl);
        CleanDatabaseTestSetup cleanDatabaseTestSetup = new CleanDatabaseTestSetup((Test)abortTest){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.execute("create table abort_table( a int )");
            }
        };
        if (bl) {
            return new SecurityManagerSetup((Test)cleanDatabaseTestSetup, "org/apache/derbyTesting/functionTests/tests/jdbc4/noAbortPermission.policy");
        }
        return SecurityManagerSetup.noSecurityManager((Test)cleanDatabaseTestSetup);
    }

    public void test_basic() throws Exception {
        if (!TestConfiguration.loadingFromJars()) {
            return;
        }
        AbortTest.println("AbortTest( " + this._hasSecurityManager + " )");
        AbortTest.assertEquals((boolean)this._hasSecurityManager, (System.getSecurityManager() != null ? 1 : 0) != 0);
        this.physical();
        this.pooled();
        this.xa();
    }

    private void physical() throws Exception {
        Connection connection = this.openUserConnection("user0");
        Connection connection2 = this.openUserConnection("user1");
        Connection connection3 = this.openUserConnection("user2");
        this.vet(connection, connection2, connection3);
    }

    private void pooled() throws Exception {
        ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
        PooledConnection pooledConnection = this.getPooledConnection(connectionPoolDataSource, "user3");
        PooledConnection pooledConnection2 = this.getPooledConnection(connectionPoolDataSource, "user4");
        PooledConnection pooledConnection3 = this.getPooledConnection(connectionPoolDataSource, "user5");
        this.vet(pooledConnection.getConnection(), pooledConnection2.getConnection(), pooledConnection3.getConnection());
    }

    private PooledConnection getPooledConnection(ConnectionPoolDataSource connectionPoolDataSource, String string) throws Exception {
        return connectionPoolDataSource.getPooledConnection(string, this.getTestConfiguration().getPassword(string));
    }

    private void xa() throws Exception {
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        XAConnection xAConnection = this.getXAConnection(xADataSource, "user6");
        XAConnection xAConnection2 = this.getXAConnection(xADataSource, "user7");
        XAConnection xAConnection3 = this.getXAConnection(xADataSource, "user8");
        this.vet(xAConnection.getConnection(), xAConnection2.getConnection(), xAConnection3.getConnection());
    }

    private XAConnection getXAConnection(XADataSource xADataSource, String string) throws Exception {
        return xADataSource.getXAConnection(string, this.getTestConfiguration().getPassword(string));
    }

    public void vet(Connection connection, Connection connection2, Connection connection3) throws Exception {
        AbortTest.assertNotNull((Object)connection);
        AbortTest.assertNotNull((Object)connection2);
        AbortTest.assertNotNull((Object)connection3);
        connection.close();
        Wrapper41Conn wrapper41Conn = new Wrapper41Conn(connection);
        wrapper41Conn.abort(new ConnectionMethodsTest.DirectExecutor());
        connection2.setAutoCommit(false);
        Wrapper41Conn wrapper41Conn2 = new Wrapper41Conn(connection2);
        try {
            wrapper41Conn2.abort(null);
        }
        catch (SQLException sQLException) {
            AbortTest.assertSQLState("XCZ02", sQLException);
        }
        if (this._hasSecurityManager) {
            this.missingPermission(wrapper41Conn2);
        } else {
            this.noSecurityManager(wrapper41Conn2, connection3);
        }
    }

    private void missingPermission(final Wrapper41Conn wrapper41Conn) throws Exception {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    ConnectionMethodsTest.DirectExecutor directExecutor = new ConnectionMethodsTest.DirectExecutor();
                    wrapper41Conn.abort(directExecutor);
                    return null;
                }
            });
            AbortTest.fail((String)"The call to Connection.abort(Executor) should have failed.");
        }
        catch (Exception exception) {
            AbortTest.assertTrue((boolean)(exception instanceof AccessControlException));
        }
    }

    private void noSecurityManager(Wrapper41Conn wrapper41Conn, Connection connection) throws Exception {
        PreparedStatement preparedStatement = this.prepareStatement(wrapper41Conn.getWrappedObject(), "insert into app.abort_table( a ) values ( 1 )");
        preparedStatement.execute();
        preparedStatement.close();
        ConnectionMethodsTest.DirectExecutor directExecutor = new ConnectionMethodsTest.DirectExecutor();
        wrapper41Conn.abort(directExecutor);
        try {
            this.prepareStatement(wrapper41Conn.getWrappedObject(), "select * from sys.systables");
            AbortTest.fail((String)"Connection should be dead!");
        }
        catch (SQLException sQLException) {
            AbortTest.assertSQLState("08003", sQLException);
        }
        preparedStatement = this.prepareStatement(connection, "select * from app.abort_table");
        ResultSet resultSet = preparedStatement.executeQuery();
        AbortTest.assertFalse((boolean)resultSet.next());
        resultSet.close();
        preparedStatement.close();
        connection.close();
    }
}

