/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.font;

import java.awt.Shape;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import org.apache.batik.ext.awt.geom.PathLength;

public class TextPathLayout {
    public static final int ALIGN_START = 0;
    public static final int ALIGN_MIDDLE = 1;
    public static final int ALIGN_END = 2;
    public static final int ADJUST_SPACING = 0;
    public static final int ADJUST_GLYPHS = 1;

    public static Shape layoutGlyphVector(GlyphVector glyphVector, Shape shape, int n, float f, float f2, int n2) {
        GeneralPath generalPath = new GeneralPath();
        PathLength pathLength = new PathLength(shape);
        float f3 = pathLength.lengthOfPath();
        float f4 = (float)glyphVector.getVisualBounds().getWidth();
        if (shape == null || glyphVector == null || glyphVector.getNumGlyphs() == 0 || pathLength.lengthOfPath() == 0.0f || f4 == 0.0f) {
            return generalPath;
        }
        float f5 = f2 / f4;
        float f6 = f;
        if (n == 2) {
            f6 += f3 - f2;
        } else if (n == 1) {
            f6 += (f3 - f2) / 2.0f;
        }
        int n3 = 0;
        while (n3 < glyphVector.getNumGlyphs()) {
            float f7;
            float f8;
            Point2D point2D;
            GlyphMetrics glyphMetrics = glyphVector.getGlyphMetrics(n3);
            float f9 = glyphMetrics.getAdvance();
            Shape shape2 = glyphVector.getGlyphOutline(n3);
            if (n2 == 1) {
                AffineTransform affineTransform = AffineTransform.getScaleInstance(f5, 1.0);
                shape2 = affineTransform.createTransformedShape(shape2);
                f9 *= f5;
            }
            if ((point2D = pathLength.pointAtLength(f8 = f6 + (f7 = (float)shape2.getBounds2D().getWidth()) / 2.0f)) != null) {
                float f10 = pathLength.angleAtLength(f8);
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(point2D.getX(), point2D.getY());
                affineTransform.rotate(f10);
                affineTransform.translate(f9 / -2.0f, 0.0);
                shape2 = affineTransform.createTransformedShape(shape2);
                generalPath.append(shape2, false);
            }
            f6 = n2 == 0 ? (f6 += f9 * f5) : (f6 += f9);
            ++n3;
        }
        return generalPath;
    }

    public static Shape layoutGlyphVector(GlyphVector glyphVector, Shape shape, int n) {
        return TextPathLayout.layoutGlyphVector(glyphVector, shape, n, 0.0f, (float)glyphVector.getVisualBounds().getWidth(), 0);
    }

    public static Shape layoutGlyphVector(GlyphVector glyphVector, Shape shape) {
        return TextPathLayout.layoutGlyphVector(glyphVector, shape, 0);
    }
}

